/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.biodiverse.entity;

import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.mcreator.biodiverse.entity.BlueWhaleBodyEntity;
import net.mcreator.biodiverse.entity.BlueWhaleTailEntity;
import net.mcreator.biodiverse.entity.KrillEntity;
import net.mcreator.biodiverse.init.BiodiverseModEntities;
import net.mcreator.biodiverse.procedures.BlueWhaleBlessedProcedure;
import net.mcreator.biodiverse.procedures.StayUnderwaterProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BlueWhaleEntity
extends Animal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(BlueWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(BlueWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(BlueWhaleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    public float yawDelta = 0.0f;
    public float prevYawDelta = 0.0f;
    public float pitchValue = 0.0f;
    public float prevPitchValue = 0.0f;
    public float zTilt = 0.0f;
    public float prevZTilt = 0.0f;
    public float smoothedYaw = 0.0f;
    public float smoothedPitch = 0.0f;
    public float bodyPitch = 0.0f;
    public float prevBodyPitch = 0.0f;
    public float prevHeadYaw = 0.0f;
    public float prevBodyYaw = 0.0f;
    public float prevTailYaw = 0.0f;
    @Nullable
    public UUID bodySegmentUUID;
    @Nullable
    public UUID tailSegmentUUID;
    @Nullable
    public BlueWhaleBodyEntity bodySegment;
    @Nullable
    public BlueWhaleTailEntity tailSegment;
    String prevAnim = "empty";

    public BlueWhaleEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<BlueWhaleEntity>)((EntityType)BiodiverseModEntities.BLUE_WHALE.get()), world);
        this.f_21344_ = new WaterBoundPathNavigation((Mob)this, this.m_9236_());
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    public BlueWhaleEntity(EntityType<BlueWhaleEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_274367_(1.2f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new MoveControl((Mob)this){

            public void m_8126_() {
                if (BlueWhaleEntity.this.m_20069_()) {
                    BlueWhaleEntity.this.m_20256_(BlueWhaleEntity.this.m_20184_().m_82520_(0.0, -0.05, 0.0));
                }
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !BlueWhaleEntity.this.m_21573_().m_26571_()) {
                    double dx = this.f_24975_ - BlueWhaleEntity.this.m_20185_();
                    double dy = this.f_24976_ - BlueWhaleEntity.this.m_20186_();
                    double dz = this.f_24977_ - BlueWhaleEntity.this.m_20189_();
                    float f = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.f_24978_ * BlueWhaleEntity.this.m_21051_(Attributes.f_22279_).m_22135_());
                    BlueWhaleEntity.this.m_146922_(this.m_24991_(BlueWhaleEntity.this.m_146908_(), f, 4.0f));
                    BlueWhaleEntity.this.f_20883_ = BlueWhaleEntity.this.m_146908_();
                    BlueWhaleEntity.this.f_20885_ = BlueWhaleEntity.this.m_146908_();
                    if (BlueWhaleEntity.this.m_20069_()) {
                        BlueWhaleEntity.this.m_7910_((float)BlueWhaleEntity.this.m_21051_(Attributes.f_22279_).m_22135_());
                        float f2 = -((float)(Mth.m_14136_((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.m_14036_((float)Mth.m_14177_((float)f2), (float)-45.0f, (float)45.0f);
                        BlueWhaleEntity.this.prevBodyPitch = BlueWhaleEntity.this.bodyPitch;
                        BlueWhaleEntity.this.bodyPitch = f2;
                        BlueWhaleEntity.this.m_146926_(this.m_24991_(BlueWhaleEntity.this.m_146909_(), f2, 0.8f));
                        float f3 = Mth.m_14089_((float)(BlueWhaleEntity.this.m_146909_() * ((float)Math.PI / 180)));
                        BlueWhaleEntity.this.m_21564_(f3 * f1);
                        float verticalIntent = (float)Mth.m_14008_((double)dy, (double)-1.5, (double)1.5);
                        BlueWhaleEntity.this.m_21567_(verticalIntent * 0.5f);
                    } else {
                        BlueWhaleEntity.this.m_7910_(f1 * 0.05f);
                    }
                } else {
                    BlueWhaleEntity.this.m_7910_(0.0f);
                    BlueWhaleEntity.this.m_21567_(0.0f);
                    BlueWhaleEntity.this.m_21564_(0.0f);
                }
            }
        };
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_20069_()) {
            boolean closeEnough = false;
            if (this.m_21573_().m_26572_()) {
                double dz;
                double dy;
                BlockPos targetPos = this.m_21573_().m_26567_();
                Vec3 target = new Vec3((double)targetPos.m_123341_() + 2.5, (double)targetPos.m_123342_() + 2.5, (double)targetPos.m_123343_() + 2.5);
                double dx = target.f_82479_ - this.m_20185_();
                double distanceSq = dx * dx + (dy = target.f_82480_ - this.m_20186_()) * dy + (dz = target.f_82481_ - this.m_20189_()) * dz;
                if (distanceSq < 16.0) {
                    closeEnough = true;
                    this.m_21573_().m_26573_();
                }
            }
            Vec3 scaledTravel = new Vec3(travelVector.f_82479_, travelVector.f_82480_ * 0.8, travelVector.f_82481_);
            this.m_19920_(this.m_6113_() * 0.5f, scaledTravel);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            Vec3 motion = this.m_20184_();
            this.m_20334_(motion.f_82479_ * 0.85, motion.f_82480_ * 0.95, motion.f_82481_ * 0.85);
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.002, 0.0));
            }
            double horizontalSpeed = Math.sqrt(this.m_20184_().f_82479_ * this.m_20184_().f_82479_ + this.m_20184_().f_82481_ * this.m_20184_().f_82481_);
            float targetPitch = (float)(-Mth.m_14136_((double)this.m_20184_().f_82480_, (double)horizontalSpeed)) * 57.295776f;
            targetPitch = Mth.m_14036_((float)targetPitch, (float)-25.0f, (float)25.0f);
            float pitchFactor = 1.0f;
            int maxCheck = 6;
            if (motion.f_82480_ > 0.0) {
                for (i = 1; i <= maxCheck; ++i) {
                    if (this.m_9236_().m_8055_(this.m_20183_().m_6630_(i)).m_60713_(Blocks.f_49990_)) continue;
                    pitchFactor = (float)i / (float)maxCheck;
                    break;
                }
            } else if (motion.f_82480_ < 0.0) {
                for (i = 1; i <= maxCheck; ++i) {
                    if (this.m_9236_().m_8055_(this.m_20183_().m_6625_(i)).m_60713_(Blocks.f_49990_)) continue;
                    pitchFactor = Math.min(pitchFactor, (float)i / (float)maxCheck);
                    break;
                }
            }
            if (horizontalSpeed < 0.001 && Math.abs(motion.f_82480_) < 0.001) {
                pitchFactor = 0.0f;
            }
            this.smoothedPitch = Mth.m_14179_((float)0.08f, (float)this.smoothedPitch, (float)(targetPitch *= pitchFactor));
            this.m_146926_(this.smoothedPitch);
            this.prevBodyPitch = this.bodyPitch;
            this.bodyPitch = Mth.m_14179_((float)0.08f, (float)this.bodyPitch, (float)this.smoothedPitch);
            this.prevZTilt = this.zTilt;
            if (!closeEnough) {
                float rawDeltaYaw = Mth.m_14177_((float)(this.m_146908_() - this.f_19859_));
                float clampedYaw = Mth.m_14036_((float)rawDeltaYaw, (float)-2.0f, (float)2.0f);
                float targetZTilt = Mth.m_14036_((float)(clampedYaw * -2.0f), (float)-30.0f, (float)30.0f);
                this.zTilt = Mth.m_14179_((float)0.12f, (float)this.zTilt, (float)targetZTilt);
            } else {
                this.zTilt = Mth.m_14179_((float)0.12f, (float)this.zTilt, (float)0.0f);
            }
            this.f_20883_ = this.m_146908_();
        } else {
            super.m_7023_(travelVector);
            this.prevZTilt = this.zTilt;
            this.zTilt = Mth.m_14179_((float)0.1f, (float)this.zTilt, (float)0.0f);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        this.prevHeadYaw = this.f_20885_;
        this.prevBodyYaw = this.f_19859_;
        this.prevTailYaw = this.f_19859_;
        this.prevBodyPitch = this.bodyPitch;
        this.prevYawDelta = this.yawDelta;
        this.yawDelta = Mth.m_14177_((float)(this.m_146908_() - this.f_19859_));
        this.prevPitchValue = this.pitchValue;
        this.pitchValue = this.bodyPitch;
        this.prevZTilt = this.zTilt;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"bluewhale");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected PathNavigation m_6037_(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, KrillEntity.class, true, false));
        this.f_21345_.m_25352_(4, (Goal)new WhaleRandomSwimmingGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new PanicGoal((PathfinderMob)this, 4.0));
    }

    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:entity.whale.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:entity.baleen.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:entity.baleen.hurt"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268722_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
    }

    public void m_6075_() {
        super.m_6075_();
        StayUnderwaterProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        BlueWhaleBlessedProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)7.5f, (float)6.5f);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        BlueWhaleEntity retval = (BlueWhaleEntity)((EntityType)BiodiverseModEntities.BLUE_WHALE.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return List.of(Items.f_42526_).contains(stack.m_41720_());
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)BiodiverseModEntities.BLUE_WHALE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_8055_(pos).m_60713_(Blocks.f_49990_) && world.m_8055_(pos.m_7494_()).m_60713_(Blocks.f_49990_));
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.4);
        builder = builder.m_22268_(Attributes.f_22276_, 300.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.4);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (this.m_20072_()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.HumpbackSwim"));
            }
            if (this.m_6144_()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.HumpbackSwimDown"));
            }
            if (this.m_20142_()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.HumpbackSwimUp"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.HumpbackSwim"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public class WhaleRandomSwimmingGoal
    extends RandomSwimmingGoal {
        private final PathfinderMob whale;
        private final Random random;
        private Vec3 targetPos;
        private int ticksSinceLastTarget;
        private final double maxDistanceXZ = 100.0;
        private final double minDistanceXZ = 40.0;
        private final double maxYDistance = 40.0;

        public WhaleRandomSwimmingGoal(PathfinderMob whale, double speed) {
            super(whale, speed, 120);
            this.random = new Random();
            this.maxDistanceXZ = 100.0;
            this.minDistanceXZ = 40.0;
            this.maxYDistance = 40.0;
            this.whale = whale;
        }

        public boolean m_8036_() {
            if (!this.whale.m_20072_()) {
                return false;
            }
            if (this.targetPos == null || this.whale.m_20182_().m_82557_(this.targetPos) < 400.0) {
                this.targetPos = this.m_7037_();
                this.ticksSinceLastTarget = 0;
            }
            return this.targetPos != null;
        }

        public void m_8056_() {
            if (this.targetPos != null) {
                this.whale.m_21573_().m_26519_(this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_, this.f_25729_);
            }
        }

        public void m_8037_() {
            if (this.targetPos != null) {
                ++this.ticksSinceLastTarget;
                if (this.whale.m_20182_().m_82509_((Position)this.targetPos, 4.0) || this.ticksSinceLastTarget > 200) {
                    this.targetPos = this.m_7037_();
                    if (this.targetPos != null) {
                        this.whale.m_21573_().m_26519_(this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_, this.f_25729_);
                    }
                    this.ticksSinceLastTarget = 0;
                }
            }
        }

        @Nullable
        protected Vec3 m_7037_() {
            for (int tries = 0; tries < 10; ++tries) {
                double angle = Math.PI * 2 * this.random.nextDouble();
                double distance = 40.0 + this.random.nextDouble() * 60.0;
                double yBias = 5.0 + this.random.nextDouble() * 10.0;
                double dx = Math.cos(angle) * distance;
                double dz = Math.sin(angle) * distance;
                double dy = this.random.nextDouble() * 40.0 - 20.0 + yBias;
                Vec3 candidate = this.whale.m_20182_().m_82520_(dx, dy, dz);
                BlockPos pos = BlockPos.m_274446_((Position)candidate);
                if (this.whale.m_9236_().m_6425_(pos).m_76178_() || !this.isWideOpen(pos)) continue;
                return candidate;
            }
            return null;
        }

        private boolean isWideOpen(BlockPos pos) {
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockPos check = pos.m_7918_(dx, dy, dz);
                        if (!this.whale.m_9236_().m_6425_(check).m_76178_()) continue;
                        return false;
                    }
                }
            }
            return true;
        }
    }
}

