/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.biodiverse.entity;

import java.util.UUID;
import net.mcreator.biodiverse.entity.BlueWhaleBodyEntity;
import net.mcreator.biodiverse.entity.BlueWhaleEntity;
import net.mcreator.biodiverse.init.BiodiverseModEntities;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BlueWhaleTailEntity
extends PathfinderMob
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(BlueWhaleTailEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(BlueWhaleTailEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(BlueWhaleTailEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    public float prevHeadYaw = 0.0f;
    public float prevBodyYaw = 0.0f;
    public float prevTailYaw = 0.0f;
    public float bodyPitch = 0.0f;
    public float prevBodyPitch = 0.0f;
    public float smoothedPitch = 0.0f;
    public float zTilt = 0.0f;
    public float prevZTilt = 0.0f;
    String prevAnim = "empty";

    public BlueWhaleTailEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<BlueWhaleTailEntity>)((EntityType)BiodiverseModEntities.BLUE_WHALE_TAIL.get()), world);
    }

    public Entity getOwnerEntity() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            UUID ownerUUID;
            Entity ownerEntity;
            ServerLevel serverLevel = (ServerLevel)level;
            String ownerUUIDString = this.getPersistentData().m_128461_("owner_uuid");
            if (!ownerUUIDString.isEmpty() && (ownerEntity = serverLevel.m_8791_(ownerUUID = UUID.fromString(ownerUUIDString))) != null) {
                return ownerEntity;
            }
        }
        return null;
    }

    public BlueWhaleTailEntity(EntityType<BlueWhaleTailEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(true);
        this.m_274367_(0.6f);
        this.m_21530_();
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.f_21342_ = new MoveControl((Mob)this){

            public void m_8126_() {
                if (BlueWhaleTailEntity.this.m_20069_()) {
                    BlueWhaleTailEntity.this.m_20256_(BlueWhaleTailEntity.this.m_20184_().m_82520_(0.0, 0.005, 0.0));
                }
                if (this.f_24981_ == MoveControl.Operation.MOVE_TO && !BlueWhaleTailEntity.this.m_21573_().m_26571_()) {
                    double dx = this.f_24975_ - BlueWhaleTailEntity.this.m_20185_();
                    double dy = this.f_24976_ - BlueWhaleTailEntity.this.m_20186_();
                    double dz = this.f_24977_ - BlueWhaleTailEntity.this.m_20189_();
                    float f = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(this.f_24978_ * BlueWhaleTailEntity.this.m_21051_(Attributes.f_22279_).m_22135_());
                    BlueWhaleTailEntity.this.m_146922_(this.m_24991_(BlueWhaleTailEntity.this.m_146908_(), f, 10.0f));
                    BlueWhaleTailEntity.this.f_20883_ = BlueWhaleTailEntity.this.m_146908_();
                    BlueWhaleTailEntity.this.f_20885_ = BlueWhaleTailEntity.this.m_146908_();
                    if (BlueWhaleTailEntity.this.m_20069_()) {
                        BlueWhaleTailEntity.this.m_7910_((float)BlueWhaleTailEntity.this.m_21051_(Attributes.f_22279_).m_22135_());
                        float f2 = -((float)(Mth.m_14136_((double)dy, (double)((float)Math.sqrt(dx * dx + dz * dz))) * 57.29577951308232));
                        f2 = Mth.m_14036_((float)Mth.m_14177_((float)f2), (float)-85.0f, (float)85.0f);
                        BlueWhaleTailEntity.this.m_146926_(this.m_24991_(BlueWhaleTailEntity.this.m_146909_(), f2, 5.0f));
                        float f3 = Mth.m_14089_((float)(BlueWhaleTailEntity.this.m_146909_() * ((float)Math.PI / 180)));
                        BlueWhaleTailEntity.this.m_21564_(f3 * f1);
                        BlueWhaleTailEntity.this.m_21567_((float)((double)f1 * dy));
                    } else {
                        BlueWhaleTailEntity.this.m_7910_(f1 * 0.05f);
                    }
                } else {
                    BlueWhaleTailEntity.this.m_7910_(0.0f);
                    BlueWhaleTailEntity.this.m_21567_(0.0f);
                    BlueWhaleTailEntity.this.m_21564_(0.0f);
                }
            }
        };
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            return;
        }
        String ownerUUIDString = this.getPersistentData().m_128461_("owner_uuid");
        String followSegmentUUIDString = this.getPersistentData().m_128461_("follow_segment_uuid");
        UUID ownerUUID = null;
        UUID followSegmentUUID = null;
        try {
            if (!ownerUUIDString.isEmpty()) {
                ownerUUID = UUID.fromString(ownerUUIDString);
            }
            if (!followSegmentUUIDString.isEmpty()) {
                followSegmentUUID = UUID.fromString(followSegmentUUIDString);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Entity followEntity = null;
        Entity ownerEntity = null;
        if (followSegmentUUID != null) {
            followEntity = ((ServerLevel)this.m_9236_()).m_8791_(followSegmentUUID);
        }
        if (ownerUUID != null) {
            ownerEntity = ((ServerLevel)this.m_9236_()).m_8791_(ownerUUID);
            if (followEntity == null) {
                followEntity = ownerEntity;
            }
        }
        if (!(ownerEntity instanceof LivingEntity) || !((LivingEntity)ownerEntity).m_6084_()) {
            this.m_6074_();
            return;
        }
        if (followEntity != null) {
            double distanceBehind = 8.0;
            float followYaw = followEntity.m_146908_();
            double angleRad = Math.toRadians(followYaw);
            double targetX = followEntity.m_20185_() + Math.sin(angleRad) * distanceBehind;
            double targetY = followEntity.m_20186_();
            double targetZ = followEntity.m_20189_() - Math.cos(angleRad) * distanceBehind;
            double lerpFactor = 0.5;
            double newX = Mth.m_14139_((double)lerpFactor, (double)this.m_20185_(), (double)targetX);
            double newY = Mth.m_14139_((double)lerpFactor, (double)this.m_20186_(), (double)targetY);
            double newZ = Mth.m_14139_((double)lerpFactor, (double)this.m_20189_(), (double)targetZ);
            this.m_6034_(newX, newY, newZ);
            this.prevBodyPitch = this.bodyPitch;
            this.prevZTilt = this.zTilt;
            this.prevBodyYaw = this.m_146908_();
            if (followEntity instanceof BlueWhaleEntity) {
                BlueWhaleEntity whale = (BlueWhaleEntity)followEntity;
                this.bodyPitch = whale.bodyPitch;
                this.smoothedPitch = whale.smoothedPitch;
                this.zTilt = whale.zTilt;
            } else if (followEntity instanceof BlueWhaleBodyEntity) {
                BlueWhaleBodyEntity segment = (BlueWhaleBodyEntity)followEntity;
                this.bodyPitch = segment.bodyPitch;
                this.smoothedPitch = segment.smoothedPitch;
                this.zTilt = segment.zTilt;
            }
            this.m_146922_(followYaw);
            this.f_20883_ = followYaw;
            this.f_20885_ = followYaw;
            this.m_5616_(followYaw);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"bluewhale");
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected PathNavigation m_6037_(Level world) {
        return new WaterBoundPathNavigation((Mob)this, world);
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268612_)) {
            return false;
        }
        String ownerUUIDString = this.getPersistentData().m_128461_("owner_uuid");
        if (!ownerUUIDString.isEmpty()) {
            try {
                LivingEntity livingOwner;
                UUID ownerUUID = UUID.fromString(ownerUUIDString);
                Entity ownerEntity = ((ServerLevel)this.m_9236_()).m_8791_(ownerUUID);
                if (ownerEntity instanceof LivingEntity && (livingOwner = (LivingEntity)ownerEntity).m_6084_()) {
                    return livingOwner.m_6469_(source, amount);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return super.m_6469_(source, amount);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return EntityDimensions.m_20395_((float)6.5f, (float)5.5f);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean m_6914_(LevelReader world) {
        return world.m_45784_((Entity)this);
    }

    public boolean m_6063_() {
        return false;
    }

    public static void init() {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 300.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 0.3);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.HumpbackSwim"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

