/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.biodiverse.entity;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.mcreator.biodiverse.ai.goal.RestingGoal;
import net.mcreator.biodiverse.init.BiodiverseModBlocks;
import net.mcreator.biodiverse.init.BiodiverseModEntities;
import net.mcreator.biodiverse.init.BiodiverseModItems;
import net.mcreator.biodiverse.procedures.CassowarycanattackProcedure;
import net.mcreator.biodiverse.procedures.JungleBiomeSpawnsProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CassowaryEntity
extends Animal
implements GeoEntity,
RestingGoal.RestingAnimatable {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(CassowaryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(CassowaryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(CassowaryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> DATA_canlayegg = SynchedEntityData.m_135353_(CassowaryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_aggression = SynchedEntityData.m_135353_(CassowaryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> DATA_digging = SynchedEntityData.m_135353_(CassowaryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> RESTING = SynchedEntityData.m_135353_(CassowaryEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    private int diggingTimer = 0;
    private int eggLayingTimer = 0;
    private int breedingTimer = 0;
    private boolean readyToLayEgg = false;
    private boolean isResting = false;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public CassowaryEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<CassowaryEntity>)((EntityType)BiodiverseModEntities.CASSOWARY.get()), world);
    }

    public CassowaryEntity(EntityType<CassowaryEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_274367_(0.6f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"cassowary");
        this.f_19804_.m_135372_(DATA_canlayegg, (Object)false);
        this.f_19804_.m_135372_(DATA_aggression, (Object)false);
        this.f_19804_.m_135372_(DATA_digging, (Object)false);
        this.f_19804_.m_135372_(RESTING, (Object)false);
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    @Override
    public void setResting(boolean value) {
        this.f_19804_.m_135381_(RESTING, (Object)value);
    }

    @Override
    public boolean isResting() {
        return (Boolean)this.f_19804_.m_135370_(RESTING);
    }

    public boolean m_5912_() {
        return (Boolean)this.f_19804_.m_135370_(DATA_aggression);
    }

    public boolean isDigging() {
        return (Boolean)this.f_19804_.m_135370_(DATA_digging);
    }

    public void setDigging(boolean value) {
        this.f_19804_.m_135381_(DATA_digging, (Object)value);
    }

    private Item getRandomSeedItem() {
        TagKey seedTag = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)new ResourceLocation("forge", "seeds"));
        List<Item> taggedSeeds = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.m_204114_().m_203656_(seedTag)).toList();
        List<Item> fallbackSeeds = List.of(Items.f_42404_, Items.f_42733_, Items.f_42578_, Items.f_42577_);
        if (taggedSeeds.isEmpty()) {
            return fallbackSeeds.get(this.f_19796_.m_188503_(fallbackSeeds.size()));
        }
        HashSet<Item> combined = new HashSet<Item>(taggedSeeds);
        combined.addAll(fallbackSeeds);
        ArrayList<Item> seedPool = new ArrayList<Item>(combined);
        return (Item)seedPool.get(this.f_19796_.m_188503_(seedPool.size()));
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
        super.m_7472_(source, looting, recentlyHit);
        RandomSource random = this.m_217043_();
        int rawCount = Mth.m_216271_((RandomSource)random, (int)1, (int)2);
        this.m_19983_(new ItemStack((ItemLike)BiodiverseModItems.RAW_FLIGHTLESS_BIRD.get(), rawCount));
        int featherCount = Mth.m_216271_((RandomSource)random, (int)2, (int)4);
        this.m_19983_(new ItemStack((ItemLike)Items.f_42402_, featherCount));
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, true){

            public boolean m_8036_() {
                double x = CassowaryEntity.this.m_20185_();
                double y = CassowaryEntity.this.m_20186_();
                double z = CassowaryEntity.this.m_20189_();
                CassowaryEntity entity = CassowaryEntity.this;
                Level world = CassowaryEntity.this.m_9236_();
                return super.m_8036_() && CassowarycanattackProcedure.execute((Entity)entity);
            }

            public boolean m_8045_() {
                double x = CassowaryEntity.this.m_20185_();
                double y = CassowaryEntity.this.m_20186_();
                double z = CassowaryEntity.this.m_20189_();
                CassowaryEntity entity = CassowaryEntity.this;
                Level world = CassowaryEntity.this.m_9236_();
                return super.m_8045_() && CassowarycanattackProcedure.execute((Entity)entity);
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new CassowaryBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new LayCassowaryEggGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new RestingGoal((PathfinderMob)this, this, 600));
        this.f_21345_.m_25352_(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(7, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 20.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(10, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.diggingTimer > 0) {
            --this.diggingTimer;
            if (this.diggingTimer == 0) {
                this.setDigging(false);
                if (!this.m_9236_().f_46443_) {
                    ItemStack seed = new ItemStack((ItemLike)this.getRandomSeedItem());
                    ItemEntity drop = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), seed);
                    this.m_9236_().m_7967_((Entity)drop);
                }
            }
        }
        if (!this.m_9236_().f_46443_ && !this.m_6162_() && "cassowarybaby".equals(this.getTexture())) {
            this.setTexture("cassowary");
        }
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:entity.cassowary.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:entity.cassowary.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:entity.cassowary.death"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
        compound.m_128379_("Datacanlayegg", ((Boolean)this.f_19804_.m_135370_(DATA_canlayegg)).booleanValue());
        compound.m_128379_("Dataaggression", ((Boolean)this.f_19804_.m_135370_(DATA_aggression)).booleanValue());
        compound.m_128379_("Datadigging", ((Boolean)this.f_19804_.m_135370_(DATA_digging)).booleanValue());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
        if (compound.m_128441_("Datacanlayegg")) {
            this.f_19804_.m_135381_(DATA_canlayegg, (Object)compound.m_128471_("Datacanlayegg"));
        }
        if (compound.m_128441_("Dataaggression")) {
            this.f_19804_.m_135381_(DATA_aggression, (Object)compound.m_128471_("Dataaggression"));
        }
        if (compound.m_128441_("Datadigging")) {
            this.f_19804_.m_135381_(DATA_digging, (Object)compound.m_128471_("Datadigging"));
        }
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_150930_(Items.f_42575_)) {
            BlockState groundState;
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11912_, this.m_5720_(), 1.0f, 1.0f);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (this.f_19796_.m_188501_() < 0.15f && this.m_5912_()) {
                this.m_21561_(false);
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), 3, 0.2, 0.3, 0.2, 0.0);
                }
            }
            if (!this.m_5912_() && !this.isDigging() && ((groundState = this.m_9236_().m_8055_(this.m_20183_().m_7495_())).m_60713_(Blocks.f_50493_) || groundState.m_60713_(Blocks.f_50440_) || groundState.m_60713_(Blocks.f_50093_))) {
                this.setDigging(true);
                this.diggingTimer = 40;
                this.triggerAnim("controller", "animation.dig");
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    BlockParticleOption dirtParticle = new BlockParticleOption(ParticleTypes.f_123794_, groundState);
                    serverLevel.m_8767_((ParticleOptions)dirtParticle, this.m_20185_(), this.m_20186_(), this.m_20189_(), 10, 0.25, 0.1, 0.25, 0.0);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.SUCCESS;
        }
        if (stack.m_150930_(Blocks.f_50186_.m_5456_()) && !this.m_5912_()) {
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            this.m_27595_(player);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        return null;
    }

    public void m_27563_(ServerLevel level, Animal partner) {
        this.readyToLayEgg = true;
        this.eggLayingTimer = 100;
        this.m_27594_();
        partner.m_27594_();
        this.m_146762_(6000);
        partner.m_146762_(6000);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_150930_(Items.f_42575_);
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)BiodiverseModEntities.CASSOWARY.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            return JungleBiomeSpawnsProcedure.execute((LevelAccessor)world, x, y, z);
        });
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        SpawnGroupData data = super.m_6518_(level, difficulty, reason, spawnData, tag);
        if (this.m_6162_()) {
            this.setTexture("cassowarybaby");
        } else {
            this.setTexture("cassowary");
        }
        return data;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 16.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 6.0);
        builder = builder.m_22268_(Attributes.f_22277_, 7.0);
        builder = builder.m_22268_(Attributes.f_22282_, 0.7);
        return builder;
    }

    @Nullable
    public BlockPos findNearbyFlatSpot(BlockPos center, int radius) {
        Level level = this.m_9236_();
        BlockPos best = null;
        double bestDist = Double.MAX_VALUE;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                double dist;
                BlockPos pos = center.m_7918_(dx, 0, dz);
                BlockPos above = pos.m_7494_();
                if (!level.m_8055_(pos).m_60804_((BlockGetter)level, pos) || !level.m_46859_(above) || !level.m_46859_(above.m_7494_()) || !((dist = center.m_123331_((Vec3i)pos)) < bestDist)) continue;
                bestDist = dist;
                best = pos;
            }
        }
        return best;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (this.isDigging()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.dig"));
            }
            if (this.isResting()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.sit"));
            }
            if (!(!event.isMoving() && event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.m_5912_())) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.walk"));
            }
            if (this.m_5912_() && event.isMoving()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.run"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.m_20185_() - this.f_19790_;
        double d0 = this.m_20189_() - this.f_19792_;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.m_21324_(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.m_9236_().m_46467_();
        }
        if (this.swinging && this.lastSwing + 7L <= this.m_9236_().m_46467_()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.attack"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 4, this::attackingPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public class CassowaryBreedGoal
    extends BreedGoal {
        private final CassowaryEntity cassowary;

        public CassowaryBreedGoal(CassowaryEntity animal, double speed) {
            super((Animal)animal, speed);
            this.cassowary = animal;
        }

        protected void m_8026_() {
            ServerLevel serverLevel = (ServerLevel)this.f_25114_;
            Animal partner = this.f_25115_;
            this.cassowary.m_27563_(serverLevel, partner);
        }
    }

    private class LayCassowaryEggGoal
    extends Goal {
        private final CassowaryEntity cassowary;
        private BlockPos targetPos;
        private final double speed = 1.0;
        private int restTicks = -1;

        public LayCassowaryEggGoal(CassowaryEntity cassowary) {
            this.cassowary = cassowary;
        }

        public boolean m_8036_() {
            return this.cassowary.readyToLayEgg && !this.cassowary.isResting();
        }

        public boolean m_8045_() {
            return this.cassowary.readyToLayEgg && this.targetPos != null;
        }

        public void m_8056_() {
            this.targetPos = this.cassowary.findNearbyFlatSpot(this.cassowary.m_20183_(), 6);
            if (this.targetPos != null) {
                this.cassowary.m_21573_().m_26519_((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_() + 0.5, 1.0);
            }
            this.restTicks = -1;
        }

        public void m_8037_() {
            boolean reachedTarget;
            if (this.targetPos == null) {
                return;
            }
            boolean bl = reachedTarget = this.cassowary.m_20183_().m_123314_((Vec3i)this.targetPos, 1.5) || this.cassowary.m_21573_().m_26571_();
            if (reachedTarget) {
                this.cassowary.m_21573_().m_26573_();
                if (this.restTicks == -1) {
                    this.cassowary.setResting(true);
                    this.restTicks = 60;
                } else if (this.restTicks > 0) {
                    --this.restTicks;
                } else {
                    if (!this.cassowary.m_9236_().f_46443_) {
                        BlockPos currentPos = this.cassowary.m_20183_();
                        BlockPos belowPos = currentPos.m_7495_();
                        BlockState ground = this.cassowary.m_9236_().m_8055_(belowPos);
                        BlockState current = this.cassowary.m_9236_().m_8055_(currentPos);
                        if (ground.m_60804_((BlockGetter)this.cassowary.m_9236_(), belowPos) && current.m_60722_(Fluids.f_76191_)) {
                            this.cassowary.m_9236_().m_46961_(currentPos, true);
                            this.cassowary.m_9236_().m_7731_(currentPos, ((Block)BiodiverseModBlocks.CASSOWARY_EGG.get()).m_49966_(), 3);
                        }
                    }
                    this.cassowary.readyToLayEgg = false;
                    this.cassowary.setResting(false);
                    this.targetPos = null;
                }
            }
        }

        public void m_8041_() {
            this.cassowary.setResting(false);
            this.targetPos = null;
            this.restTicks = -1;
        }
    }
}

