/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.biodiverse.entity;

import java.util.List;
import net.mcreator.biodiverse.ai.goal.RestingGoal;
import net.mcreator.biodiverse.entity.CapybaraEntity;
import net.mcreator.biodiverse.init.BiodiverseModEntities;
import net.mcreator.biodiverse.procedures.JungleBiomeSpawnsProcedure;
import net.mcreator.biodiverse.procedures.StopSneakingProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class JaguarEntity
extends Animal
implements GeoEntity,
RestingGoal.RestingAnimatable {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(JaguarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(JaguarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(JaguarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> RESTING = SynchedEntityData.m_135353_(JaguarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    private boolean isResting = false;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public JaguarEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<JaguarEntity>)((EntityType)BiodiverseModEntities.JAGUAR.get()), world);
    }

    public JaguarEntity(EntityType<JaguarEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_274367_(0.7f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"jaguar");
        this.f_19804_.m_135372_(RESTING, (Object)false);
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    @Override
    public void setResting(boolean value) {
        this.f_19804_.m_135381_(RESTING, (Object)value);
    }

    @Override
    public boolean isResting() {
        return (Boolean)this.f_19804_.m_135370_(RESTING);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.4, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            public boolean m_8036_() {
                Mob mob = this.f_26135_;
                if (!(mob instanceof JaguarEntity)) {
                    return false;
                }
                JaguarEntity jaguar = (JaguarEntity)mob;
                Player nearestPlayer = jaguar.m_9236_().m_45930_((Entity)jaguar, 12.0);
                if (nearestPlayer == null || !nearestPlayer.m_6084_()) {
                    return false;
                }
                if (jaguar.m_21223_() <= 8.0f) {
                    return false;
                }
                double distanceSq = jaguar.m_20280_((Entity)nearestPlayer);
                if (distanceSq <= 9.0) {
                    return true;
                }
                if (this.isPlayerLookingAtEntity(nearestPlayer, (LivingEntity)jaguar)) {
                    return false;
                }
                return super.m_8036_();
            }

            public boolean m_8045_() {
                Player player;
                Mob mob = this.f_26135_;
                if (!(mob instanceof JaguarEntity)) {
                    return false;
                }
                JaguarEntity jaguar = (JaguarEntity)mob;
                LivingEntity target = jaguar.m_5448_();
                if (!(target instanceof Player) || !(player = (Player)target).m_6084_()) {
                    return false;
                }
                if (jaguar.m_21223_() <= 8.0f) {
                    return false;
                }
                double distanceSq = jaguar.m_20280_((Entity)player);
                if (distanceSq <= 9.0) {
                    return true;
                }
                if (this.isPlayerLookingAtEntity(player, (LivingEntity)jaguar)) {
                    return false;
                }
                return super.m_8045_();
            }

            private boolean isPlayerLookingAtEntity(Player player, LivingEntity target) {
                Vec3 toEntity;
                Vec3 playerLook = player.m_20154_().m_82541_();
                double dot = playerLook.m_82526_(toEntity = target.m_20182_().m_82546_(player.m_20182_()).m_82541_());
                return dot > 0.6 && player.m_142582_((Entity)target);
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new AvoidEntityGoal<Player>((PathfinderMob)this, Player.class, 6.0f, 1.0, 1.2){

            public boolean m_8036_() {
                PathfinderMob pathfinderMob = this.f_25015_;
                if (!(pathfinderMob instanceof JaguarEntity)) {
                    return false;
                }
                JaguarEntity jaguar = (JaguarEntity)pathfinderMob;
                return jaguar.m_21223_() <= 8.0f && super.m_8036_();
            }
        });
        this.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)this, CapybaraEntity.class, true, true));
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Pig.class, false, false));
        this.f_21345_.m_25352_(7, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new FollowParentGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(9, (Goal)new RestingGoal((PathfinderMob)this, this, 400));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(11, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(12, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(13, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:jaguar.ambient"));
    }

    public void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.wolf.step")), 0.15f, 1.0f);
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:jaguar.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:jaguar.hurt"));
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        StopSneakingProcedure.execute((Entity)this);
        return super.m_142535_(l, d, source);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        StopSneakingProcedure.execute((Entity)this);
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
    }

    public void m_5993_(Entity entity, int score, DamageSource damageSource) {
        super.m_5993_(entity, score, damageSource);
        StopSneakingProcedure.execute(entity);
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        JaguarEntity retval = (JaguarEntity)((EntityType)BiodiverseModEntities.JAGUAR.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return List.of(Items.f_42658_, Items.f_42579_, Items.f_42581_).contains(stack.m_41720_());
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)BiodiverseModEntities.JAGUAR.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            return JungleBiomeSpawnsProcedure.execute((LevelAccessor)world, x, y, z);
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 18.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 5.0);
        builder = builder.m_22268_(Attributes.f_22277_, 25.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (this.isResting()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.TigerRest"));
            }
            if (!(!event.isMoving() && event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.m_5912_())) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.TigerWalk"));
            }
            if (this.m_6144_() && event.isMoving()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.TigerSneak"));
            }
            if (this.m_5912_() && event.isMoving()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.TigerRun"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.TigerIdle"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

