/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.biodiverse.entity;

import javax.annotation.Nullable;
import net.mcreator.biodiverse.ai.goal.MeerkatWalkToBurrowGoal;
import net.mcreator.biodiverse.block.DirtBurrowBlock;
import net.mcreator.biodiverse.entity.LionEntity;
import net.mcreator.biodiverse.init.BiodiverseModEntities;
import net.mcreator.biodiverse.procedures.MeerkatAlertNearbyProcedure;
import net.mcreator.biodiverse.procedures.MeerkatCanEnterProcedure;
import net.mcreator.biodiverse.procedures.MeerkatSpawnsProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class MeerkatEntity
extends Animal
implements GeoEntity {
    private static final EntityDataAccessor<BlockPos> HOME_POS = SynchedEntityData.m_135353_(MeerkatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public static final EntityDataAccessor<Boolean> IS_ENTERING_BURROW = SynchedEntityData.m_135353_(MeerkatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(MeerkatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(MeerkatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(MeerkatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> DATA_canenter = SynchedEntityData.m_135353_(MeerkatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    public static long lastMeerkatAlertTime = 0L;
    private BlockPos homePos;
    String prevAnim = "empty";

    public MeerkatEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<MeerkatEntity>)((EntityType)BiodiverseModEntities.MEERKAT.get()), world);
    }

    public void findAndAssignNearestBurrow() {
        BlockPos currentPos = this.m_20183_();
        BlockPos closest = null;
        double closestDistance = Double.MAX_VALUE;
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int dx = -16; dx <= 16; ++dx) {
            for (int dy = -4; dy <= 4; ++dy) {
                for (int dz = -16; dz <= 16; ++dz) {
                    double dist;
                    mutable.m_122178_(currentPos.m_123341_() + dx, currentPos.m_123342_() + dy, currentPos.m_123343_() + dz);
                    if (!(this.m_9236_().m_8055_((BlockPos)mutable).m_60734_() instanceof DirtBurrowBlock) || !((dist = mutable.m_123331_((Vec3i)currentPos)) < closestDistance)) continue;
                    closest = mutable.m_7949_();
                    closestDistance = dist;
                }
            }
        }
        if (closest != null) {
            this.setHomePos(closest);
            System.out.println("New burrow assigned: " + closest);
        }
    }

    public MeerkatEntity(EntityType<MeerkatEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_274367_(0.6f);
        this.m_21530_();
    }

    public BlockPos getHomePos() {
        return this.homePos;
    }

    public void setHomePos(BlockPos pos) {
        this.homePos = pos;
        this.m_21446_(pos, 10);
    }

    public boolean isHomeBurrowValid() {
        if (this.homePos == null) {
            return false;
        }
        return this.m_9236_().m_8055_(this.homePos).m_60734_() instanceof DirtBurrowBlock;
    }

    public BlockPos findNearestDirtBurrow(Level level, BlockPos startPos, int radius) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        BlockPos closest = null;
        double closestDistSq = Double.MAX_VALUE;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    double distSq;
                    mutable.m_122178_(startPos.m_123341_() + x, startPos.m_123342_() + y, startPos.m_123343_() + z);
                    if (!(level.m_8055_((BlockPos)mutable).m_60734_() instanceof DirtBurrowBlock) || !((distSq = mutable.m_123331_((Vec3i)startPos)) < closestDistSq)) continue;
                    closest = mutable.m_7949_();
                    closestDistSq = distSq;
                }
            }
        }
        return closest;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_ENTERING_BURROW, (Object)false);
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"meerkat");
        this.f_19804_.m_135372_(DATA_canenter, (Object)true);
    }

    public boolean isEnteringBurrow() {
        return (Boolean)this.f_19804_.m_135370_(IS_ENTERING_BURROW);
    }

    public void setEnteringBurrow(boolean entering) {
        this.f_19804_.m_135381_(IS_ENTERING_BURROW, (Object)entering);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            BlockPos found;
            if (this.homePos == null) {
                BlockPos found2 = this.findNearestDirtBurrow(this.m_9236_(), this.m_20183_(), 16);
                if (found2 != null) {
                    this.setHomePos(found2);
                    this.m_21446_(found2, 12);
                }
            } else if (this.f_19797_ % 200 == 0 && !this.isHomeBurrowValid() && (found = this.findNearestDirtBurrow(this.m_9236_(), this.m_20183_(), 16)) != null) {
                this.setHomePos(found);
                this.m_21446_(found, 12);
            }
        }
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean result = super.m_6469_(source, amount);
        if (!this.m_9236_().f_46443_) {
            lastMeerkatAlertTime = this.m_9236_().m_46467_();
        }
        return result;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, LionEntity.class, 16.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new MeerkatWalkToBurrowGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 16.0f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 16.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:entity.meerkat.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:entity.meerkat.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:entity.meerkat.death"));
    }

    public InteractionResult m_6071_(Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        super.m_6071_(sourceentity, hand);
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        MeerkatEntity entity = this;
        Level world = this.m_9236_();
        MeerkatAlertNearbyProcedure.execute((LevelAccessor)world, x, y, z, (Entity)sourceentity);
        return retval;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        MeerkatCanEnterProcedure.execute((LevelAccessor)world, (Entity)this);
        return retval;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.homePos != null) {
            compound.m_128365_("HomePos", (Tag)NbtUtils.m_129224_((BlockPos)this.homePos));
        }
        compound.m_128359_("Texture", this.getTexture());
        compound.m_128379_("Datacanenter", ((Boolean)this.f_19804_.m_135370_(DATA_canenter)).booleanValue());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("HomePos")) {
            this.homePos = NbtUtils.m_129239_((CompoundTag)compound.m_128469_("HomePos"));
        }
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
        if (compound.m_128441_("Datacanenter")) {
            this.f_19804_.m_135381_(DATA_canenter, (Object)compound.m_128471_("Datacanenter"));
        }
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        MeerkatEntity retval = (MeerkatEntity)((EntityType)BiodiverseModEntities.MEERKAT.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)BiodiverseModEntities.MEERKAT.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            return MeerkatSpawnsProcedure.execute((LevelAccessor)world, x, y, z);
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 10.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 0.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (event.isMoving() || !(event.getLimbSwingAmount() > -0.15f) || !(event.getLimbSwingAmount() < 0.15f)) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.meerkat.walk"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.meerkat.idle"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

