/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.biodiverse.entity;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mcreator.biodiverse.entity.OrangutanEntityProjectile;
import net.mcreator.biodiverse.init.BiodiverseModEntities;
import net.mcreator.biodiverse.procedures.ClimbingProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OrangutanEntity
extends Animal
implements RangedAttackMob,
GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(OrangutanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(OrangutanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(OrangutanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(OrangutanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final TagKey<Item> SEED_TAG = TagKey.m_203882_((ResourceKey)BuiltInRegistries.f_257033_.m_123023_(), (ResourceLocation)new ResourceLocation("forge", "seeds"));
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    private final ItemStackHandler inventory = new ItemStackHandler(27){

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});
    String prevAnim = "empty";

    public OrangutanEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<OrangutanEntity>)((EntityType)BiodiverseModEntities.ORANGUTAN.get()), world);
    }

    public OrangutanEntity(EntityType<OrangutanEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_274367_(0.6f);
    }

    protected PathNavigation m_6037_(Level world) {
        return new WallClimberNavigation((Mob)this, world);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            boolean shouldClimb = false;
            if (this.f_19862_) {
                BlockPos pos = this.m_20183_().m_121945_(this.m_6350_());
                BlockState state = this.m_9236_().m_8055_(pos);
                if (state.m_204336_(BlockTags.f_13106_)) {
                    shouldClimb = true;
                }
            }
            this.setClimbing(shouldClimb);
        }
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean world) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = world ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"orangutan");
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(LivingEntity entity) {
                return 4.0;
            }

            public boolean m_8036_() {
                LivingEntity target = this.f_25540_.m_5448_();
                if (target instanceof OrangutanEntity) {
                    return false;
                }
                return super.m_8036_();
            }

            public boolean m_8045_() {
                LivingEntity target = this.f_25540_.m_5448_();
                if (target instanceof OrangutanEntity) {
                    return false;
                }
                return super.m_8045_();
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new FollowMobGoal((Mob)this, 1.0, 10.0f, 5.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(8, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RangedAttackGoal(this, 1.25, 20, 10.0f){

            @Override
            public boolean m_8045_() {
                return this.m_8036_();
            }
        });
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:orangutan.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:orangutan.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:orangutan.death"));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_276093_(DamageTypes.f_268671_)) {
            return false;
        }
        Entity attacker = source.m_7639_();
        if (attacker instanceof OrangutanEntity) {
            return super.m_6469_(source, amount);
        }
        return super.m_6469_(source, amount);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER && side == null) {
            return LazyOptional.of(() -> this.combined).cast();
        }
        return super.getCapability(capability, side);
    }

    protected void m_5907_() {
        super.m_5907_();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
            this.m_19983_(itemstack);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("InventoryCustom", (Tag)this.inventory.serializeNBT());
        compound.m_128359_("Texture", this.getTexture());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        Tag inventoryCustom = compound.m_128423_("InventoryCustom");
        if (inventoryCustom instanceof CompoundTag) {
            CompoundTag inventoryTag = (CompoundTag)inventoryCustom;
            this.inventory.deserializeNBT(inventoryTag);
        }
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
    }

    private boolean isAxe(ItemStack stack) {
        return stack.m_150930_(Items.f_42423_) || stack.m_150930_(Items.f_42428_) || stack.m_150930_(Items.f_42386_) || stack.m_150930_(Items.f_42391_) || stack.m_150930_(Items.f_42396_);
    }

    private boolean isShovel(ItemStack stack) {
        return stack.m_150930_(Items.f_42421_) || stack.m_150930_(Items.f_42426_) || stack.m_150930_(Items.f_42384_) || stack.m_150930_(Items.f_42389_) || stack.m_150930_(Items.f_42394_);
    }

    private boolean isHoe(ItemStack stack) {
        return stack.m_150930_(Items.f_42424_) || stack.m_150930_(Items.f_42429_) || stack.m_150930_(Items.f_42387_) || stack.m_150930_(Items.f_42392_) || stack.m_150930_(Items.f_42397_);
    }

    public void m_6075_() {
        super.m_6075_();
        ClimbingProcedure.execute((LevelAccessor)this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), (Entity)this);
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    public void m_6504_(LivingEntity target, float flval) {
        OrangutanEntityProjectile entityarrow = new OrangutanEntityProjectile((EntityType<? extends OrangutanEntityProjectile>)((EntityType)BiodiverseModEntities.ORANGUTAN_PROJECTILE.get()), (LivingEntity)this, this.m_9236_());
        double d0 = target.m_20186_() + (double)target.m_20192_() - 1.1;
        double d1 = target.m_20185_() - this.m_20185_();
        double d3 = target.m_20189_() - this.m_20189_();
        entityarrow.m_6686_(d1, d0 - entityarrow.m_20186_() + Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f, d3, 1.6f, 12.0f);
        this.m_9236_().m_7967_((Entity)entityarrow);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        OrangutanEntity retval = (OrangutanEntity)((EntityType)BiodiverseModEntities.ORANGUTAN.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return List.of(Items.f_42575_).contains(stack.m_41720_());
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)BiodiverseModEntities.ORANGUTAN.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184228_) && world.m_45524_(pos, 0) > 8);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (!(!event.isMoving() && event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.m_20142_())) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.orangutan.walk"));
            }
            if (this.m_6144_()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.orangutan.hang"));
            }
            if (this.m_20142_()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.orangutan.climb"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.orangutan.idle"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 10, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 10, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean addItemToInventory(ItemStack stack) {
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            int maxStack;
            ItemStack slotStack = this.inventory.getStackInSlot(slot);
            if (slotStack.m_41619_()) {
                this.inventory.setStackInSlot(slot, stack.m_41777_());
                return true;
            }
            if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)stack)) continue;
            int combinedCount = slotStack.m_41613_() + stack.m_41613_();
            if (combinedCount <= (maxStack = Math.min(slotStack.m_41741_(), this.inventory.getSlotLimit(slot)))) {
                slotStack.m_41764_(combinedCount);
                return true;
            }
            if (slotStack.m_41613_() >= maxStack) continue;
            int toAdd = maxStack - slotStack.m_41613_();
            slotStack.m_41764_(maxStack);
            stack.m_41774_(toAdd);
        }
        return stack.m_41619_();
    }

    public class OrangutanHarvestGoal
    extends Goal {
        private final OrangutanEntity orangutan;
        private final Level level;

        public OrangutanHarvestGoal(OrangutanEntity orangutan) {
            this.orangutan = orangutan;
            this.level = orangutan.m_9236_();
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return !this.level.f_46443_ && this.orangutan.m_217043_().m_188501_() < 0.05f;
        }

        public void m_8037_() {
            ItemStack held = this.orangutan.m_21205_();
            BlockPos orangutanPos = this.orangutan.m_20183_();
            BlockPos targetPos = this.findNearbyTargetBlock(orangutanPos);
            if (targetPos == null) {
                return;
            }
            BlockState state = this.level.m_8055_(targetPos);
            if (this.isAxe(held) && state.m_204336_(BlockTags.f_13106_)) {
                this.breakBlockAndCollect(targetPos, held);
            } else if (this.isShovel(held) && (state.m_204336_(BlockTags.f_144274_) || state.m_60713_(Blocks.f_49992_) || state.m_60713_(Blocks.f_49994_))) {
                this.breakBlockAndCollect(targetPos, held);
            } else if (this.isHoe(held) && this.isFullyGrownCrop(state)) {
                this.breakBlockAndCollect(targetPos, held);
            }
            this.tryPlantSeed();
        }

        private boolean isAxe(ItemStack stack) {
            return stack.m_150930_(Items.f_42423_) || stack.m_150930_(Items.f_42428_) || stack.m_150930_(Items.f_42386_) || stack.m_150930_(Items.f_42391_) || stack.m_150930_(Items.f_42396_);
        }

        private boolean isShovel(ItemStack stack) {
            return stack.m_150930_(Items.f_42421_) || stack.m_150930_(Items.f_42426_) || stack.m_150930_(Items.f_42384_) || stack.m_150930_(Items.f_42389_) || stack.m_150930_(Items.f_42394_);
        }

        private boolean isHoe(ItemStack stack) {
            return stack.m_150930_(Items.f_42424_) || stack.m_150930_(Items.f_42429_) || stack.m_150930_(Items.f_42387_) || stack.m_150930_(Items.f_42392_) || stack.m_150930_(Items.f_42397_);
        }

        private boolean isSeed(ItemStack stack) {
            if (stack.m_41619_()) {
                return false;
            }
            return stack.m_41720_().m_204114_().m_203656_(SEED_TAG);
        }

        private boolean isLogItem(ItemStack stack) {
            if (stack.m_41619_()) {
                return false;
            }
            Item item = stack.m_41720_();
            ResourceLocation id = item.m_204114_().m_205785_().m_135782_();
            if (id == null) {
                return false;
            }
            return id.m_135815_().toLowerCase().contains("log");
        }

        private boolean isFullyGrownCrop(BlockState state) {
            CropBlock crop;
            Block block = state.m_60734_();
            return block instanceof CropBlock && (crop = (CropBlock)block).m_52307_(state);
        }

        private BlockPos findNearbyTargetBlock(BlockPos center) {
            List<BlockPos> candidates = List.of(center, center.m_7495_(), center.m_122012_(), center.m_122019_(), center.m_122029_(), center.m_122024_());
            for (BlockPos pos : candidates) {
                BlockState state = this.level.m_8055_(pos);
                if (!state.m_204336_(BlockTags.f_13106_) && !state.m_204336_(BlockTags.f_144274_) && !state.m_60713_(Blocks.f_49992_) && !state.m_60713_(Blocks.f_49994_) && !this.isFullyGrownCrop(state)) continue;
                return pos.m_7949_();
            }
            return null;
        }

        private void breakBlockAndCollect(BlockPos pos, ItemStack tool) {
            Level level = this.level;
            if (!(level instanceof ServerLevel)) {
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            BlockState state = this.level.m_8055_(pos);
            this.level.m_46961_(pos, false);
            LootParams.Builder lootParamsBuilder = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_287286_(LootContextParams.f_81463_, (Object)tool).m_287286_(LootContextParams.f_81455_, (Object)this.orangutan);
            List drops = state.m_287290_(lootParamsBuilder);
            for (ItemStack drop : drops) {
                boolean added;
                if (!this.isSeed(drop) && !this.isLogItem(drop) && !drop.m_150930_(Items.f_41830_) && !drop.m_150930_(Items.f_41832_) && !drop.m_150930_(Items.f_42329_) || (added = this.orangutan.addItemToInventory(drop))) continue;
                this.orangutan.m_19983_(drop);
            }
            tool.m_41622_(1, (LivingEntity)this.orangutan, e -> e.m_21190_(InteractionHand.MAIN_HAND));
        }

        private void tryPlantSeed() {
            for (int i = 0; i < this.orangutan.inventory.getSlots(); ++i) {
                BlockPos plantPos;
                BlockState groundState;
                ItemStack stack = this.orangutan.inventory.getStackInSlot(i);
                if (!this.isSeed(stack) || stack.m_41613_() <= 0 || !(groundState = this.level.m_8055_(plantPos = this.orangutan.m_20183_().m_7495_())).m_204336_(BlockTags.f_144274_) && !groundState.m_60713_(Blocks.f_50093_)) continue;
                this.level.m_7731_(plantPos, Blocks.f_50092_.m_49966_(), 3);
                stack.m_41774_(1);
                if (!stack.m_41619_()) break;
                this.orangutan.inventory.setStackInSlot(i, ItemStack.f_41583_);
                break;
            }
        }
    }

    public class RangedAttackGoal
    extends Goal {
        private final Mob mob;
        private final RangedAttackMob rangedAttackMob;
        @Nullable
        private LivingEntity target;
        private int attackTime = -1;
        private final double speedModifier;
        private int seeTime;
        private final int attackIntervalMin;
        private final int attackIntervalMax;
        private final float attackRadius;
        private final float attackRadiusSqr;

        public RangedAttackGoal(RangedAttackMob p_25768_, double p_25769_, int p_25770_, float p_25771_) {
            this(p_25768_, p_25769_, p_25770_, p_25770_, p_25771_);
        }

        public RangedAttackGoal(RangedAttackMob p_25773_, double p_25774_, int p_25775_, int p_25776_, float p_25777_) {
            if (!(p_25773_ instanceof LivingEntity)) {
                throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
            }
            this.rangedAttackMob = p_25773_;
            this.mob = (Mob)p_25773_;
            this.speedModifier = p_25774_;
            this.attackIntervalMin = p_25775_;
            this.attackIntervalMax = p_25776_;
            this.attackRadius = p_25777_;
            this.attackRadiusSqr = p_25777_ * p_25777_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            if (livingentity != null && livingentity.m_6084_()) {
                if (livingentity instanceof OrangutanEntity) {
                    return false;
                }
                this.target = livingentity;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            if (this.target instanceof OrangutanEntity) {
                return false;
            }
            return this.m_8036_() || this.target != null && this.target.m_6084_() && !this.mob.m_21573_().m_26571_();
        }

        public void m_8041_() {
            this.target = null;
            this.seeTime = 0;
            this.attackTime = -1;
            ((OrangutanEntity)this.rangedAttackMob).f_19804_.m_135381_(SHOOT, (Object)false);
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            double d0 = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
            boolean flag = this.mob.m_21574_().m_148306_((Entity)this.target);
            this.seeTime = flag ? ++this.seeTime : 0;
            if (!(d0 > (double)this.attackRadiusSqr) && this.seeTime >= 5) {
                this.mob.m_21573_().m_26573_();
            } else {
                this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
            }
            this.mob.m_21563_().m_24960_((Entity)this.target, 30.0f, 30.0f);
            if (--this.attackTime == 0) {
                if (!flag) {
                    ((OrangutanEntity)this.rangedAttackMob).f_19804_.m_135381_(SHOOT, (Object)false);
                    return;
                }
                ((OrangutanEntity)this.rangedAttackMob).f_19804_.m_135381_(SHOOT, (Object)true);
                float f = (float)Math.sqrt(d0) / this.attackRadius;
                float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
                this.rangedAttackMob.m_6504_(this.target, f1);
                this.attackTime = Mth.m_14143_((float)(f * (float)(this.attackIntervalMax - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.attackTime < 0) {
                this.attackTime = Mth.m_14107_((double)Mth.m_14139_((double)(Math.sqrt(d0) / (double)this.attackRadius), (double)this.attackIntervalMin, (double)this.attackIntervalMax));
            } else {
                ((OrangutanEntity)this.rangedAttackMob).f_19804_.m_135381_(SHOOT, (Object)false);
            }
        }
    }
}

