/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.biodiverse.entity;

import io.netty.buffer.Unpooled;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mcreator.biodiverse.ai.goal.RestingGoal;
import net.mcreator.biodiverse.init.BiodiverseModBlocks;
import net.mcreator.biodiverse.init.BiodiverseModEntities;
import net.mcreator.biodiverse.init.BiodiverseModItems;
import net.mcreator.biodiverse.procedures.OstrichSaddleProcedure;
import net.mcreator.biodiverse.procedures.RhinoTamedProcedure;
import net.mcreator.biodiverse.procedures.SavannaBiomeSpawnsProcedure;
import net.mcreator.biodiverse.world.inventory.OstrichInventoryMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class OstrichEntity
extends TamableAnimal
implements GeoEntity,
RestingGoal.RestingAnimatable {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> RESTING = SynchedEntityData.m_135353_(OstrichEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    private int eggLayingTimer = 0;
    private int breedingTimer = 0;
    private boolean readyToLayEgg = false;
    private boolean isResting = false;
    public String animationprocedure = "empty";
    private final ItemStackHandler inventory = new ItemStackHandler(2){

        public int getSlotLimit(int slot) {
            return 16;
        }
    };
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});

    public OstrichEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<OstrichEntity>)((EntityType)BiodiverseModEntities.OSTRICH.get()), world);
    }

    public OstrichEntity(EntityType<OstrichEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_274367_(1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"ostrich");
        this.f_19804_.m_135372_(RESTING, (Object)false);
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    @Override
    public void setResting(boolean value) {
        this.f_19804_.m_135381_(RESTING, (Object)value);
    }

    @Override
    public boolean isResting() {
        return (Boolean)this.f_19804_.m_135370_(RESTING);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new PanicGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(2, (Goal)new OstrichBreedGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LayOstrichEggGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42575_}), true));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(9, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public double m_6048_() {
        return super.m_6048_() + -0.3;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:ostrich.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:ostrich.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:ostrich.death"));
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER && side == null) {
            return LazyOptional.of(() -> this.combined).cast();
        }
        return super.getCapability(capability, side);
    }

    protected void m_5907_() {
        super.m_5907_();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
            this.m_19983_(itemstack);
        }
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
        super.m_7472_(source, looting, recentlyHit);
        RandomSource random = this.m_217043_();
        int rawCount = Mth.m_216271_((RandomSource)random, (int)1, (int)2);
        this.m_19983_(new ItemStack((ItemLike)BiodiverseModItems.RAW_FLIGHTLESS_BIRD.get(), rawCount));
        int featherCount = Mth.m_216271_((RandomSource)random, (int)2, (int)4);
        this.m_19983_(new ItemStack((ItemLike)Items.f_42402_, featherCount));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        return retval;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("InventoryCustom", (Tag)this.inventory.serializeNBT());
        compound.m_128359_("Texture", this.getTexture());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        Tag inventoryCustom = compound.m_128423_("InventoryCustom");
        if (inventoryCustom instanceof CompoundTag) {
            CompoundTag inventoryTag = (CompoundTag)inventoryCustom;
            this.inventory.deserializeNBT(inventoryTag);
        }
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
    }

    public InteractionResult m_6071_(final Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        Item item = itemstack.m_41720_();
        boolean clientSide = this.m_9236_().m_5776_();
        if (player.m_36341_() && player.m_6144_() && this.m_21824_() && (!this.m_6162_() || !this.m_21830_((LivingEntity)player))) {
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237113_((String)"Ostrich");
                    }

                    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player p) {
                        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                        buf.m_130064_(player.m_20183_());
                        buf.writeByte(0);
                        buf.m_130130_(OstrichEntity.this.m_19879_());
                        return new OstrichInventoryMenu(id, inventory, buf);
                    }
                }, buf -> {
                    buf.m_130064_(player.m_20183_());
                    buf.writeByte(0);
                    buf.m_130130_(this.m_19879_());
                });
            }
            return InteractionResult.m_19078_((boolean)clientSide);
        }
        if (item instanceof SpawnEggItem) {
            return super.m_6071_(player, hand);
        }
        if (clientSide) {
            return InteractionResult.m_19078_((boolean)clientSide);
        }
        if (itemstack.m_150930_(Items.f_42575_)) {
            this.m_142075_(player, hand, itemstack);
            if (this.m_21824_()) {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(4.0f);
                }
            } else if (this.f_19796_.m_188501_() < 0.2f && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)player)) {
                this.m_21828_(player);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.m_19078_((boolean)clientSide);
        }
        if (itemstack.m_150930_(Blocks.f_50186_.m_5456_())) {
            this.m_142075_(player, hand, itemstack);
            this.m_27595_(player);
            return InteractionResult.m_19078_((boolean)clientSide);
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)player) && !this.inventory.getStackInSlot(1).m_41619_() && this.inventory.getStackInSlot(1).m_41720_() == Items.f_42450_) {
            player.m_20329_((Entity)this);
            RhinoTamedProcedure.execute((Entity)this, (Entity)player);
            return InteractionResult.m_19078_((boolean)clientSide);
        }
        InteractionResult superResult = super.m_6071_(player, hand);
        if (superResult == InteractionResult.SUCCESS || superResult == InteractionResult.CONSUME) {
            this.m_21530_();
        }
        return superResult;
    }

    public void m_6075_() {
        super.m_6075_();
        OstrichSaddleProcedure.execute((Entity)this);
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        return null;
    }

    public void m_27563_(ServerLevel level, Animal partner) {
        this.readyToLayEgg = true;
        this.eggLayingTimer = 100;
        this.m_27594_();
        partner.m_27594_();
        this.m_146762_(6000);
        partner.m_146762_(6000);
    }

    public boolean m_6898_(ItemStack stack) {
        return List.of(Items.f_42575_).contains(stack.m_41720_());
    }

    public ItemStack getItem(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.setStackInSlot(slot, stack);
    }

    public int getContainerSize() {
        return this.inventory.getSlots();
    }

    public void m_7023_(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
        if (this.m_20160_()) {
            double d0;
            double d1;
            float f1;
            this.m_146922_(entity.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(entity.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = entity.m_146908_();
            this.f_20885_ = entity.m_146908_();
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                float forward = passenger.f_20902_;
                float strafe = 0.0f;
                super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward));
            }
            if ((f1 = (float)Math.sqrt((d1 = this.m_20185_() - this.f_19854_) * d1 + (d0 = this.m_20189_() - this.f_19856_) * d0) * 4.0f) > 1.0f) {
                f1 = 1.0f;
            }
            this.f_267362_.m_267771_(this.f_267362_.m_267731_() + (f1 - this.f_267362_.m_267731_()) * 0.4f);
            this.f_267362_.m_267590_(this.f_267362_.m_267756_() + this.f_267362_.m_267731_());
            this.m_267651_(true);
            return;
        }
        super.m_7023_(dir);
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)BiodiverseModEntities.OSTRICH.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            return SavannaBiomeSpawnsProcedure.execute((LevelAccessor)world, x, y, z);
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.4);
        builder = builder.m_22268_(Attributes.f_22276_, 20.0);
        builder = builder.m_22268_(Attributes.f_22284_, 10.0);
        builder = builder.m_22268_(Attributes.f_22281_, 8.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22282_, 1.0);
        return builder;
    }

    @Nullable
    public BlockPos findNearbyFlatSpot(BlockPos center, int radius) {
        Level level = this.m_9236_();
        BlockPos best = null;
        double bestDist = Double.MAX_VALUE;
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                double dist;
                BlockPos pos = center.m_7918_(dx, 0, dz);
                BlockPos above = pos.m_7494_();
                if (!level.m_8055_(pos).m_60804_((BlockGetter)level, pos) || !level.m_46859_(above) || !level.m_46859_(above.m_7494_()) || !((dist = center.m_123331_((Vec3i)pos)) < bestDist)) continue;
                bestDist = dist;
                best = pos;
            }
        }
        return best;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (this.isResting()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.ostrich.idle2"));
            }
            if (!(!event.isMoving() && event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.m_20160_())) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.ostrich.walk"));
            }
            if (this.m_20142_()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.ostrich.run"));
            }
            if (this.m_20160_() && event.isMoving()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.ostrich.run"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.ostrich.idle"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            return PlayState.STOP;
        }
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public class OstrichBreedGoal
    extends BreedGoal {
        private final OstrichEntity ostrich;

        public OstrichBreedGoal(OstrichEntity animal, double speed) {
            super((Animal)animal, speed);
            this.ostrich = animal;
        }

        protected void m_8026_() {
            ServerLevel serverLevel = (ServerLevel)this.f_25114_;
            Animal partner = this.f_25115_;
            this.ostrich.m_27563_(serverLevel, partner);
        }
    }

    private class LayOstrichEggGoal
    extends Goal {
        private final OstrichEntity ostrich;
        private BlockPos targetPos;
        private final double speed = 1.0;
        private int restTicks = -1;

        public LayOstrichEggGoal(OstrichEntity ostrich) {
            this.ostrich = ostrich;
        }

        public boolean m_8036_() {
            return this.ostrich.readyToLayEgg && !this.ostrich.isResting();
        }

        public boolean m_8045_() {
            return this.ostrich.readyToLayEgg && this.targetPos != null;
        }

        public void m_8056_() {
            this.targetPos = this.ostrich.findNearbyFlatSpot(this.ostrich.m_20183_(), 6);
            if (this.targetPos != null) {
                this.ostrich.m_21573_().m_26519_((double)this.targetPos.m_123341_() + 0.5, (double)this.targetPos.m_123342_(), (double)this.targetPos.m_123343_() + 0.5, 1.0);
            }
            this.restTicks = -1;
        }

        public void m_8037_() {
            boolean reachedTarget;
            if (this.targetPos == null) {
                return;
            }
            boolean bl = reachedTarget = this.ostrich.m_20183_().m_123314_((Vec3i)this.targetPos, 1.5) || this.ostrich.m_21573_().m_26571_();
            if (reachedTarget) {
                this.ostrich.m_21573_().m_26573_();
                if (this.restTicks == -1) {
                    this.ostrich.setResting(true);
                    this.restTicks = 60;
                } else if (this.restTicks > 0) {
                    --this.restTicks;
                } else {
                    if (!this.ostrich.m_9236_().f_46443_) {
                        BlockPos currentPos = this.ostrich.m_20183_();
                        BlockPos belowPos = currentPos.m_7495_();
                        BlockState ground = this.ostrich.m_9236_().m_8055_(belowPos);
                        BlockState current = this.ostrich.m_9236_().m_8055_(currentPos);
                        if (ground.m_60804_((BlockGetter)this.ostrich.m_9236_(), belowPos) && current.m_60722_(Fluids.f_76191_)) {
                            this.ostrich.m_9236_().m_46961_(currentPos, true);
                            this.ostrich.m_9236_().m_7731_(currentPos, ((Block)BiodiverseModBlocks.OSTRICH_EGG.get()).m_49966_(), 3);
                        }
                    }
                    this.ostrich.readyToLayEgg = false;
                    this.ostrich.setResting(false);
                    this.targetPos = null;
                }
            }
        }

        public void m_8041_() {
            this.ostrich.setResting(false);
            this.targetPos = null;
            this.restTicks = -1;
        }
    }
}

