/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.biodiverse.entity;

import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mcreator.biodiverse.init.BiodiverseModEntities;
import net.mcreator.biodiverse.item.DiamondRhinocerosArmorItem;
import net.mcreator.biodiverse.item.GoldRhinocerosArmorItem;
import net.mcreator.biodiverse.item.IronRhinocerosArmorItem;
import net.mcreator.biodiverse.procedures.RhinoBeingRiddenTrueProcedure;
import net.mcreator.biodiverse.procedures.RhinoTamedProcedure;
import net.mcreator.biodiverse.procedures.RhinocerosArmorProcedure;
import net.mcreator.biodiverse.procedures.RhinocerosVariantsProcedure;
import net.mcreator.biodiverse.procedures.SavannaBiomeSpawnsProcedure;
import net.mcreator.biodiverse.world.inventory.RhinoInventoryMenu;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.EntityArmorInvWrapper;
import net.minecraftforge.items.wrapper.EntityHandsInvWrapper;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RhinocerosEntity
extends TamableAnimal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(RhinocerosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(RhinocerosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(RhinocerosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> DATA_armor = SynchedEntityData.m_135353_(RhinocerosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> DATA_hasSaddle = SynchedEntityData.m_135353_(RhinocerosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<Integer> DATA_variant = SynchedEntityData.m_135353_(RhinocerosEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    private boolean isCharging = false;
    private int chargeDurationRemaining = 0;
    private int chargeCooldownTicks = 0;
    private float chargeSpeedMultiplier = 0.5f;
    public String animationprocedure = "empty";
    private final ItemStackHandler inventory = new ItemStackHandler(3){

        public int getSlotLimit(int slot) {
            return 64;
        }
    };
    private final CombinedInvWrapper combined = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.inventory, new EntityHandsInvWrapper((LivingEntity)this), new EntityArmorInvWrapper((LivingEntity)this)});
    String prevAnim = "empty";

    public RhinocerosEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<RhinocerosEntity>)((EntityType)BiodiverseModEntities.RHINOCEROS.get()), world);
    }

    public RhinocerosEntity(EntityType<RhinocerosEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 0;
        this.m_21557_(false);
        this.m_274367_(1.0f);
        this.m_21530_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"white_rhino");
        this.f_19804_.m_135372_(DATA_armor, (Object)"none");
        this.f_19804_.m_135372_(DATA_hasSaddle, (Object)false);
        this.f_19804_.m_135372_(DATA_variant, (Object)0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
    }

    private void damageEntitiesInFront() {
        double reach = 1.5;
        AABB box = this.m_20191_().m_82369_(this.m_20154_().m_82490_(reach));
        List riders = this.m_142429_().collect(Collectors.toList());
        List targets = this.m_9236_().m_6443_(LivingEntity.class, box, e -> e != this && e.m_6084_() && !riders.contains(e));
        float knockbackStrength = 2.0f;
        Vec3 look = this.m_20154_().m_82541_();
        for (LivingEntity living : targets) {
            living.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), 8.0f);
            living.m_147240_((double)knockbackStrength, -look.f_82479_, -look.f_82481_);
        }
    }

    public int getChargeCooldownTicks() {
        return this.chargeCooldownTicks;
    }

    public void setChargeCooldownTicks(int ticks) {
        this.chargeCooldownTicks = ticks;
    }

    public boolean isChargeOnCooldown() {
        return this.chargeCooldownTicks > 0;
    }

    public void setChargeDurationRemaining(int ticks) {
        this.chargeDurationRemaining = ticks;
    }

    public int getChargeDurationRemaining() {
        return this.chargeDurationRemaining;
    }

    public void setCharging(boolean charging) {
        this.isCharging = charging;
    }

    public boolean isCharging() {
        return this.isCharging;
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public boolean hasArmor() {
        return !this.getArmorType().equals("none");
    }

    public ResourceLocation getArmorTexture() {
        return new ResourceLocation("biodiverse", "textures/entity/rhino_armor_" + this.getArmorType() + ".png");
    }

    public String getArmorType() {
        return (String)this.f_19804_.m_135370_(DATA_armor);
    }

    public boolean hasSaddle() {
        return (Boolean)this.f_19804_.m_135370_(DATA_hasSaddle);
    }

    public void setHasSaddle(boolean hasSaddle) {
        this.f_19804_.m_135381_(DATA_hasSaddle, (Object)hasSaddle);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_() * entity.m_20205_();
            }
        });
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21346_.m_25352_(4, (Goal)new OwnerHurtTargetGoal(this){

            public boolean m_8036_() {
                double x = RhinocerosEntity.this.m_20185_();
                double y = RhinocerosEntity.this.m_20186_();
                double z = RhinocerosEntity.this.m_20189_();
                RhinocerosEntity entity = RhinocerosEntity.this;
                Level world = RhinocerosEntity.this.m_9236_();
                return super.m_8036_() && RhinoBeingRiddenTrueProcedure.execute((Entity)entity);
            }

            public boolean m_8045_() {
                double x = RhinocerosEntity.this.m_20185_();
                double y = RhinocerosEntity.this.m_20186_();
                double z = RhinocerosEntity.this.m_20189_();
                RhinocerosEntity entity = RhinocerosEntity.this;
                Level world = RhinocerosEntity.this.m_9236_();
                return super.m_8045_() && RhinoBeingRiddenTrueProcedure.execute((Entity)entity);
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new OwnerHurtByTargetGoal(this){

            public boolean m_8036_() {
                double x = RhinocerosEntity.this.m_20185_();
                double y = RhinocerosEntity.this.m_20186_();
                double z = RhinocerosEntity.this.m_20189_();
                RhinocerosEntity entity = RhinocerosEntity.this;
                Level world = RhinocerosEntity.this.m_9236_();
                return super.m_8036_() && RhinoBeingRiddenTrueProcedure.execute((Entity)entity);
            }

            public boolean m_8045_() {
                double x = RhinocerosEntity.this.m_20185_();
                double y = RhinocerosEntity.this.m_20186_();
                double z = RhinocerosEntity.this.m_20189_();
                RhinocerosEntity entity = RhinocerosEntity.this;
                Level world = RhinocerosEntity.this.m_9236_();
                return super.m_8045_() && RhinoBeingRiddenTrueProcedure.execute((Entity)entity);
            }
        });
        this.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal((Mob)this, Pillager.class, true, false));
        this.f_21346_.m_25352_(7, (Goal)new NearestAttackableTargetGoal((Mob)this, Evoker.class, true, false));
        this.f_21346_.m_25352_(8, (Goal)new NearestAttackableTargetGoal((Mob)this, Vindicator.class, true, false));
        this.f_21346_.m_25352_(9, (Goal)new NearestAttackableTargetGoal((Mob)this, Ravager.class, true, false));
        this.f_21345_.m_25352_(10, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Blocks.f_50335_.m_5456_()}), false));
        this.f_21345_.m_25352_(11, (Goal)new FollowParentGoal((Animal)this, 0.8));
        this.f_21345_.m_25352_(12, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(13, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(14, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(15, (Goal)new FloatGoal((Mob)this));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public double m_6048_() {
        return super.m_6048_() + 0.6;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:entity.rhino.ambient"));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:entity.rhino.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("biodiverse:entity.rhino.death"));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata, @Nullable CompoundTag tag) {
        SpawnGroupData retval = super.m_6518_(world, difficulty, reason, livingdata, tag);
        RhinocerosVariantsProcedure.execute((Entity)this);
        return retval;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            ItemStack saddleStack;
            boolean currentlyHasSaddle;
            String detectedArmor = "none";
            ItemStack armorStack = this.inventory.getStackInSlot(2);
            if (armorStack.m_41720_() instanceof DiamondRhinocerosArmorItem) {
                detectedArmor = "diamond";
            } else if (armorStack.m_41720_() instanceof GoldRhinocerosArmorItem) {
                detectedArmor = "gold";
            } else if (armorStack.m_41720_() instanceof IronRhinocerosArmorItem) {
                detectedArmor = "iron";
            }
            if (!detectedArmor.equals(this.f_19804_.m_135370_(DATA_armor))) {
                this.f_19804_.m_135381_(DATA_armor, (Object)detectedArmor);
            }
            boolean bl = currentlyHasSaddle = !(saddleStack = this.inventory.getStackInSlot(1)).m_41619_() && saddleStack.m_41720_() == Items.f_42450_;
            if (currentlyHasSaddle != this.hasSaddle()) {
                this.setHasSaddle(currentlyHasSaddle);
            }
            if (this.getChargeCooldownTicks() > 0) {
                this.setChargeCooldownTicks(this.getChargeCooldownTicks() - 1);
            }
            if (this.isCharging()) {
                int remaining = this.getChargeDurationRemaining() - 1;
                this.setChargeDurationRemaining(remaining);
                if (remaining <= 0) {
                    this.setCharging(false);
                    this.setChargeDurationRemaining(0);
                    this.setAnimation("empty");
                    this.chargeCooldownTicks = 100;
                }
                this.performChargeMovement();
            }
        }
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER && side == null) {
            return LazyOptional.of(() -> this.combined).cast();
        }
        return super.getCapability(capability, side);
    }

    protected void m_5907_() {
        super.m_5907_();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemstack)) continue;
            this.m_19983_(itemstack);
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128365_("InventoryCustom", (Tag)this.inventory.serializeNBT());
        compound.m_128359_("Texture", this.getTexture());
        compound.m_128359_("Dataarmor", (String)this.f_19804_.m_135370_(DATA_armor));
        compound.m_128405_("Datavariant", ((Integer)this.f_19804_.m_135370_(DATA_variant)).intValue());
    }

    public void m_7378_(CompoundTag compound) {
        Tag inventoryCustom;
        super.m_7378_(compound);
        if (compound.m_128441_("InventoryCustom") && (inventoryCustom = compound.m_128423_("InventoryCustom")) instanceof CompoundTag) {
            CompoundTag inventoryTag = (CompoundTag)inventoryCustom;
            this.inventory.deserializeNBT(inventoryTag);
        }
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
        if (compound.m_128441_("Datavariant")) {
            this.f_19804_.m_135381_(DATA_variant, (Object)compound.m_128451_("Datavariant"));
        }
    }

    public InteractionResult m_6071_(final Player sourceentity, InteractionHand hand) {
        ItemStack itemstack = sourceentity.m_21120_(hand);
        InteractionResult retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        if (sourceentity.m_6144_() && this.m_21824_() && (!this.m_6162_() || !this.m_21830_((LivingEntity)sourceentity))) {
            if (sourceentity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)sourceentity;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                    public Component m_5446_() {
                        return Component.m_237113_((String)"Rhinoceros");
                    }

                    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
                        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                        packetBuffer.m_130064_(sourceentity.m_20183_());
                        packetBuffer.writeByte(0);
                        packetBuffer.m_130130_(RhinocerosEntity.this.m_19879_());
                        return new RhinoInventoryMenu(id, inventory, packetBuffer);
                    }
                }, buf -> {
                    buf.m_130064_(sourceentity.m_20183_());
                    buf.writeByte(0);
                    buf.m_130130_(this.m_19879_());
                });
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        }
        Item item = itemstack.m_41720_();
        if (itemstack.m_41720_() instanceof SpawnEggItem) {
            retval = super.m_6071_(sourceentity, hand);
        } else if (this.m_9236_().m_5776_()) {
            retval = this.m_21824_() && this.m_21830_((LivingEntity)sourceentity) || this.m_6898_(itemstack) ? InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()) : InteractionResult.PASS;
        } else if (this.m_21824_()) {
            if (this.m_21830_((LivingEntity)sourceentity)) {
                if (item.m_41472_() && this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(item.m_41473_().m_38744_());
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                } else if (this.m_6898_(itemstack) && this.m_21223_() < this.m_21233_()) {
                    this.m_142075_(sourceentity, hand, itemstack);
                    this.m_5634_(4.0f);
                    retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
                } else {
                    retval = super.m_6071_(sourceentity, hand);
                }
            }
        } else if (this.m_6898_(itemstack)) {
            this.m_142075_(sourceentity, hand, itemstack);
            if (this.f_19796_.m_188503_(20) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)sourceentity)) {
                this.m_21828_(sourceentity);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            this.m_21530_();
            retval = InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
        } else {
            retval = super.m_6071_(sourceentity, hand);
            if (retval == InteractionResult.SUCCESS || retval == InteractionResult.CONSUME) {
                this.m_21530_();
            }
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)sourceentity) && !this.inventory.getStackInSlot(1).m_41619_() && this.inventory.getStackInSlot(1).m_41720_() == Items.f_42450_) {
            sourceentity.m_20329_((Entity)this);
            double x = this.m_20185_();
            double y = this.m_20186_();
            double z = this.m_20189_();
            RhinocerosEntity entity = this;
            Level world = this.m_9236_();
            RhinoTamedProcedure.execute((Entity)entity, (Entity)sourceentity);
        }
        return retval;
    }

    public void m_6075_() {
        super.m_6075_();
        this.m_6210_();
    }

    public EntityDimensions m_6972_(Pose pose) {
        float width = 2.8f;
        float height = 2.2f;
        if (this.m_6162_()) {
            width *= 0.5f;
            height *= 0.5f;
        }
        return EntityDimensions.m_20395_((float)width, (float)height);
    }

    public void m_6123_(Player sourceentity) {
        super.m_6123_(sourceentity);
        RhinocerosArmorProcedure.execute((Entity)this);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        RhinocerosEntity retval = (RhinocerosEntity)((EntityType)BiodiverseModEntities.RHINOCEROS.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return List.of(Blocks.f_50335_.m_5456_()).contains(stack.m_41720_());
    }

    public ItemStack getItem(int slot) {
        return this.inventory.getStackInSlot(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.setStackInSlot(slot, stack);
    }

    public int getContainerSize() {
        return this.inventory.getSlots();
    }

    public void m_7023_(Vec3 dir) {
        Entity entity;
        Entity entity2 = entity = this.m_20197_().isEmpty() ? null : (Entity)this.m_20197_().get(0);
        if (this.m_20160_()) {
            double d0;
            double d1;
            float f1;
            this.m_146922_(entity.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(entity.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            this.f_20883_ = entity.m_146908_();
            this.f_20885_ = entity.m_146908_();
            if (entity instanceof LivingEntity) {
                LivingEntity passenger = (LivingEntity)entity;
                this.m_7910_((float)this.m_21133_(Attributes.f_22279_));
                if (this.isCharging) {
                    super.m_7023_(Vec3.f_82478_);
                } else {
                    float forward = passenger.f_20902_;
                    forward = forward < 0.0f ? (forward *= 0.3f) : (forward *= 0.6f);
                    float strafe = 0.0f;
                    super.m_7023_(new Vec3((double)strafe, 0.0, (double)forward));
                }
            }
            if ((f1 = (float)Math.sqrt((d1 = this.m_20185_() - this.f_19854_) * d1 + (d0 = this.m_20189_() - this.f_19856_) * d0) * 4.0f) > 1.0f) {
                f1 = 1.0f;
            }
            this.f_267362_.m_267771_(this.f_267362_.m_267731_() + (f1 - this.f_267362_.m_267731_()) * 0.4f);
            this.f_267362_.m_267590_(this.f_267362_.m_267756_() + this.f_267362_.m_267731_());
            this.m_267651_(true);
            return;
        }
        super.m_7023_(dir);
    }

    private void performChargeMovement() {
        Vec3 lookVec = this.m_20154_();
        Vec3 chargeMotion = lookVec.m_82490_((double)this.chargeSpeedMultiplier);
        this.m_20334_(chargeMotion.f_82479_, this.m_20184_().f_82480_, chargeMotion.f_82481_);
        LivingEntity livingEntity = this.m_6688_();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            float yaw = player.m_146908_();
            this.m_146922_(yaw);
            this.f_19859_ = yaw;
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.damageEntitiesInFront();
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)BiodiverseModEntities.RHINOCEROS.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            return SavannaBiomeSpawnsProcedure.execute((LevelAccessor)world, x, y, z);
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.3);
        builder = builder.m_22268_(Attributes.f_22276_, 50.0);
        builder = builder.m_22268_(Attributes.f_22284_, 10.0);
        builder = builder.m_22268_(Attributes.f_22281_, 8.0);
        builder = builder.m_22268_(Attributes.f_22277_, 16.0);
        builder = builder.m_22268_(Attributes.f_22278_, 1.0);
        builder = builder.m_22268_(Attributes.f_22282_, 5.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty")) {
            return PlayState.STOP;
        }
        if (event.isMoving() && !this.m_5912_()) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.Rhinowalk"));
        }
        if (event.isMoving() && this.m_5912_()) {
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.Rhinocharge"));
        }
        return event.setAndContinue(RawAnimation.begin().thenLoop("animation.Rhinoidle"));
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.m_20185_() - this.f_19790_;
        double d0 = this.m_20189_() - this.f_19792_;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.m_21324_(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.m_9236_().m_46467_();
        }
        if (this.swinging && this.lastSwing + 7L <= this.m_9236_().m_46467_()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.Rhinoattack"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "attacking", 4, this::attackingPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

