/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.biodiverse.entity;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.mcreator.biodiverse.init.BiodiverseModEntities;
import net.mcreator.biodiverse.procedures.TundraBiomeSpawnsProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PlayMessages;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SnowyOwlEntity
extends Animal
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.m_135353_(SnowyOwlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.m_135353_(SnowyOwlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.m_135353_(SnowyOwlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(SnowyOwlEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private PathNavigation flyingNav;
    private PathNavigation groundNav;
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    private boolean isFlying = false;
    private boolean goingToPerch = false;
    private int perchCooldownTicks = 0;
    public float flightPitch = 0.0f;
    public float prevFlightPitch = 0.0f;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public SnowyOwlEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<SnowyOwlEntity>)((EntityType)BiodiverseModEntities.SNOWY_OWL.get()), world);
    }

    public SnowyOwlEntity(EntityType<SnowyOwlEntity> type, Level world) {
        super(type, world);
        this.f_21364_ = 3;
        this.m_21557_(false);
        this.m_274367_(1.1f);
        this.f_21342_ = new SmoothFlyingMoveControl(this);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHOOT, (Object)false);
        this.f_19804_.m_135372_(ANIMATION, (Object)"undefined");
        this.f_19804_.m_135372_(TEXTURE, (Object)"snowyowl");
        this.f_19804_.m_135372_(FLYING, (Object)false);
    }

    public void setFlying(boolean flying) {
        this.f_21344_ = flying ? this.flyingNav : this.groundNav;
        this.f_19804_.m_135381_(FLYING, (Object)flying);
        this.isFlying = flying;
        this.m_20242_(flying);
    }

    public void setFlightPitch(float pitch) {
        this.prevFlightPitch = this.flightPitch;
        this.flightPitch = pitch;
    }

    public float getFlightPitch() {
        return this.flightPitch;
    }

    public float getPrevFlightPitch() {
        return this.prevFlightPitch;
    }

    public boolean isFlying() {
        return this.isFlying;
    }

    public boolean isPerching() {
        return this.perchCooldownTicks > 0;
    }

    public int getPerchCooldownTicks() {
        return this.perchCooldownTicks;
    }

    public void setPerchCooldownTicks(int ticks) {
        this.perchCooldownTicks = ticks;
    }

    public boolean isGoingToPerch() {
        return this.goingToPerch;
    }

    public void setGoingToPerch(boolean goingToPerch) {
        this.goingToPerch = goingToPerch;
    }

    public void setTexture(String texture) {
        this.f_19804_.m_135381_(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.f_19804_.m_135370_(TEXTURE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected PathNavigation m_6037_(Level world) {
        this.flyingNav = new FlyingPathNavigation((Mob)this, world);
        this.groundNav = new GroundPathNavigation((Mob)this, world);
        return this.flyingNav;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, new Goal(){
            {
                this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            }

            public boolean m_8036_() {
                return SnowyOwlEntity.this.m_5448_() != null && !SnowyOwlEntity.this.m_21566_().m_24995_();
            }

            public boolean m_8045_() {
                return SnowyOwlEntity.this.m_21566_().m_24995_() && SnowyOwlEntity.this.m_5448_() != null && SnowyOwlEntity.this.m_5448_().m_6084_();
            }

            public void m_8056_() {
                LivingEntity livingentity = SnowyOwlEntity.this.m_5448_();
                Vec3 vec3d = livingentity.m_20299_(1.0f);
                SnowyOwlEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 4.0);
            }

            public void m_8037_() {
                LivingEntity livingentity = SnowyOwlEntity.this.m_5448_();
                if (SnowyOwlEntity.this.m_20191_().m_82381_(livingentity.m_20191_())) {
                    SnowyOwlEntity.this.m_7327_((Entity)livingentity);
                } else {
                    double d0 = SnowyOwlEntity.this.m_20280_((Entity)livingentity);
                    if (d0 < 16.0) {
                        Vec3 vec3d = livingentity.m_20299_(1.0f);
                        SnowyOwlEntity.this.f_21342_.m_6849_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 4.0);
                    }
                }
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new OwlPerchAndIdleGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new OwlFlyAroundGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false){

            protected double m_6639_(LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                return super.m_8036_() && SnowyOwlEntity.this.m_20096_();
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 16.0f));
        this.f_21346_.m_25352_(8, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, false, false));
        this.f_21346_.m_25352_(9, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHitIn) {
        super.m_7472_(source, looting, recentlyHitIn);
        this.m_19983_(new ItemStack((ItemLike)Items.f_42402_));
    }

    public SoundEvent m_7975_(DamageSource ds) {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.hurt"));
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation("entity.generic.death"));
    }

    public boolean m_142535_(float l, float d, DamageSource source) {
        return false;
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Texture", this.getTexture());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("Texture")) {
            this.setTexture(compound.m_128461_("Texture"));
        }
    }

    public EntityDimensions m_6972_(Pose p_33597_) {
        return super.m_6972_(p_33597_).m_20388_(1.0f);
    }

    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageable) {
        SnowyOwlEntity retval = (SnowyOwlEntity)((EntityType)BiodiverseModEntities.SNOWY_OWL.get()).m_20615_((Level)serverWorld);
        retval.m_6518_((ServerLevelAccessor)serverWorld, serverWorld.m_6436_(retval.m_20183_()), MobSpawnType.BREEDING, null, null);
        return retval;
    }

    public boolean m_6898_(ItemStack stack) {
        return List.of(Items.f_42697_).contains(stack.m_41720_());
    }

    protected void m_7840_(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.perchCooldownTicks > 0) {
            --this.perchCooldownTicks;
        }
        if (this.isFlying()) {
            if (!(this.f_21344_ instanceof FlyingPathNavigation)) {
                this.f_21344_ = new FlyingPathNavigation((Mob)this, this.m_9236_());
            }
            Vec3 motion = this.m_20184_();
            if (motion.f_82480_ < -0.1) {
                this.m_20334_(motion.f_82479_, -0.1, motion.f_82481_);
            }
        } else {
            if (!(this.f_21344_ instanceof GroundPathNavigation)) {
                this.f_21344_ = new GroundPathNavigation((Mob)this, this.m_9236_());
            }
            if (!this.m_20096_()) {
                Vec3 motion = this.m_20184_();
                this.m_20334_(motion.f_82479_, -0.05, motion.f_82481_);
            }
        }
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)BiodiverseModEntities.SNOWY_OWL.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.m_123341_();
            int y = pos.m_123342_();
            int z = pos.m_123343_();
            return TundraBiomeSpawnsProcedure.execute((LevelAccessor)world, x, y, z);
        });
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.05);
        builder = builder.m_22268_(Attributes.f_22276_, 13.0);
        builder = builder.m_22268_(Attributes.f_22284_, 0.0);
        builder = builder.m_22268_(Attributes.f_22281_, 5.0);
        builder = builder.m_22268_(Attributes.f_22277_, 32.0);
        builder = builder.m_22268_(Attributes.f_22280_, 0.3);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            boolean isMoving;
            if (!this.m_20096_()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.owl.fly"));
            }
            Vec3 motion = this.m_20184_();
            boolean bl = isMoving = motion.m_165925_() > 1.0E-6;
            if (isMoving) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.owl.walk"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.owl.idle"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.m_21226_();
        }
    }

    public String getSyncedAnimation() {
        return (String)this.f_19804_.m_135370_(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate)});
        data.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public static class SmoothFlyingMoveControl
    extends MoveControl {
        private final Animal mob;

        public SmoothFlyingMoveControl(Animal mob) {
            super((Mob)mob);
            this.mob = mob;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                Vec3 direction = new Vec3(this.f_24975_ - this.mob.m_20185_(), this.f_24976_ - this.mob.m_20186_(), this.f_24977_ - this.mob.m_20189_());
                double distance = direction.m_82553_();
                if (distance < 0.3) {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                    Animal animal = this.mob;
                    if (animal instanceof SnowyOwlEntity) {
                        SnowyOwlEntity owl = (SnowyOwlEntity)animal;
                        owl.prevFlightPitch = owl.flightPitch;
                        owl.setFlightPitch(0.0f);
                    }
                    return;
                }
                Vec3 normalized = direction.m_82541_();
                double speed = this.f_24978_ * 0.75;
                this.mob.m_20256_(this.mob.m_20184_().m_82520_((normalized.f_82479_ * speed - this.mob.m_20184_().f_82479_) * 0.1, (normalized.f_82480_ * speed - this.mob.m_20184_().f_82480_) * 0.1, (normalized.f_82481_ * speed - this.mob.m_20184_().f_82481_) * 0.1));
                this.mob.m_146922_((float)(Mth.m_14136_((double)normalized.f_82481_, (double)normalized.f_82479_) * 57.29577951308232) - 90.0f);
                this.mob.f_20883_ = this.mob.m_146908_();
                Animal animal = this.mob;
                if (animal instanceof SnowyOwlEntity) {
                    SnowyOwlEntity owl = (SnowyOwlEntity)animal;
                    Vec3 motion = this.mob.m_20184_();
                    double horizontalSpeed = Math.sqrt(motion.f_82479_ * motion.f_82479_ + motion.f_82481_ * motion.f_82481_);
                    float pitch = (float)Math.toDegrees(Math.atan2(motion.f_82480_, horizontalSpeed));
                    owl.prevFlightPitch = owl.flightPitch;
                    owl.setFlightPitch(Mth.m_14036_((float)pitch, (float)-45.0f, (float)45.0f));
                }
            }
        }
    }

    public static class OwlPerchAndIdleGoal
    extends Goal {
        private final SnowyOwlEntity owl;
        private BlockPos perchTarget;
        private int perchTimer = 0;
        private static final int MAX_PERCH_TIME = 500;

        public OwlPerchAndIdleGoal(SnowyOwlEntity owl) {
            this.owl = owl;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            if (!this.owl.isFlying() || this.owl.m_5448_() != null) {
                return false;
            }
            if (this.owl.getPerchCooldownTicks() > 0 || this.owl.isGoingToPerch()) {
                return false;
            }
            this.perchTarget = this.findPerch();
            return this.perchTarget != null && this.owl.m_217043_().m_188501_() < 0.05f;
        }

        public boolean m_8045_() {
            return this.owl.isGoingToPerch() && this.owl.m_5448_() == null && this.perchTarget != null;
        }

        public void m_8056_() {
            this.perchTimer = 0;
            if (this.perchTarget != null) {
                this.owl.setGoingToPerch(true);
                this.owl.m_21573_().m_26519_((double)this.perchTarget.m_123341_() + 0.5, (double)this.perchTarget.m_123342_(), (double)this.perchTarget.m_123343_() + 0.5, 1.0);
            }
        }

        public void m_8037_() {
            ++this.perchTimer;
            if (this.perchTarget != null && this.owl.m_20183_().m_123314_((Vec3i)this.perchTarget, 2.0)) {
                boolean validPerch;
                BlockState belowState = this.owl.m_9236_().m_8055_(this.owl.m_20183_().m_7495_());
                boolean bl = validPerch = belowState.m_60734_() instanceof LeavesBlock || belowState.m_204336_(BlockTags.f_13106_);
                if (!validPerch) {
                    return;
                }
                this.owl.setFlying(false);
                this.owl.m_21573_().m_26573_();
                this.owl.setPerchCooldownTicks(120 + this.owl.m_217043_().m_188503_(200));
                this.owl.setGoingToPerch(false);
                this.perchTarget = null;
                this.perchTimer = 0;
            } else if (this.perchTimer > 500 || this.owl.m_21573_().m_26571_()) {
                this.owl.setGoingToPerch(false);
                this.perchTarget = null;
                this.perchTimer = 0;
            } else if (this.owl.getPerchCooldownTicks() > 0) {
                this.owl.setPerchCooldownTicks(this.owl.getPerchCooldownTicks() - 1);
            }
        }

        public void m_8041_() {
            this.perchTarget = null;
            this.owl.setFlying(false);
        }

        @Nullable
        private BlockPos findPerch() {
            BlockState belowState;
            BlockPos mobPos = this.owl.m_20183_();
            BlockPos.MutableBlockPos check = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos below = new BlockPos.MutableBlockPos();
            int minX = Mth.m_14107_((double)(this.owl.m_20185_() - 6.0));
            int maxX = Mth.m_14107_((double)(this.owl.m_20185_() + 6.0));
            int minY = Mth.m_14107_((double)(this.owl.m_20186_() - 10.0));
            int maxY = Mth.m_14107_((double)(this.owl.m_20186_() + 4.0));
            int minZ = Mth.m_14107_((double)(this.owl.m_20189_() - 6.0));
            int maxZ = Mth.m_14107_((double)(this.owl.m_20189_() + 6.0));
            for (BlockPos pos : BlockPos.m_121976_((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
                belowState = this.owl.m_9236_().m_8055_((BlockPos)below.m_122159_((Vec3i)pos, Direction.DOWN));
                if (!(belowState.m_60734_() instanceof LeavesBlock) || !this.owl.m_9236_().m_46859_(pos) || !this.owl.m_9236_().m_46859_((BlockPos)check.m_122159_((Vec3i)pos, Direction.UP))) continue;
                return pos;
            }
            for (BlockPos pos : BlockPos.m_121976_((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
                belowState = this.owl.m_9236_().m_8055_((BlockPos)below.m_122159_((Vec3i)pos, Direction.DOWN));
                if (!belowState.m_60819_().m_76178_() || !belowState.m_60804_((BlockGetter)this.owl.m_9236_(), (BlockPos)below) || !this.owl.m_9236_().m_46859_(pos) || !this.owl.m_9236_().m_46859_((BlockPos)check.m_122159_((Vec3i)pos, Direction.UP))) continue;
                return pos;
            }
            return null;
        }
    }

    public static class OwlFlyAroundGoal
    extends Goal {
        private final Animal mob;
        private Vec3 target;
        private int targetUpdateTimer = 0;

        public OwlFlyAroundGoal(Animal mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            SnowyOwlEntity owl;
            if (this.mob.m_5448_() != null || !this.mob.m_6084_()) {
                return false;
            }
            Animal animal = this.mob;
            return !(animal instanceof SnowyOwlEntity) || (owl = (SnowyOwlEntity)animal).getPerchCooldownTicks() <= 0 && !owl.isGoingToPerch();
        }

        public boolean m_8045_() {
            Animal animal = this.mob;
            if (animal instanceof SnowyOwlEntity) {
                SnowyOwlEntity owl = (SnowyOwlEntity)animal;
                return !owl.isPerching() && !owl.isGoingToPerch() && this.mob.m_5448_() == null;
            }
            return true;
        }

        public void m_8056_() {
            this.target = this.chooseTargetPosition();
            if (this.target != null) {
                this.mob.m_21573_().m_26519_(this.target.f_82479_, this.target.f_82480_, this.target.f_82481_, 1.0);
            }
            this.targetUpdateTimer = 0;
            Animal animal = this.mob;
            if (animal instanceof SnowyOwlEntity) {
                SnowyOwlEntity owl = (SnowyOwlEntity)animal;
                owl.setFlying(true);
            }
        }

        public void m_8041_() {
            Animal animal = this.mob;
            if (animal instanceof SnowyOwlEntity) {
                SnowyOwlEntity owl = (SnowyOwlEntity)animal;
                owl.setFlying(false);
            }
        }

        public void m_8037_() {
            if (this.target == null) {
                return;
            }
            ++this.targetUpdateTimer;
            if (this.mob.m_21573_().m_26571_() || this.mob.m_20238_(this.target) < 8.0 || this.targetUpdateTimer > 60) {
                this.target = this.chooseTargetPosition();
                if (this.target != null) {
                    this.mob.m_21573_().m_26519_(this.target.f_82479_, this.target.f_82480_, this.target.f_82481_, 1.0);
                }
                this.targetUpdateTimer = 0;
            }
        }

        @Nullable
        private Vec3 chooseTargetPosition() {
            RandomSource random = this.mob.m_217043_();
            int attempts = 10;
            while (attempts-- > 0) {
                BlockState targetBlock;
                double x = this.mob.m_20185_() + (random.m_188500_() * 2.0 - 1.0) * 30.0;
                double z = this.mob.m_20189_() + (random.m_188500_() * 2.0 - 1.0) * 30.0;
                BlockPos base = new BlockPos((int)x, (int)this.mob.m_20186_(), (int)z);
                int groundY = this.mob.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, base).m_123342_();
                double targetY = (double)(groundY + 5) + random.m_188500_() * 10.0;
                BlockPos candidatePosBelow = new BlockPos((int)x, (int)(targetY - 1.0), (int)z);
                BlockState blockBelow = this.mob.m_9236_().m_8055_(candidatePosBelow);
                boolean validLanding = blockBelow.m_60783_((BlockGetter)this.mob.m_9236_(), candidatePosBelow, Direction.UP) || blockBelow.m_60734_() instanceof LeavesBlock || blockBelow.m_204336_(BlockTags.f_13106_);
                if (!validLanding || (targetBlock = this.mob.m_9236_().m_8055_(new BlockPos((int)x, (int)targetY, (int)z))).m_60819_().m_192917_((Fluid)Fluids.f_76193_)) continue;
                Vec3 candidate = new Vec3(x, targetY, z);
                if (this.mob.m_21573_().m_26524_(candidate.f_82479_, candidate.f_82480_, candidate.f_82481_, 0) == null || !(this.mob.m_20238_(candidate) > 15.0)) continue;
                return candidate;
            }
            return LandRandomPos.m_148488_((PathfinderMob)this.mob, (int)20, (int)8);
        }

        @Nullable
        private Vec3 getTreePos() {
            BlockPos mobPos = this.mob.m_20183_();
            BlockPos.MutableBlockPos check = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos below = new BlockPos.MutableBlockPos();
            for (BlockPos pos : BlockPos.m_121976_((int)Mth.m_14107_((double)(this.mob.m_20185_() - 3.0)), (int)Mth.m_14107_((double)(this.mob.m_20186_() - 6.0)), (int)Mth.m_14107_((double)(this.mob.m_20189_() - 3.0)), (int)Mth.m_14107_((double)(this.mob.m_20185_() + 3.0)), (int)Mth.m_14107_((double)(this.mob.m_20186_() + 6.0)), (int)Mth.m_14107_((double)(this.mob.m_20189_() + 3.0)))) {
                BlockState blockBelow;
                boolean isPerch;
                if (mobPos.equals((Object)pos) || !(isPerch = (blockBelow = this.mob.m_9236_().m_8055_((BlockPos)below.m_122159_((Vec3i)pos, Direction.DOWN))).m_60734_() instanceof LeavesBlock || blockBelow.m_204336_(BlockTags.f_13106_)) || !this.mob.m_9236_().m_46859_(pos) || !this.mob.m_9236_().m_46859_((BlockPos)check.m_122159_((Vec3i)pos, Direction.UP))) continue;
                return Vec3.m_82539_((Vec3i)pos);
            }
            return null;
        }
    }
}

