/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.biodiverse.entity.ai;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class WhaleCruiseGoal
extends Goal {
    private final Mob mob;
    private final double speed;
    private Vec3 targetPos;
    private int cooldown;
    private float headingYaw;

    public WhaleCruiseGoal(Mob mob) {
        this(mob, 1.0);
    }

    public WhaleCruiseGoal(Mob mob, double speed) {
        this.mob = mob;
        this.speed = speed;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.cooldown = 0;
        this.headingYaw = mob.m_146908_();
    }

    public boolean m_8036_() {
        return this.mob.m_20069_() && this.mob.m_5448_() == null;
    }

    public boolean m_8045_() {
        return this.mob.m_20069_();
    }

    public void m_8056_() {
    }

    public void m_8037_() {
        boolean accepted;
        Vec3 delta;
        boolean needsNewTarget;
        Level level = this.mob.m_9236_();
        RandomSource rand = this.mob.m_217043_();
        Vec3 currentPos = this.mob.m_20182_();
        boolean bl = needsNewTarget = this.targetPos == null || currentPos.m_82554_(this.targetPos) < 100.0 || this.cooldown <= 0;
        if (needsNewTarget) {
            float yawChange = 10.0f;
            this.headingYaw += rand.m_188501_() * yawChange - yawChange / 2.0f;
            this.headingYaw = Mth.m_14177_((float)this.headingYaw);
            double distance = 40.0 + rand.m_188500_() * 60.0;
            double x = currentPos.f_82479_ + distance * (double)Mth.m_14089_((float)(this.headingYaw * ((float)Math.PI / 180)));
            double z = currentPos.f_82481_ + distance * (double)Mth.m_14031_((float)(this.headingYaw * ((float)Math.PI / 180)));
            int seaLevel = level.m_5736_();
            double surfaceY = seaLevel - 4;
            double floorY = this.findOceanFloor(level, new BlockPos((int)x, (int)currentPos.f_82480_, (int)z)) + 4;
            double yCandidate = currentPos.f_82480_ + (rand.m_188500_() * 8.0 - 4.0);
            double y = Mth.m_14008_((double)yCandidate, (double)floorY, (double)surfaceY);
            this.targetPos = new Vec3(x, y, z);
            this.cooldown = 70 + rand.m_188503_(50);
        } else {
            --this.cooldown;
        }
        if (this.targetPos != null && (delta = this.targetPos.m_82546_(currentPos)).m_82556_() > 1.0 && !(accepted = this.mob.m_21573_().m_26519_(this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_, this.speed))) {
            this.cooldown = 0;
            this.targetPos = null;
        }
    }

    private int findOceanFloor(Level level, BlockPos pos) {
        BlockPos.MutableBlockPos scan = new BlockPos.MutableBlockPos(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        int minY = level.m_141937_() + 1;
        while (scan.m_123342_() > minY && level.m_8055_((BlockPos)scan).m_60713_(Blocks.f_49990_)) {
            scan.m_122173_(Direction.DOWN);
        }
        return scan.m_123342_();
    }
}

