/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.biodiverse.entity.model;

import net.mcreator.biodiverse.entity.BlueWhaleEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;

public class BlueWhaleModel
extends GeoModel<BlueWhaleEntity> {
    private static final float[] waveTimes = new float[]{0.0f, 0.5f, 1.0f, 1.5f, 2.0f};
    private static final float[] bodyX = new float[]{0.0f, 3.0f, 0.0f, -3.0f, 0.0f};
    private static final float[] tailX = new float[]{0.0f, 5.0f, 0.0f, -5.0f, 0.0f};
    private static final float[] tail2X = new float[]{0.0f, 7.0f, 0.0f, -7.0f, 0.0f};
    private static final float[] tail3X = new float[]{0.0f, 9.0f, 0.0f, -9.0f, 0.0f};
    private static final float[] headX = new float[]{0.0f, -2.0f, 0.0f, 2.0f, 0.0f};

    public ResourceLocation getAnimationResource(BlueWhaleEntity entity) {
        return new ResourceLocation("biodiverse", "animations/humpback.animation.json");
    }

    public ResourceLocation getModelResource(BlueWhaleEntity entity) {
        return new ResourceLocation("biodiverse", "geo/bluewhale.geo.json");
    }

    public ResourceLocation getTextureResource(BlueWhaleEntity entity) {
        return new ResourceLocation("biodiverse", "textures/entities/" + entity.getTexture() + ".png");
    }

    public void setCustomAnimations(BlueWhaleEntity whale, long instanceId, AnimationState<BlueWhaleEntity> state) {
        super.setCustomAnimations((GeoAnimatable)whale, instanceId, state);
        LivingEntity entity = (LivingEntity)state.getAnimatable();
        if (entity == null) {
            return;
        }
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        CoreGeoBone body = this.getAnimationProcessor().getBone("BlueWhale");
        CoreGeoBone tail = this.getAnimationProcessor().getBone("tail");
        CoreGeoBone tail2 = this.getAnimationProcessor().getBone("tail2");
        CoreGeoBone tail3 = this.getAnimationProcessor().getBone("tail3");
        CoreGeoBone finLeft = this.getAnimationProcessor().getBone("finleft");
        CoreGeoBone finRight = this.getAnimationProcessor().getBone("finright");
        if (body == null || tail == null || tail2 == null || tail3 == null || head == null) {
            return;
        }
        if (!whale.m_20069_()) {
            body.setRotZ((float)Math.toRadians(-77.5));
            body.setPosX(8.0f);
            body.setPosY(-15.0f);
            body.setScaleX(1.025f);
            body.setScaleY(1.025f);
            body.setScaleZ(1.025f);
            tail.setRotX((float)Math.toRadians(17.0));
            tail.setRotY((float)Math.toRadians(5.0));
            tail.setRotZ((float)Math.toRadians(17.0));
            tail2.setRotX((float)Math.toRadians(20.0));
            tail2.setRotY((float)Math.toRadians(11.0));
            tail2.setRotZ((float)Math.toRadians(45.0));
            tail3.setRotX((float)Math.toRadians(-20.0));
            tail3.setRotZ((float)Math.toRadians(22.0));
            if (finRight != null) {
                finRight.setRotX((float)Math.toRadians(-20.0));
                finRight.setRotY((float)Math.toRadians(-7.0));
                finRight.setRotZ((float)Math.toRadians(30.0));
            }
            if (finLeft != null) {
                finLeft.setRotZ((float)Math.toRadians(-17.5));
            }
            head.setRotX((float)Math.toRadians(-25.0));
            head.setRotY((float)Math.toRadians(-3.0));
            head.setRotZ((float)Math.toRadians(6.0));
            return;
        }
        body.setPosZ(150.0f);
        float partialTick = Minecraft.m_91087_().getPartialTick();
        float interpolatedYaw = Mth.m_14179_((float)partialTick, (float)whale.prevYawDelta, (float)whale.yawDelta);
        float interpolatedPitch = Mth.m_14179_((float)partialTick, (float)whale.prevPitchValue, (float)whale.pitchValue);
        float smoothedZTilt = Mth.m_14179_((float)partialTick, (float)whale.prevZTilt, (float)whale.zTilt);
        Vec3 motion = entity.m_20184_();
        boolean isMoving = motion.m_82556_() > 0.001;
        body.setRotZ((float)Math.toRadians(smoothedZTilt * 1.75f));
        head.setRotY((float)Math.toRadians(-interpolatedYaw * 6.0f));
        body.setRotY((float)Math.toRadians(interpolatedYaw * 1.8f));
        tail.setRotY((float)Math.toRadians(interpolatedYaw * 6.0f));
        tail2.setRotY((float)Math.toRadians(interpolatedYaw * 5.5f));
        tail3.setRotY((float)Math.toRadians(interpolatedYaw * 3.5f));
        head.setRotX((float)Math.toRadians(-interpolatedPitch * 0.5f));
        body.setRotX((float)Math.toRadians(-interpolatedPitch * 0.8f));
        tail.setRotX((float)Math.toRadians(interpolatedPitch * 0.5f));
        tail2.setRotX((float)Math.toRadians(interpolatedPitch * 0.3f));
        tail3.setRotX((float)Math.toRadians(interpolatedPitch * 0.2f));
        if (isMoving) {
            float tickCount = (float)whale.f_19797_ + partialTick;
            float frequency = 0.35f;
            float amplitude = 10.0f;
            float tailWave = (float)Math.toRadians(Math.sin((double)(tickCount * frequency * 0.1f) * Math.PI * 2.0) * (double)amplitude);
            float tailWave2 = tailWave * 0.7f;
            float tailWave3 = tailWave * 0.5f;
            float bodyWave = tailWave * 0.4f;
            body.setRotX(body.getRotX() + bodyWave);
            tail.setRotX(tail.getRotX() + tailWave);
            tail2.setRotX(tail2.getRotX() + tailWave2);
            tail3.setRotX(tail3.getRotX() + tailWave3);
        }
    }
}

