/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.biodiverse.entity.model;

import net.mcreator.biodiverse.entity.HippoEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class HippoModel
extends GeoModel<HippoEntity> {
    public ResourceLocation getAnimationResource(HippoEntity entity) {
        return new ResourceLocation("biodiverse", "animations/hippo.animation.json");
    }

    public ResourceLocation getModelResource(HippoEntity entity) {
        return new ResourceLocation("biodiverse", "geo/hippo.geo.json");
    }

    public ResourceLocation getTextureResource(HippoEntity entity) {
        return new ResourceLocation("biodiverse", "textures/entities/" + entity.getTexture() + ".png");
    }

    public void setCustomAnimations(HippoEntity entity, long instanceId, AnimationState<HippoEntity> state) {
        boolean isMoving;
        EntityModelData entityData = (EntityModelData)state.getData(DataTickets.ENTITY_MODEL_DATA);
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        CoreGeoBone head2 = this.getAnimationProcessor().getBone("head2");
        CoreGeoBone body = this.getAnimationProcessor().getBone("Hippo");
        CoreGeoBone legFL = this.getAnimationProcessor().getBone("leg");
        CoreGeoBone legFR = this.getAnimationProcessor().getBone("leg2");
        CoreGeoBone legBL = this.getAnimationProcessor().getBone("leg3");
        CoreGeoBone legBR = this.getAnimationProcessor().getBone("leg4");
        if (head2 != null) {
            head2.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head2.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
        if (head != null) {
            head.setRotX(0.0f);
            head.setRotY(0.0f);
        }
        float limbSwing = state.getLimbSwing();
        float limbSwingAmount = state.getLimbSwingAmount();
        float partialTick = state.getPartialTick();
        float ageInTicks = (float)entity.f_19797_ + partialTick;
        boolean bl = isMoving = limbSwingAmount > 0.15f;
        if (entity.isResting()) {
            if (body != null) {
                body.setPosY(-7.0f);
                body.setRotX(0.0f);
            }
            if (head != null) {
                head.setPosY(-5.5f);
            }
            this.applyLegPoseResting(legFL, 90.0f, 25.0f);
            this.applyLegPoseResting(legFR, 90.0f, -25.0f);
            this.applyLegPoseResting(legBL, 90.0f, 25.0f);
            this.applyLegPoseResting(legBR, 90.0f, -25.0f);
            return;
        }
        if (entity.m_6069_()) {
            float swimPhase = ageInTicks * 0.5f;
            float bodyBob = Mth.m_14031_((float)swimPhase) * 2.5f;
            if (body != null) {
                body.setRotX((float)Math.PI / 180 * bodyBob);
                body.setPosY(-1.0f);
            }
            if (head != null) {
                head.setRotX((float)Math.PI / 180 * (22.5f + Mth.m_14089_((float)swimPhase) * 2.5f));
                head.setPosY(1.0f);
            }
            this.applyLegSwim(legFL, ageInTicks);
            this.applyLegSwim(legFR, ageInTicks + 10.0f);
            this.applyLegSwim(legBL, ageInTicks + 5.0f);
            this.applyLegSwim(legBR, ageInTicks + 15.0f);
            return;
        }
        if (body != null) {
            body.setRotX(0.0f);
            body.setPosY(0.0f);
        }
        if (head != null) {
            head.setPosY(0.0f);
        }
        if (isMoving && entity.m_5912_()) {
            this.applyLegRun(legFL, ageInTicks);
            this.applyLegRun(legFR, ageInTicks + 10.0f);
            this.applyLegRun(legBL, ageInTicks + 5.0f);
            this.applyLegRun(legBR, ageInTicks + 15.0f);
            return;
        }
        if (isMoving) {
            this.applyLegWalk(legFL, ageInTicks);
            this.applyLegWalk(legFR, ageInTicks + 10.0f);
            this.applyLegWalk(legBL, ageInTicks + 5.0f);
            this.applyLegWalk(legBR, ageInTicks + 15.0f);
            return;
        }
        this.resetLegs(legFL, legFR, legBL, legBR);
    }

    private void applyLegPoseResting(CoreGeoBone leg, float pitch, float yaw) {
        if (leg != null) {
            leg.setRotX((float)Math.PI / 180 * pitch);
            leg.setRotY((float)Math.PI / 180 * yaw);
            leg.setPosX(leg.getName().contains("2") || leg.getName().contains("4") ? -1.0f : 1.0f);
            leg.setPosY(0.5f);
        }
    }

    private void applyLegWalk(CoreGeoBone leg, float time) {
        if (leg != null) {
            float angle = Mth.m_14089_((float)(time * 0.4f)) * 12.0f;
            leg.setRotX((float)Math.PI / 180 * angle);
            leg.setPosY(0.0f);
        }
    }

    private void applyLegRun(CoreGeoBone leg, float time) {
        if (leg != null) {
            float angle = Mth.m_14089_((float)(time * 0.8f)) * 25.0f;
            leg.setRotX((float)Math.PI / 180 * angle);
            leg.setPosY(0.0f);
        }
    }

    private void applyLegSwim(CoreGeoBone leg, float time) {
        if (leg != null) {
            float angle = Mth.m_14031_((float)(time * 0.5f)) * 10.0f;
            leg.setRotX((float)Math.PI / 180 * (10.0f + angle));
            leg.setPosY(1.0f);
        }
    }

    private void resetLegs(CoreGeoBone ... legs) {
        for (CoreGeoBone leg : legs) {
            if (leg == null) continue;
            leg.setRotX(0.0f);
            leg.setRotY(0.0f);
            leg.setPosX(0.0f);
            leg.setPosY(0.0f);
        }
    }
}

