/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.biodiverse.entity.model;

import net.mcreator.biodiverse.entity.SnowyOwlEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class SnowyOwlModel
extends GeoModel<SnowyOwlEntity> {
    public ResourceLocation getAnimationResource(SnowyOwlEntity entity) {
        return new ResourceLocation("biodiverse", "animations/snowyowl.animation.json");
    }

    public ResourceLocation getModelResource(SnowyOwlEntity entity) {
        return new ResourceLocation("biodiverse", "geo/snowyowl.geo.json");
    }

    public ResourceLocation getTextureResource(SnowyOwlEntity entity) {
        return new ResourceLocation("biodiverse", "textures/entities/" + entity.getTexture() + ".png");
    }

    public void setCustomAnimations(SnowyOwlEntity animatable, long instanceId, AnimationState animationState) {
        CoreGeoBone owl;
        CoreGeoBone head = this.getAnimationProcessor().getBone("head");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            head.setRotX(entityData.headPitch() * ((float)Math.PI / 180));
            head.setRotY(entityData.netHeadYaw() * ((float)Math.PI / 180));
        }
        if ((owl = this.getAnimationProcessor().getBone("owlrotation")) != null) {
            float partialTick = Minecraft.m_91087_().getPartialTick();
            float interpolatedPitch = Mth.m_14179_((float)partialTick, (float)animatable.prevFlightPitch, (float)animatable.flightPitch);
            owl.setRotX((float)Math.toRadians(-interpolatedPitch));
        }
    }
}

