/*
 * Decompiled with CFR 0.152.
 */
package org.primal.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import org.jetbrains.annotations.NotNull;
import org.primal.block.ShortRiverReeds;
import org.primal.block.properties.TripleBlockHalf;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_Tags;

public class RiverReeds
extends BushBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final EnumProperty<TripleBlockHalf> HALF = EnumProperty.create((String)"half", TripleBlockHalf.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_1;
    public static final MapCodec<RiverReeds> CODEC = RiverReeds.simpleCodec(RiverReeds::new);

    public RiverReeds(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(HALF, (Comparable)((Object)TripleBlockHalf.LOWER))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF}).add(new Property[]{WATERLOGGED}).add(new Property[]{AGE});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean isUnderwater = fluidstate.getType() == Fluids.WATER;
        BlockState finalState = (BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isUnderwater));
        return (BlockState)finalState.setValue(HALF, (Comparable)((Object)TripleBlockHalf.LOWER));
    }

    public void setPlacedBy(@NotNull Level level, BlockPos pos, @NotNull BlockState state, LivingEntity placer, @NotNull ItemStack stack) {
        BlockPos blockPosAbove = pos.above();
        BlockPos blockPosAboveAbove = pos.above().above();
        if (state.getValue(HALF) == TripleBlockHalf.LOWER && !level.isClientSide) {
            if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue() && level.getRandom().nextBoolean()) {
                level.setBlock(blockPosAbove, RiverReeds.copyWaterloggedFrom((LevelReader)level, blockPosAbove, (BlockState)this.defaultBlockState().setValue(HALF, (Comparable)((Object)TripleBlockHalf.MIDDLE))), 3);
                level.setBlock(blockPosAboveAbove, RiverReeds.copyWaterloggedFrom((LevelReader)level, blockPosAboveAbove, (BlockState)this.defaultBlockState().setValue(HALF, (Comparable)((Object)TripleBlockHalf.UPPER))), 3);
            } else {
                level.setBlock(blockPosAbove, RiverReeds.copyWaterloggedFrom((LevelReader)level, blockPosAbove, (BlockState)this.defaultBlockState().setValue(HALF, (Comparable)((Object)TripleBlockHalf.UPPER))), 3);
            }
        }
    }

    @NotNull
    protected BlockState updateShape(BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        TripleBlockHalf half;
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (!((half = (TripleBlockHalf)((Object)state.getValue(HALF))) != TripleBlockHalf.LOWER && half != TripleBlockHalf.MIDDLE || facing != Direction.UP || facingState.is((Block)this))) {
            return Blocks.AIR.defaultBlockState();
        }
        if (half == TripleBlockHalf.UPPER && facing == Direction.DOWN && !facingState.is((Block)this)) {
            return Blocks.AIR.defaultBlockState();
        }
        if ((facing == Direction.UP || facing == Direction.DOWN) && facingState.is((Block)this)) {
            int age = (Integer)facingState.getValue((Property)AGE);
            return (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(age));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    protected boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader level, @NotNull BlockPos pos) {
        BlockState blockBelow = level.getBlockState(pos.below());
        BlockState blockAbove = level.getBlockState(pos.above());
        if (state.getValue(HALF) == TripleBlockHalf.UPPER) {
            return blockBelow.is((Block)this);
        }
        if (state.getValue(HALF) == TripleBlockHalf.MIDDLE) {
            return blockAbove.is((Block)this) && blockBelow.is((Block)this);
        }
        return super.canSurvive(state, level, pos);
    }

    protected boolean mayPlaceOn(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return super.mayPlaceOn(state, level, pos) || state.is(Primal_Tags.RIVER_REED_SOIL);
    }

    @NotNull
    protected FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public static BlockState copyWaterloggedFrom(LevelReader level, BlockPos pos, BlockState state) {
        return state.hasProperty((Property)BlockStateProperties.WATERLOGGED) ? (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.isWaterAt(pos))) : state;
    }

    protected long getSeed(BlockState state, BlockPos pos) {
        return Mth.getSeed((int)pos.getX(), (int)pos.below(state.getValue(HALF) == TripleBlockHalf.LOWER ? 0 : (state.getValue(HALF) == TripleBlockHalf.MIDDLE ? 1 : 2)).getY(), (int)pos.getZ());
    }

    @NotNull
    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }

    public boolean isValidBonemealTarget(@NotNull LevelReader level, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(@NotNull Level level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        return true;
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state) {
        this.performBonemeal(level, random, pos, state, true);
    }

    public void performBonemeal(@NotNull ServerLevel level, @NotNull RandomSource random, @NotNull BlockPos pos, @NotNull BlockState state, boolean canSpread) {
        if ((Integer)state.getValue((Property)AGE) == 0) {
            level.setBlock(pos, (BlockState)state.setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
        } else {
            BlockPos lowestPos;
            BlockState blockBelow = level.getBlockState(pos.below());
            if (state.getValue(HALF) == TripleBlockHalf.UPPER && blockBelow.is((Block)this)) {
                pos = pos.below();
            }
            if (level.getBlockState(pos).getValue(HALF) == TripleBlockHalf.MIDDLE && level.getBlockState(pos.below()).is((Block)this)) {
                pos = pos.below();
            }
            if (level.getFluidState(lowestPos = pos).is((Fluid)Fluids.WATER) && RiverReeds.isValidPosForRiverReed((LevelReader)level, pos.above().above()) && !level.getBlockState(pos.above().above()).is((Block)this)) {
                BlockState defaultState = this.defaultBlockState();
                level.setBlock(lowestPos, (BlockState)((BlockState)((BlockState)defaultState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))).setValue(HALF, (Comparable)((Object)TripleBlockHalf.LOWER))).setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
                level.setBlock(lowestPos.above(), (BlockState)((BlockState)((BlockState)defaultState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(lowestPos.above()).is((Fluid)Fluids.WATER)))).setValue(HALF, (Comparable)((Object)TripleBlockHalf.MIDDLE))).setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
                level.setBlock(lowestPos.above().above(), (BlockState)((BlockState)((BlockState)defaultState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(lowestPos.above().above()).is((Fluid)Fluids.WATER)))).setValue(HALF, (Comparable)((Object)TripleBlockHalf.UPPER))).setValue((Property)AGE, (Comparable)Integer.valueOf(1)), 2);
            } else if (canSpread) {
                this.setRiverReedsNear((Level)level, lowestPos, level.getRandom().nextBoolean() ? 2 : 1);
            }
        }
    }

    protected void setRiverReedsNear(Level level, BlockPos initialPos, int lateralDistance) {
        BlockPos.MutableBlockPos check = new BlockPos.MutableBlockPos();
        for (int dx = -lateralDistance; dx <= lateralDistance; ++dx) {
            for (int dz = -lateralDistance; dz <= lateralDistance; ++dz) {
                check.set(initialPos.getX() + dx, initialPos.getY(), initialPos.getZ() + dz);
                ShortRiverReeds reeds = (ShortRiverReeds)((Object)Primal_Blocks.SHORT_RIVER_REEDS.get());
                FluidState fluidstate = level.getFluidState((BlockPos)check);
                if (!reeds.canSurvive(reeds.defaultBlockState(), (LevelReader)level, (BlockPos)check) || level.getRandom().nextIntBetweenInclusive(0, 3) != 0 || check.getX() == initialPos.getX() && check.getZ() == initialPos.getZ() && check.getY() == initialPos.getY() || !level.getBlockState((BlockPos)check).isAir() && (!fluidstate.is((Fluid)Fluids.WATER) || fluidstate.getAmount() != 8 || !level.getBlockState((BlockPos)check).is(Blocks.WATER))) continue;
                BlockState finalState = reeds.defaultBlockState();
                if (fluidstate.is((Fluid)Fluids.WATER)) {
                    finalState = (BlockState)finalState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
                }
                level.setBlock((BlockPos)check, finalState, 2);
                Block block = level.getBlockState((BlockPos)check).getBlock();
                if (!(block instanceof ShortRiverReeds)) continue;
                ShortRiverReeds shortRiverReeds = (ShortRiverReeds)block;
                if (!(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                if (level.getRandom().nextIntBetweenInclusive(0, 3) != 0) continue;
                shortRiverReeds.performBonemeal(serverLevel, level.getRandom(), (BlockPos)check, level.getBlockState((BlockPos)check));
            }
        }
    }

    public static boolean isValidPosForRiverReed(LevelReader level, BlockPos pos) {
        return level.getBlockState(pos).isAir() || level.getBlockState(pos).is(Blocks.WATER) || level.getBlockState(pos).is((Block)Primal_Blocks.RIVER_REEDS.get());
    }

    protected boolean isRandomlyTicking(@NotNull BlockState state) {
        return state.getValue(HALF) == TripleBlockHalf.LOWER;
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (level.getRawBrightness(pos, 0) >= 6 && level.getRandom().nextIntBetweenInclusive(1, 50) == 1) {
            this.performBonemeal(level, random, pos, state, false);
        }
    }
}

