/*
 * Decompiled with CFR 0.152.
 */
package org.primal.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.primal.client.model.entity.CrocodileModel;
import org.primal.entity.animal.CrocodileEntity;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class CrocodileRenderer
extends GeoEntityRenderer<CrocodileEntity> {
    public CrocodileRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new CrocodileModel());
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer<CrocodileEntity>(this, (GeoRenderer)this){

            public ResourceLocation getTextureResource(CrocodileEntity crocodile) {
                return ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("textures/entity/crocodile/" + crocodile.getVariant().getSerializedName() + ".png"));
            }
        });
        this.shadowRadius = 1.1f;
    }

    public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, CrocodileEntity animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        if (animatable.isBaby()) {
            heightScale = 0.3f;
            widthScale = 0.3f;
        }
        super.scaleModelForRender(widthScale, heightScale, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    protected void applyRotations(CrocodileEntity animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick, float nativeScale) {
        if (animatable.isUnderWater()) {
            float yaw = Mth.lerp((float)partialTick, (float)animatable.yRotO, (float)animatable.getYRot());
            poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yaw));
            float pitch = Mth.lerp((float)partialTick, (float)animatable.xRotO, (float)animatable.getXRot());
            poseStack.mulPose(Axis.XP.rotationDegrees(-pitch));
        } else {
            super.applyRotations((Entity)animatable, poseStack, ageInTicks, rotationYaw, partialTick, nativeScale);
        }
    }

    public float getMotionAnimThreshold(CrocodileEntity animatable) {
        return super.getMotionAnimThreshold((GeoAnimatable)animatable);
    }
}

