/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.BabyFollowAdult;
import net.minecraft.world.entity.ai.behavior.BecomePassiveIfMemoryPresent;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.EraseMemoryIf;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomLookAround;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTargetSometimes;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetAwayFrom;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import org.primal.entity.ai.behavior.bear.BearBeg;
import org.primal.entity.ai.behavior.bear.BearDefeated;
import org.primal.entity.ai.behavior.bear.BearRaidBeehive;
import org.primal.entity.ai.behavior.bear.BearRaidSweetBerryBush;
import org.primal.entity.ai.behavior.bear.BearRoar;
import org.primal.entity.ai.behavior.bear.BearSitting;
import org.primal.entity.ai.behavior.bear.BearSleep;
import org.primal.entity.ai.behavior.bear.SetBearLookRoarTarget;
import org.primal.entity.ai.behavior.bear.SetBearRoarTarget;
import org.primal.entity.ai.behavior.generic.FollowOwner;
import org.primal.entity.animal.BearEntity;
import org.primal.registry.Primal_Activities;
import org.primal.registry.Primal_Entities;
import org.primal.registry.Primal_Sensors;

public final class BearAi {
    private static final ImmutableList<SensorType<? extends Sensor<? super BearEntity>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)((SensorType)Primal_Sensors.NEAREST_ADULT_BEAR.get()), (Object)((SensorType)Primal_Sensors.NEAREST_BABY.get()), (Object)SensorType.NEAREST_PLAYERS, (Object)((SensorType)Primal_Sensors.BEAR_ATTACK_SENSOR.get()), (Object)((SensorType)Primal_Sensors.BEAR_NEAREST_BEEHIVE_SENSOR.get()), (Object)((SensorType)Primal_Sensors.BEAR_NEAREST_SWEET_BERRY_BUSH_SENSOR.get()), (Object)((SensorType)Primal_Sensors.BEAR_TEMPTATIONS_SENSOR.get()), (Object)((SensorType)Primal_Sensors.BEAR_REPELLENT_SENSOR.get()));
    private static final ImmutableList<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryModuleType.ATTACK_COOLING_DOWN, (Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryModuleType.ROAR_TARGET, (Object)MemoryModuleType.HURT_BY, (Object)MemoryModuleType.HURT_BY_ENTITY, (Object[])new MemoryModuleType[]{MemoryModuleType.BREED_TARGET, MemoryModuleType.IS_PANICKING, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.AVOID_TARGET, MemoryModuleType.NEAREST_REPELLENT});
    private static final UniformInt ADULT_FOLLOW_RANGE = UniformInt.of((int)5, (int)16);
    private static final UniformInt RETREAT_DURATION = TimeUtil.rangeOfSeconds((int)5, (int)20);

    public static Predicate<ItemStack> getTemptations() {
        return BearEntity::isMatingFood;
    }

    private static void initMemories(BearEntity BearEntity2, RandomSource random) {
    }

    public static Brain.Provider<BearEntity> brainProvider() {
        return Brain.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static Brain<?> makeBrain(Brain<BearEntity> brain) {
        BearAi.initCoreActivity(brain);
        BearAi.initIdleActivity(brain);
        BearAi.initRoarActivity(brain);
        BearAi.initFightActivity(brain);
        BearAi.initRetreatActivity(brain);
        BearAi.initFollowActivity(brain);
        BearAi.initSitActivity(brain);
        BearAi.initJockeyActivity(brain);
        brain.setCoreActivities((Set)ImmutableSet.of((Object)Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<BearEntity> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), SetBearLookRoarTarget.create(), (Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink()));
    }

    private static void initRoarActivity(Brain<BearEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.ROAR, 10, ImmutableList.of((Object)((Object)new BearRoar())), MemoryModuleType.ROAR_TARGET);
    }

    private static void initIdleActivity(Brain<BearEntity> brain) {
        brain.addActivity(Activity.IDLE, 10, ImmutableList.of((Object)((Object)new BearDefeated()), (Object)BecomePassiveIfMemoryPresent.create((MemoryModuleType)MemoryModuleType.NEAREST_REPELLENT, (int)200), (Object)SetWalkTargetAwayFrom.pos((MemoryModuleType)MemoryModuleType.NEAREST_REPELLENT, (float)1.5f, (int)8, (boolean)true), (Object)((Object)new BearSleep()), (Object)new AnimalMakeLove((EntityType)Primal_Entities.BEAR.get()), (Object)new AnimalMakeLove(EntityType.POLAR_BEAR), (Object)((Object)new BearBeg()), SetBearRoarTarget.create(), (Object)((Object)new BearRaidBeehive()), (Object)((Object)new BearRaidSweetBerryBush()), (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)new FollowTemptation(livingEntity -> Float.valueOf(1.0f), livingEntity -> livingEntity.isBaby() ? 2.5 : 3.5), (Object)4), (Object)Pair.of((Object)BehaviorBuilder.triggerIf(Predicate.not(BearEntity::refuseToMove), (OneShot)BabyFollowAdult.create((UniformInt)ADULT_FOLLOW_RANGE, (float)1.0f)), (Object)1))), (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object[])new BehaviorControl[]{new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f), BearAi.createIdleMovementBehaviors()}));
    }

    private static void initFollowActivity(Brain<BearEntity> brain) {
        brain.addActivity((Activity)Primal_Activities.FOLLOW.get(), 10, ImmutableList.of((Object)((Object)new BearDefeated()), (Object)new AnimalMakeLove((EntityType)Primal_Entities.BEAR.get()), (Object)new AnimalMakeLove(EntityType.POLAR_BEAR), (Object)((Object)new BearBeg()), SetBearRoarTarget.create(), (Object)((Object)new FollowOwner(pet -> {
            BearEntity bear;
            return pet instanceof BearEntity && !(bear = (BearEntity)((Object)pet)).bearCollapses();
        })), (Object)SetEntityLookTargetSometimes.create((EntityType)EntityType.PLAYER, (float)6.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f), BearAi.createIdleMovementBehaviors()));
    }

    private static void initSitActivity(Brain<BearEntity> brain) {
        brain.addActivity((Activity)Primal_Activities.SIT.get(), ImmutableList.of((Object)Pair.of((Object)0, (Object)((Object)new BearSitting()))));
    }

    private static void initFightActivity(Brain<BearEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.FIGHT, 10, ImmutableList.of((Object)BecomePassiveIfMemoryPresent.create((MemoryModuleType)MemoryModuleType.NEAREST_REPELLENT, (int)200), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.create((float)1.0f), (Object)MeleeAttack.create((int)20), (Object)SetEntityLookTarget.create((float)50.0f), (Object)StopAttackingIfTargetInvalid.create(), (Object)EraseMemoryIf.create(bear -> bear.isInLove() || bear.bearCollapses(), (MemoryModuleType)MemoryModuleType.ATTACK_TARGET)), MemoryModuleType.ATTACK_TARGET);
    }

    private static void initJockeyActivity(Brain<BearEntity> brain) {
        brain.addActivity((Activity)Primal_Activities.JOCKEY.get(), 10, ImmutableList.of((Object)((Object)new BearDefeated()), (Object)new RandomLookAround((IntProvider)UniformInt.of((int)150, (int)250), 30.0f, 0.0f, 0.0f)));
    }

    private static void initRetreatActivity(Brain<BearEntity> brain) {
        brain.addActivityAndRemoveMemoryWhenStopped(Activity.AVOID, 10, ImmutableList.of((Object)SetWalkTargetAwayFrom.entity((MemoryModuleType)MemoryModuleType.AVOID_TARGET, (float)1.2f, (int)20, (boolean)false), BearAi.createIdleMovementBehaviors(), (Object)SetEntityLookTargetSometimes.create((float)8.0f, (UniformInt)UniformInt.of((int)30, (int)60)), (Object)EraseMemoryIf.create(bear -> !bear.isBaby(), (MemoryModuleType)MemoryModuleType.AVOID_TARGET)), MemoryModuleType.AVOID_TARGET);
    }

    public static void wasHurtBy(BearEntity bear, LivingEntity target) {
        Brain<BearEntity> brain = bear.getBrain();
        brain.eraseMemory(MemoryModuleType.BREED_TARGET);
        if (bear.isBaby()) {
            BearAi.retreatFromNearestTarget(bear, target);
            for (BearEntity nearBear : BearAi.getNearestAdultBears(bear)) {
                nearBear.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)target);
            }
        } else {
            bear.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)target);
        }
    }

    private static void retreatFromNearestTarget(BearEntity bear, LivingEntity target) {
        Brain<BearEntity> brain = bear.getBrain();
        LivingEntity avoidTarget = BehaviorUtils.getNearestTarget((LivingEntity)bear, (Optional)brain.getMemory(MemoryModuleType.AVOID_TARGET), (LivingEntity)target);
        avoidTarget = BehaviorUtils.getNearestTarget((LivingEntity)bear, (Optional)brain.getMemory(MemoryModuleType.ATTACK_TARGET), (LivingEntity)avoidTarget);
        BearAi.setAvoidTarget(bear, avoidTarget);
    }

    private static void setAvoidTarget(BearEntity bear, LivingEntity target) {
        bear.getBrain().eraseMemory(MemoryModuleType.ATTACK_TARGET);
        bear.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        bear.getBrain().setMemoryWithExpiry(MemoryModuleType.AVOID_TARGET, (Object)target, (long)RETREAT_DURATION.sample(bear.level().random));
    }

    private static List<BearEntity> getNearestAdultBears(BearEntity bear) {
        return bear.level().getEntitiesOfClass(BearEntity.class, bear.getBoundingBox().inflate(20.0, 5.0, 20.0)).stream().filter(bear1 -> !bear1.isTame() && !bear1.isBaby()).toList();
    }

    private static RunOne<BearEntity> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)BehaviorBuilder.triggerIf(Predicate.not(BearEntity::refuseToMove), (OneShot)RandomStroll.stroll((float)1.0f)), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    public static void updateActivity(BearEntity bear) {
        if (bear.isSitting()) {
            bear.getBrain().setActiveActivityIfPossible((Activity)Primal_Activities.SIT.get());
        } else if (bear.isFollowing()) {
            bear.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.ROAR, (Object)Activity.FIGHT, (Object)((Activity)Primal_Activities.FOLLOW.get())));
            bear.setAggressive(bear.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
        } else if (bear.isBaby()) {
            if (bear.isBearJockey()) {
                bear.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)((Activity)Primal_Activities.JOCKEY.get())));
            } else {
                bear.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.AVOID, (Object)Activity.IDLE));
            }
        } else {
            bear.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.ROAR, (Object)Activity.FIGHT, (Object)Activity.IDLE));
            bear.setAggressive(bear.getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET));
        }
    }

    public static boolean isPosNearNearestRepellent(BearEntity bear, BlockPos pos) {
        Optional optional = bear.getBrain().getMemory(MemoryModuleType.NEAREST_REPELLENT);
        return optional.isPresent() && ((BlockPos)optional.get()).closerThan((Vec3i)pos, 8.0);
    }
}

