/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.bear;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.BearEntity;
import org.primal.registry.Primal_MemoryModuleTypes;

public class BearRaidBeehive
extends Behavior<BearEntity> {
    public BearRaidBeehive() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.ROAR_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_BEEHIVE.get()), (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean canStillUse(@NotNull ServerLevel level, BearEntity entity, long gameTime) {
        return entity.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_BEEHIVE.get()).isPresent();
    }

    protected void start(@NotNull ServerLevel level, BearEntity entity, long gameTime) {
        entity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((BlockPos)entity.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_BEEHIVE.get()).get(), 1.0f, 2));
    }

    protected void tick(@NotNull ServerLevel level, BearEntity owner, long gameTime) {
        BlockPos nearestBeehive = owner.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_BEEHIVE.get()).orElse(null);
        if (nearestBeehive != null && (float)owner.blockPosition().distManhattan((Vec3i)nearestBeehive) <= 2.0f) {
            BlockState state = level.getBlockState(nearestBeehive);
            if (!state.is(BlockTags.BEEHIVES)) {
                return;
            }
            BeehiveBlockEntity beehiveBlockEntity = (BeehiveBlockEntity)level.getBlockEntity(nearestBeehive);
            if (beehiveBlockEntity == null) {
                return;
            }
            for (Entity entity : beehiveBlockEntity.releaseAllOccupants(state, BeehiveBlockEntity.BeeReleaseStatus.EMERGENCY)) {
                ((Bee)entity).setTarget((LivingEntity)owner);
            }
            level.destroyBlock(nearestBeehive, false, (Entity)owner);
            owner.triggerAnim("attack", "attack");
            owner.setHoneyCounter(12000);
        }
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, BearEntity owner) {
        if (owner.isBaby() || owner.getHoneyCounter() > 0) {
            return false;
        }
        BlockPos blockPosBeehive = owner.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_BEEHIVE.get()).orElse(null);
        return level.getBlockEntity(blockPosBeehive) instanceof BeehiveBlockEntity && BeehiveBlockEntity.getHoneyLevel((BlockState)level.getBlockState(blockPosBeehive)) >= 5;
    }
}

