/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.bear;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.BearEntity;

public final class BearRoar
extends Behavior<BearEntity> {
    public BearRoar() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ROAR_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), 45);
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull BearEntity bear, long p_217590_) {
        return true;
    }

    protected void start(@NotNull ServerLevel level, @Nonnull BearEntity bear, long gameTime) {
        bear.stopMoving();
        Optional target = bear.getBrain().getMemory(MemoryModuleType.ROAR_TARGET);
        target.ifPresent(entity -> BehaviorUtils.lookAtEntity((LivingEntity)bear, (LivingEntity)entity));
        bear.setPose(Pose.ROARING);
        if (bear.getRoarSound() != null) {
            bear.playSound(bear.getRoarSound(), 1.0f, 1.0f);
        }
        bear.triggerAnim("base_controller", "roar");
    }

    protected void stop(@NotNull ServerLevel level, BearEntity bear, long gameTime) {
        if (bear.hasPose(Pose.ROARING)) {
            bear.setPose(Pose.STANDING);
        }
        bear.getBrain().getMemory(MemoryModuleType.ROAR_TARGET).ifPresent(bear::setAttackTarget);
        bear.getBrain().eraseMemory(MemoryModuleType.ROAR_TARGET);
    }
}

