/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.bear;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.BearEntity;

public class BearSleep
extends Behavior<BearEntity> {
    public BearSleep() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.ROAR_TARGET, (Object)MemoryStatus.VALUE_ABSENT), Integer.MAX_VALUE);
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull BearEntity bear) {
        return this.canStillUse(level, bear, 0L);
    }

    protected boolean canStillUse(ServerLevel level, @NotNull BearEntity bear, long gameTime) {
        return level.isNight() && !bear.isVehicle() && (bear.getLastHurtByMobTimestamp() > bear.tickCount || bear.tickCount - bear.getLastHurtByMobTimestamp() >= 200) && bear.getAwakeCounter() == 0 && this.hasRequiredMemories((LivingEntity)bear);
    }

    protected void start(@NotNull ServerLevel level, BearEntity bear, long gameTime) {
        bear.stopMoving();
        if (!bear.isBearSleeping()) {
            bear.triggerAnim("base_controller", "sleep_start");
        }
        bear.setPose(Pose.CROAKING);
        if (bear.isVehicle()) {
            bear.ejectPassengers();
        }
        bear.setBearSleeping(true);
    }

    protected void tick(@NotNull ServerLevel level, @NotNull BearEntity bear, long gameTime) {
        bear.stopMoving();
    }

    protected void stop(@NotNull ServerLevel level, BearEntity entity, long gameTime) {
        entity.triggerAnim("base_controller", "sleep_end");
        entity.setPose(Pose.STANDING);
        if (entity.getWakeUpSound() != null) {
            entity.playSound(entity.getWakeUpSound(), 1.0f, 0.8f + (float)entity.getRandom().nextIntBetweenInclusive(0, 2) * 0.1f);
        }
        entity.setBearSleeping(false);
        entity.setAwakeCounter(600 + entity.getRandom().nextIntBetweenInclusive(20, 200));
    }
}

