/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.eagle;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.EagleEntity;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Tags;

public class EagleSnatch
extends Behavior<EagleEntity> {
    private long endTimestamp = 10L;
    private final int defaultDuration;

    public EagleSnatch(int defaultDuration) {
        super((Map)ImmutableMap.of((Object)((MemoryModuleType)Primal_MemoryModuleTypes.IS_SNATCHING.get()), (Object)MemoryStatus.VALUE_PRESENT, (Object)((MemoryModuleType)Primal_MemoryModuleTypes.IS_STUNNED.get()), (Object)MemoryStatus.VALUE_ABSENT), defaultDuration);
        this.defaultDuration = defaultDuration;
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, EagleEntity eagle) {
        return !eagle.getPassengers().isEmpty();
    }

    protected void start(@NotNull ServerLevel level, @NotNull EagleEntity eagle, long gameTime) {
        List<EagleEntity> babyEagles;
        Vec3 lookVec = eagle.getLookAngle().normalize();
        int finalDuration = this.defaultDuration;
        double strengthAddition = 0.0;
        if (eagle.hasEffect(MobEffects.DAMAGE_BOOST)) {
            int amplifier = Objects.requireNonNull(eagle.getEffect(MobEffects.DAMAGE_BOOST)).getAmplifier();
            strengthAddition = 4 * (amplifier + 1);
            finalDuration += 2 * (amplifier + 1);
        }
        double verticalAddition = 20.0 + strengthAddition;
        this.endTimestamp = gameTime + (long)finalDuration;
        double forward = 10.0;
        Vec3 targetPos = eagle.position().add(lookVec.x * forward, lookVec.y * forward + verticalAddition, lookVec.z * forward);
        if (!eagle.isFollowing() && eagle.getFirstPassenger() != null && eagle.getFirstPassenger().getType().is(Primal_Tags.EAGLE_HUNTABLE) && !(babyEagles = level.getEntitiesOfClass(EagleEntity.class, eagle.getBoundingBox().inflate(10.0)).stream().filter(babyEagle -> babyEagle.isBaby() && !babyEagle.isFollowing()).toList()).isEmpty()) {
            BlockPos babyPos = babyEagles.get(level.random.nextInt(babyEagles.size())).getOnPos();
            targetPos = new Vec3((double)babyPos.getX(), (double)(babyPos.getY() + 5), (double)babyPos.getZ());
        }
        BlockPos flyTo = BlockPos.containing((Position)targetPos);
        eagle.stopMoving();
        eagle.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(flyTo));
        eagle.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(flyTo, 1.2f, 0));
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull EagleEntity eagle, long gameTime) {
        return this.checkExtraStartConditions(level, eagle) && this.hasRequiredMemories((LivingEntity)eagle);
    }

    protected void tick(@NotNull ServerLevel level, @NotNull EagleEntity eagle, long gameTime) {
        WalkTarget pos;
        LivingEntity living;
        Object e;
        LivingEntity target;
        LivingEntity livingEntity = target = !eagle.getPassengers().isEmpty() && (e = eagle.getPassengers().getFirst()) instanceof LivingEntity ? (living = (LivingEntity)e) : null;
        if (target == null) {
            this.stop(level, eagle, gameTime);
        }
        if (eagle.getBrain().getMemory(MemoryModuleType.WALK_TARGET).isPresent() && (float)(pos = (WalkTarget)eagle.getBrain().getMemory(MemoryModuleType.WALK_TARGET).get()).getTarget().currentBlockPosition().distManhattan((Vec3i)eagle.getOnPos()) < 2.0f) {
            this.stop(level, eagle, gameTime);
        }
    }

    protected void stop(@NotNull ServerLevel level, @NotNull EagleEntity eagle, long gameTime) {
        if (!eagle.getPassengers().isEmpty()) {
            LivingEntity livingEntity;
            Entity passenger = (Entity)eagle.getPassengers().getFirst();
            if (passenger instanceof LivingEntity && (livingEntity = (LivingEntity)passenger).getHealth() > 0.0f) {
                eagle.getBrain().setMemory(MemoryModuleType.ATTACK_TARGET, (Object)livingEntity);
            }
            eagle.ejectPassengers();
        }
        eagle.setPose(Pose.STANDING);
        eagle.getBrain().eraseMemory((MemoryModuleType)Primal_MemoryModuleTypes.IS_SNATCHING.get());
        eagle.getBrain().setMemoryWithExpiry((MemoryModuleType)Primal_MemoryModuleTypes.IS_STUNNED.get(), (Object)true, 20L);
        eagle.getBrain().setMemoryWithExpiry(MemoryModuleType.ATTACK_COOLING_DOWN, (Object)true, 10L);
    }

    protected boolean timedOut(long gameTime) {
        return gameTime > this.endTimestamp;
    }
}

