/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.behavior.generic;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import org.jetbrains.annotations.NotNull;

public class TriesReturnToWater
extends Behavior<Mob> {
    public TriesReturnToWater() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull Mob owner) {
        return owner.onGround() && !owner.level().getFluidState(owner.blockPosition()).is(FluidTags.WATER);
    }

    protected void start(@NotNull ServerLevel level, @NotNull Mob owner, long gameTime) {
        BlockPos blockpos = null;
        for (BlockPos blockPos1 : BlockPos.betweenClosed((int)Mth.floor((double)(owner.getX() - 8.0)), (int)Mth.floor((double)(owner.getY() - 8.0)), (int)Mth.floor((double)(owner.getZ() - 8.0)), (int)Mth.floor((double)(owner.getX() + 8.0)), (int)owner.getBlockY(), (int)Mth.floor((double)(owner.getZ() + 8.0)))) {
            if (!owner.level().getFluidState(blockPos1).is(FluidTags.WATER)) continue;
            blockpos = blockPos1;
            break;
        }
        if (blockpos != null) {
            owner.getMoveControl().setWantedPosition((double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), 1.0);
        }
    }
}

