/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.controls;

import java.util.function.Predicate;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import org.primal.util.MiscUtil;

public class SmoothRotationControl
extends BodyRotationControl {
    private final Mob mob;
    private final float maxChangeRate;
    private final Predicate<Mob> condition;
    private float lastStableYHeadRot;
    private int headStableTime;

    public SmoothRotationControl(Mob mob, float maxChangeRate, Predicate<Mob> condition) {
        super(mob);
        this.mob = mob;
        this.maxChangeRate = maxChangeRate;
        this.condition = condition;
    }

    public void clientTick() {
        if (this.condition.test(this.mob)) {
            if (this.isMoving()) {
                this.mob.yBodyRot = MiscUtil.smoothAngle(this.mob.yBodyRot, this.mob.getYRot(), this.maxChangeRate);
                this.lastStableYHeadRot = this.mob.yHeadRot = MiscUtil.smoothAngle(this.mob.yHeadRot, Mth.rotateIfNecessary((float)this.mob.yHeadRot, (float)this.mob.yBodyRot, (float)this.mob.getMaxHeadYRot()), this.maxChangeRate);
                this.headStableTime = 0;
            } else if (this.notCarryingMobPassengers()) {
                if (Math.abs(this.mob.yHeadRot - this.lastStableYHeadRot) > 15.0f) {
                    this.headStableTime = 0;
                    this.lastStableYHeadRot = this.mob.yHeadRot;
                    this.mob.yBodyRot = MiscUtil.smoothAngle(this.mob.yBodyRot, Mth.rotateIfNecessary((float)this.mob.yBodyRot, (float)this.mob.yHeadRot, (float)this.mob.getMaxHeadYRot()), this.maxChangeRate);
                } else {
                    ++this.headStableTime;
                    if (this.headStableTime > 10) {
                        this.rotateHeadTowardsFront();
                    }
                }
            }
        } else {
            super.clientTick();
        }
    }

    private void rotateHeadIfNecessary() {
        this.mob.yHeadRot = Mth.rotateIfNecessary((float)this.mob.yHeadRot, (float)this.mob.yBodyRot, (float)this.mob.getMaxHeadYRot());
    }

    private void rotateBodyIfNecessary() {
        this.mob.yBodyRot = Mth.rotateIfNecessary((float)this.mob.yBodyRot, (float)this.mob.yHeadRot, (float)this.mob.getMaxHeadYRot());
    }

    private void rotateHeadTowardsFront() {
        int i = this.headStableTime - 10;
        float f = Mth.clamp((float)((float)i / 10.0f), (float)0.0f, (float)1.0f);
        float f1 = (float)this.mob.getMaxHeadYRot() * (1.0f - f);
        this.mob.yBodyRot = MiscUtil.smoothAngle(this.mob.yBodyRot, Mth.rotateIfNecessary((float)this.mob.yBodyRot, (float)this.mob.yHeadRot, (float)f1), this.maxChangeRate);
    }

    private boolean notCarryingMobPassengers() {
        return !(this.mob.getFirstPassenger() instanceof Mob);
    }

    private boolean isMoving() {
        double d1;
        double d0 = this.mob.getX() - this.mob.xo;
        return d0 * d0 + (d1 = this.mob.getZ() - this.mob.zo) * d1 > 2.500000277905201E-7;
    }
}

