/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.ai.controls;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;

public class WaterOrLandMoveControl
extends MoveControl {
    private final Mob amphibian;
    private final int maxTurnX;
    private final int maxTurnY;
    private final float inWaterSpeedModifier;
    private final float outsideWaterSpeedModifier;
    private final boolean applyGravity;

    public WaterOrLandMoveControl(Mob amphibian, int maxTurnX, int maxTurnY, float inWaterSpeedModifier, float outsideWaterSpeedModifier, boolean applyGravity) {
        super(amphibian);
        this.amphibian = amphibian;
        this.maxTurnX = maxTurnX;
        this.maxTurnY = maxTurnY;
        this.inWaterSpeedModifier = inWaterSpeedModifier;
        this.outsideWaterSpeedModifier = outsideWaterSpeedModifier;
        this.applyGravity = applyGravity;
    }

    public void handleUnderwaterMovement() {
        if (this.applyGravity && this.mob.isInWater() && this.mob.yya >= 0.0f) {
            this.mob.setDeltaMovement(this.mob.getDeltaMovement().add(0.0, 0.005, 0.0));
        }
        if (this.operation == MoveControl.Operation.MOVE_TO && !this.mob.getNavigation().isDone()) {
            double f;
            double e;
            double d = this.wantedX - this.mob.getX();
            double g = d * d + (e = this.wantedY - this.mob.getY()) * e + (f = this.wantedZ - this.mob.getZ()) * f;
            if (g < 2.500000277905201E-7) {
                this.mob.setZza(0.0f);
            } else {
                float h = (float)(Mth.atan2((double)f, (double)d) * 180.0 / 3.1415927410125732) - 90.0f;
                this.mob.setYRot(this.rotlerp(this.mob.getYRot(), h, this.maxTurnY));
                this.mob.yBodyRot = this.mob.getYRot();
                this.mob.yHeadRot = this.mob.getYRot();
                float i = (float)(this.speedModifier * this.mob.getAttributeValue(Attributes.MOVEMENT_SPEED));
                if (this.mob.isInWater()) {
                    float k;
                    this.mob.setSpeed(i * this.inWaterSpeedModifier);
                    double j = Math.sqrt(d * d + f * f);
                    if (Math.abs(e) > (double)1.0E-5f || Math.abs(j) > (double)1.0E-5f) {
                        k = -((float)(Mth.atan2((double)e, (double)j) * 180.0 / 3.1415927410125732));
                        k = Mth.clamp((float)Mth.wrapDegrees((float)k), (float)(-this.maxTurnX), (float)this.maxTurnX);
                        this.mob.setXRot(this.rotlerp(this.mob.getXRot(), k, 5.0f));
                    }
                    k = Mth.cos((float)(this.mob.getXRot() * ((float)Math.PI / 180)));
                    float l = Mth.sin((float)(this.mob.getXRot() * ((float)Math.PI / 180)));
                    this.mob.zza = k * i;
                    this.mob.yya = -l * i;
                } else {
                    float m = Math.abs(Mth.wrapDegrees((float)(this.mob.getYRot() - h)));
                    float n = WaterOrLandMoveControl.getTurningSpeedFactor(m);
                    this.mob.setSpeed(i * this.outsideWaterSpeedModifier * n);
                }
            }
        } else {
            this.mob.setSpeed(0.0f);
            this.mob.setXxa(0.0f);
            this.mob.setYya(0.0f);
            this.mob.setZza(0.0f);
        }
    }

    private static float getTurningSpeedFactor(float f) {
        return 1.0f - Mth.clamp((float)((f - 10.0f) / 50.0f), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        if (this.amphibian.isInWater()) {
            this.handleUnderwaterMovement();
        } else {
            super.tick();
        }
    }
}

