/*
 * Decompiled with CFR 0.152.
 */
package org.primal.util;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Tags;
import org.primal.util.HostileMount;

public class MiscUtil {
    public static final IntegerProperty EGGS_2 = IntegerProperty.create((String)"eggs", (int)1, (int)2);
    public static final IntegerProperty EGGS_3 = IntegerProperty.create((String)"eggs", (int)1, (int)3);
    public static final IntegerProperty EGGS_4 = IntegerProperty.create((String)"eggs", (int)1, (int)4);

    public static boolean isMoving(LivingEntity entity, float motionThreshold) {
        float limbSwingAmount = 0.0f;
        if (entity.isAlive() && (limbSwingAmount = entity.walkAnimation.speed((float)entity.tickCount)) > 1.0f) {
            limbSwingAmount = 1.0f;
        }
        Vec3 velocity = entity.getDeltaMovement();
        float avgVelocity = (float)((Math.abs(velocity.x) + Math.abs(velocity.z)) / 2.0);
        return avgVelocity >= motionThreshold && limbSwingAmount != 0.0f;
    }

    public static boolean isSeeingTarget(Entity target, Entity watcher, float angle) {
        Vec3 vec3d = target.position();
        Vec3 vec3d2 = watcher.calculateViewVector(0.0f, watcher.getYHeadRot());
        Vec3 vec3d3 = vec3d.vectorTo(watcher.position());
        vec3d3 = new Vec3(vec3d3.x, 0.0, vec3d3.z).normalize();
        return vec3d3.dot(vec3d2) < (double)angle;
    }

    public static float smoothAngle(float current, float target, float maxChange) {
        float delta = Mth.wrapDegrees((float)(target - current));
        delta = Mth.clamp((float)delta, (float)(-maxChange), (float)maxChange);
        return current + delta;
    }

    public static boolean isRidingUnfriendly(LivingEntity entity) {
        return entity.isPassenger() && entity.getVehicle() instanceof HostileMount;
    }

    public static void extendLootPool(LootPool pool, List<LootPoolEntryContainer> newEntries) {
        ImmutableList.Builder entriesBuilder = ImmutableList.builder();
        entriesBuilder.addAll((Iterable)pool.entries);
        entriesBuilder.addAll(newEntries);
        pool.entries = entriesBuilder.build();
    }

    public static boolean isNotNeverAttack(LivingEntity entity) {
        return !entity.getType().is(Primal_Tags.NEVER_ATTACK);
    }

    public static void addToAttackCount(LivingEntity entity) {
        if (entity.getBrain().hasMemoryValue((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get())) {
            entity.getBrain().setMemory((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get(), (Object)((Integer)entity.getBrain().getMemory((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get()).get() + 1));
        } else {
            entity.getBrain().setMemory((MemoryModuleType)Primal_MemoryModuleTypes.AMOUNT_ATTACKED.get(), (Object)1);
        }
    }

    public static boolean isSameEagleAttacking(LivingEntity target, LivingEntity eagle) {
        if (target.primal$eagleAttacking().isPresent()) {
            if (eagle.isBaby()) {
                return true;
            }
            return target.primal$eagleAttacking().get() == eagle.getUUID();
        }
        return true;
    }

    public static void insertItemsAfter(BuildCreativeModeTabContentsEvent event, ItemStack after, ItemStack ... itemStacks) {
        for (int i = 0; i < itemStacks.length; ++i) {
            if (i == 0) {
                event.insertAfter(after, itemStacks[i], CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
                continue;
            }
            event.insertAfter(itemStacks[i - 1], itemStacks[i], CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    public static ResourceLocation nomanslandLoc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"nomansland", (String)name);
    }
}

