/*
 * Decompiled with CFR 0.152.
 */
package org.primal;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.SpawnPlacementRegisterEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.primal.Primal_Config;
import org.primal.Primal_Registries;
import org.primal.biome_modifiers.features.EagleNest_BiomeModifier;
import org.primal.biome_modifiers.features.RiverReeds_BiomeModifier;
import org.primal.biome_modifiers.features.Seashells_BiomeModifier;
import org.primal.biome_modifiers.mobs.BearGroup_BiomeModifier;
import org.primal.biome_modifiers.mobs.BearSingle_BiomeModifier;
import org.primal.biome_modifiers.mobs.CrocodileNormal_BiomeModifier;
import org.primal.biome_modifiers.mobs.CrocodileWarm_BiomeModifier;
import org.primal.biome_modifiers.mobs.SharkGroup_BiomeModifier;
import org.primal.biome_modifiers.mobs.SharkSingle_BiomeModifier;
import org.primal.datagen.providers.Primal_DataMapGenerator;
import org.primal.entity.animal.BearEntity;
import org.primal.entity.animal.CrocodileEntity;
import org.primal.entity.animal.EagleEntity;
import org.primal.entity.animal.SharkEntity;
import org.primal.registry.Primal_Activities;
import org.primal.registry.Primal_BannerPatterns;
import org.primal.registry.Primal_BlockEntities;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_Entities;
import org.primal.registry.Primal_Items;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Sensors;
import org.primal.registry.Primal_Sounds;
import org.primal.registry.Primal_VillagerCustomTrades;
import org.primal.registry.Primal_WorldGen;
import org.primal.util.MiscUtil;

@Mod.EventBusSubscriber(modid="primal", bus=Mod.EventBusSubscriber.Bus.MOD)
@Mod(value="primal")
public class Primal_Main {
    public static final String MOD_ID = "primal";
    public static final Primal_Config COMMON_CONFIG;
    public static final ForgeConfigSpec COMMON_SPEC;

    public Primal_Main(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_SPEC);
        Primal_Sensors.init();
        Primal_Registries.SENSOR_TYPES.register(modEventBus);
        Primal_MemoryModuleTypes.init();
        Primal_Registries.MEMORY_MODULE_TYPES.register(modEventBus);
        Primal_Activities.init();
        Primal_Registries.ACTIVITIES.register(modEventBus);
        Primal_Entities.init();
        Primal_Registries.ENTITIES.register(modEventBus);
        Primal_Sounds.init();
        Primal_Registries.SOUNDS.register(modEventBus);
        Primal_Blocks.init();
        Primal_Registries.BLOCKS.register(modEventBus);
        Primal_BlockEntities.init();
        Primal_Registries.BLOCK_ENTITIES.register(modEventBus);
        Primal_Items.initItems();
        Primal_Registries.ITEMS.register(modEventBus);
        Primal_Items.initGroups();
        Primal_Registries.CREATIVE_MODE_TABS.register(modEventBus);
        Primal_WorldGen.init();
        Primal_Registries.FEATURES.register(modEventBus);
        Primal_VillagerCustomTrades.init();
        Primal_BannerPatterns.init();
        Primal_Registries.BANNER_PATTERNS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Primal_Main.createBiomeModifiers(modEventBus);
    }

    public static void createBiomeModifiers(IEventBus modEventBus) {
        DeferredRegister biomeModifiers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)MOD_ID);
        biomeModifiers.register(modEventBus);
        biomeModifiers.register("bear_single_spawn", BearSingle_BiomeModifier::makeCodec);
        biomeModifiers.register("bear_group_spawn", BearGroup_BiomeModifier::makeCodec);
        biomeModifiers.register("crocodile_normal_spawn", CrocodileNormal_BiomeModifier::makeCodec);
        biomeModifiers.register("crocodile_warm_spawn", CrocodileWarm_BiomeModifier::makeCodec);
        biomeModifiers.register("shark_single_spawn", SharkSingle_BiomeModifier::makeCodec);
        biomeModifiers.register("shark_group_spawn", SharkGroup_BiomeModifier::makeCodec);
        biomeModifiers.register("river_reeds_patch_spawn", RiverReeds_BiomeModifier::makeCodec);
        biomeModifiers.register("seashells_patch_spawn", Seashells_BiomeModifier::makeCodec);
        biomeModifiers.register("eagle_nest_spawn", EagleNest_BiomeModifier::makeCodec);
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        Primal_Main.setFlammables();
        Primal_DataMapGenerator.setSimilarToDataMaps();
    }

    public static void setFlammables() {
        FireBlock fireblock = (FireBlock)Blocks.f_50083_;
        fireblock.m_53444_((Block)Primal_Blocks.SHORT_RIVER_REEDS.get(), 30, 60);
        fireblock.m_53444_((Block)Primal_Blocks.RIVER_REEDS.get(), 30, 60);
        fireblock.m_53444_((Block)Primal_Blocks.NEST_BLOCK.get(), 30, 60);
        fireblock.m_53444_((Block)Primal_Blocks.STRAW_BALE.get(), 100, 200);
    }

    @SubscribeEvent
    public static void addToCreativeTabs(@NotNull BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey().equals((Object)CreativeModeTabs.f_256839_)) {
            MiscUtil.insertItemsAfter(event, Items.f_42437_.m_7968_(), ((Item)Primal_Items.APPLE_FRITTER.get()).m_7968_(), ((Item)Primal_Items.GOLDEN_APPLE_FRITTER.get()).m_7968_(), ((Item)Primal_Items.ENCHANTED_GOLDEN_APPLE_FRITTER.get()).m_7968_());
        }
        if (event.getTabKey().equals((Object)CreativeModeTabs.f_256776_)) {
            MiscUtil.insertItemsAfter(event, Items.f_41864_.m_7968_(), ((Item)Primal_Items.SHORT_RIVER_REEDS.get()).m_7968_());
            MiscUtil.insertItemsAfter(event, Items.f_42210_.m_7968_(), ((Item)Primal_Items.RIVER_REEDS.get()).m_7968_());
            MiscUtil.insertItemsAfter(event, Items.f_220223_.m_7968_(), ((Item)Primal_Items.NEST.get()).m_7968_());
            MiscUtil.insertItemsAfter(event, Items.f_42279_.m_7968_(), ((Item)Primal_Items.CROCODILE_EGG.get()).m_7968_(), ((Item)Primal_Items.EAGLE_EGG.get()).m_7968_());
            MiscUtil.insertItemsAfter(event, Items.f_42094_.m_7968_(), ((Item)Primal_Items.SEASHELLS.get()).m_7968_());
            MiscUtil.insertItemsAfter(event, Items.f_42129_.m_7968_(), ((Item)Primal_Items.STRAW_BLOCK.get()).m_7968_());
        }
        if (event.getTabKey().equals((Object)CreativeModeTabs.f_256968_)) {
            MiscUtil.insertItemsAfter(event, Items.f_42355_.m_7968_(), ((Item)Primal_Items.CROCODILE_SCUTE.get()).m_7968_());
            MiscUtil.insertItemsAfter(event, Items.f_42696_.m_7968_(), ((Item)Primal_Items.SHARK_TOOTH.get()).m_7968_());
            MiscUtil.insertItemsAfter(event, Items.f_42720_.m_7968_(), ((Item)Primal_Items.PAW_BANNER_PATTERN.get()).m_7968_(), ((Item)Primal_Items.JAWS_BANNER_PATTERN.get()).m_7968_(), ((Item)Primal_Items.MARSH_BANNER_PATTERN.get()).m_7968_(), ((Item)Primal_Items.EYRIE_BANNER_PATTERN.get()).m_7968_());
        }
        if (event.getTabKey().equals((Object)CreativeModeTabs.f_256788_)) {
            MiscUtil.insertItemsAfter(event, Items.f_41990_.m_7968_(), ((Item)Primal_Items.CROCODILE_SCUTE_BLOCK.get()).m_7968_(), ((Item)Primal_Items.CROCODILE_SCUTE_STAIRS.get()).m_7968_(), ((Item)Primal_Items.CROCODILE_SCUTE_SLAB.get()).m_7968_(), ((Item)Primal_Items.CHISELED_CROCODILE_SCUTE.get()).m_7968_(), ((Item)Primal_Items.CROCODILE_SCUTE_SHINGLE.get()).m_7968_());
        }
        if (event.getTabKey().equals((Object)CreativeModeTabs.f_256731_)) {
            event.getEntries().putAfter((Object)Items.f_42547_.m_7968_(), (Object)((Item)Primal_Items.BEAR_SPAWN_EGG.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42555_.m_7968_(), (Object)((Item)Primal_Items.CROCODILE_SPAWN_EGG.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42558_.m_7968_(), (Object)((Item)Primal_Items.EAGLE_SPAWN_EGG.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            event.getEntries().putAfter((Object)Items.f_42638_.m_7968_(), (Object)((Item)Primal_Items.SHARK_SPAWN_EGG.get()).m_7968_(), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
        }
    }

    @SubscribeEvent
    public static void registerAttribute(@NotNull EntityAttributeCreationEvent event) {
        event.put((EntityType)Primal_Entities.BEAR.get(), BearEntity.createAttributes().m_22265_());
        event.put((EntityType)Primal_Entities.SHARK.get(), SharkEntity.createAttributes().m_22265_());
        event.put((EntityType)Primal_Entities.CROCODILE.get(), CrocodileEntity.createAttributes().m_22265_());
        event.put((EntityType)Primal_Entities.EAGLE.get(), EagleEntity.createAttributes().m_22265_());
    }

    @SubscribeEvent
    public static void registerSpawnPlacements(@NotNull SpawnPlacementRegisterEvent event) {
        event.register((EntityType)Primal_Entities.BEAR.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)Primal_Entities.SHARK.get(), SpawnPlacements.Type.IN_WATER, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, WaterAnimal::m_218282_, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)Primal_Entities.CROCODILE.get(), SpawnPlacements.Type.NO_RESTRICTIONS, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CrocodileEntity::checkCrocodileSpawnRules, SpawnPlacementRegisterEvent.Operation.REPLACE);
        event.register((EntityType)Primal_Entities.EAGLE.get(), SpawnPlacements.Type.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Animal::m_218104_, SpawnPlacementRegisterEvent.Operation.REPLACE);
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(Primal_Config::new);
        COMMON_CONFIG = (Primal_Config)pair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)pair.getRight();
    }

    @Mod.EventBusSubscriber(modid="primal", bus=Mod.EventBusSubscriber.Bus.FORGE)
    private static class Primal_MainGameBus {
        private Primal_MainGameBus() {
        }

        @SubscribeEvent
        public static void captureDropsForCrocodile(@NotNull LivingDropsEvent event) {
            Entity entity;
            if (event.getSource().m_7639_() != null && (entity = event.getSource().m_7639_()) instanceof CrocodileEntity) {
                CrocodileEntity crocodile = (CrocodileEntity)entity;
                if (!(event.getEntity() instanceof Player)) {
                    ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                    ArrayList<ItemEntity> stacksEaten = new ArrayList<ItemEntity>();
                    for (ItemEntity itemEntity : event.getDrops()) {
                        if (!crocodile.canEatItem(itemEntity.m_32055_())) continue;
                        stacks.add(itemEntity.m_32055_());
                        stacksEaten.add(itemEntity);
                    }
                    for (ItemEntity itemEntity : stacksEaten) {
                        event.getDrops().remove(itemEntity);
                    }
                    crocodile.addItemsToInventory(stacks);
                }
            }
        }

        @SubscribeEvent
        public static void modifyLootTables(LootTableLoadEvent event) {
            LootTable originalTable;
            LootPool originalPool;
            if (event.getName().equals((Object)BuiltInLootTables.f_78690_) && (originalPool = (originalTable = event.getTable()).getPool("pool1")) != null) {
                LootPoolEntryContainer shark_tooth = LootItem.m_79579_((ItemLike)((ItemLike)Primal_Items.SHARK_TOOTH.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79707_(2).m_7512_();
                MiscUtil.extendLootPool(originalPool, List.of(shark_tooth));
            }
        }
    }
}

