/*
 * Decompiled with CFR 0.152.
 */
package org.primal.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ambient.Bat;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.primal.entity.animal.EagleEntity;
import org.primal.registry.Primal_Entities;
import org.primal.util.AnimalEgg;
import org.primal.util.MiscUtil;

public class EagleEgg
extends Block
implements AnimalEgg {
    public static final IntegerProperty EGGS = MiscUtil.EGGS_2;
    private static final VoxelShape ONE_EGG_AABB = Block.m_49796_((double)3.0, (double)0.0, (double)2.0, (double)9.0, (double)6.0, (double)8.0);
    private static final VoxelShape MULTIPLE_EGGS_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public EagleEgg(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{EGGS, HATCH});
    }

    @Override
    public RegistryObject<? extends EntityType<? extends Animal>> getAnimal() {
        return Primal_Entities.EAGLE;
    }

    @Override
    public boolean entityCannotDestroyEgg(Entity entity) {
        return entity instanceof EagleEntity || entity instanceof Bat || entity instanceof Parrot;
    }

    public void m_141947_(@NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState state, Entity entity) {
        if (!entity.m_20161_()) {
            this.destroyEgg(level, state, pos, entity, 100, this, EGGS);
        }
        super.m_141947_(level, pos, state, entity);
    }

    public void m_142072_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Entity entity, float fallDistance) {
        if (!(entity instanceof Zombie)) {
            this.destroyEgg(level, state, pos, entity, 3, this, EGGS);
        }
        super.m_142072_(level, state, pos, entity, fallDistance);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = context.m_43725_().m_8055_(context.m_8083_());
        return blockstate.m_60713_((Block)this) ? (BlockState)blockstate.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(Math.min(2, (Integer)blockstate.m_61143_((Property)EGGS) + 1))) : super.m_5573_(context);
    }

    public void m_6240_(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity te, @NotNull ItemStack stack) {
        super.m_6240_(level, player, pos, state, te, stack);
        this.decreaseEggs(level, pos, state, EGGS);
    }

    public boolean m_6864_(@NotNull BlockState state, BlockPlaceContext useContext) {
        return !useContext.m_7078_() && useContext.m_43722_().m_150930_(this.m_5456_()) && (Integer)state.m_61143_((Property)EGGS) < 3 || super.m_6864_(state, useContext);
    }

    public void m_213898_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        this.randomTick(state, level, pos, random, EGGS);
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Integer)state.m_61143_((Property)EGGS) > 1 ? MULTIPLE_EGGS_AABB : ONE_EGG_AABB;
    }
}

