/*
 * Decompiled with CFR 0.152.
 */
package org.primal.client.renderer.block_entity;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.primal.block.NestBlock;
import org.primal.block_entity.NestBlockEntity;

public class NestBlockEntityRenderer
implements BlockEntityRenderer<NestBlockEntity> {
    private final BlockRenderDispatcher blockRenderer;

    public NestBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.blockRenderer = context.m_173584_();
    }

    public void render(@NotNull NestBlockEntity nestBlockEntity, float partialTick, @NotNull PoseStack poseStack, @NotNull MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        Level level = nestBlockEntity.m_58904_();
        if (level != null) {
            if (!((Boolean)nestBlockEntity.m_58900_().m_61143_((Property)NestBlock.HAS_EGG)).booleanValue()) {
                return;
            }
            ItemStack eggStack = nestBlockEntity.getEgg();
            Item item = eggStack.m_41720_();
            if (item instanceof BlockItem) {
                BakedModel eggModel;
                BlockItem blockItem = (BlockItem)item;
                Block eggBlock = blockItem.m_40614_();
                BlockState eggState = eggBlock.m_49966_();
                Optional<Property> eggProperty = eggBlock.m_49966_().m_61147_().stream().filter(property -> property.m_61708_().equals("eggs") && property instanceof IntegerProperty).findFirst();
                Optional<Property> hatchProperty = eggBlock.m_49966_().m_61147_().stream().filter(property -> property.m_61708_().equals("hatch") && property instanceof IntegerProperty).findFirst();
                if (eggProperty.isPresent()) {
                    eggState = (BlockState)eggState.m_61124_((Property)((IntegerProperty)eggProperty.get()), (Comparable)Integer.valueOf(eggStack.m_41613_()));
                }
                if (hatchProperty.isPresent()) {
                    eggState = (BlockState)eggState.m_61124_((Property)((IntegerProperty)hatchProperty.get()), (Comparable)((Integer)nestBlockEntity.m_58900_().m_61143_((Property)NestBlock.HATCH)));
                }
                if ((eggModel = this.blockRenderer.m_110910_(eggState)) != null) {
                    poseStack.m_85836_();
                    poseStack.m_252880_(0.0f, 0.25f, 0.0f);
                    this.blockRenderer.m_110912_(eggState, poseStack, bufferSource, packedLight, packedOverlay);
                    poseStack.m_85849_();
                }
            }
        }
    }
}

