/*
 * Decompiled with CFR 0.152.
 */
package org.primal.datagen.providers;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import org.primal.registry.Primal_Blocks;

public class Primal_BlockModelGenerator
extends BlockModelProvider {
    public Primal_BlockModelGenerator(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "primal", existingFileHelper);
    }

    protected void registerModels() {
        ((BlockModelBuilder)this.withExistingParent("shark_tooth_base", ResourceLocation.withDefaultNamespace((String)"block/pointed_dripstone"))).texture("cross", ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/shark_tooth_base"));
        ((BlockModelBuilder)this.withExistingParent("shark_tooth_tip", ResourceLocation.withDefaultNamespace((String)"block/pointed_dripstone"))).texture("cross", ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/shark_tooth_tip"));
        ((BlockModelBuilder)this.withExistingParent("shark_tooth_tip_down", ResourceLocation.withDefaultNamespace((String)"block/pointed_dripstone"))).texture("cross", ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/shark_tooth_tip_down"));
        this.createCubeAll(Primal_Blocks.CROCODILE_SCUTE_BLOCK);
        this.createCubeAll(Primal_Blocks.CROCODILE_SCUTE_SHINGLE);
        this.createCubeAll(Primal_Blocks.CHISELED_CROCODILE_SCUTE);
        this.simpleStairs(Primal_Blocks.CROCODILE_SCUTE_STAIRS, Primal_Blocks.CROCODILE_SCUTE_BLOCK);
        this.simpleSlab(Primal_Blocks.CROCODILE_SCUTE_SLAB, Primal_Blocks.CROCODILE_SCUTE_BLOCK);
        this.tintedOverlayCross("river_reeds_top_0", ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/river_reeds_top_0"), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/river_reeds_top_0_overlay"));
        this.tintedOverlayCross("river_reeds_top_1", ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/river_reeds_top_1"), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/river_reeds_top_1_overlay"));
        this.tintedCross("river_reeds_middle", ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/river_reeds_middle"));
        this.tintedCross("river_reeds_bottom", ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/river_reeds_bottom"));
        this.tintedCross(Primal_Blocks.SHORT_RIVER_REEDS.getId().m_135815_(), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"block/short_river_reeds"));
        this.createEggModel("eagle_egg_one", "template_one_eagle_egg");
        this.createEggModel("eagle_egg_one_chipped", "template_one_eagle_egg");
        this.createEggModel("eagle_egg_one_cracked", "template_one_eagle_egg");
        this.createEggModel("eagle_egg_two", "template_two_eagle_eggs");
        this.createEggModel("eagle_egg_two_chipped", "template_two_eagle_eggs");
        this.createEggModel("eagle_egg_two_cracked", "template_two_eagle_eggs");
        this.createEggModel("crocodile_egg_one", "template_one_crocodile_egg");
        this.createEggModel("crocodile_egg_one_chipped", "template_one_crocodile_egg");
        this.createEggModel("crocodile_egg_one_cracked", "template_one_crocodile_egg");
        this.createEggModel("crocodile_egg_two", "template_two_crocodile_eggs");
        this.createEggModel("crocodile_egg_two_chipped", "template_two_crocodile_eggs");
        this.createEggModel("crocodile_egg_two_cracked", "template_two_crocodile_eggs");
        this.createEggModel("crocodile_egg_three", "template_three_crocodile_eggs");
        this.createEggModel("crocodile_egg_three_chipped", "template_three_crocodile_eggs");
        this.createEggModel("crocodile_egg_three_cracked", "template_three_crocodile_eggs");
        this.columBlock(Primal_Blocks.STRAW_BALE, "block/straw_bale_side", "block/straw_bale_top");
    }

    private void columBlock(RegistryObject<Block> block, String side, String top) {
        this.cubeColumn(block.getId().m_135815_(), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)side), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)top));
        this.cubeColumnHorizontal(block.getId().m_135815_() + "_horizontal", ResourceLocation.fromNamespaceAndPath((String)"primal", (String)side), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)top));
    }

    private void tintedCross(String name, ResourceLocation cross) {
        this.singleTexture(name, "block/tinted_cross", "cross", cross);
    }

    private void tintedOverlayCross(String name, ResourceLocation cross, ResourceLocation overlay) {
        ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(name, ResourceLocation.fromNamespaceAndPath((String)"primal", (String)"tinted_cross_overlay"))).texture("cross", cross)).texture("overlay", overlay);
    }

    private void createCubeAll(RegistryObject<Block> block) {
        this.cubeAll(block.getId().m_135815_(), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("block/" + block.getId().m_135815_())));
    }

    private void simpleStairs(RegistryObject<Block> stairs, RegistryObject<Block> baseBlock) {
        this.stairs(stairs.getId().m_135815_(), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("block/" + baseBlock.getId().m_135815_())), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("block/" + baseBlock.getId().m_135815_())), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("block/" + baseBlock.getId().m_135815_())));
    }

    private void simpleSlab(RegistryObject<Block> slab, RegistryObject<Block> baseBlock) {
        this.slab(slab.getId().m_135815_(), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("block/" + baseBlock.getId().m_135815_())), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("block/" + baseBlock.getId().m_135815_())), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("block/" + baseBlock.getId().m_135815_())));
    }

    private void createCross(RegistryObject<Block> block, boolean tinted) {
        if (tinted) {
            this.tintedCross(block.getId().m_135815_(), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("block/" + block.getId().m_135815_())));
        } else {
            this.cross(block.getId().m_135815_(), ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("block/" + block.getId().m_135815_())));
        }
    }

    private void singleTexture(String name, String parent, String textureKey, ResourceLocation texture) {
        this.singleTexture(name, this.mcLoc(parent), textureKey, texture);
    }

    private void createEggModel(String name, String type) {
        this.createEggModel(name, type, name);
    }

    private void createEggModel(String name, String parent, String texture) {
        ((BlockModelBuilder)this.withExistingParent(name, ResourceLocation.fromNamespaceAndPath((String)"primal", (String)parent))).texture("egg", ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("block/" + texture)));
    }
}

