/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.animal;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.primal.client.animation.entity.BearAnimations;
import org.primal.entity.ai.BearAi;
import org.primal.entity.misc.TamableAnimalExtension;
import org.primal.registry.Primal_Entities;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Sounds;
import org.primal.registry.Primal_Tags;
import org.primal.util.MiscUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BearEntity
extends TamableAnimalExtension
implements VariantHolder<Variant>,
GeoEntity,
ContainerListener,
HasCustomInventoryScreen,
OwnableEntity,
NeutralMob {
    protected SimpleContainer inventory = new SimpleContainer(27);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Boolean> BEAR_SLEEPING = SynchedEntityData.m_135353_(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_HONEY_COUNTER = SynchedEntityData.m_135353_(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AWAKE_COUNTER = SynchedEntityData.m_135353_(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> HEALING_COOLDOWN = SynchedEntityData.m_135353_(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_CHEST = SynchedEntityData.m_135353_(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> FOLLOWER_STATE = SynchedEntityData.m_135353_(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_JOCKEY = SynchedEntityData.m_135353_(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(BearEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int tameAttempts = 0;

    public void m_5757_(@NotNull Container container) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, (double)0.1f).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22282_, (double)1.8f).m_22268_(Attributes.f_22278_, (double)0.6f);
    }

    public BearEntity(EntityType<BearEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21153_(this.m_21233_());
        this.m_21573_().m_7008_(true);
        this.m_274367_(1.5f);
    }

    @NotNull
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, CompoundTag tag) {
        Holder holder;
        AgeableMob.AgeableMobGroupData ageableData;
        if (spawnGroupData == null) {
            spawnGroupData = new AgeableMob.AgeableMobGroupData(false);
        }
        if ((ageableData = (AgeableMob.AgeableMobGroupData)spawnGroupData).m_146777_() > 0) {
            this.m_6863_(ageableData.m_146777_() % 2 != 0);
        }
        if ((holder = level.m_204166_(this.m_20183_())).m_203656_(Primal_Tags.SPAWNS_BLACK_BEAR)) {
            this.setVariant(Variant.WARM);
        } else {
            this.setVariant(Variant.GRIZZLY);
        }
        return super.m_6518_(level, difficulty, spawnType, spawnGroupData, tag);
    }

    public double m_142593_(LivingEntity entity) {
        return this.m_20205_() * 1.8f * this.m_20205_() * 1.8f + entity.m_20205_();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{BearAnimations.mainController(this).receiveTriggeredAnimations().triggerableAnim("roar", BearAnimations.ROAR).triggerableAnim("beg_end", RawAnimation.begin().thenPlay("animation.grizzly_bear.beg_end")).triggerableAnim("sleep_start", RawAnimation.begin().thenPlay("animation.grizzly_bear.sleep_start")).triggerableAnim("sleep_end", RawAnimation.begin().thenPlay("animation.grizzly_bear.sleep_end")), new AnimationController((GeoAnimatable)this, "alt_idle", state -> PlayState.STOP).triggerableAnim("alt_idle", BearAnimations.IDLE_ALT), new AnimationController((GeoAnimatable)this, "attack", state -> PlayState.STOP).triggerableAnim("attack", BearAnimations.ATTACK).triggerableAnim("attack2", BearAnimations.ATTACK_ALT)});
    }

    public int m_8085_() {
        return 35;
    }

    public int m_8132_() {
        return 35;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_6674_(@NotNull InteractionHand hand) {
        this.triggerAnim("attack", this.m_217043_().m_188499_() ? "attack" : "attack2");
        super.m_6674_(hand);
    }

    public boolean m_7327_(@NotNull Entity entity) {
        boolean hurt = super.m_7327_(entity);
        List<Object> attackablesEntities = new ArrayList<Entity>(this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(1.0)).stream().filter(target -> {
            BearEntity bear2;
            return MiscUtil.isSeeingTarget(target, (Entity)this, -0.8f) && (!(target instanceof BearEntity) || (bear2 = (BearEntity)((Object)target)).m_269323_() == null || bear2.m_269323_() != this.m_269323_());
        }).toList());
        if (attackablesEntities.size() > 5) {
            attackablesEntities = attackablesEntities.subList(0, 5);
        }
        for (Entity otherEntity : attackablesEntities) {
            this.doHurtOther(otherEntity);
        }
        return hurt;
    }

    public void doHurtOther(@NotNull Entity entity) {
        boolean flag;
        float f = (float)this.m_21133_(Attributes.f_22281_) * 0.6f;
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        DamageSource damagesource = this.m_269291_().m_269333_((LivingEntity)this);
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (entity instanceof LivingEntity) {
                f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)((LivingEntity)entity).m_6336_());
                f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
            }
        }
        if (flag = entity.m_6469_(damagesource, f)) {
            Level level2;
            if (f1 > 0.0f && entity instanceof LivingEntity) {
                LivingEntity livingentity = (LivingEntity)entity;
                livingentity.m_147240_((double)(f1 * 0.2f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if ((level2 = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel1 = (ServerLevel)level2;
                this.m_19970_((LivingEntity)this, entity);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            if (this.f_19797_ % 300 == 0 && this.m_217043_().m_188499_()) {
                this.triggerAnim("alt_idle", "alt_idle");
            }
        } else {
            this.setCounters();
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BEAR_SLEEPING, (Object)false);
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)Variant.GRIZZLY.id);
        this.f_19804_.m_135372_(DATA_HONEY_COUNTER, (Object)0);
        this.f_19804_.m_135372_(AWAKE_COUNTER, (Object)0);
        this.f_19804_.m_135372_(HEALING_COOLDOWN, (Object)0);
        this.f_19804_.m_135372_(HAS_CHEST, (Object)false);
        this.f_19804_.m_135372_(FOLLOWER_STATE, (Object)0);
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(IS_JOCKEY, (Object)false);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant().id);
        compound.m_128405_("HoneyCounter", this.getHoneyCounter());
        compound.m_128405_("AwakeCounter", this.getAwakeCounter());
        compound.m_128405_("HealingCooldown", this.getHealingCooldown());
        compound.m_128379_("IsSleeping", this.isBearSleeping());
        compound.m_128379_("HasChest", this.hasChest());
        if (this.m_21805_() != null) {
            compound.m_128405_("FollowerState", this.getFollowerState());
        }
        if (this.hasChest()) {
            ListTag listtag = new ListTag();
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag compoundtag = new CompoundTag();
                compoundtag.m_128344_("Slot", (byte)i);
                itemstack.m_41739_(compoundtag);
                listtag.add((Object)compoundtag);
            }
            compound.m_128365_("Items", (Tag)listtag);
        }
        compound.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
        compound.m_128379_("BearJockey", this.isBearJockey());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(Variant.byId(compound.m_128451_("Variant")));
        this.setHoneyCounter(compound.m_128451_("HoneyCounter"));
        this.setAwakeCounter(compound.m_128451_("AwakeCounter"));
        this.setBearSleeping(compound.m_128471_("IsSleeping"));
        this.setHealingCooldown(compound.m_128451_("HealingCooldown"));
        this.setChest(compound.m_128471_("HasChest"));
        if (compound.m_128403_("Owner")) {
            this.setFollowerState(compound.m_128451_("FollowerState"));
        }
        if (this.hasChest()) {
            ListTag listtag = compound.m_128437_("Items", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag compoundtag = listtag.m_128728_(i);
                int j = compoundtag.m_128445_("Slot") & 0xFF;
                if (j < 2 || j >= this.inventory.m_6643_()) continue;
                this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
            }
        }
        if (compound.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)compound.m_128451_("CollarColor")));
        }
        this.setBearJockey(compound.m_128471_("BearJockey"));
    }

    public boolean isBearSleeping() {
        return (Boolean)this.f_19804_.m_135370_(BEAR_SLEEPING);
    }

    public void setBearSleeping(boolean isSleeping) {
        this.f_19804_.m_135381_(BEAR_SLEEPING, (Object)isSleeping);
    }

    public int getHoneyCounter() {
        return (Integer)this.f_19804_.m_135370_(DATA_HONEY_COUNTER);
    }

    public void setHoneyCounter(int value) {
        this.f_19804_.m_135381_(DATA_HONEY_COUNTER, (Object)value);
    }

    public int getAwakeCounter() {
        return (Integer)this.f_19804_.m_135370_(AWAKE_COUNTER);
    }

    public void setAwakeCounter(int value) {
        this.f_19804_.m_135381_(AWAKE_COUNTER, (Object)value);
    }

    public int getHealingCooldown() {
        return (Integer)this.f_19804_.m_135370_(HEALING_COOLDOWN);
    }

    public void setHealingCooldown(int value) {
        this.f_19804_.m_135381_(HEALING_COOLDOWN, (Object)value);
    }

    public boolean hasChest() {
        return (Boolean)this.f_19804_.m_135370_(HAS_CHEST);
    }

    public void setChest(boolean chested) {
        this.f_19804_.m_135381_(HAS_CHEST, (Object)chested);
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    private void setCollarColor(DyeColor collarColor) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)collarColor.m_41060_());
    }

    public boolean isBearJockey() {
        return (Boolean)this.f_19804_.m_135370_(IS_JOCKEY);
    }

    public void setBearJockey(boolean isJockey) {
        this.f_19804_.m_135381_(IS_JOCKEY, (Object)isJockey);
    }

    public int getFollowerState() {
        return (Integer)this.f_19804_.m_135370_(FOLLOWER_STATE);
    }

    public void setFollowerState(int state) {
        this.f_19804_.m_135381_(FOLLOWER_STATE, (Object)state);
    }

    public boolean isSitting() {
        return this.getFollowerState() == 2;
    }

    public boolean isFollowing() {
        return this.getFollowerState() == 1;
    }

    public boolean isWandering() {
        return this.getFollowerState() == 0;
    }

    public void setVariant(Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    @NotNull
    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    private void setCounters() {
        if (this.getHoneyCounter() > 0) {
            this.setHoneyCounter(this.getHoneyCounter() - 1);
        }
        if (this.getAwakeCounter() > 0 && !this.m_5912_() && !this.m_6274_().m_21954_(Activity.f_219851_)) {
            this.setAwakeCounter(this.getAwakeCounter() - 1);
        }
        if (this.getHealingCooldown() > 0) {
            this.setHealingCooldown(this.getHealingCooldown() - 1);
        }
    }

    public boolean m_7848_(@NotNull Animal otherAnimal) {
        PolarBear polarBear;
        BearEntity bear;
        if (otherAnimal instanceof BearEntity && (bear = (BearEntity)otherAnimal).canParent() && this.canParent()) {
            return true;
        }
        return otherAnimal instanceof PolarBear && (polarBear = (PolarBear)otherAnimal).m_7848_((Animal)this) && this.canParent() && this.getVariant() == Variant.GRIZZLY;
    }

    public boolean canParent() {
        return !this.m_20160_() && !this.m_20159_() && !this.m_6162_() && this.m_27593_();
    }

    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob otherParent) {
        return BearEntity.createFromParents((AgeableMob)this, otherParent);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static BearEntity createFromParents(AgeableMob parent, AgeableMob otherParent) {
        BearEntity offspring = (BearEntity)((EntityType)Primal_Entities.BEAR.get()).m_20615_(parent.m_9236_());
        if (offspring == null) return offspring;
        if (parent instanceof BearEntity) {
            BearEntity bear1 = (BearEntity)parent;
            if (otherParent instanceof BearEntity) {
                BearEntity bear2 = (BearEntity)otherParent;
                offspring.setVariant(offspring.f_19796_.m_188499_() ? bear1.getVariant() : bear2.getVariant());
                return offspring;
            }
        }
        if (!(parent instanceof PolarBear)) {
            if (!(otherParent instanceof PolarBear)) return offspring;
        }
        offspring.setVariant(Variant.GROLAR);
        return offspring;
    }

    public boolean refuseToMove() {
        return ImmutableList.of((Object)Pose.ROARING, (Object)Pose.SNIFFING, (Object)Pose.CROAKING).contains((Object)this.m_20089_());
    }

    public void stopMoving() {
        this.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        this.m_21573_().m_26573_();
        this.m_6274_().m_21936_(MemoryModuleType.f_26371_);
    }

    protected void m_8024_() {
        super.m_8024_();
        Brain<BearEntity> brain = this.m_6274_();
        brain.m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        if (!this.m_20069_()) {
            this.m_6858_(brain.m_21952_(MemoryModuleType.f_26372_).isPresent());
        }
        if (this.m_20142_() && this.m_20069_()) {
            this.m_6858_(false);
        }
        BearAi.updateActivity(this);
        if (this.m_21223_() < this.m_21233_() && this.f_19796_.m_216339_(0, 100) <= 20 && this.getHealingCooldown() == 0) {
            int indexOfHealItem = -1;
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                if (!BearEntity.isHealFood(this.inventory.m_8020_(i))) continue;
                indexOfHealItem = i;
            }
            if (indexOfHealItem != -1) {
                this.m_5634_(2.0f);
                this.inventory.m_6836_(indexOfHealItem, new ItemStack((ItemLike)this.inventory.m_8020_(indexOfHealItem).m_41720_(), this.inventory.m_8020_(indexOfHealItem).m_41613_() - 1));
                this.playEatingSound();
                this.setHealingCooldown(50);
            }
        }
        this.applySpeedModifiers();
        if (this.isBearJockey() && this.m_6162_()) {
            this.m_146762_(-24000);
        }
        if (this.isBearJockey() && !this.m_20160_()) {
            this.setBearJockey(false);
        }
    }

    public float m_6113_() {
        return this.m_20142_() ? super.m_6113_() * 1.3f : (this.m_20089_().equals((Object)Pose.ROARING) ? 0.0f : super.m_6113_());
    }

    public AttributeModifier createSpeedModifier(float amount) {
        return new AttributeModifier(UUID.fromString("46362845-4d60-4b8b-a275-bd6d32f665a7"), "health_speed_modifier", Mth.m_14008_((double)amount, (double)0.0, (double)0.13), AttributeModifier.Operation.ADDITION);
    }

    public void applySpeedModifiers() {
        AttributeModifier modifier = this.createSpeedModifier(this.m_21223_() / this.m_21233_() * 0.13f);
        AttributeInstance entityAttributeInstance_speed = this.m_21051_(Attributes.f_22279_);
        if (entityAttributeInstance_speed != null) {
            entityAttributeInstance_speed.m_22120_(modifier.m_22209_());
            entityAttributeInstance_speed.m_22118_(modifier);
        }
    }

    public boolean bearCollapses() {
        return this.m_21233_() * 0.2f > this.m_21223_();
    }

    public float m_5610_(@NotNull BlockPos pos, @NotNull LevelReader level) {
        if (BearAi.isPosNearNearestRepellent(this, pos)) {
            return -1.0f;
        }
        return level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_50440_) ? 10.0f : level.m_220419_(pos);
    }

    protected float m_6108_() {
        return this.getVariant() == Variant.GROLAR ? 0.96f : 0.9f;
    }

    protected void m_8099_() {
    }

    @NotNull
    protected Brain.Provider<BearEntity> m_5490_() {
        return BearAi.brainProvider();
    }

    @NotNull
    protected Brain<?> m_8075_(@NotNull Dynamic<?> dynamic) {
        return BearAi.makeBrain((Brain<BearEntity>)this.m_5490_().m_22073_(dynamic));
    }

    @NotNull
    public Brain<BearEntity> m_6274_() {
        return super.m_6274_();
    }

    @Nullable
    public LivingEntity m_5448_() {
        return this.getTargetFromBrain();
    }

    protected final LivingEntity getTargetFromBrain() {
        return this.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        BearEntity bear2;
        LivingEntity target;
        Entity entity;
        boolean hurt = super.m_6469_(source, amount);
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (hurt && (entity = source.m_7639_()) instanceof LivingEntity && (target = (LivingEntity)entity) != this.m_269323_() && (!(target instanceof BearEntity) || (bear2 = (BearEntity)target).m_269323_() == null || bear2.m_269323_() != this.m_269323_())) {
            BearAi.wasHurtBy(this, target);
        }
        return hurt;
    }

    public boolean canTargetEntity(LivingEntity target) {
        return !this.m_6162_() && !this.bearCollapses() && this.m_6274_().m_21952_(MemoryModuleType.f_148194_).isPresent() && this.m_6274_().m_21952_(MemoryModuleType.f_148194_).get() == target && (this.m_6274_().m_21874_((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_VISIBLE_BABY.get()) || this.m_21824_() || target.m_20270_((Entity)this) < 8.0f && !target.m_6144_()) && target.m_21223_() > 0.0f && target.m_142066_() && MiscUtil.isNotNeverAttack(target);
    }

    public void setAttackTarget(LivingEntity attackTarget) {
        this.m_6274_().m_21936_(MemoryModuleType.f_217782_);
        this.m_6274_().m_21879_(MemoryModuleType.f_26372_, (Object)attackTarget);
        this.m_6274_().m_21936_(MemoryModuleType.f_26326_);
    }

    public boolean m_6898_(@NotNull ItemStack stack) {
        return BearEntity.isTameFood(stack) || BearEntity.isHealFood(stack) || BearEntity.isMatingFood(stack);
    }

    public static boolean isTameFood(@NotNull ItemStack stack) {
        return stack.m_150930_(Items.f_42784_);
    }

    public static boolean isHealFood(@NotNull ItemStack stack) {
        return stack.m_150930_(Items.f_42780_);
    }

    public static boolean isMatingFood(@NotNull ItemStack stack) {
        return stack.m_150930_(Items.f_42457_);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        boolean wasFeed;
        ItemStack stackInHand = player.m_21120_(hand);
        Item item = stackInHand.m_41720_();
        if (item instanceof DyeItem) {
            DyeColor dyecolor;
            DyeItem dyeitem = (DyeItem)item;
            if (this.m_21830_((LivingEntity)player) && (dyecolor = dyeitem.m_41089_()) != this.getCollarColor()) {
                this.setCollarColor(dyecolor);
                MiscUtil.consumeStack(1, (LivingEntity)player, stackInHand);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        if (this.m_6898_(stackInHand) && (wasFeed = this.handleEating(player, stackInHand))) {
            MiscUtil.consumeStack(1, (LivingEntity)player, stackInHand);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_21824_() && player.m_36341_() && this.hasChest()) {
            this.m_213583_(player);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_21824_() && !this.hasChest() && stackInHand.m_150930_(Items.f_42768_) && !this.m_6162_()) {
            this.setChest(true);
            this.playChestEquipsSound();
            MiscUtil.consumeStack(1, (LivingEntity)player, stackInHand);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_21824_()) {
            if (this.isBearSleeping() && !this.isSitting()) {
                this.setAwakeCounter(600 + this.m_217043_().m_216332_(20, 200));
                return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
            }
            return this.changeFollowState(player, hand);
        }
        return InteractionResult.PASS;
    }

    public InteractionResult changeFollowState(Player player, InteractionHand hand) {
        if (player != this.m_269323_()) {
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
            return InteractionResult.PASS;
        }
        if (!this.m_9236_().f_46443_ && hand.equals((Object)InteractionHand.MAIN_HAND)) {
            this.setFollowerState(this.isWandering() ? 1 : (this.isFollowing() ? 2 : 0));
            player.m_5661_((Component)Component.m_237110_((String)(this.isFollowing() ? "primal.gui.animal_following" : (this.isSitting() ? "primal.gui.animal_sitting" : "primal.gui.animal_wandering")), (Object[])new Object[]{this.m_7755_()}), true);
        }
        return InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_());
    }

    public void m_213583_(@NotNull Player player) {
        if (this.hasChest()) {
            player.m_5893_((MenuProvider)new SimpleMenuProvider((i, inventory, player1) -> ChestMenu.m_39237_((int)i, (Inventory)inventory, (Container)this.inventory), this.m_7755_()));
        }
    }

    protected boolean handleEating(@NotNull Player player, @NotNull ItemStack stack) {
        if (this.m_6898_(stack)) {
            if (BearEntity.isMatingFood(stack) && !this.isBearSleeping() && !this.m_9236_().f_46443_ && this.m_146764_() == 0 && this.m_5957_()) {
                this.m_27595_(player);
                return this.playEatingSound();
            }
            if (!this.m_21824_() && BearEntity.isTameFood(stack) && !this.isBearSleeping() && !this.m_9236_().f_46443_) {
                boolean canTameNow;
                ++this.tameAttempts;
                boolean bl = canTameNow = this.tameAttempts >= 10 && this.f_19796_.m_188503_(21 - this.tameAttempts) == 0;
                if (canTameNow) {
                    this.m_21828_(player);
                    this.f_21344_.m_26573_();
                    this.m_6710_(null);
                    this.m_9236_().m_7605_((Entity)this, (byte)7);
                } else {
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                }
                return this.playEatingSound();
            }
            if (this.m_21824_() && !this.m_9236_().f_46443_ && BearEntity.isHealFood(stack) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(2.0f);
                return this.playEatingSound();
            }
            if (this.m_6162_() && !BearEntity.isTameFood(stack)) {
                int i = this.m_146764_();
                this.m_146740_(BearEntity.m_216967_((int)(-i)), true);
                return this.playEatingSound();
            }
        }
        return false;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.m_6274_().m_21954_(Activity.f_219851_) ? null : (this.isBearSleeping() ? (SoundEvent)Primal_Sounds.BEAR_SNORING.get() : (this.m_5912_() ? (SoundEvent)Primal_Sounds.BEAR_IDLE_ANGRY.get() : (SoundEvent)Primal_Sounds.BEAR_IDLE.get()));
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)Primal_Sounds.BEAR_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)Primal_Sounds.BEAR_DEATH.get();
    }

    @Nullable
    public SoundEvent getRoarSound() {
        return (SoundEvent)Primal_Sounds.BEAR_ROAR.get();
    }

    @Nullable
    public SoundEvent getWakeUpSound() {
        return (SoundEvent)Primal_Sounds.BEAR_WAKE_UP.get();
    }

    protected boolean playEatingSound() {
        SoundEvent soundEvent;
        if (!this.m_20067_() && (soundEvent = this.getEatingSound()) != null) {
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), soundEvent, this.m_5720_(), 1.0f, 1.0f + (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f);
        }
        return true;
    }

    protected void playChestEquipsSound() {
        this.m_5496_((SoundEvent)Primal_Sounds.ANIMAL_CHEST.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    public SoundEvent getEatingSound() {
        return (SoundEvent)Primal_Sounds.BEAR_EAT.get();
    }

    public boolean m_6094_() {
        return super.m_6094_() && !this.isBearSleeping();
    }

    public void m_147240_(double strength, double x, double z) {
        if (this.isBearSleeping()) {
            return;
        }
        super.m_147240_(strength, x, z);
    }

    @Override
    public boolean shouldTryTeleportToOwner() {
        LivingEntity livingentity = this.m_269323_();
        return livingentity != null && this.m_20280_((Entity)this.m_269323_()) >= 625.0;
    }

    protected void m_5907_() {
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.m_6643_(); ++i) {
                ItemStack itemstack = this.inventory.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                this.m_19983_(itemstack);
            }
        }
        if (this.hasChest()) {
            if (!this.m_9236_().f_46443_) {
                this.m_19998_((ItemLike)Blocks.f_50618_);
            }
            this.setChest(false);
        }
    }

    public boolean m_142066_() {
        return super.m_142066_() && !this.isBearSleeping();
    }

    public boolean m_6573_(@NotNull Player player) {
        return super.m_6573_(player) && !this.isBearSleeping();
    }

    @NotNull
    protected Vec3 m_7939_() {
        return new Vec3(0.0, (double)(this.m_20192_() * 0.6f), (double)(this.m_20205_() * 0.2f));
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return this.isBearJockey();
    }

    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions entityDimensions) {
        return 1.25f;
    }

    public int m_6784_() {
        return 0;
    }

    public void m_7870_(int remainingPersistentAngerTime) {
    }

    @Nullable
    public UUID m_6120_() {
        return null;
    }

    public void m_6925_(@Nullable UUID persistentAngerTarget) {
    }

    public void m_6825_() {
    }

    public static enum Variant implements StringRepresentable
    {
        GRIZZLY(0, "grizzly"),
        WARM(1, "warm"),
        GROLAR(2, "grolar");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

