/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.animal;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.util.Unit;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CompassItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.primal.client.animation.entity.CrocodileAnimations;
import org.primal.entity.ai.CrocodileAi;
import org.primal.entity.ai.controls.CrocodilePathNavigation;
import org.primal.entity.ai.controls.WaterOrLandLookControl;
import org.primal.entity.ai.controls.WaterOrLandMoveControl;
import org.primal.mixin.SimpleContainerAccessor;
import org.primal.registry.Primal_Advancements;
import org.primal.registry.Primal_Blocks;
import org.primal.registry.Primal_Entities;
import org.primal.registry.Primal_Items;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Sounds;
import org.primal.registry.Primal_Tags;
import org.primal.util.HostileMount;
import org.primal.util.MiscUtil;
import org.primal.util.VariantHolderPrimal;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CrocodileEntity
extends Animal
implements VariantHolder<Variant>,
GeoEntity,
ContainerListener,
NeutralMob,
HostileMount,
VariantHolderPrimal<Variant, CrocodileEntity> {
    protected SimpleContainer inventory = new SimpleContainer(54);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(CrocodileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Float> HEALTH_WHEN_START_RIDING = SynchedEntityData.m_135353_(CrocodileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public static final EntityDataAccessor<Boolean> THRASHING = SynchedEntityData.m_135353_(CrocodileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final float healthLossToBeReleased = 2.0f;
    public static final byte CROCODILE_THRASHING = 99;

    public void m_5757_(@NotNull Container container) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22282_, (double)1.2f).m_22268_(Attributes.f_22278_, (double)0.4f);
    }

    public CrocodileEntity(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.m_21153_(this.m_21233_());
        this.m_21441_(BlockPathTypes.WATER, 1.0f);
        this.f_21342_ = new WaterOrLandMoveControl((Mob)this, 85, 10, 0.18f, 0.01f, false);
        this.f_21365_ = new WaterOrLandLookControl((Mob)this, 10);
        this.m_274367_(1.5f);
    }

    @NotNull
    public SpawnGroupData m_6518_(ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, CompoundTag tag) {
        if (level.m_213780_().m_216332_(0, 100) == 1) {
            this.setVariant(Variant.ALBINO);
        } else {
            this.setVariantFromBiome(this, (Holder<Biome>)level.m_204166_(this.m_20183_()));
        }
        return super.m_6518_(level, difficulty, spawnType, spawnGroupData, tag);
    }

    @Override
    public void setVariantFromBiome(CrocodileEntity crocodile, Holder<Biome> holder) {
        if (holder.m_203656_(Primal_Tags.SPAWNS_BLACK_CROCODILE)) {
            crocodile.setVariant(Variant.BLACK);
        } else if (holder.m_203656_(Primal_Tags.SPAWNS_BROWN_CROCODILE)) {
            crocodile.setVariant(Variant.BROWN);
        } else {
            crocodile.setVariant(Variant.GREEN);
        }
    }

    @Override
    public Variant getRareVariant(CrocodileEntity crocodile) {
        return Variant.ALBINO;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{CrocodileAnimations.mainController(this).receiveTriggeredAnimations().triggerableAnim("vomits", CrocodileAnimations.VOMITS).triggerableAnim("basking_start", CrocodileAnimations.BASKING_START).triggerableAnim("basking_end", CrocodileAnimations.BASKING_END), new AnimationController((GeoAnimatable)this, "attack", state -> PlayState.STOP).triggerableAnim("attack", CrocodileAnimations.ATTACK).triggerableAnim("attack_water", CrocodileAnimations.ATTACK_UNDERWATER)});
    }

    public int m_8132_() {
        return 25;
    }

    public int m_8085_() {
        return 10;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_6674_(@NotNull InteractionHand hand) {
        this.triggerAnim("attack", this.m_20069_() ? "attack_water" : "attack");
        super.m_6674_(hand);
    }

    public boolean m_7327_(@NotNull Entity entity) {
        return super.m_7327_(entity);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.hasClock() && this.f_19797_ % 20 == 0) {
            float pitch = this.f_19797_ / 20 % 2 == 0 ? 0.6f : 0.5f;
            this.m_5496_((SoundEvent)Primal_Sounds.CROCODILE_CLOCK.get(), 1.0f, pitch);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HEALTH_WHEN_START_RIDING, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)Variant.GREEN.id);
        this.f_19804_.m_135372_(THRASHING, (Object)false);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant().id);
        ListTag listtag = new ListTag();
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            ItemStack itemstack = this.inventory.m_8020_(i);
            if (itemstack.m_41619_()) continue;
            CompoundTag compoundtag = new CompoundTag();
            compoundtag.m_128344_("Slot", (byte)i);
            itemstack.m_41739_(compoundtag);
            listtag.add((Object)compoundtag);
        }
        compound.m_128365_("Items", (Tag)listtag);
        compound.m_128350_("HealthWhenStarted", this.getHealthWhenStartRiding());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(Variant.byId(compound.m_128451_("Variant")));
        ListTag listtag = compound.m_128437_("Items", 10);
        for (int i = 0; i < listtag.size(); ++i) {
            CompoundTag compoundtag = listtag.m_128728_(i);
            int j = compoundtag.m_128445_("Slot") & 0xFF;
            if (j < 2 || j >= this.inventory.m_6643_()) continue;
            this.inventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)compoundtag));
        }
        this.setHealthWhenStartRiding(compound.m_128457_("HealthWhenStarted"));
    }

    public float getHealthWhenStartRiding() {
        return ((Float)this.f_19804_.m_135370_(HEALTH_WHEN_START_RIDING)).floatValue();
    }

    public void setHealthWhenStartRiding(float healthWhenStartRiding) {
        this.f_19804_.m_135381_(HEALTH_WHEN_START_RIDING, (Object)Float.valueOf(healthWhenStartRiding));
    }

    public void setVariant(@NotNull Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    @NotNull
    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public boolean isThrashing() {
        return (Boolean)this.f_19804_.m_135370_(THRASHING);
    }

    public void setThrashing(boolean thrashing) {
        this.f_19804_.m_135381_(THRASHING, (Object)thrashing);
    }

    public void m_27563_(@NotNull ServerLevel level, @NotNull Animal mate) {
        this.m_277117_(level, mate, null);
        this.m_6274_().m_21879_(MemoryModuleType.f_217767_, (Object)Unit.INSTANCE);
    }

    @org.jetbrains.annotations.Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob otherParent) {
        CrocodileEntity crocodile = (CrocodileEntity)((EntityType)Primal_Entities.CROCODILE.get()).m_20615_((Level)level);
        if (crocodile != null) {
            CrocodileAi.initMemories(crocodile, level.m_213780_());
        }
        return crocodile;
    }

    protected void m_30232_() {
        super.m_30232_();
        if (!this.m_6162_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            this.m_5552_(new ItemStack((ItemLike)Primal_Items.CROCODILE_SCUTE.get(), this.m_217043_().m_216332_(3, 5)), 1.0f);
        }
    }

    public boolean brushOffScute() {
        if (this.m_6162_()) {
            return false;
        }
        this.m_5552_(new ItemStack((ItemLike)Primal_Items.CROCODILE_SCUTE.get()), 1.0f);
        this.m_146850_(GameEvent.f_223708_);
        this.m_216990_((SoundEvent)Primal_Sounds.ARMADILLO_BRUSH.get());
        return true;
    }

    public boolean m_6898_(@NotNull ItemStack stack) {
        return CrocodileEntity.isMatingFood(stack);
    }

    public static boolean isMatingFood(@NotNull ItemStack stack) {
        return stack.m_150930_(Items.f_42581_);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new CrocodilePathNavigation((Mob)this, level);
    }

    public boolean m_6147_() {
        return false;
    }

    protected void m_8024_() {
        Optional thrashing;
        super.m_8024_();
        Brain<CrocodileEntity> brain = this.m_6274_();
        brain.m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        CrocodileAi.updateActivity(this);
        if (!this.m_20069_()) {
            this.m_6858_(brain.m_21952_(MemoryModuleType.f_26372_).isPresent());
        }
        if (this.m_20142_() && this.m_20069_()) {
            this.m_6858_(false);
        }
        if ((thrashing = this.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.IS_THRASHING.get())).isPresent() && ((Boolean)thrashing.get()).booleanValue() && this.m_20197_().isEmpty()) {
            this.m_6274_().m_21936_((MemoryModuleType)Primal_MemoryModuleTypes.IS_THRASHING.get());
            this.m_20124_(Pose.STANDING);
            if (this.isThrashing()) {
                this.setThrashing(false);
            }
        }
        if (thrashing.isEmpty() && !this.m_20197_().isEmpty()) {
            this.m_20153_();
        }
        if (!this.m_20197_().isEmpty()) {
            this.stopMoving();
        }
    }

    @NotNull
    protected Vec3 m_20272_(@NotNull Vec3 vec) {
        AABB aabb = this.m_20191_();
        List list = this.m_9236_().m_183134_((Entity)this, aabb.m_82369_(vec));
        Vec3 vec3 = vec.m_82556_() == 0.0 ? vec : CrocodileEntity.m_198894_((Entity)this, (Vec3)vec, (AABB)aabb, (Level)this.m_9236_(), (List)list);
        boolean flag = vec.f_82479_ != vec3.f_82479_;
        boolean flag1 = vec.f_82480_ != vec3.f_82480_;
        boolean flag2 = vec.f_82481_ != vec3.f_82481_;
        boolean flag3 = this.m_20096_() || this.m_20069_() || flag1 && vec.f_82480_ < 0.0;
        float stepHeight = this.getStepHeight();
        if (stepHeight > 0.0f && flag3 && (flag || flag2)) {
            Vec3 vec33;
            Vec3 vec31 = CrocodileEntity.m_198894_((Entity)this, (Vec3)new Vec3(vec.f_82479_, (double)stepHeight, vec.f_82481_), (AABB)aabb, (Level)this.m_9236_(), (List)list);
            Vec3 vec32 = CrocodileEntity.m_198894_((Entity)this, (Vec3)new Vec3(0.0, (double)stepHeight, 0.0), (AABB)aabb.m_82363_(vec.f_82479_, 0.0, vec.f_82481_), (Level)this.m_9236_(), (List)list);
            if (vec32.f_82480_ < (double)stepHeight && (vec33 = CrocodileEntity.m_198894_((Entity)this, (Vec3)new Vec3(vec.f_82479_, 0.0, vec.f_82481_), (AABB)aabb.m_82383_(vec32), (Level)this.m_9236_(), (List)list).m_82549_(vec32)).m_165925_() > vec31.m_165925_()) {
                vec31 = vec33;
            }
            if (vec31.m_165925_() > vec3.m_165925_()) {
                return vec31.m_82549_(CrocodileEntity.m_198894_((Entity)this, (Vec3)new Vec3(0.0, -vec31.f_82480_ + vec.f_82480_, 0.0), (AABB)aabb.m_82383_(vec31), (Level)this.m_9236_(), (List)list));
            }
        }
        return vec3;
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5842_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 5.0E-4, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        boolean hurt = super.m_6469_(source, amount);
        if (hurt) {
            Player player;
            LivingEntity target;
            Entity entity;
            ServerPlayer player2;
            Entity entity2;
            if (this.m_20160_() && this.m_21223_() < this.getHealthWhenStartRiding() - 2.0f) {
                this.m_20153_();
                this.m_6274_().m_21882_((MemoryModuleType)Primal_MemoryModuleTypes.IS_STUNNED.get(), (Object)true, 60L);
            }
            if (source.m_7639_() != null && (entity2 = source.m_7639_()) instanceof ServerPlayer && (player2 = (ServerPlayer)entity2).m_21205_().m_41619_()) {
                Primal_Advancements.PUNCH_CROCODILE.trigger(player2);
            }
            if (!(!((entity = source.m_7639_()) instanceof LivingEntity) || (target = (LivingEntity)entity) instanceof Player && (player = (Player)target).m_7500_())) {
                CrocodileAi.wasHurtBy(this, target);
            }
        }
        return hurt;
    }

    @NotNull
    public Vec3 m_7688_(LivingEntity passenger) {
        return new Vec3(passenger.m_20185_(), passenger.m_20186_() + 0.1, passenger.m_20189_());
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public boolean canRiderInteract() {
        return true;
    }

    @org.jetbrains.annotations.Nullable
    public LivingEntity m_6688_() {
        return null;
    }

    protected void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (this.m_20363_(passenger)) {
            double y = this.m_20186_();
            float bodyYawRad = this.f_20883_ * ((float)Math.PI / 180);
            double forwardOffset = -1.2;
            double sideOffset = -0.0;
            double x = this.m_20185_() + (double)Mth.m_14031_((float)bodyYawRad) * forwardOffset + (double)Mth.m_14089_((float)bodyYawRad) * sideOffset;
            double z = this.m_20189_() - (double)Mth.m_14089_((float)bodyYawRad) * forwardOffset + (double)Mth.m_14031_((float)bodyYawRad) * sideOffset;
            callback.m_20372_(passenger, x, y, z);
        }
    }

    public double m_142593_(LivingEntity entity) {
        return this.m_20205_() * 1.1f * this.m_20205_() * 1.1f + entity.m_20205_();
    }

    public static boolean canPickUpEntity(@NotNull Entity target, @NotNull CrocodileEntity crocodile) {
        return target.m_20191_().m_82309_() < crocodile.m_20191_().m_82309_() && !crocodile.m_6274_().m_21874_((MemoryModuleType)Primal_MemoryModuleTypes.IS_STUNNED.get());
    }

    public void stopMoving() {
        this.m_6274_().m_21936_(MemoryModuleType.f_26370_);
        this.m_21573_().m_26573_();
        this.m_6274_().m_21936_(MemoryModuleType.f_26371_);
    }

    @NotNull
    public Vec3 m_20994_(double gravity, boolean isFalling, @NotNull Vec3 deltaMovement) {
        if (gravity != 0.0 && !this.m_20142_()) {
            double d0 = isFalling && Math.abs(deltaMovement.f_82480_ - 0.005) >= 0.003 && Math.abs(deltaMovement.f_82480_ - gravity / 16.0) < 0.003 ? -1.0E-4 : deltaMovement.f_82480_ - gravity / 16.0;
            return new Vec3(deltaMovement.f_82479_, d0, deltaMovement.f_82481_);
        }
        return deltaMovement;
    }

    public float m_6113_() {
        return this.m_20142_() ? super.m_6113_() * 1.375f : super.m_6113_();
    }

    protected void m_8099_() {
    }

    @NotNull
    protected Brain.Provider<CrocodileEntity> m_5490_() {
        return CrocodileAi.brainProvider();
    }

    @NotNull
    protected Brain<?> m_8075_(@NotNull Dynamic<?> dynamic) {
        return CrocodileAi.makeBrain((Brain<CrocodileEntity>)this.m_5490_().m_22073_(dynamic));
    }

    @NotNull
    public Brain<CrocodileEntity> m_6274_() {
        return super.m_6274_();
    }

    @org.jetbrains.annotations.Nullable
    public LivingEntity m_5448_() {
        return this.getTargetFromBrain();
    }

    protected final LivingEntity getTargetFromBrain() {
        return this.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
    }

    public boolean m_6779_(@NotNull LivingEntity target) {
        if (this.m_6274_().m_21938_(MemoryModuleType.f_26372_, (Object)target) && super.m_6779_(target)) {
            return true;
        }
        return super.m_6779_(target) && (target.m_6095_().m_204039_(Primal_Tags.CROCODILE_HUNTABLE) && !this.m_6274_().m_21874_(MemoryModuleType.f_148201_) || this.m_6274_().m_21874_((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_VISIBLE_BABY.get()) && !(target instanceof CrocodileEntity) && !target.m_6144_() || this.m_21188_() == target || this.m_6274_().m_21874_((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get()) && this.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get()).isPresent() && this.m_9236_().m_8055_((BlockPos)this.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_IMPORTANT_BLOCK.get()).get()).m_60713_((Block)Primal_Blocks.CROCODILE_EGG.get()) && !(target instanceof CrocodileEntity) && !target.m_6144_() || target.m_20270_((Entity)this) < 8.0f && !(target instanceof CrocodileEntity) && !target.m_6144_()) && !this.isPacified() && MiscUtil.isNotNeverAttack(target) && !target.m_6095_().m_204039_(Primal_Tags.CROCODILE_NEVER_ATTACK);
    }

    public boolean m_214076_(@NotNull ServerLevel level, @NotNull LivingEntity killed) {
        if (killed.m_6095_().m_204039_(Primal_Tags.CROCODILE_HUNTABLE)) {
            this.m_6274_().m_21882_(MemoryModuleType.f_148201_, (Object)true, 600L);
        }
        return super.m_214076_(level, killed);
    }

    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (hand == InteractionHand.MAIN_HAND && !this.m_5912_() && !this.m_6162_()) {
            if (itemstack.m_150930_(Items.f_271356_) && this.brushOffScute()) {
                itemstack.m_41622_(16, (LivingEntity)player, p -> p.m_21166_(MiscUtil.getSlotForHand(hand)));
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (itemstack.m_204117_(Tags.Items.FEATHERS) && !this.inventory.m_7983_()) {
                double y = this.m_20186_();
                float bodyYawRad = this.f_20883_ * ((float)Math.PI / 180);
                double forwardOffset = -1.3;
                double sideOffset = -0.0;
                double x = this.m_20185_() + (double)Mth.m_14031_((float)bodyYawRad) * forwardOffset + (double)Mth.m_14089_((float)bodyYawRad) * sideOffset;
                double z = this.m_20189_() - (double)Mth.m_14089_((float)bodyYawRad) * forwardOffset + (double)Mth.m_14031_((float)bodyYawRad) * sideOffset;
                NonNullList<ItemStack> items = ((SimpleContainerAccessor)this.inventory).getItems();
                int maxIndex = 0;
                for (ItemStack stack : items) {
                    if (stack.m_41619_()) continue;
                    ++maxIndex;
                }
                if (maxIndex != 0) {
                    --maxIndex;
                }
                ItemStack stackToDrop = (ItemStack)items.get(maxIndex);
                this.inventory.m_6836_(maxIndex, ItemStack.f_41583_);
                ItemEntity itementity = new ItemEntity(this.m_9236_(), x, y, z, stackToDrop);
                itementity.m_32060_();
                this.m_9236_().m_7967_((Entity)itementity);
                if (!this.m_9236_().f_46443_) {
                    this.triggerAnim("base_controller", "vomits");
                }
                if (this.getVomitSound() != null) {
                    this.m_5496_(this.getVomitSound(), 1.0f, 1.0f);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Primal_Advancements.TICKLE_CROC.trigger(serverPlayer);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (!this.m_6898_(itemstack) && this.canEatItem(itemstack)) {
                if (itemstack.m_150930_(Items.f_42524_) && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    Primal_Advancements.CLOCK_CROC.trigger(serverPlayer);
                }
                List<ItemStack> stack = List.of(itemstack);
                this.addItemsToInventory(stack);
                itemstack.m_41774_(itemstack.m_41613_());
                if (!this.m_9236_().f_46443_) {
                    this.triggerAnim("base_controller", "vomits");
                }
                if (this.getEatSound() != null) {
                    this.m_5496_(this.getEatSound(), 1.0f, 1.0f);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        if (this.m_6898_(itemstack) && !this.m_5912_()) {
            int i = this.m_146764_();
            if (!this.m_9236_().f_46443_ && i == 0) {
                this.m_142075_(player, hand, itemstack);
                if (this.m_5957_()) {
                    this.m_27595_(player);
                }
                this.m_6274_().m_21882_(MemoryModuleType.f_26357_, (Object)true, 1200L);
                this.m_9236_().m_7605_((Entity)this, (byte)38);
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                this.m_142075_(player, hand, itemstack);
                this.m_146740_(CrocodileEntity.m_216967_((int)(-i)), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_7822_(byte id) {
        if (id == 38) {
            this.addParticlesAroundSelf((ParticleOptions)ParticleTypes.f_123748_);
        } else if (id == 80) {
            this.addSplashes();
        } else {
            super.m_7822_(id);
        }
    }

    private void addSplashes() {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.01;
            double d1 = this.f_19796_.m_188583_() * 0.01;
            double d2 = this.f_19796_.m_188583_() * 0.01;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
        }
    }

    private void addParticlesAroundSelf(ParticleOptions particleOption) {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.01;
            double d1 = this.f_19796_.m_188583_() * 0.01;
            double d2 = this.f_19796_.m_188583_() * 0.01;
            this.m_9236_().m_7106_(particleOption, this.m_20208_(1.0), this.m_20187_() + 0.2, this.m_20262_(1.0), d0, d1, d2);
        }
    }

    public boolean isPacified() {
        return this.m_6274_().m_21874_(MemoryModuleType.f_26357_);
    }

    public boolean canEatItem(ItemStack drop) {
        return this.inventory.m_19183_(drop) && !drop.m_204117_(Primal_Tags.CROCODILE_CANT_EAT) && !drop.m_41619_();
    }

    public void addItemsToInventory(Collection<ItemStack> drops) {
        for (ItemStack stack : drops) {
            if (!this.inventory.m_19183_(stack)) continue;
            this.inventory.m_19173_(stack);
        }
    }

    public Optional<GlobalPos> getCompassPos() {
        Optional<GlobalPos> compassPos = Optional.empty();
        for (ItemStack stack : ((SimpleContainerAccessor)this.inventory).getItems()) {
            if (!CompassItem.m_40736_((ItemStack)stack) || CompassItem.m_220021_((CompoundTag)stack.m_41783_()) == null) continue;
            compassPos = Optional.ofNullable(CompassItem.m_220021_((CompoundTag)stack.m_41783_()));
        }
        return compassPos;
    }

    public boolean hasClock() {
        return this.inventory.m_216874_(stack -> stack.m_150930_(Items.f_42524_));
    }

    protected void m_7472_(@NotNull DamageSource damageSource, int i, boolean recentlyHit) {
        if (!this.inventory.m_7983_()) {
            for (ItemStack stack : ((SimpleContainerAccessor)this.inventory).getItems()) {
                this.m_19983_(stack);
            }
        }
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7515_() {
        if (!this.isThrashing()) {
            return (SoundEvent)Primal_Sounds.CROCODILE_IDLE.get();
        }
        return null;
    }

    public int m_8100_() {
        return 200;
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)Primal_Sounds.CROCODILE_HURT.get();
    }

    public void m_21011_(@NotNull InteractionHand hand, boolean p_21013_) {
        super.m_21011_(hand, p_21013_);
        this.m_5496_((SoundEvent)Primal_Sounds.CROCODILE_ATTACK.get(), 1.0f, 1.0f);
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)Primal_Sounds.CROCODILE_DEATH.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getVomitSound() {
        return (SoundEvent)Primal_Sounds.CROCODILE_VOMIT.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent getEatSound() {
        return (SoundEvent)Primal_Sounds.CROCODILE_EAT.get();
    }

    public int m_6062_() {
        return 4800;
    }

    public boolean isPushedByFluid(@NotNull FluidType type) {
        return false;
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.3f : 1.0f;
    }

    public boolean m_6914_(LevelReader level) {
        return level.m_45784_((Entity)this);
    }

    public static boolean checkCrocodileSpawnRules(EntityType<? extends Animal> animal, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return pos.m_123342_() >= level.m_5736_() - 10 && CrocodileEntity.isNearWater(level, pos, 5, 2);
    }

    protected static boolean isNearWater(LevelAccessor level, BlockPos pos, int lateralDistance, int verticalDistance) {
        BlockPos.MutableBlockPos check = new BlockPos.MutableBlockPos();
        for (int dx = -lateralDistance; dx <= lateralDistance; ++dx) {
            for (int dz = -lateralDistance; dz <= lateralDistance; ++dz) {
                for (int dy = -verticalDistance; dy <= verticalDistance; ++dy) {
                    check.m_122178_(pos.m_123341_() + dx, pos.m_123342_() + dy, pos.m_123343_() + dz);
                    if (!level.isAreaLoaded((BlockPos)check, 1) || !level.m_6425_((BlockPos)check).m_205070_(FluidTags.f_13131_)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions entityDimensions) {
        return this.m_6162_() ? 0.3f : 1.0f;
    }

    public int m_6784_() {
        return 0;
    }

    public void m_7870_(int remainingPersistentAngerTime) {
    }

    @org.jetbrains.annotations.Nullable
    public UUID m_6120_() {
        return null;
    }

    public void m_6925_(@org.jetbrains.annotations.Nullable UUID persistentAngerTarget) {
    }

    public void m_6825_() {
    }

    public static enum Variant implements StringRepresentable
    {
        GREEN(0, "green"),
        BROWN(1, "brown"),
        BLACK(2, "black"),
        ALBINO(3, "albino");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

