/*
 * Decompiled with CFR 0.152.
 */
package net.biohazardcraft.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelzombia<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"biohazardcraft", (String)"modelzombia"), "main");
    public final ModelPart telo;
    public final ModelPart ruka;
    public final ModelPart ruka2;
    public final ModelPart hoga;
    public final ModelPart hoga2;
    public final ModelPart glo;

    public Modelzombia(ModelPart root) {
        this.telo = root.getChild("telo");
        this.ruka = root.getChild("ruka");
        this.ruka2 = root.getChild("ruka2");
        this.hoga = root.getChild("hoga");
        this.hoga2 = root.getChild("hoga2");
        this.glo = root.getChild("glo");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition telo = partdefinition.addOrReplaceChild("telo", CubeListBuilder.create().texOffs(0, 16).addBox(-4.0f, -24.0f, -2.0f, 4.0f, 13.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(16, 32).addBox(0.0f, -17.0f, -2.0f, 3.0f, 5.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(32, 23).addBox(0.0f, -24.0f, -2.0f, 4.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(30, 34).addBox(3.0f, -14.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(36, 46).addBox(0.0f, -20.0f, 0.0f, 1.0f, 3.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(6, 47).addBox(1.0f, -21.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(10, 47).addBox(1.0f, -19.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(24, 47).addBox(2.0f, -19.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(40, 47).addBox(2.0f, -21.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(30, 40).addBox(0.0f, -22.0f, -2.0f, 1.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition ruka = partdefinition.addOrReplaceChild("ruka", CubeListBuilder.create().texOffs(16, 16).addBox(-8.0f, -24.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition ruka2 = partdefinition.addOrReplaceChild("ruka2", CubeListBuilder.create().texOffs(32, 13).addBox(0.0f, -12.0f, -2.0f, 4.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(32, 29).addBox(0.0f, -1.0f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(8, 40).addBox(1.0f, -6.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 40).addBox(3.0f, -6.0f, -1.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(16, 41).addBox(0.0f, -2.0f, -1.0f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(24, 41).addBox(3.0f, -2.0f, 0.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 46).addBox(1.0f, -6.0f, 1.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(30, 46).addBox(1.0f, -2.0f, 1.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)12.0f, (float)0.0f));
        PartDefinition hoga = partdefinition.addOrReplaceChild("hoga", CubeListBuilder.create().texOffs(24, 44).addBox(-7.0f, -7.0f, -3.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(40, 44).addBox(-7.0f, -1.0f, 0.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 34).addBox(-8.0f, -1.0f, -2.0f, 4.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r1 = hoga.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(8, 33).addBox(-1.0f, -6.0f, -1.0f, 2.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)0.0f, (float)0.0f, (float)0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = hoga.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 33).addBox(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)-6.0f, (float)-1.0f, (float)-0.2182f, (float)0.0f, (float)0.0f));
        PartDefinition hoga2 = partdefinition.addOrReplaceChild("hoga2", CubeListBuilder.create().texOffs(32, 0).addBox(4.0f, -12.0f, -2.0f, 4.0f, 9.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(40, 37).addBox(5.0f, -1.0f, -2.0f, 3.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(16, 45).addBox(5.0f, -1.0f, 0.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(0, 42).addBox(5.0f, -3.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)24.0f, (float)0.0f));
        PartDefinition glo = partdefinition.addOrReplaceChild("glo", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -32.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.telo.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.ruka.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.ruka2.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.hoga.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.hoga2.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.glo.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.hoga.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.ruka2.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.glo.xRot = headPitch / 57.295776f;
        this.ruka.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.hoga2.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
    }
}

