/*
 * Decompiled with CFR 0.152.
 */
package com.wdiscute.starcatcher.networkandstuff;

import com.mojang.serialization.Codec;
import com.wdiscute.starcatcher.networkandstuff.FishCaughtCounter;
import com.wdiscute.starcatcher.networkandstuff.FishProperties;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.attachment.AttachmentSyncHandler;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ModDataAttachments {
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES = DeferredRegister.create((Registry)NeoForgeRegistries.ATTACHMENT_TYPES, (String)"starcatcher");
    public static final Supplier<AttachmentType<String>> FISHING = ATTACHMENT_TYPES.register("fishing", () -> AttachmentType.builder(() -> "").serialize(Codec.unit((Object)"")).sync((AttachmentSyncHandler)new FishingSyncHandler()).build());
    public static final Supplier<AttachmentType<FishProperties>> FISH_SPOTTER = ATTACHMENT_TYPES.register("fish_spotter", () -> AttachmentType.builder(() -> FishProperties.DEFAULT).serialize(FishProperties.CODEC).sync((AttachmentSyncHandler)new FishSpotterSyncHandler()).copyOnDeath().build());
    public static final Supplier<AttachmentType<List<FishCaughtCounter>>> FISHES_CAUGHT = ATTACHMENT_TYPES.register("fishes_caught", () -> AttachmentType.builder(() -> List.of(new FishCaughtCounter(FishProperties.DEFAULT, 0))).serialize(FishCaughtCounter.LIST_CODEC).sync((AttachmentSyncHandler)new FishCounterSyncHandler()).copyOnDeath().build());
    public static final Supplier<AttachmentType<List<FishProperties>>> FISHES_NOTIFICATION = ATTACHMENT_TYPES.register("fishes_notification", () -> AttachmentType.builder(() -> List.of(FishProperties.DEFAULT)).serialize(FishProperties.LIST_CODEC).sync((AttachmentSyncHandler)new FishPropertiesListSyncHandler()).copyOnDeath().build());

    public static void register(IEventBus eventBus) {
        ATTACHMENT_TYPES.register(eventBus);
    }

    public static class FishPropertiesListSyncHandler
    implements AttachmentSyncHandler<List<FishProperties>> {
        public void write(@NotNull RegistryFriendlyByteBuf buf, @NotNull List<FishProperties> attachment, boolean initialSync) {
            FishProperties.STREAM_CODEC_LIST.encode((Object)buf, attachment);
        }

        @Nullable
        public List<FishProperties> read(@NotNull IAttachmentHolder holder, @NotNull RegistryFriendlyByteBuf buf, @Nullable List<FishProperties> previousValue) {
            return (List)FishProperties.STREAM_CODEC_LIST.decode((Object)buf);
        }

        public boolean sendToPlayer(@NotNull IAttachmentHolder holder, @NotNull ServerPlayer to) {
            return holder == to;
        }
    }

    public static class FishCounterSyncHandler
    implements AttachmentSyncHandler<List<FishCaughtCounter>> {
        public void write(@NotNull RegistryFriendlyByteBuf buf, @NotNull List<FishCaughtCounter> attachment, boolean initialSync) {
            FishCaughtCounter.STREAM_CODEC.encode((Object)buf, attachment);
        }

        @Nullable
        public List<FishCaughtCounter> read(@NotNull IAttachmentHolder holder, @NotNull RegistryFriendlyByteBuf buf, @Nullable List<FishCaughtCounter> previousValue) {
            return (List)FishCaughtCounter.STREAM_CODEC.decode((Object)buf);
        }

        public boolean sendToPlayer(@NotNull IAttachmentHolder holder, @NotNull ServerPlayer to) {
            return holder == to;
        }
    }

    public static class FishSpotterSyncHandler
    implements AttachmentSyncHandler<FishProperties> {
        public void write(@NotNull RegistryFriendlyByteBuf buf, @NotNull FishProperties attachment, boolean initialSync) {
            FishProperties.STREAM_CODEC.encode((Object)buf, (Object)attachment);
        }

        @Nullable
        public FishProperties read(@NotNull IAttachmentHolder holder, @NotNull RegistryFriendlyByteBuf buf, @Nullable FishProperties previousValue) {
            return (FishProperties)FishProperties.STREAM_CODEC.decode((Object)buf);
        }

        public boolean sendToPlayer(@NotNull IAttachmentHolder holder, @NotNull ServerPlayer to) {
            return holder == to;
        }
    }

    public static class FishingSyncHandler
    implements AttachmentSyncHandler<String> {
        public void write(@NotNull RegistryFriendlyByteBuf buf, @NotNull String attachment, boolean initialSync) {
            ByteBufCodecs.STRING_UTF8.encode((Object)buf, (Object)attachment);
        }

        @Nullable
        public String read(@NotNull IAttachmentHolder holder, @NotNull RegistryFriendlyByteBuf buf, @Nullable String previousValue) {
            return (String)ByteBufCodecs.STRING_UTF8.decode((Object)buf);
        }

        public boolean sendToPlayer(@NotNull IAttachmentHolder holder, @NotNull ServerPlayer to) {
            return holder == to;
        }
    }
}

