/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.api.ritual;

import com.Polarice3.Goety.api.ritual.IRitualType;
import com.Polarice3.Goety.common.ritual.type.AdeptNetherRitualType;
import com.Polarice3.Goety.common.ritual.type.AnimationRitualType;
import com.Polarice3.Goety.common.ritual.type.DeepRitualType;
import com.Polarice3.Goety.common.ritual.type.EndRitualType;
import com.Polarice3.Goety.common.ritual.type.ExpertNetherRitualType;
import com.Polarice3.Goety.common.ritual.type.ForgeRitualType;
import com.Polarice3.Goety.common.ritual.type.FrostRitualType;
import com.Polarice3.Goety.common.ritual.type.GeoturgyRitualType;
import com.Polarice3.Goety.common.ritual.type.MagicRitualType;
import com.Polarice3.Goety.common.ritual.type.NecroturgyRitualType;
import com.Polarice3.Goety.common.ritual.type.SabbathRitualType;
import com.Polarice3.Goety.common.ritual.type.SkyRitualType;
import com.Polarice3.Goety.common.ritual.type.StormRitualType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraftforge.common.IExtensibleEnum;

public enum RitualType implements IExtensibleEnum
{
    NONE(() -> "none"),
    ANIMATION(new AnimationRitualType()),
    NECROTURGY(new NecroturgyRitualType()),
    FORGE(new ForgeRitualType()),
    MAGIC(new MagicRitualType()),
    ADEPT_NETHER(new AdeptNetherRitualType()),
    EXPERT_NETHER(new ExpertNetherRitualType()),
    SABBATH(new SabbathRitualType()),
    END(new EndRitualType()),
    SKY(new SkyRitualType()),
    STORM(new StormRitualType()),
    GEOTURGY(new GeoturgyRitualType()),
    FROST(new FrostRitualType()),
    DEEP(new DeepRitualType());

    private final IRitualType type;

    private RitualType(IRitualType type) {
        this.type = type;
    }

    public static RitualType create(String name, IRitualType type) {
        throw new IllegalStateException("Enum not extended");
    }

    public IRitualType getType() {
        return this.type;
    }

    public static IRitualType getRitualType(String craftType) {
        for (RitualType ritualType : RitualType.values()) {
            if (ritualType.getType() == null || !Objects.equals(ritualType.getType().getName(), craftType)) continue;
            return ritualType.getType();
        }
        return null;
    }

    public static List<IRitualType> getAllRitualType() {
        ArrayList<IRitualType> list = new ArrayList<IRitualType>();
        for (RitualType ritualType : RitualType.values()) {
            if (ritualType.getType() == null) continue;
            list.add(ritualType.getType());
        }
        return list;
    }
}

