/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.client.render.model;

import com.Polarice3.Goety.client.render.animation.MinisterAnimations;
import com.Polarice3.Goety.common.entities.hostile.illagers.HuntingIllagerEntity;
import com.Polarice3.Goety.common.entities.hostile.illagers.Minister;
import com.Polarice3.Goety.utils.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.monster.AbstractIllager;

public class MinisterModel<T extends Minister>
extends HierarchicalModel<T>
implements ArmedModel,
HeadedModel {
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart head;
    private final ModelPart body;
    private final ModelPart arms;
    private final ModelPart rightArm;
    private final ModelPart staff;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    public final ModelPart clothes;
    private final ModelPart cape;

    public MinisterModel(ModelPart root) {
        this.root = root;
        this.all = root.m_171324_("all");
        this.head = this.all.m_171324_("head");
        this.body = this.all.m_171324_("body");
        this.arms = this.all.m_171324_("arms");
        this.rightArm = this.all.m_171324_("right_arm");
        this.staff = this.rightArm.m_171324_("staff");
        this.leftArm = this.all.m_171324_("left_arm");
        this.rightLeg = this.all.m_171324_("right_leg");
        this.leftLeg = this.all.m_171324_("left_leg");
        this.clothes = this.body.m_171324_("clothes");
        this.cape = this.body.m_171324_("cape");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = all.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition eyebrows = head.m_171599_("eyebrows", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)-5.5f, (float)-4.1f));
        PartDefinition right_eye = eyebrows.m_171599_("right_eye", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = right_eye.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-2.5f, -1.5f, 0.0f, 5.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2182f));
        PartDefinition left_eye = eyebrows.m_171599_("left_eye", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = left_eye.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171480_().m_171488_(-2.5f, -1.5f, 0.0f, 5.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)3.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2182f));
        PartDefinition moustache = head.m_171599_("moustache", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r3 = moustache.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(10, 18).m_171480_().m_171488_(-2.5f, -1.0f, 0.0f, 5.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)3.5f, (float)-3.5f, (float)-4.1f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition cube_r4 = moustache.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(10, 18).m_171488_(-2.5f, -1.0f, 0.0f, 5.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.5f, (float)-3.5f, (float)-4.1f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 116).m_171488_(-4.0f, -1.25f, -4.0f, 8.0f, 1.0f, 8.0f, new CubeDeformation(0.25f)).m_171514_(0, 104).m_171488_(-5.0f, -0.25f, -5.0f, 10.0f, 2.0f, 10.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)-9.25f, (float)0.0f));
        PartDefinition body = all.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, -12.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 65).m_171488_(-5.0f, -14.0f, -5.0f, 10.0f, 3.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition cape = body.m_171599_("cape", CubeListBuilder.m_171558_().m_171514_(44, 62).m_171488_(-4.5f, 0.0f, 0.0f, 9.0f, 20.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-11.0f, (float)3.0f));
        PartDefinition clothes = body.m_171599_("clothes", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.5f)).m_171514_(18, 78).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.75f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition arms = all.m_171599_("arms", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171488_(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(44, 22).m_171488_(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(40, 38).m_171488_(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 78).m_171488_(4.5f, -2.5f, -2.5f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.5f)).m_171514_(0, 78).m_171480_().m_171488_(-8.5f, -2.5f, -2.5f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.5f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_arm = all.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(0, 78).m_171480_().m_171488_(-3.5f, -2.5f, -2.5f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.5f)).m_171555_(false), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition staff = right_arm.m_171599_("staff", CubeListBuilder.m_171558_().m_171514_(60, 103).m_171488_(-0.5f, -8.125f, -0.5f, 1.0f, 24.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(48, 124).m_171488_(-1.5f, -9.125f, -1.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(48, 124).m_171488_(-1.5f, 15.375f, -1.5f, 3.0f, 1.0f, 3.0f, new CubeDeformation(-0.25f)).m_171514_(48, 118).m_171488_(-1.5f, -12.625f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.5f)), PartPose.m_171423_((float)-0.5f, (float)9.125f, (float)-1.5f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = all.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 78).m_171488_(-0.5f, -2.5f, -2.5f, 4.0f, 3.0f, 5.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_leg = all.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = all.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        this.animateCape(entity, limbSwing, limbSwingAmount);
        if (!((HuntingIllagerEntity)entity).isCasting() && !entity.m_21224_()) {
            this.animateHeadLookTarget(netHeadYaw, headPitch);
            this.animateWalk(limbSwing, limbSwingAmount);
        }
        this.m_233381_(((Minister)entity).attackAnimationState, MinisterAnimations.SHOOT, ageInTicks);
        this.m_233381_(((Minister)entity).castAnimationState, MinisterAnimations.CAST_TEETH, ageInTicks);
        this.m_233381_(((Minister)entity).laughAnimationState, MinisterAnimations.LAUGH, ageInTicks);
        this.m_233381_(((Minister)entity).laughTargetAnimationState, MinisterAnimations.LAUGH_AT_YOU, ageInTicks);
        this.m_233381_(((Minister)entity).commandAnimationState, MinisterAnimations.COMMAND, ageInTicks);
        this.m_233381_(((Minister)entity).blockAnimationState, MinisterAnimations.BLOCK, ageInTicks);
        this.m_233381_(((Minister)entity).smashedAnimationState, MinisterAnimations.SMASHED, ageInTicks);
        this.m_233381_(((Minister)entity).speechAnimationState, MinisterAnimations.SPEECH, ageInTicks);
        this.m_233381_(((Minister)entity).deathAnimationState, MinisterAnimations.DEATH, ageInTicks);
        AbstractIllager.IllagerArmPose armPose = ((Minister)entity).m_6768_();
        boolean flag = armPose == AbstractIllager.IllagerArmPose.CROSSED;
        this.staff.f_104207_ = ((Minister)entity).hasStaff();
        this.arms.f_104207_ = flag;
        this.leftArm.f_104207_ = !flag;
        this.rightArm.f_104207_ = !flag;
    }

    private void animateHeadLookTarget(float netHeadYaw, float headPitch) {
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
    }

    private void animateWalk(float limbSwing, float limbSwingAmount) {
        this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
        this.rightArm.f_104204_ = 0.0f;
        this.rightArm.f_104205_ = 0.0f;
        this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
        this.leftArm.f_104204_ = 0.0f;
        this.leftArm.f_104205_ = 0.0f;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.rightLeg.f_104204_ = 0.0f;
        this.rightLeg.f_104205_ = 0.0f;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.leftLeg.f_104204_ = 0.0f;
        this.leftLeg.f_104205_ = 0.0f;
        this.resetArmPoses();
    }

    private void animateCape(T entity, float limbSwing, float limbSwingAmount) {
        float f = 1.0f;
        if (entity.m_21256_() > 4) {
            f = (float)entity.m_20184_().m_82556_();
            f /= 0.2f;
            f = f * f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        this.cape.f_104203_ = MathHelper.modelDegrees(10.0f) + Mth.m_14154_((float)(Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.7f * limbSwingAmount / f));
    }

    private void resetArmPoses() {
        this.leftArm.f_104200_ = 5.0f;
        this.leftArm.f_104201_ = 2.0f;
        this.leftArm.f_104202_ = 0.0f;
        this.leftArm.f_104204_ = 0.0f;
        this.rightArm.f_104200_ = -5.0f;
        this.rightArm.f_104201_ = 2.0f;
        this.rightArm.f_104202_ = 0.0f;
        this.rightArm.f_104204_ = 0.0f;
        this.arms.f_104201_ = 2.0f;
        this.arms.f_104203_ = -0.75f;
    }

    public boolean isAggressive(T entityIn) {
        return entityIn.m_5912_();
    }

    private ModelPart getArm(HumanoidArm p_102923_) {
        return p_102923_ == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    public ModelPart m_5585_() {
        return this.head;
    }

    public void m_6002_(HumanoidArm p_102925_, PoseStack p_102926_) {
        this.getArm(p_102925_).m_104299_(p_102926_);
    }

    public ModelPart m_142109_() {
        return this.root;
    }
}

