/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.blocks.entities;

import com.Polarice3.Goety.api.blocks.entities.IWindPowered;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.blocks.ResonanceCrystalBlock;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntities;
import com.Polarice3.Goety.common.blocks.entities.ModBlockEntity;
import com.Polarice3.Goety.common.entities.ally.golem.SquallGolem;
import com.Polarice3.Goety.common.items.block.ResonanceBlockItem;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.EntityFinder;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.ModTicketTypes;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class ResonanceCrystalBlockEntity
extends ModBlockEntity
implements IWindPowered {
    public static String GOLEM_LIST = ResonanceBlockItem.GOLEM_LIST;
    public static String BLOCK_LIST = "BlockList";
    public List<BlockPos> blockPosList = new ArrayList<BlockPos>();
    public List<SquallGolem> squallGolems = new ArrayList<SquallGolem>();
    public List<UUID> uuids = new ArrayList<UUID>();
    public int active;
    private boolean isOn;
    public boolean showBlock;
    public long ticketTime = 0L;

    public ResonanceCrystalBlockEntity(BlockPos p_155229_, BlockState p_155230_) {
        super((BlockEntityType)ModBlockEntities.RESONANCE_CRYSTAL.get(), p_155229_, p_155230_);
    }

    public void tick() {
        if (this.f_58857_ != null) {
            if (this.active > 0) {
                --this.active;
            }
            if (((Boolean)this.m_58900_().m_61143_((Property)ResonanceCrystalBlock.POWERED)).booleanValue()) {
                if (!this.isOn) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.RESONANCE_CRYSTAL_ON.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    this.isOn = true;
                } else if (this.f_58857_.m_46467_() % (long)MathHelper.secondsToTicks(6) == 0L) {
                    this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.RESONANCE_CRYSTAL_LOOP.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                Level level = this.f_58857_;
                if (level instanceof ServerLevel) {
                    ServerLevel world = (ServerLevel)level;
                    ChunkPos chunkPos = this.f_58857_.m_46745_(this.f_58858_).m_7697_();
                    if (--this.ticketTime <= 0L) {
                        world.m_7726_().m_8387_(ModTicketTypes.BLOCK, chunkPos, 2, (Object)this.f_58858_);
                        this.ticketTime = ModTicketTypes.BLOCK.m_9469_() - 1L;
                    }
                    BlockPos blockPos = this.m_58899_();
                    ServerParticleUtil.gatheringBlockParticles((ParticleOptions)ModParticleTypes.RESONANCE_GATHER.get(), blockPos, world);
                    ColorUtil color = new ColorUtil(0xFFFFFF);
                    ServerParticleUtil.windParticle(world, color, 1.0f + world.f_46441_.m_188501_() * 0.5f, 0.0f, -1, Vec3.m_82539_((Vec3i)blockPos));
                    if (!this.uuids.isEmpty()) {
                        this.uuids.removeIf(uuid -> {
                            Entity entity = EntityFinder.getEntityByUuiD(uuid);
                            if (!(entity instanceof SquallGolem)) {
                                return true;
                            }
                            SquallGolem squallGolem = (SquallGolem)entity;
                            if (!squallGolem.m_6084_()) {
                                this.squallGolems.remove(squallGolem);
                                return true;
                            }
                            return false;
                        });
                        for (UUID uuid2 : this.uuids) {
                            SquallGolem squallGolem;
                            Entity entity;
                            if (uuid2 == null || !((entity = EntityFinder.getEntityByUuiD(uuid2)) instanceof SquallGolem) || this.squallGolems.contains(squallGolem = (SquallGolem)entity)) continue;
                            this.squallGolems.add(squallGolem);
                        }
                    }
                    this.activateGolems();
                }
                if (!this.getBlockPosList().isEmpty()) {
                    for (BlockPos blockPos1 : this.getBlockPosList()) {
                        BlockEntity blockEntity = this.f_58857_.m_7702_(blockPos1);
                        if (!(blockEntity instanceof ResonanceCrystalBlockEntity)) continue;
                        ResonanceCrystalBlockEntity crystalBlock = (ResonanceCrystalBlockEntity)blockEntity;
                        crystalBlock.activate(20);
                    }
                }
            } else if (this.isOn) {
                this.f_58857_.m_5594_(null, this.m_58899_(), (SoundEvent)ModSounds.RESONANCE_CRYSTAL_OFF.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                this.isOn = false;
            }
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ResonanceCrystalBlock.POWERED, (Comparable)Boolean.valueOf(this.active > 0)), 3);
        }
    }

    public void activateGolems() {
        if (!this.squallGolems.isEmpty()) {
            for (SquallGolem squallGolem : this.squallGolems) {
                if (squallGolem == null) continue;
                squallGolem.activate(20);
            }
        }
    }

    public List<BlockPos> getBlockPosList() {
        return this.blockPosList;
    }

    public void addBlockPos(BlockPos blockPos) {
        if (!this.blockPosList.contains(blockPos)) {
            this.blockPosList.add(blockPos);
        }
    }

    public void removeBlockPos(BlockPos blockPos) {
        this.blockPosList.remove(blockPos);
    }

    public void clearBlocks() {
        this.blockPosList.clear();
    }

    public List<SquallGolem> getSquallGolems() {
        return this.squallGolems;
    }

    public void addSquallGolem(SquallGolem squallGolem) {
        this.uuids.add(squallGolem.m_20148_());
    }

    public List<UUID> getUuids() {
        return this.uuids;
    }

    @Override
    public int activeTicks() {
        return this.active;
    }

    @Override
    public void activate(int tick) {
        this.active = tick;
        this.m_6596_();
    }

    public boolean isShowBlock() {
        return this.showBlock;
    }

    public void setShowBlock(boolean showBlock) {
        this.showBlock = showBlock;
        this.m_6596_();
    }

    @Override
    public void readNetwork(CompoundTag tag) {
        int i;
        ListTag list;
        if (tag.m_128441_("active")) {
            this.active = tag.m_128451_("active");
        }
        if (tag.m_128441_("showBlock")) {
            this.showBlock = tag.m_128471_("showBlock");
        }
        if (tag.m_128441_(BLOCK_LIST)) {
            list = tag.m_128437_(BLOCK_LIST, 10);
            for (i = 0; i < list.size(); ++i) {
                this.blockPosList.add(NbtUtils.m_129239_((CompoundTag)list.m_128728_(i)));
            }
        }
        if (tag.m_128441_(GOLEM_LIST)) {
            list = tag.m_128437_(GOLEM_LIST, 8);
            for (i = 0; i < list.size(); ++i) {
                this.uuids.add(UUID.fromString(list.m_128778_(i)));
            }
        }
        if (tag.m_128441_("isOn")) {
            this.isOn = tag.m_128471_("isOn");
        }
    }

    @Override
    public CompoundTag writeNetwork(CompoundTag tag) {
        ListTag nbttaglist;
        int i;
        tag.m_128405_("active", this.active);
        ArrayList<String> list = new ArrayList<String>();
        ArrayList<BlockPos> list2 = new ArrayList<BlockPos>();
        if (tag.m_128441_(GOLEM_LIST)) {
            for (i = 0; i < tag.m_128437_(GOLEM_LIST, 8).size(); ++i) {
                list.add(tag.m_128437_(GOLEM_LIST, 8).m_128778_(i));
            }
        }
        if (tag.m_128441_(BLOCK_LIST)) {
            for (i = 0; i < tag.m_128437_(BLOCK_LIST, 10).size(); ++i) {
                list2.add(NbtUtils.m_129239_((CompoundTag)tag.m_128437_(BLOCK_LIST, 10).m_128728_(i)));
            }
        }
        if (!this.blockPosList.isEmpty()) {
            for (BlockPos blockPos : this.blockPosList) {
                if (list2.contains(blockPos)) continue;
                nbttaglist = new ListTag();
                if (tag.m_128441_(BLOCK_LIST)) {
                    nbttaglist = tag.m_128437_(BLOCK_LIST, 10);
                }
                nbttaglist.add((Object)NbtUtils.m_129224_((BlockPos)blockPos));
                tag.m_128365_(BLOCK_LIST, (Tag)nbttaglist);
            }
        }
        if (!this.uuids.isEmpty()) {
            for (UUID uuid : this.uuids) {
                if (list.contains(uuid.toString())) continue;
                nbttaglist = new ListTag();
                if (tag.m_128441_(GOLEM_LIST)) {
                    nbttaglist = tag.m_128437_(GOLEM_LIST, 8);
                }
                nbttaglist.add((Object)StringTag.m_129297_((String)uuid.toString()));
                tag.m_128365_(GOLEM_LIST, (Tag)nbttaglist);
            }
        }
        tag.m_128379_("showBlock", this.showBlock);
        tag.m_128379_("isOn", this.isOn);
        return tag;
    }
}

