/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ai.ModLeaveWaterGoal;
import com.Polarice3.Goety.common.entities.ai.path.GroundPathNavigatorFat;
import com.Polarice3.Goety.common.entities.ai.path.ModWaterPathNavigation;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.Whisperer;
import com.Polarice3.Goety.common.entities.neutral.AbstractMonolith;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.init.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.Nullable;

public class Wavewhisperer
extends Whisperer {
    private boolean searchingForLand;
    protected final ModWaterPathNavigation waterNavigation;
    protected final GroundPathNavigation groundNavigation;

    public Wavewhisperer(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
        this.m_274367_(1.25f);
        this.f_21342_ = new MoveHelperController(this);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.WATER_BORDER, 0.0f);
        this.waterNavigation = new ModWaterPathNavigation((Mob)this, worldIn);
        this.groundNavigation = new GroundPathNavigatorFat((Mob)this, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new Summoned.GoToWaterGoal(this, 1.0));
        this.f_21345_.m_25352_(4, new ModLeaveWaterGoal<Wavewhisperer>(this));
        this.f_21345_.m_25352_(8, (Goal)new Summoned.WaterWanderGoal<Wavewhisperer>(this){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && Wavewhisperer.this.m_5448_() == null;
            }
        });
    }

    @Override
    public void followGoal() {
        this.f_21345_.m_25352_(5, (Goal)new Summoned.FollowOwnerWaterGoal(this, 1.0, 10.0f, 2.0f));
    }

    protected void handleAirSupply(int p_30344_) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(p_30344_ - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269483_(), 2.0f);
            }
        } else {
            this.m_20301_(300);
        }
    }

    public void m_6075_() {
        int i = this.m_20146_();
        super.m_6075_();
        this.handleAirSupply(i);
    }

    private boolean wantsToSwim() {
        if (this.searchingForLand) {
            return true;
        }
        if (this.m_5448_() != null && this.m_5448_().m_20069_()) {
            return true;
        }
        return this.getTrueOwner() != null && this.isFollowing() && (this.getTrueOwner().m_20069_() || this.m_20069_() && this.getTrueOwner().m_20186_() > this.m_20186_());
    }

    protected boolean closeToNextPos() {
        BlockPos blockpos;
        Path path = this.m_21573_().m_26570_();
        if (path != null && (blockpos = path.m_77406_()) != null) {
            double d0 = this.m_20275_(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_());
            return d0 < 4.0;
        }
        return false;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
            this.m_19920_(0.01f, pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    public void m_5844_() {
        if (!this.f_19853_.f_46443_) {
            if (this.m_21515_() && this.m_20069_() && this.wantsToSwim()) {
                this.f_21344_ = this.waterNavigation;
                this.m_20282_(true);
            } else {
                this.f_21344_ = this.groundNavigation;
                this.m_20282_(false);
            }
        }
    }

    @Override
    protected boolean convertsInWater() {
        return false;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return type != ForgeMod.WATER_TYPE.get();
    }

    public boolean isPushedByFluid(FluidType type) {
        return !this.m_6069_();
    }

    @Override
    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.WAVEWHISPERER_AMBIENT.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.WAVEWHISPERER_HURT.get();
    }

    @Override
    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.WAVEWHISPERER_DEATH.get();
    }

    @Override
    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_5496_((SoundEvent)ModSounds.WAVEWHISPERER_STEP.get(), 0.15f, 1.0f);
    }

    @Override
    protected SoundEvent getAttackSound() {
        return (SoundEvent)ModSounds.WAVEWHISPERER_ATTACK.get();
    }

    @Override
    protected SoundEvent getSummonSound() {
        return (SoundEvent)ModSounds.WAVEWHISPERER_SUMMON.get();
    }

    @Override
    protected SoundEvent getSummonPoisonSound() {
        return (SoundEvent)ModSounds.WAVEWHISPERER_SUMMON_POISON.get();
    }

    @Override
    protected SoundEvent getSummonThornsSound() {
        return (SoundEvent)ModSounds.WAVEWHISPERER_SUMMON_THORNS.get();
    }

    @Override
    protected EntityType<? extends AbstractMonolith> getVines() {
        return (EntityType)ModEntityType.QUICK_GROWING_KELP.get();
    }

    @Override
    protected EntityType<? extends AbstractMonolith> getPoison() {
        return (EntityType)ModEntityType.POISON_ANEMONE.get();
    }

    public void setSearchingForLand(boolean p_204713_1_) {
        this.searchingForLand = p_204713_1_;
    }

    static class MoveHelperController
    extends MoveControl {
        private final Wavewhisperer wavewhisperer;

        public MoveHelperController(Wavewhisperer p_i48909_1_) {
            super((Mob)p_i48909_1_);
            this.wavewhisperer = p_i48909_1_;
        }

        public void m_8126_() {
            LivingEntity livingentity = this.wavewhisperer.m_5448_();
            LivingEntity owner = this.wavewhisperer.getTrueOwner();
            if (this.wavewhisperer.wantsToSwim() && this.wavewhisperer.m_20069_()) {
                if (livingentity != null && livingentity.m_20186_() > this.wavewhisperer.m_20186_() || this.wavewhisperer.searchingForLand || owner != null && owner.m_20186_() > this.wavewhisperer.m_20186_() && this.wavewhisperer.isFollowing()) {
                    this.wavewhisperer.m_20256_(this.wavewhisperer.m_20184_().m_82520_(0.0, 0.002, 0.0));
                }
                if (this.f_24981_ != MoveControl.Operation.MOVE_TO || this.wavewhisperer.m_21573_().m_26571_()) {
                    this.wavewhisperer.m_7910_(0.0f);
                    return;
                }
                double d0 = this.f_24975_ - this.wavewhisperer.m_20185_();
                double d1 = this.f_24976_ - this.wavewhisperer.m_20186_();
                double d2 = this.f_24977_ - this.wavewhisperer.m_20189_();
                double d3 = Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2)));
                d1 /= d3;
                float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                this.wavewhisperer.m_146922_(this.m_24991_(this.wavewhisperer.m_146908_(), f, 90.0f));
                this.wavewhisperer.m_5618_(this.wavewhisperer.m_146908_());
                float f1 = (float)(this.f_24978_ * this.wavewhisperer.m_21133_(Attributes.f_22279_));
                float f2 = Mth.m_14179_((float)0.125f, (float)this.wavewhisperer.m_6113_(), (float)f1);
                this.wavewhisperer.m_7910_(f2);
                this.wavewhisperer.m_20256_(this.wavewhisperer.m_20184_().m_82520_((double)f2 * d0 * 0.005, (double)f2 * d1 * 0.1, (double)f2 * d2 * 0.005));
            } else {
                if (!this.wavewhisperer.m_20096_()) {
                    this.wavewhisperer.m_20256_(this.wavewhisperer.m_20184_().m_82520_(0.0, -0.008, 0.0));
                }
                super.m_8126_();
            }
        }
    }

    static class GoToBeachGoal
    extends MoveToBlockGoal {
        private final Wavewhisperer wavewhisperer;

        public GoToBeachGoal(Wavewhisperer p_i48911_1_, double p_i48911_2_) {
            super((PathfinderMob)p_i48911_1_, p_i48911_2_, 8, 2);
            this.wavewhisperer = p_i48911_1_;
        }

        public boolean m_8036_() {
            if (this.wavewhisperer.getTrueOwner() != null && this.wavewhisperer.isFollowing()) {
                return false;
            }
            return super.m_8036_() && this.wavewhisperer.m_20069_() && this.wavewhisperer.m_20186_() >= (double)(this.wavewhisperer.f_19853_.m_5736_() - 3);
        }

        public boolean m_8045_() {
            return super.m_8045_();
        }

        protected boolean m_6465_(LevelReader pLevel, BlockPos pPos) {
            BlockPos blockpos = pPos.m_7494_();
            return pLevel.m_46859_(blockpos) && pLevel.m_46859_(blockpos.m_7494_()) && pLevel.m_8055_(pPos).m_60634_((BlockGetter)pLevel, pPos, (Entity)this.wavewhisperer);
        }

        public void m_8056_() {
            this.wavewhisperer.setSearchingForLand(false);
            this.wavewhisperer.f_21344_ = (PathNavigation)this.wavewhisperer.groundNavigation;
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    static class SwimUpGoal
    extends Goal {
        private final Wavewhisperer whisperer;
        private final double speedModifier;
        private final int seaLevel;
        private boolean stuck;

        public SwimUpGoal(Wavewhisperer p_i48908_1_, double p_i48908_2_, int p_i48908_4_) {
            this.whisperer = p_i48908_1_;
            this.speedModifier = p_i48908_2_;
            this.seaLevel = p_i48908_4_;
        }

        public boolean m_8036_() {
            if (this.whisperer.getTrueOwner() != null && this.whisperer.isFollowing()) {
                return false;
            }
            return this.whisperer.m_20069_() && this.whisperer.m_20186_() < (double)(this.seaLevel - 2);
        }

        public boolean m_8045_() {
            return this.m_8036_() && !this.stuck;
        }

        public void m_8037_() {
            if (this.whisperer.m_20186_() < (double)(this.seaLevel - 1) && (this.whisperer.m_21573_().m_26571_() || this.whisperer.closeToNextPos())) {
                Vec3 vec3 = DefaultRandomPos.m_148412_((PathfinderMob)this.whisperer, (int)4, (int)8, (Vec3)new Vec3(this.whisperer.m_20185_(), (double)(this.seaLevel - 1), this.whisperer.m_20189_()), (double)1.5707963705062866);
                if (vec3 == null) {
                    this.stuck = true;
                    return;
                }
                this.whisperer.m_21573_().m_26519_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, this.speedModifier);
            }
        }

        public void m_8056_() {
            this.whisperer.setSearchingForLand(true);
            this.stuck = false;
        }

        public void m_8041_() {
            this.whisperer.setSearchingForLand(false);
        }
    }
}

