/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.golem;

import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ai.SummonTargetGoal;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.golem.AbstractGolemServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.magic.spells.frost.FrostNovaSpell;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModMobType;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.Nullable;

public class IceGolem
extends AbstractGolemServant {
    private static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(IceGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(IceGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public int attackTick;
    public int smashTick;
    public int attackCool;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState walkAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    public AnimationState smashAnimationState = new AnimationState();

    public IceGolem(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(8, new Summoned.WanderGoal<IceGolem>(this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.IceGolemHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.IceGolemArmor.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.22).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.IceGolemDamage.get()).doubleValue()).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 1.0).m_22268_(Attributes.f_22277_, ((Double)AttributesConfig.IceGolemFollowRange.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.IceGolemHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.IceGolemArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.IceGolemDamage.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22277_), (Double)AttributesConfig.IceGolemFollowRange.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.ICE_GOLEM_HURT.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_5496_((SoundEvent)ModSounds.ICE_GOLEM_STEP.get(), 1.0f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ICE_GOLEM_DEATH.get();
    }

    @Override
    public Predicate<Entity> summonPredicate() {
        return entity -> entity instanceof IceGolem;
    }

    @Override
    public int getSummonLimit(LivingEntity owner) {
        return (Integer)SpellConfig.IceGolemLimit.get();
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, "idle")) {
            return 1;
        }
        if (Objects.equals(animation, "walk")) {
            return 2;
        }
        if (Objects.equals(animation, "attack")) {
            return 3;
        }
        if (Objects.equals(animation, "smash")) {
            return 4;
        }
        return 0;
    }

    public List<AnimationState> getAllAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.walkAnimationState);
        animationStates.add(this.attackAnimationState);
        animationStates.add(this.smashAnimationState);
        return animationStates;
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAllAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (ANIM_STATE.equals(accessor) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: {
                    break;
                }
                case 1: {
                    this.idleAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 2: {
                    this.walkAnimationState.m_216982_(this.f_19797_);
                    this.stopMostAnimation(this.walkAnimationState);
                    break;
                }
                case 3: {
                    this.attackAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.attackAnimationState);
                    break;
                }
                case 4: {
                    this.smashAnimationState.m_216977_(this.f_19797_);
                    this.stopMostAnimation(this.smashAnimationState);
                }
            }
        }
    }

    private boolean getFlag(int mask) {
        byte i = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        return (i & mask) != 0;
    }

    private void setFlag(int mask, boolean value) {
        int i = ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID)).byteValue();
        i = value ? (i |= mask) : (i &= ~mask);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)((byte)(i & 0xFF)));
    }

    public boolean isMeleeAttacking() {
        return this.getFlag(1);
    }

    public void setMeleeAttacking(boolean meleeAttacking) {
        this.setFlag(1, meleeAttacking);
        this.attackTick = 0;
        if (meleeAttacking) {
            this.setAnimationState("attack");
            this.m_5496_((SoundEvent)ModSounds.ICE_GOLEM_SWING.get(), this.m_6121_(), this.m_6100_());
        }
    }

    public boolean isSmashing() {
        return this.getFlag(2);
    }

    public void setSmashing(boolean smashing) {
        this.setFlag(2, smashing);
        this.smashTick = 0;
        if (smashing) {
            this.setAnimationState("smash");
            this.m_5496_((SoundEvent)ModSounds.ICE_GOLEM_PRE_SMASH.get(), this.m_6121_(), this.m_6100_());
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity;
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            amount *= 1.33f;
        }
        if (source.m_269533_(DamageTypeTags.f_268419_)) {
            return false;
        }
        if (this.isUpgraded() && !source.m_269533_(DamageTypeTags.f_268640_) && !source.m_276093_(DamageTypes.f_268440_) && (entity = source.m_7640_()) instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            livingentity.m_6469_(this.m_269291_().m_269374_((Entity)this), 2.0f);
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public boolean m_5829_() {
        return false;
    }

    public void m_7822_(byte p_21375_) {
        if (p_21375_ == 5) {
            this.m_21561_(true);
        } else if (p_21375_ == 6) {
            this.m_21561_(false);
        } else {
            super.m_7822_(p_21375_);
        }
    }

    public MobType m_6336_() {
        return ModMobType.FROST;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            Object object;
            if (!this.isMeleeAttacking() && !this.isSmashing()) {
                if (!this.isMoving()) {
                    this.setAnimationState("idle");
                } else {
                    this.setAnimationState("walk");
                }
            }
            if (this.attackCool > 0) {
                --this.attackCool;
                this.f_21344_.m_26573_();
            } else {
                if (this.isMeleeAttacking()) {
                    ++this.attackTick;
                    if (this.attackTick >= 20) {
                        this.attackCool = 10;
                        this.setMeleeAttacking(false);
                    }
                } else {
                    this.attackTick = 0;
                }
                if (this.isSmashing()) {
                    ++this.smashTick;
                    if (this.smashTick == 19) {
                        new FrostNovaSpell().mobSpellResult((LivingEntity)this, ItemStack.f_41583_);
                    }
                    if (this.smashTick >= MathHelper.secondsToTicks(2.5f)) {
                        this.attackCool = 10;
                        this.setSmashing(false);
                    }
                } else {
                    this.smashTick = 0;
                }
            }
            if (this.isUpgraded() && (object = this.f_19853_) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)object;
                ServerParticleUtil.addAuraParticles(serverLevel, (ParticleOptions)ParticleTypes.f_175821_, (Entity)this, 1.0f);
                for (LivingEntity living : serverLevel.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(1.0))) {
                    if (living.m_203117_() || !living.m_142079_() || !MobUtil.validEntity((Entity)living) || MobUtil.areAllies((Entity)this, (Entity)living)) continue;
                    ServerParticleUtil.addParticlesAroundSelf(serverLevel, (ParticleOptions)ParticleTypes.f_175821_, (Entity)living);
                    living.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.FREEZING.get(), 100, 0));
                }
            }
        }
    }

    @Override
    public double getAttackReachSqr(LivingEntity enemy) {
        return this.m_20205_() * 2.0f * this.m_20205_() * 2.0f + enemy.m_20205_();
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand p_230254_2_) {
        if (!this.f_19853_.f_46443_) {
            ItemStack itemstack = pPlayer.m_21120_(p_230254_2_);
            Item item = itemstack.m_41720_();
            if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && (item == Items.f_41980_ || item == Items.f_42201_ || item == Items.f_42363_) && this.m_21223_() < this.m_21233_()) {
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
                this.m_5496_(SoundEvents.f_12009_, 1.0f, 1.25f);
                if (item == Items.f_41980_) {
                    this.m_5634_(0.25f);
                } else if (item == Items.f_42201_) {
                    this.m_5634_(3.0f);
                } else {
                    this.m_5634_(18.0f);
                }
                Level level = this.f_19853_;
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    for (int i = 0; i < 7; ++i) {
                        double d0 = this.f_19796_.m_188583_() * 0.02;
                        double d1 = this.f_19796_.m_188583_() * 0.02;
                        double d2 = this.f_19796_.m_188583_() * 0.02;
                        serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.HEAL_EFFECT.get()), this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                    }
                }
                pPlayer.m_6674_(p_230254_2_);
                return InteractionResult.CONSUME;
            }
        }
        return super.m_6071_(pPlayer, p_230254_2_);
    }

    static class AttackGoal
    extends Goal {
        public IceGolem iceGolem;
        private int delayCounter;

        public AttackGoal(IceGolem iceGolem) {
            this.iceGolem = iceGolem;
        }

        public boolean m_8036_() {
            return this.iceGolem.m_5448_() != null && this.iceGolem.m_5448_().m_6084_() && !this.iceGolem.isMeleeAttacking() && !this.iceGolem.isSmashing() && this.iceGolem.attackCool <= 0 && this.iceGolem.m_142582_((Entity)this.iceGolem.m_5448_());
        }

        public boolean m_8045_() {
            return (this.iceGolem.isMeleeAttacking() || this.iceGolem.isSmashing()) && this.iceGolem.attackCool <= 0;
        }

        public void m_8056_() {
            this.iceGolem.m_21561_(true);
            this.iceGolem.f_19853_.m_7605_((Entity)this.iceGolem, (byte)5);
            this.delayCounter = 0;
        }

        public void m_8041_() {
            this.iceGolem.setMeleeAttacking(false);
            this.iceGolem.m_21561_(false);
            this.iceGolem.setSmashing(false);
            this.iceGolem.f_19853_.m_7605_((Entity)this.iceGolem, (byte)6);
            this.iceGolem.setAnimationState("idle");
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity livingentity = this.iceGolem.m_5448_();
            if (livingentity == null) {
                return;
            }
            if (this.iceGolem.targetClose(livingentity, this.iceGolem.m_20280_((Entity)livingentity))) {
                MobUtil.instaLook((Mob)this.iceGolem, (Entity)livingentity);
                float chance = 0.05f;
                if (this.getNearbyTargets().size() >= 4) {
                    chance += 0.45f;
                }
                if (!this.iceGolem.isMeleeAttacking() && !this.iceGolem.isSmashing()) {
                    if (this.iceGolem.f_19796_.m_188501_() > chance) {
                        this.iceGolem.setMeleeAttacking(true);
                    } else {
                        this.iceGolem.setSmashing(true);
                    }
                } else {
                    this.iceGolem.f_21344_.m_26573_();
                }
            } else {
                this.iceGolem.m_21563_().m_24960_((Entity)livingentity, (float)this.iceGolem.m_8085_(), (float)this.iceGolem.m_8132_());
                if (--this.delayCounter <= 0) {
                    this.delayCounter = 10;
                    this.iceGolem.m_21573_().m_5624_((Entity)livingentity, 1.25);
                }
            }
            if (this.iceGolem.attackTick == 10) {
                this.iceGolem.m_6674_(InteractionHand.MAIN_HAND);
                if (this.iceGolem.targetClose(livingentity, this.iceGolem.m_20280_((Entity)livingentity))) {
                    this.iceGolem.m_7327_((Entity)livingentity);
                    this.iceGolem.m_5496_((SoundEvent)ModSounds.ICE_GOLEM_ATTACK.get(), this.iceGolem.m_6121_(), this.iceGolem.m_6100_());
                }
            }
        }

        public List<LivingEntity> getNearbyTargets() {
            return this.iceGolem.f_19853_.m_6443_(LivingEntity.class, this.iceGolem.m_20191_().m_82377_(4.0, 2.0, 4.0), living -> SummonTargetGoal.predicate((LivingEntity)this.iceGolem).test((LivingEntity)living));
        }
    }
}

