/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.illager;

import com.Polarice3.Goety.api.items.magic.IWand;
import com.Polarice3.Goety.common.entities.ai.ModMeleeAttackGoal;
import com.Polarice3.Goety.common.entities.ai.path.ModClimberNavigation;
import com.Polarice3.Goety.common.entities.ally.illager.AbstractIllagerServant;
import com.Polarice3.Goety.common.entities.ally.illager.VindicatorServant;
import com.Polarice3.Goety.common.entities.neutral.Owned;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.items.equipment.IceAxeItem;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.Tags;
import org.jetbrains.annotations.NotNull;

public class MountaineerServant
extends AbstractIllagerServant {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(MountaineerServant.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);

    public MountaineerServant(EntityType<? extends Owned> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MountaineerBreakDoorGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new MountaineerMeleeAttackGoal(this));
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.MountaineerServantHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.MountaineerServantArmor.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.MountaineerServantDamage.get()).doubleValue());
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.MountaineerServantHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.MountaineerServantArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.MountaineerServantDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    protected PathNavigation m_6037_(Level level) {
        return new ModClimberNavigation((Mob)this, level);
    }

    @Override
    public boolean canOpenDoors() {
        return true;
    }

    @Override
    public AbstractIllagerServant.IllagerServantArmPose getArmPose() {
        if (this.m_5912_()) {
            return AbstractIllagerServant.IllagerServantArmPose.ATTACKING;
        }
        return this.isCelebrating() ? AbstractIllagerServant.IllagerServantArmPose.CELEBRATING : AbstractIllagerServant.IllagerServantArmPose.NEUTRAL;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_34088_, DifficultyInstance p_34089_, MobSpawnType p_34090_, @Nullable SpawnGroupData p_34091_, @Nullable CompoundTag p_34092_) {
        SpawnGroupData spawngroupdata = super.m_6518_(p_34088_, p_34089_, p_34090_, p_34091_, p_34092_);
        RandomSource randomsource = p_34088_.m_213780_();
        this.m_213945_(randomsource, p_34089_);
        this.m_213946_(randomsource, p_34089_);
        return spawngroupdata;
    }

    @Override
    protected void m_213945_(RandomSource p_219149_, DifficultyInstance p_219150_) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ModItems.IRON_ICE_AXE.get()));
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)ModSounds.MOUNTAINEER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_34103_) {
        return (SoundEvent)ModSounds.MOUNTAINEER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.MOUNTAINEER_DEATH.get();
    }

    @Override
    public SoundEvent getCelebrateSound() {
        return (SoundEvent)ModSounds.MOUNTAINEER_CELEBRATE.get();
    }

    public void m_6674_(InteractionHand pHand) {
        super.m_6674_(pHand);
        this.m_216990_((SoundEvent)ModSounds.MOUNTAINEER_ATTACK.get());
    }

    public boolean isClimbing() {
        return ((Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID) & 1) != 0;
    }

    public void setClimbing(boolean p_33820_) {
        byte b0 = (Byte)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = p_33820_ ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    public boolean isClimbableBlock(BlockPos blockPos) {
        BlockState blockState = this.f_19853_.m_8055_(blockPos);
        return (blockState.m_204336_(BlockTags.f_13047_) || blockState.m_204336_(Tags.Blocks.STONE) || blockState.m_204336_(Tags.Blocks.COBBLESTONE) || blockState.m_204336_(BlockTags.f_144274_) || blockState.m_204336_(BlockTags.f_144279_)) && blockState.m_60804_((BlockGetter)this.f_19853_, blockPos);
    }

    public boolean m_6147_() {
        return this.isClimbing();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_ instanceof ServerLevel) {
            this.setClimbing(this.f_19862_);
        }
    }

    @Override
    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        ItemStack itemstack2 = this.m_21205_();
        if (this.getTrueOwner() != null && pPlayer == this.getTrueOwner() && !(pPlayer.m_21206_().m_41720_() instanceof IWand) && item instanceof IceAxeItem) {
            this.m_5496_(SoundEvents.f_11675_, 1.0f, 1.0f);
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41777_());
            this.dropEquipment(EquipmentSlot.MAINHAND, itemstack2);
            this.m_21508_(EquipmentSlot.MAINHAND);
            for (int i = 0; i < 7; ++i) {
                double d0 = this.f_19796_.m_188583_() * 0.02;
                double d1 = this.f_19796_.m_188583_() * 0.02;
                double d2 = this.f_19796_.m_188583_() * 0.02;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_() + 0.5, this.m_20262_(1.0), d0, d1, d2);
            }
            if (!pPlayer.m_150110_().f_35937_) {
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    static class MountaineerBreakDoorGoal
    extends BreakDoorGoal {
        public MountaineerBreakDoorGoal(Mob p_34112_) {
            super(p_34112_, 6, VindicatorServant.DOOR_BREAKING_PREDICATE);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8045_() {
            MountaineerServant vindicator = (MountaineerServant)this.f_25189_;
            return vindicator.isRaiding() && super.m_8045_();
        }

        public boolean m_8036_() {
            MountaineerServant vindicator = (MountaineerServant)this.f_25189_;
            return vindicator.isRaiding() && vindicator.f_19796_.m_188503_(MountaineerBreakDoorGoal.m_186073_((int)10)) == 0 && super.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            this.f_25189_.m_21310_(0);
        }
    }

    static class MountaineerMeleeAttackGoal
    extends ModMeleeAttackGoal {
        public MountaineerMeleeAttackGoal(MountaineerServant p_34123_) {
            super(p_34123_, 1.0, false);
        }
    }
}

