/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.ally.spider;

import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.ally.spider.AbstractSpiderServant;
import com.Polarice3.Goety.common.ritual.RitualRequirements;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.init.ModTags;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.EffectsUtil;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.Vec3;

public class SpiderServant
extends AbstractSpiderServant {
    private static final EntityDataAccessor<Byte> DATA_FLAGS_ID = SynchedEntityData.m_135353_(SpiderServant.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final UUID SPEED_MODIFIER_UUID = UUID.fromString("2a3ee720-61cb-402c-affa-2eef9343910d");
    public static final AttributeModifier STOP_MODIFIER = new AttributeModifier(SPEED_MODIFIER_UUID, "Stop Moving Dammit", -1.0, AttributeModifier.Operation.ADDITION);
    private static final UUID DETECTION_MODIFIER_UUID = UUID.fromString("858f6b2f-73e3-45a0-8bef-bb31e0d55be4");
    public static final AttributeModifier DETECTION_MODIFIER = new AttributeModifier(DETECTION_MODIFIER_UUID, "Light Is Blinding", -1.0, AttributeModifier.Operation.ADDITION);

    public SpiderServant(EntityType<? extends SpiderServant> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(5, new Summoned.WanderGoal<SpiderServant>(this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.attackGoal();
    }

    public void attackGoal() {
        this.f_21345_.m_25352_(3, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(4, (Goal)new SpiderAttackGoal(this));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FLAGS_ID, (Object)0);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            AttributeInstance modifiableattributeinstance = this.m_21051_(Attributes.f_22277_);
            if (MobUtil.isInBrightLight((LivingEntity)this)) {
                if (modifiableattributeinstance != null && this.m_21051_(Attributes.f_22277_) != null) {
                    modifiableattributeinstance.m_22130_(DETECTION_MODIFIER);
                    modifiableattributeinstance.m_22118_(DETECTION_MODIFIER);
                }
            } else if (modifiableattributeinstance != null && modifiableattributeinstance.m_22109_(DETECTION_MODIFIER)) {
                modifiableattributeinstance.m_22130_(DETECTION_MODIFIER);
            }
        }
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.SpiderServantHealth.get()).doubleValue()).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.SpiderServantDamage.get()).doubleValue()).m_22268_(Attributes.f_22279_, 0.3);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.SpiderServantHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.SpiderServantDamage.get());
    }

    public void m_7601_(BlockState p_33796_, Vec3 p_33797_) {
        if (!p_33796_.m_60713_(Blocks.f_50033_) && !p_33796_.m_60713_(Blocks.f_50016_)) {
            super.m_7601_(p_33796_, p_33797_);
        }
    }

    public boolean spawnWithEffects() {
        return true;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33790_, DifficultyInstance p_33791_, MobSpawnType p_33792_, @Nullable SpawnGroupData p_33793_, @Nullable CompoundTag p_33794_) {
        p_33793_ = super.m_6518_(p_33790_, p_33791_, p_33792_, p_33793_, p_33794_);
        RandomSource randomsource = p_33790_.m_213780_();
        if (this.spawnWithEffects()) {
            MobEffect mobeffect;
            if (p_33793_ == null) {
                p_33793_ = new SpiderEffectsGroupData();
                if (p_33790_.m_46791_() == Difficulty.HARD && randomsource.m_188501_() < 0.1f * p_33791_.m_19057_()) {
                    ((SpiderEffectsGroupData)p_33793_).setRandomEffect(randomsource);
                }
            }
            if (p_33793_ instanceof SpiderEffectsGroupData && (mobeffect = ((SpiderEffectsGroupData)p_33793_).effect) != null) {
                this.m_7292_(new MobEffectInstance(mobeffect, EffectsUtil.infiniteEffect()));
            }
        }
        return p_33793_;
    }

    @Override
    @Nullable
    public EntityType<?> getVariant(Level level, BlockPos blockPos) {
        EntityType entityType = (EntityType)ModEntityType.SPIDER_SERVANT.get();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (BlockFinder.findStructure(serverLevel, blockPos, ModTags.Structures.CRYPT)) {
                entityType = (EntityType)ModEntityType.BONE_SPIDER_SERVANT.get();
            } else if (RitualRequirements.frostRitual(blockPos, level)) {
                entityType = (EntityType)ModEntityType.ICY_SPIDER_SERVANT.get();
            } else if (BlockFinder.findStructure(serverLevel, blockPos, (TagKey<Structure>)StructureTags.f_215890_)) {
                entityType = (EntityType)ModEntityType.CAVE_SPIDER_SERVANT.get();
            }
        }
        return entityType;
    }

    static class SpiderAttackGoal
    extends MeleeAttackGoal {
        public SpiderAttackGoal(SpiderServant p_33822_) {
            super((PathfinderMob)p_33822_, 1.0, true);
        }

        public SpiderAttackGoal(SpiderServant p_33822_, double speed) {
            super((PathfinderMob)p_33822_, speed, true);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.f_25540_.m_20160_();
        }

        protected double m_6639_(LivingEntity p_33825_) {
            return 4.0f + p_33825_.m_20205_();
        }
    }

    public static class SpiderEffectsGroupData
    implements SpawnGroupData {
        @Nullable
        public MobEffect effect;

        public void setRandomEffect(RandomSource p_219119_) {
            int i = p_219119_.m_188503_(5);
            if (i <= 1) {
                this.effect = MobEffects.f_19596_;
            } else if (i == 2) {
                this.effect = MobEffects.f_19600_;
            } else if (i == 3) {
                this.effect = MobEffects.f_19605_;
            } else if (i == 4) {
                this.effect = MobEffects.f_19609_;
            }
        }
    }
}

