/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.boss;

import com.Polarice3.Goety.client.particles.AbsorbTrailParticleOption;
import com.Polarice3.Goety.client.particles.AoEParticleOption;
import com.Polarice3.Goety.client.particles.CircleExplodeParticleOption;
import com.Polarice3.Goety.client.particles.DustCloudParticleOption;
import com.Polarice3.Goety.client.particles.GatherTrailParticle;
import com.Polarice3.Goety.client.particles.MagicSmokeParticle;
import com.Polarice3.Goety.client.particles.ReverseShockwaveParticleOption;
import com.Polarice3.Goety.client.particles.VerticalCircleExplodeParticleOption;
import com.Polarice3.Goety.client.particles.WindBlowParticle;
import com.Polarice3.Goety.client.particles.WindParticleOption;
import com.Polarice3.Goety.common.blocks.entities.VoidShrineBlockEntity;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.entities.ai.path.ModGroundNavigation;
import com.Polarice3.Goety.common.entities.ally.Summoned;
import com.Polarice3.Goety.common.entities.neutral.ender.AbstractEnderling;
import com.Polarice3.Goety.common.entities.projectiles.VoidShock;
import com.Polarice3.Goety.common.entities.projectiles.VoidShockBomb;
import com.Polarice3.Goety.common.entities.projectiles.VoidSlash;
import com.Polarice3.Goety.common.entities.util.CameraShake;
import com.Polarice3.Goety.common.entities.util.ModFallingBlock;
import com.Polarice3.Goety.common.entities.util.VoidLightningTrap;
import com.Polarice3.Goety.common.items.ModItems;
import com.Polarice3.Goety.common.network.ModNetwork;
import com.Polarice3.Goety.common.network.ModServerBossInfo;
import com.Polarice3.Goety.common.network.server.SPlayFollowSoundPacket;
import com.Polarice3.Goety.common.network.server.SRepositionPacket;
import com.Polarice3.Goety.config.AttributesConfig;
import com.Polarice3.Goety.config.MainConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BlockFinder;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MiscCapHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.SpellExplosion;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class EnderKeeper
extends AbstractEnderling
implements Enemy {
    protected static final EntityDataAccessor<Integer> ANIM_STATE = SynchedEntityData.m_135353_(EnderKeeper.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final ModServerBossInfo bossInfo;
    public static String IDLE = "idle";
    public static String SWING = "swing";
    public static String SWING_COMBO = "swing_combo";
    public static String SWING_COMBO_TRIPLE = "swing_combo_triple";
    public static String RAPID_SWING = "rapid_swing";
    public static String CHARGE = "charge";
    public static String SPELL_1 = "spell_1";
    public static String SPELL_2 = "spell_2";
    public static String SPELL_3 = "spell_3";
    public static String LIFE_STEAL = "life_steal";
    public static String GROUND_POUND = "ground_pound";
    public static String GROUND_POUND_SPIN = "ground_pound_spin";
    public static String BACK_AWAY = "back_away";
    public static String SLICE_START = "slice_start";
    public static String SLICE_1 = "slice_1";
    public static String SLICE_2 = "slice_2";
    public static String DEATH = "death";
    public int attackTick;
    public int sliceAmount = 0;
    public int swingCool = 0;
    public int swingComboCool = 0;
    public int rapidSwingCool = 0;
    public int chargeCool = 0;
    public int spell1Cool = 0;
    public int spell2Cool = 0;
    public int spell3Cool = 0;
    public int lifeStealCool = 0;
    public int groundPoundCool = 0;
    public int backAwayCool = 0;
    public int slicingCool = 0;
    public int groundPoundSize = 6;
    public int shakeSword = 0;
    public int deathTime;
    public float deathRotation = 0.0f;
    private BlockPos lastSafePosition;
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState swingAnimationState = new AnimationState();
    public AnimationState swingComboAnimationState = new AnimationState();
    public AnimationState swingComboTripleAnimationState = new AnimationState();
    public AnimationState rapidSwingAnimationState = new AnimationState();
    public AnimationState chargeAnimationState = new AnimationState();
    public AnimationState spell1AnimationState = new AnimationState();
    public AnimationState spell2AnimationState = new AnimationState();
    public AnimationState spell3AnimationState = new AnimationState();
    public AnimationState lifeStealAnimationState = new AnimationState();
    public AnimationState groundPoundAnimationState = new AnimationState();
    public AnimationState groundPoundSpinAnimationState = new AnimationState();
    public AnimationState backAwayAnimationState = new AnimationState();
    public AnimationState slice1AnimationState = new AnimationState();
    public AnimationState slice2AnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();

    public EnderKeeper(EntityType<? extends AbstractEnderling> p_33002_, Level p_33003_) {
        super(p_33002_, p_33003_);
        this.setHostile(true);
        this.bossInfo = new ModServerBossInfo((Mob)this, BossEvent.BossBarColor.PURPLE, true, false);
        this.m_274367_(2.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.attackGoals();
        this.f_21345_.m_25352_(5, new Summoned.WanderGoal<EnderKeeper>(this, 1.0, 80.0f));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal<Player>((Mob)this, Player.class, true){

            @NotNull
            protected AABB m_7255_(double area) {
                return this.f_26135_.m_20191_().m_82377_(area, area, area);
            }
        });
    }

    public void attackGoals() {
        this.f_21345_.m_25352_(1, (Goal)new KeeperAttackGoal(this, IDLE, SWING, IDLE, 50, 10, 6.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && !MobUtil.healthIsHalved((LivingEntity)EnderKeeper.this) && EnderKeeper.this.swingCool <= 0;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                EnderKeeper.this.swingCool = 100;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new KeeperAttackGoal(this, IDLE, BACK_AWAY, IDLE, 20, 20, 6.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && EnderKeeper.this.backAwayCool <= 0;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                EnderKeeper.this.backAwayCool = 100;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new KeeperAttackGoal(this, IDLE, SWING_COMBO, IDLE, 70, 60, 6.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && EnderKeeper.this.m_217043_().m_188499_() && !MobUtil.healthIsHalved((LivingEntity)EnderKeeper.this) && EnderKeeper.this.swingComboCool <= 0;
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                if (EnderKeeper.this.m_5448_() != null) {
                    MobUtil.instaLook((Mob)EnderKeeper.this, (Entity)EnderKeeper.this.m_5448_(), true);
                }
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                EnderKeeper.this.swingComboCool = 100;
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new KeeperAttackGoal(this, IDLE, SWING_COMBO_TRIPLE, IDLE, 75, 65, 6.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && (EnderKeeper.this.m_217043_().m_188501_() <= 0.25f || MobUtil.healthIsHalved((LivingEntity)EnderKeeper.this)) && EnderKeeper.this.swingComboCool <= 0;
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                if (EnderKeeper.this.m_5448_() != null) {
                    MobUtil.instaLook((Mob)EnderKeeper.this, (Entity)EnderKeeper.this.m_5448_(), true);
                }
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                EnderKeeper.this.swingComboCool = 100;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new KeeperAttackGoal(this, IDLE, RAPID_SWING, IDLE, 62, 10, 6.0f, 40.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && EnderKeeper.this.f_19853_.m_213780_().m_188501_() <= 0.25f && EnderKeeper.this.rapidSwingCool <= 0;
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                if (EnderKeeper.this.m_5448_() != null) {
                    MobUtil.instaLook((Mob)EnderKeeper.this, (Entity)EnderKeeper.this.m_5448_(), true);
                }
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                EnderKeeper.this.rapidSwingCool = 200;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new KeeperAttackGoal(this, IDLE, CHARGE, IDLE, 50, 10, 6.0f, 40.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && EnderKeeper.this.chargeCool <= 0;
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                if (EnderKeeper.this.m_5448_() != null) {
                    MobUtil.instaLook((Mob)EnderKeeper.this, (Entity)EnderKeeper.this.m_5448_(), true);
                }
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                EnderKeeper.this.chargeCool = 200;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new KeeperAttackGoal(this, IDLE, GROUND_POUND, IDLE, 30, 10, 6.0f, 40.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && EnderKeeper.this.groundPoundCool <= 0 && EnderKeeper.this.f_19853_.m_213780_().m_188499_();
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                EnderKeeper.this.groundPoundSize = MobUtil.healthIsHalved((LivingEntity)EnderKeeper.this) ? EnderKeeper.this.f_19853_.m_213780_().m_216332_(8, 10) : 6;
                EnderKeeper.this.startHide();
                if (EnderKeeper.this.m_5448_() != null) {
                    Vec3 vec3 = EnderKeeper.this.m_5448_().m_20182_();
                    Vec3 vec31 = BlockFinder.SummonPosition((Entity)EnderKeeper.this.m_5448_(), vec3);
                    EnderKeeper.this.ownedTeleport(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
                    Level level = EnderKeeper.this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        ColorUtil colorUtil = ColorUtil.WHITE;
                        serverLevel.m_8767_((ParticleOptions)new AoEParticleOption(EnderKeeper.this.groundPoundSize, 20), EnderKeeper.this.m_20185_(), EnderKeeper.this.m_20186_() + 0.25, EnderKeeper.this.m_20189_(), 0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue(), 1.0);
                    }
                }
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                EnderKeeper.this.stopHide();
                EnderKeeper.this.groundPoundCool = 200;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new KeeperAttackGoal(this, IDLE, GROUND_POUND_SPIN, IDLE, 65, 10, 6.0f, 40.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && EnderKeeper.this.groundPoundCool <= 0 && (EnderKeeper.this.f_19853_.m_213780_().m_188501_() <= 0.05f || MobUtil.healthIsHalved((LivingEntity)EnderKeeper.this) && EnderKeeper.this.f_19853_.m_213780_().m_188501_() <= 0.75f);
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                EnderKeeper.this.groundPoundSize = MobUtil.healthIsHalved((LivingEntity)EnderKeeper.this) ? EnderKeeper.this.f_19853_.m_213780_().m_216332_(8, 10) : 6;
                EnderKeeper.this.startHide();
                if (EnderKeeper.this.m_5448_() != null) {
                    Vec3 vec3 = EnderKeeper.this.m_5448_().m_20182_();
                    Vec3 vec31 = BlockFinder.SummonPosition((Entity)EnderKeeper.this.m_5448_(), vec3);
                    EnderKeeper.this.ownedTeleport(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_);
                    Level level = EnderKeeper.this.f_19853_;
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        ColorUtil colorUtil = ColorUtil.WHITE;
                        serverLevel.m_8767_((ParticleOptions)new AoEParticleOption(EnderKeeper.this.groundPoundSize, 20), EnderKeeper.this.m_20185_(), EnderKeeper.this.m_20186_() + 0.25, EnderKeeper.this.m_20189_(), 0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue(), 1.0);
                    }
                }
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                EnderKeeper.this.stopHide();
                EnderKeeper.this.groundPoundCool = 200;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new KeeperAttackGoal(this, IDLE, LIFE_STEAL, IDLE, 140, 30, 20.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && EnderKeeper.this.f_19853_.m_213780_().m_188499_() && EnderKeeper.this.m_21223_() <= EnderKeeper.this.m_21233_() / 2.0f && EnderKeeper.this.lifeStealCool <= 0;
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                EnderKeeper.this.m_5496_((SoundEvent)ModSounds.VOID_PREPARE_SPELL.get(), 2.0f, 0.5f);
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                EnderKeeper.this.lifeStealCool = 200;
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new KeeperAttackGoal(this, IDLE, SPELL_1, IDLE, 50, 0, 40.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && EnderKeeper.this.spell1Cool <= 0 && EnderKeeper.this.spell2Cool <= 0;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                EnderKeeper.this.spell1Cool = 100;
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new KeeperAttackGoal(this, IDLE, SPELL_2, IDLE, 65, 30, 20.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && EnderKeeper.this.f_19853_.m_213780_().m_188499_() && EnderKeeper.this.spell2Cool <= 0;
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                EnderKeeper.this.spell2Cool = 200;
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new KeeperAttackGoal(this, IDLE, SPELL_3, IDLE, 80, 30, 6.0f, 20.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && EnderKeeper.this.f_19853_.m_213780_().m_188499_() && EnderKeeper.this.spell3Cool <= 0;
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                EnderKeeper.this.m_5496_((SoundEvent)ModSounds.THUNDER_STRIKE_FAST.get(), 2.0f, 0.5f);
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                EnderKeeper.this.spell3Cool = 300;
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new KeeperAttackGoal(this, IDLE, LIFE_STEAL, IDLE, 140, 30, 20.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && EnderKeeper.this.f_19853_.m_213780_().m_188499_() && EnderKeeper.this.m_21223_() > EnderKeeper.this.m_21233_() / 2.0f && EnderKeeper.this.m_21223_() < EnderKeeper.this.m_21233_() && EnderKeeper.this.lifeStealCool <= 0;
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                EnderKeeper.this.m_5496_((SoundEvent)ModSounds.VOID_PREPARE_SPELL.get(), 2.0f, 0.5f);
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                EnderKeeper.this.lifeStealCool = 200;
            }
        });
        this.sliceGoals();
    }

    public void sliceGoals() {
        this.f_21345_.m_25352_(3, (Goal)new KeeperAttackGoal(this, IDLE, SLICE_START, SLICE_START, 20, 10, 6.0f, 40.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && EnderKeeper.this.slicingCool <= 0 && EnderKeeper.this.spell2Cool <= 100;
            }

            @Override
            public boolean m_8045_() {
                int hideTime = MobUtil.healthIsHalved((LivingEntity)EnderKeeper.this) ? 20 : 40;
                return super.m_8045_() && EnderKeeper.this.hidingTime < hideTime;
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                EnderKeeper.this.startHide();
                if (EnderKeeper.this.m_5448_() != null) {
                    EnderKeeper.this.teleportTowards((Entity)EnderKeeper.this.m_5448_(), 4.0);
                }
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new KeeperAttackGoal(this, SLICE_START, SLICE_1, SLICE_1, 24, 14, 40.0f){

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && EnderKeeper.this.hidingTime < 10;
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                EnderKeeper.this.stopHide();
                if (EnderKeeper.this.m_5448_() != null) {
                    MobUtil.instaLook((Mob)EnderKeeper.this, (Entity)EnderKeeper.this.m_5448_(), true);
                }
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new KeeperAttackGoal(this, SLICE_1, SLICE_2, SLICE_2, 24, 14, 40.0f){

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && EnderKeeper.this.hidingTime < 10;
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                EnderKeeper.this.stopHide();
                if (EnderKeeper.this.m_5448_() != null) {
                    MobUtil.instaLook((Mob)EnderKeeper.this, (Entity)EnderKeeper.this.m_5448_(), true);
                }
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new KeeperAttackGoal(this, SLICE_2, SLICE_1, SLICE_1, 24, 14, 40.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && EnderKeeper.this.sliceAmount <= 1;
            }

            @Override
            public boolean m_8045_() {
                return super.m_8045_() && EnderKeeper.this.hidingTime < 10;
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                EnderKeeper.this.stopHide();
                ++EnderKeeper.this.sliceAmount;
                if (EnderKeeper.this.m_5448_() != null) {
                    MobUtil.instaLook((Mob)EnderKeeper.this, (Entity)EnderKeeper.this.m_5448_(), true);
                }
            }
        });
        this.f_21345_.m_25352_(0, (Goal)new KeeperAttackGoal(this, SLICE_2, SLICE_1, IDLE, 20, 12, 40.0f){

            @Override
            public boolean m_8036_() {
                return super.m_8036_() && EnderKeeper.this.sliceAmount > 1;
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                EnderKeeper.this.stopHide();
                EnderKeeper.this.slicingCool = 250;
                EnderKeeper.this.sliceAmount = 0;
                if (EnderKeeper.this.m_5448_() != null) {
                    MobUtil.instaLook((Mob)EnderKeeper.this, (Entity)EnderKeeper.this.m_5448_(), true);
                }
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                EnderKeeper.this.stopHide();
                EnderKeeper.this.slicingCool = 400;
                EnderKeeper.this.sliceAmount = 0;
                if (EnderKeeper.this.m_5448_() != null) {
                    MobUtil.instaLook((Mob)EnderKeeper.this, (Entity)EnderKeeper.this.m_5448_(), true);
                }
            }
        });
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new ModGroundNavigation((Mob)this, worldIn);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 48.0).m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22281_, ((Double)AttributesConfig.EnderKeeperDamage.get()).doubleValue()).m_22268_(Attributes.f_22276_, ((Double)AttributesConfig.EnderKeeperHealth.get()).doubleValue()).m_22268_(Attributes.f_22284_, ((Double)AttributesConfig.EnderKeeperArmor.get()).doubleValue()).m_22268_(Attributes.f_22278_, 1.0);
    }

    @Override
    public void setConfigurableAttributes() {
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22276_), (Double)AttributesConfig.EnderKeeperHealth.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22284_), (Double)AttributesConfig.EnderKeeperArmor.get());
        MobUtil.setBaseAttributes(this.m_21051_(Attributes.f_22281_), (Double)AttributesConfig.EnderKeeperDamage.get());
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANIM_STATE, (Object)0);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("SwingCool", this.swingCool);
        compound.m_128405_("SwingComboCool", this.swingComboCool);
        compound.m_128405_("RapidSwingCool", this.rapidSwingCool);
        compound.m_128405_("ChargeCool", this.chargeCool);
        compound.m_128405_("Spell1Cool", this.spell1Cool);
        compound.m_128405_("Spell2Cool", this.spell2Cool);
        compound.m_128405_("Spell3Cool", this.spell3Cool);
        compound.m_128405_("LifeStealCool", this.lifeStealCool);
        compound.m_128405_("GroundPoundCool", this.groundPoundCool);
        compound.m_128405_("BackAwayCool", this.backAwayCool);
        compound.m_128405_("SlicingCool", this.slicingCool);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("SwingCool")) {
            this.swingCool = compound.m_128451_("SwingCool");
        }
        if (compound.m_128441_("SwingComboCool")) {
            this.swingComboCool = compound.m_128451_("SwingComboCool");
        }
        if (compound.m_128441_("RapidSwingCool")) {
            this.rapidSwingCool = compound.m_128451_("RapidSwingCool");
        }
        if (compound.m_128441_("ChargeCool")) {
            this.chargeCool = compound.m_128451_("ChargeCool");
        }
        if (compound.m_128441_("Spell1Cool")) {
            this.spell1Cool = compound.m_128451_("Spell1Cool");
        }
        if (compound.m_128441_("Spell2Cool")) {
            this.spell2Cool = compound.m_128451_("Spell2Cool");
        }
        if (compound.m_128441_("Spell3Cool")) {
            this.spell3Cool = compound.m_128451_("Spell3Cool");
        }
        if (compound.m_128441_("LifeStealCool")) {
            this.lifeStealCool = compound.m_128451_("LifeStealCool");
        }
        if (compound.m_128441_("GroundPoundCool")) {
            this.groundPoundCool = compound.m_128451_("GroundPoundCool");
        }
        if (compound.m_128441_("BackAwayCool")) {
            this.backAwayCool = compound.m_128451_("BackAwayCool");
        }
        if (compound.m_128441_("SlicingCool")) {
            this.slicingCool = compound.m_128451_("SlicingCool");
        }
    }

    @Override
    @Nullable
    public LivingEntity getTrueOwner() {
        return null;
    }

    @Override
    public int xpReward() {
        return 1000;
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        OwnableEntity ownable;
        double range = MobUtil.calculateRange((LivingEntity)this, source);
        if (range > Mth.m_144952_((double)((Double)AttributesConfig.EnderKeeperHurtRange.get())) && !source.m_269533_(DamageTypeTags.f_268738_)) {
            if (!(source.m_7639_() == null || MobUtil.areAllies((Entity)this, source.m_7639_()) || this.isAttacking() || this.isHiding())) {
                this.teleportTowards(source.m_7639_(), 4.0);
            }
            return false;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof OwnableEntity && (ownable = (OwnableEntity)entity).m_269323_() != null) {
            damage *= 0.5f;
        }
        return super.m_6469_(source, damage);
    }

    protected void m_6475_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_273918_) || source.m_269533_(DamageTypeTags.f_268738_) && source.m_7639_() != null) {
            this.f_19802_ = 20;
        }
        if (!source.m_269533_(DamageTypeTags.f_268738_)) {
            amount = Math.min(amount, ((Double)AttributesConfig.EnderKeeperDamageCap.get()).floatValue());
        }
        super.m_6475_(source, amount);
    }

    public void setAnimationState(String input) {
        this.setAnimationState(this.getAnimationState(input));
    }

    public void setAnimationState(int id) {
        this.f_19804_.m_135381_(ANIM_STATE, (Object)id);
    }

    public int getAnimationState(String animation) {
        if (Objects.equals(animation, IDLE)) {
            return 0;
        }
        if (Objects.equals(animation, SWING)) {
            return 1;
        }
        if (Objects.equals(animation, SWING_COMBO)) {
            return 2;
        }
        if (Objects.equals(animation, SWING_COMBO_TRIPLE)) {
            return 3;
        }
        if (Objects.equals(animation, RAPID_SWING)) {
            return 4;
        }
        if (Objects.equals(animation, CHARGE)) {
            return 5;
        }
        if (Objects.equals(animation, SPELL_1)) {
            return 6;
        }
        if (Objects.equals(animation, SPELL_2)) {
            return 7;
        }
        if (Objects.equals(animation, SPELL_3)) {
            return 8;
        }
        if (Objects.equals(animation, GROUND_POUND)) {
            return 9;
        }
        if (Objects.equals(animation, GROUND_POUND_SPIN)) {
            return 10;
        }
        if (Objects.equals(animation, BACK_AWAY)) {
            return 11;
        }
        if (Objects.equals(animation, SLICE_1)) {
            return 12;
        }
        if (Objects.equals(animation, SLICE_2)) {
            return 13;
        }
        if (Objects.equals(animation, SLICE_START)) {
            return 14;
        }
        if (Objects.equals(animation, DEATH)) {
            return 15;
        }
        if (Objects.equals(animation, LIFE_STEAL)) {
            return 16;
        }
        return 0;
    }

    public List<AnimationState> getAnimations() {
        ArrayList<AnimationState> animationStates = new ArrayList<AnimationState>();
        animationStates.add(this.idleAnimationState);
        animationStates.add(this.swingAnimationState);
        animationStates.add(this.swingComboAnimationState);
        animationStates.add(this.swingComboTripleAnimationState);
        animationStates.add(this.rapidSwingAnimationState);
        animationStates.add(this.chargeAnimationState);
        animationStates.add(this.spell1AnimationState);
        animationStates.add(this.spell2AnimationState);
        animationStates.add(this.spell3AnimationState);
        animationStates.add(this.lifeStealAnimationState);
        animationStates.add(this.groundPoundAnimationState);
        animationStates.add(this.groundPoundSpinAnimationState);
        animationStates.add(this.backAwayAnimationState);
        animationStates.add(this.slice1AnimationState);
        animationStates.add(this.slice2AnimationState);
        animationStates.add(this.deathAnimationState);
        return animationStates;
    }

    public void stopAllAnimations() {
        for (AnimationState state : this.getAnimations()) {
            state.m_216973_();
        }
    }

    public void stopMostAnimation(AnimationState exception) {
        for (AnimationState state : this.getAnimations()) {
            if (state == exception) continue;
            state.m_216973_();
        }
    }

    public int getCurrentAnimation() {
        return (Integer)this.f_19804_.m_135370_(ANIM_STATE);
    }

    public boolean isCurrentAnimation(String animation) {
        return this.getCurrentAnimation() == this.getAnimationState(animation);
    }

    public boolean isAttacking() {
        return !this.isCurrentAnimation(IDLE) && !this.isHiding();
    }

    public void m_7350_(EntityDataAccessor<?> p_219422_) {
        if (ANIM_STATE.equals(p_219422_) && this.f_19853_.f_46443_) {
            switch ((Integer)this.f_19804_.m_135370_(ANIM_STATE)) {
                case 0: 
                case 14: {
                    this.stopMostAnimation(this.idleAnimationState);
                    break;
                }
                case 1: {
                    this.stopMostAnimation(this.swingAnimationState);
                    this.swingAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 2: {
                    this.stopMostAnimation(this.swingComboAnimationState);
                    this.swingComboAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 3: {
                    this.stopMostAnimation(this.swingComboTripleAnimationState);
                    this.swingComboTripleAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 4: {
                    this.stopMostAnimation(this.rapidSwingAnimationState);
                    this.rapidSwingAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 5: {
                    this.stopMostAnimation(this.chargeAnimationState);
                    this.chargeAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 6: {
                    this.stopMostAnimation(this.spell1AnimationState);
                    this.spell1AnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 7: {
                    this.stopMostAnimation(this.spell2AnimationState);
                    this.spell2AnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 8: {
                    this.stopMostAnimation(this.spell3AnimationState);
                    this.spell3AnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 9: {
                    this.stopMostAnimation(this.groundPoundAnimationState);
                    this.groundPoundAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 10: {
                    this.stopMostAnimation(this.groundPoundSpinAnimationState);
                    this.groundPoundSpinAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 11: {
                    this.stopMostAnimation(this.backAwayAnimationState);
                    this.backAwayAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 12: {
                    this.stopMostAnimation(this.slice1AnimationState);
                    this.slice1AnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 13: {
                    this.stopMostAnimation(this.slice2AnimationState);
                    this.slice2AnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 15: {
                    this.stopMostAnimation(this.deathAnimationState);
                    this.deathAnimationState.m_216977_(this.f_19797_);
                    break;
                }
                case 16: {
                    this.stopMostAnimation(this.lifeStealAnimationState);
                    this.lifeStealAnimationState.m_216977_(this.f_19797_);
                }
            }
        }
        super.m_7350_(p_219422_);
    }

    protected int m_7302_(int air) {
        return air;
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected boolean m_6129_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        if (((Boolean)MainConfig.SpecialBossBar.get()).booleanValue()) {
            this.bossInfo.m_6543_(pPlayer);
        }
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossInfo.m_6539_(pPlayer);
    }

    public void m_7601_(BlockState p_33796_, Vec3 p_33797_) {
    }

    protected boolean m_7341_(Entity p_219462_) {
        return false;
    }

    public boolean m_6072_() {
        return false;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)ModSounds.ENDER_KEEPER_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)ModSounds.ENDER_KEEPER_DEATH.get();
    }

    @Override
    public void stepSound() {
        this.m_5496_((SoundEvent)ModSounds.TOWER_WRAITH_FLY.get(), 0.15f, 0.5f);
    }

    @Override
    public boolean m_7301_(MobEffectInstance pPotioneffect) {
        return pPotioneffect.m_19544_().m_19486_() && super.m_7301_(pPotioneffect);
    }

    public boolean m_147207_(MobEffectInstance pPotioneffect, @Nullable Entity entity) {
        if (entity == this) {
            return super.m_147207_(pPotioneffect, entity);
        }
        return pPotioneffect.m_19544_().m_19486_();
    }

    public VoidShrineBlockEntity getVoidShrine() {
        BlockEntity blockEntity;
        if (this.getBoundPos() != null && (blockEntity = this.f_19853_.m_7702_(this.getBoundPos())) instanceof VoidShrineBlockEntity) {
            VoidShrineBlockEntity blockEntity2 = (VoidShrineBlockEntity)blockEntity;
            return blockEntity2;
        }
        return null;
    }

    private BlockPos getSafeGround() {
        BlockPos position = this.m_20183_();
        while (position.m_123342_() < 256 && !this.f_19853_.m_6425_(position).m_76178_()) {
            position = position.m_7494_();
        }
        while (position.m_123342_() > 1 && this.f_19853_.m_46859_(position)) {
            position = position.m_7495_();
        }
        return position;
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        this.deathRotation = this.m_146908_();
        super.m_6667_(pCause);
        this.setAnimationState(DEATH);
    }

    protected void m_6153_() {
        Level level;
        ++this.deathTime;
        if (this.deathTime >= MathHelper.secondsToTicks(2.5f) && this.deathTime < MathHelper.secondsToTicks(6) && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 8; ++i) {
                serverLevel.m_8767_((ParticleOptions)new MagicSmokeParticle.Option(0, 0, this.f_19853_.m_213780_().m_216332_(40, 80), 0.25f), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0, this.f_19853_.m_213780_().m_188499_() ? 0.01 : -0.01, 0.1, this.f_19853_.m_213780_().m_188499_() ? 0.01 : -0.01, 0.5);
            }
        }
        if (this.deathTime == 32) {
            this.m_5496_((SoundEvent)ModSounds.OBSIDIAN_CLAYMORE_SMASH.get(), 2.0f, 1.0f);
        }
        if (this.deathTime >= MathHelper.secondsToTicks(7.5f)) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        this.m_146922_(this.deathRotation);
        this.m_5618_(this.deathRotation);
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_)) {
            if (this.getVoidShrine() != null) {
                try {
                    this.getVoidShrine().getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(handler -> {
                        ItemStack itemStack = handler.getStackInSlot(0);
                        if (itemStack.m_41619_()) {
                            handler.insertItem(0, new ItemStack((ItemLike)ModItems.SHROUDED_BLUEPRINT.get()), false);
                        }
                    });
                }
                catch (NullPointerException exception) {
                    ItemEntity itementity = this.m_19998_((ItemLike)ModItems.SHROUDED_BLUEPRINT.get());
                    if (itementity != null) {
                        itementity.m_146915_(true);
                        itementity.m_32064_();
                    }
                }
            } else {
                ItemEntity itementity = this.m_19998_((ItemLike)ModItems.SHROUDED_BLUEPRINT.get());
                if (itementity != null) {
                    itementity.m_146915_(true);
                    itementity.m_32064_();
                }
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ % 5 == 0) {
            this.bossInfo.update();
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.m_21224_()) {
            this.m_146922_(this.deathRotation);
            this.m_5618_(this.deathRotation);
        }
        MiscCapHelper.updateMobTarget((Mob)this);
        if (this.f_19853_.f_46443_) {
            this.idleAnimationState.m_246184_(!this.f_267362_.m_267780_() && this.isCurrentAnimation(IDLE) && !this.m_21224_(), this.f_19797_);
            if (this.shakeSword > 0) {
                --this.shakeSword;
            }
            if (!this.m_21224_() && !this.isHiding()) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20187_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        Vec3 vector3d = this.m_20184_();
        if (!this.m_20096_() && vector3d.f_82480_ < 0.0 && !this.m_20068_()) {
            this.m_20256_(vector3d.m_82542_(1.0, 0.6, 1.0));
        }
        if (this.getVoidShrine() != null) {
            try {
                this.getVoidShrine().setCoolTick(0);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        if (this.swingCool > 0) {
            --this.swingCool;
        }
        if (this.swingComboCool > 0) {
            --this.swingComboCool;
        }
        if (this.rapidSwingCool > 0) {
            --this.rapidSwingCool;
        }
        if (this.chargeCool > 0) {
            --this.chargeCool;
        }
        if (this.spell1Cool > 0) {
            --this.spell1Cool;
        }
        if (this.spell2Cool > 0) {
            --this.spell2Cool;
        }
        if (this.spell3Cool > 0) {
            --this.spell3Cool;
        }
        if (this.lifeStealCool > 0) {
            --this.lifeStealCool;
        }
        if (this.groundPoundCool > 0) {
            --this.groundPoundCool;
        }
        if (this.backAwayCool > 0) {
            --this.backAwayCool;
        }
        if (this.slicingCool > 0) {
            --this.slicingCool;
        }
        if (!this.f_19853_.f_46443_) {
            Level blockPos1;
            BlockPos blockPos;
            if (this.getBoundPos() == null && (this.f_19797_ % 100 == 0 || this.lastSafePosition == null) && (blockPos = this.getSafeGround()).m_123342_() > 1) {
                this.lastSafePosition = blockPos;
            }
            if (this.m_20186_() <= (double)this.f_19853_.m_141937_()) {
                blockPos = null;
                if (this.getBoundPos() != null) {
                    blockPos = this.getBoundPos();
                } else if (this.lastSafePosition != null) {
                    blockPos = this.lastSafePosition;
                }
                if (blockPos != null) {
                    this.ownedTeleport(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
                }
            }
            float damage = (float)this.m_21133_(Attributes.f_22281_);
            this.attackTick = this.isAttacking() ? ++this.attackTick : 0;
            if (this.isCurrentAnimation(SWING)) {
                if (this.attackTick == 13) {
                    this.m_5496_((SoundEvent)ModSounds.OBSIDIAN_CLAYMORE_SWING.get(), 2.0f, this.m_6100_());
                }
                if (this.attackTick == 18) {
                    CameraShake.cameraShake(this.f_19853_, this.m_20182_(), 15.0f, 0.1f, 0, 10);
                    this.pushOn(1.35f, 1.35f);
                    this.areaAttack(6.5f, 6.0f, 90.0f, damage, 60, false);
                }
            }
            if (this.isCurrentAnimation(SWING_COMBO)) {
                if (this.attackTick == 13 || this.attackTick == 31) {
                    this.m_5496_((SoundEvent)ModSounds.OBSIDIAN_CLAYMORE_SWING.get(), 2.0f, this.m_6100_());
                }
                if (this.attackTick == 18 || this.attackTick == 34) {
                    CameraShake.cameraShake(this.f_19853_, this.m_20182_(), 15.0f, 0.1f, 0, 10);
                    this.pushOn(1.35f, 1.35f);
                    this.areaAttack(6.5f, 6.0f, 90.0f, damage, 60, false);
                }
            }
            if (this.isCurrentAnimation(SWING_COMBO_TRIPLE)) {
                if (this.attackTick == 13 || this.attackTick == 31 || this.attackTick == 52) {
                    this.m_5496_((SoundEvent)ModSounds.OBSIDIAN_CLAYMORE_SWING.get(), 2.0f, this.m_6100_());
                }
                if (this.attackTick == 18 || this.attackTick == 34) {
                    CameraShake.cameraShake(this.f_19853_, this.m_20182_(), 15.0f, 0.1f, 0, 10);
                    this.pushOn(1.35f, 1.35f);
                    this.areaAttack(6.5f, 6.0f, 90.0f, damage, 60, false);
                }
                if (this.attackTick == 56) {
                    CameraShake.cameraShake(this.f_19853_, this.m_20182_(), 15.0f, 0.1f, 0, 10);
                    this.areaAttack(6.5f, 8.0f, 100.0f, damage, 100, false);
                    this.m_5496_((SoundEvent)ModSounds.OBSIDIAN_CLAYMORE_SMASH.get(), 3.0f, this.m_6100_() * 0.5f);
                }
                for (int i = 56; i < 66; ++i) {
                    if (this.attackTick != i) continue;
                    int l = i - 56;
                    this.outwardTremor(l, 0.0f, damage);
                    this.outwardTremor(l, 0.5f, damage);
                    this.outwardTremor(l, -0.5f, damage);
                    if (l >= 1) {
                        this.outwardTremor(l, 1.5f, damage);
                        this.outwardTremor(l, -1.5f, damage);
                    }
                    if (l >= 2) {
                        this.outwardTremor(l, 2.5f, damage);
                        this.outwardTremor(l, -2.5f, damage);
                    }
                    if (l >= 3) {
                        this.outwardTremor(l, 3.5f, damage);
                        this.outwardTremor(l, -3.5f, damage);
                    }
                    if (l >= 4) {
                        this.outwardTremor(l, 4.5f, damage);
                        this.outwardTremor(l, -4.5f, damage);
                    }
                    if (l >= 5) {
                        this.outwardTremor(l, 5.5f, damage);
                        this.outwardTremor(l, -5.5f, damage);
                    }
                    if (l >= 6) {
                        this.outwardTremor(l, 6.5f, damage);
                        this.outwardTremor(l, -6.5f, damage);
                    }
                    if (l < 7) continue;
                    this.outwardTremor(l, 7.5f, damage);
                    this.outwardTremor(l, -7.5f, damage);
                }
            }
            if (this.isCurrentAnimation(RAPID_SWING)) {
                if ((this.attackTick - 3) % 7 == 0 && this.attackTick < 39) {
                    this.m_5496_((SoundEvent)ModSounds.OBSIDIAN_CLAYMORE_SWING.get(), 2.0f, this.m_6100_());
                }
                if (this.attackTick >= 13 && this.attackTick < 54) {
                    if (this.m_5448_() != null) {
                        this.m_21391_((Entity)this.m_5448_(), 100.0f, 100.0f);
                        this.m_21563_().m_24960_((Entity)this.m_5448_(), 100.0f, 100.0f);
                    }
                    if (this.attackTick == 15 || this.attackTick == 21 || this.attackTick == 27 || this.attackTick == 33 || this.attackTick == 39 || this.attackTick == 45 || this.attackTick == 51) {
                        this.areaAttack(6.5f, 6.0f, 120.0f, damage, 60, false);
                        VoidSlash voidSlash = new VoidSlash(this.f_19853_, (LivingEntity)this);
                        voidSlash.m_146884_(this.m_146892_());
                        voidSlash.slash(this.m_20154_(), 1.0);
                        voidSlash.setDamage(damage);
                        this.f_19853_.m_7967_((Entity)voidSlash);
                    }
                }
            }
            if (this.isCurrentAnimation(CHARGE)) {
                if (this.attackTick == 18) {
                    ModNetwork.sentToTrackingEntityAndPlayer((Entity)this, new SPlayFollowSoundPacket((Entity)this, (SoundEvent)ModSounds.VHOE_CHARGE.get(), 3.0f, this.m_6100_(), false));
                    float f1 = (float)Math.cos(Math.toRadians(this.m_146908_() + 90.0f));
                    float f2 = (float)Math.sin(Math.toRadians(this.m_146908_() + 90.0f));
                    if (this.m_5448_() != null) {
                        float r = this.m_20270_((Entity)this.m_5448_());
                        r = Mth.m_14036_((float)r, (float)0.0f, (float)10.0f);
                        this.m_5997_(f1 * 0.9f * r, 0.0, f2 * 0.9f * r);
                    } else {
                        this.m_5997_(f1 * 3.0f, 0.0, f2 * 3.0f);
                    }
                }
                if (this.attackTick >= 18 && this.attackTick < 27) {
                    Level f2 = this.f_19853_;
                    if (f2 instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)f2;
                        int width = serverLevel.m_213780_().m_216332_(1, 4);
                        float height = serverLevel.m_213780_().m_188501_() * 0.5f;
                        Vec3 vec3 = this.m_146892_().m_272010_(serverLevel.m_213780_(), 2.0f);
                        Vec3 angle = this.m_20154_();
                        serverLevel.m_8767_((ParticleOptions)new WindBlowParticle.Option(new ColorUtil(ChatFormatting.LIGHT_PURPLE), width, height), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0, angle.f_82479_, angle.f_82480_, angle.f_82481_, 1.0);
                    }
                    for (LivingEntity entityHit : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(1.2))) {
                        if (MobUtil.areAllies((Entity)this, (Entity)entityHit)) continue;
                        boolean flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage + entityHit.m_21233_() * ((Double)AttributesConfig.EnderKeeperHPPercentDamage.get()).floatValue());
                        if (entityHit.m_21275_(this.m_269291_().m_269333_((LivingEntity)this))) {
                            MobUtil.disableShield(entityHit, 100);
                        }
                        if (!flag) continue;
                        this.applyVoidTouched((Entity)entityHit);
                        double d0 = entityHit.m_20185_() - this.m_20185_();
                        double d1 = entityHit.m_20189_() - this.m_20189_();
                        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                        entityHit.m_5997_(d0 / d2 * 2.5, 0.18, d1 / d2 * 2.2);
                    }
                }
            }
            if (this.isCurrentAnimation(SPELL_1)) {
                if (this.attackTick >= 10 && this.attackTick < 35) {
                    int tickRate;
                    int n = tickRate = MobUtil.healthIsHalved((LivingEntity)this) ? 2 : 5;
                    if (this.attackTick % tickRate == 0) {
                        VoidShock voidShock = new VoidShock((LivingEntity)this, this.m_5448_(), this.f_19853_);
                        voidShock.m_146884_(this.m_20182_().m_82520_((double)this.f_19853_.m_213780_().m_216339_(-3, 3), 4.0, (double)this.f_19853_.m_213780_().m_216339_(-3, 3)));
                        voidShock.setPower(Vec3.f_82478_, 10);
                        voidShock.setBaseDamage(damage);
                        this.f_19853_.m_7967_((Entity)voidShock);
                        this.m_5496_((SoundEvent)ModSounds.TELEPORT_ORB_THROW.get(), 2.0f, this.m_6100_());
                    }
                }
                if (this.attackTick % 10 == 0 && this.attackTick < 35) {
                    this.m_5496_((SoundEvent)ModSounds.SWIRLINGS.get(), 1.5f, this.m_6100_() - 0.25f);
                }
            }
            if (this.isCurrentAnimation(SPELL_2)) {
                Level voidShock;
                if (this.attackTick > 10 && this.attackTick <= 28 && (voidShock = this.f_19853_) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)voidShock;
                    ColorUtil colorUtil = new ColorUtil(ChatFormatting.DARK_PURPLE);
                    ServerParticleUtil.gatheringParticles(new GatherTrailParticle.Option(colorUtil, this.m_20182_().m_82520_(0.0, 8.0, 0.0)), (Entity)this, serverLevel, 2);
                }
                if (this.attackTick == 43) {
                    VoidShockBomb voidShock2 = new VoidShockBomb((LivingEntity)this, this.f_19853_);
                    voidShock2.m_146884_(this.m_20182_().m_82520_(0.0, 6.0, 0.0));
                    voidShock2.setBaseDamage(damage);
                    voidShock2.m_37251_((Entity)this, this.m_146909_(), this.m_146908_(), 0.0f, 1.0f, 1.0f);
                    this.f_19853_.m_7967_((Entity)voidShock2);
                    this.m_5496_((SoundEvent)ModSounds.HEAVY_WOOSH.get(), 3.0f, this.m_6100_());
                    this.m_5496_((SoundEvent)ModSounds.TELEPORT_ORB_THROW.get(), 3.0f, this.m_6100_() - 0.5f);
                    if (MobUtil.healthIsHalved((LivingEntity)this)) {
                        for (int i = 0; i < 2; ++i) {
                            VoidShockBomb voidShock22 = new VoidShockBomb((LivingEntity)this, this.f_19853_);
                            voidShock22.m_146884_(this.m_20182_().m_82520_(0.0, 6.0, 0.0));
                            voidShock22.setBaseDamage(damage);
                            voidShock22.m_37251_((Entity)this, this.m_146909_(), this.m_146908_(), 0.0f, 0.5f + this.f_19853_.m_213780_().m_188501_(), 8.0f);
                            this.f_19853_.m_7967_((Entity)voidShock22);
                        }
                    }
                }
            }
            if (this.isCurrentAnimation(SPELL_3) && this.attackTick >= 20 && this.attackTick < 60) {
                int amount = MobUtil.healthIsHalved((LivingEntity)this) ? 2 : 1;
                for (int i = 0; i < amount; ++i) {
                    BlockPos blockPos2 = this.m_20183_();
                    if (this.attackTick < 40 && this.m_5448_() != null) {
                        blockPos2 = this.m_5448_().m_20183_();
                    }
                    blockPos1 = blockPos2.m_7918_(this.f_19853_.m_213780_().m_216339_(-16, 16), 0, this.f_19853_.m_213780_().m_216339_(-16, 16));
                    BlockPos blockPos22 = blockPos2.m_7918_(this.f_19853_.m_213780_().m_216339_(-16, 16), 0, this.f_19853_.m_213780_().m_216339_(-16, 16));
                    Vec3 vec3 = Vec3.m_82539_((Vec3i)blockPos1);
                    Vec3 vec32 = Vec3.m_82539_((Vec3i)blockPos22);
                    VoidLightningTrap trap = new VoidLightningTrap(this.f_19853_, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                    trap.setOwner((LivingEntity)this);
                    trap.setDuration(40);
                    if (!this.f_19853_.m_45976_(VoidLightningTrap.class, new AABB((BlockPos)blockPos1)).isEmpty()) {
                        trap.m_6034_(vec32.m_7096_(), vec32.m_7098_(), vec32.m_7094_());
                    }
                    MobUtil.moveDownToGround(trap);
                    this.f_19853_.m_7967_((Entity)trap);
                }
            }
            if (this.isCurrentAnimation(LIFE_STEAL)) {
                Level livingEntity2;
                ColorUtil colorUtil;
                double radius = this.m_20191_().m_82309_() * 2.0;
                if (this.attackTick < 40 && (blockPos1 = this.f_19853_) instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)blockPos1;
                    ServerParticleUtil.gatheringParticles((ParticleOptions)ParticleTypes.f_123760_, (Entity)this, serverWorld, 20);
                }
                if (this.attackTick == 40) {
                    this.m_5496_((SoundEvent)ModSounds.VHOE_PINWHEEL.get(), 2.0f, 0.75f);
                }
                if (this.attackTick == 60 && (blockPos1 = this.f_19853_) instanceof ServerLevel) {
                    ServerLevel serverWorld = (ServerLevel)blockPos1;
                    colorUtil = new ColorUtil(ChatFormatting.LIGHT_PURPLE);
                    serverWorld.m_8767_((ParticleOptions)new AoEParticleOption(0.0f, 0.06666667f, 4.0f, 60), this.m_20185_(), this.m_20186_() + (double)0.1f, this.m_20189_(), 0, (double)colorUtil.red, (double)colorUtil.green, (double)colorUtil.blue, 1.0);
                }
                if (this.attackTick >= 40 && this.attackTick < 120) {
                    this.f_19853_.m_7605_((Entity)this, (byte)6);
                    colorUtil = this.f_19853_;
                    if (colorUtil instanceof ServerLevel) {
                        ServerLevel serverWorld = (ServerLevel)colorUtil;
                        colorUtil = new ColorUtil(ChatFormatting.LIGHT_PURPLE);
                        ServerParticleUtil.gatheringParticles(new GatherTrailParticle.Option(colorUtil, this.m_20182_().m_82520_(0.0, 1.0, 0.0)), (Entity)this, serverWorld, 4);
                        ServerParticleUtil.windParticle(serverWorld, colorUtil, (float)radius, 1.0f, this.m_19879_(), this.m_20182_());
                        ServerParticleUtil.gatheringParticles((ParticleOptions)ParticleTypes.f_123760_, (Entity)this, serverWorld, 20);
                        if (this.attackTick % 5 == 0) {
                            serverWorld.m_8767_((ParticleOptions)new ReverseShockwaveParticleOption(colorUtil, 20.0f, 1.0f, 0, true), this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.5);
                        }
                    }
                    for (Level livingEntity2 : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82400_(20.0))) {
                        if (MobUtil.areAllies((Entity)this, (Entity)livingEntity2) || !EntitySelector.f_20406_.test(livingEntity2) || !livingEntity2.m_6084_()) continue;
                        Vec3 vec30 = this.m_20182_().m_82546_(livingEntity2.m_20182_());
                        vec30 = vec30.m_82541_();
                        double scale = (double)(this.attackTick - 40) / 80.0;
                        vec30 = vec30.m_82490_(scale);
                        vec30 = vec30.m_82490_(0.2);
                        Vec3 add = livingEntity2.m_20184_().m_82549_(vec30);
                        MobUtil.drag((Entity)livingEntity2, add.f_82479_, add.f_82480_, add.f_82481_);
                        if (!((double)this.m_20270_((Entity)livingEntity2) < radius)) continue;
                        float lifeSteal = (livingEntity2.m_21233_() - livingEntity2.m_21223_()) * 0.25f + 1.0f;
                        if (livingEntity2.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this), lifeSteal)) {
                            Level level = this.f_19853_;
                            if (level instanceof ServerLevel) {
                                ServerLevel serverLevel = (ServerLevel)level;
                                ColorUtil colorUtil2 = new ColorUtil(ChatFormatting.DARK_PURPLE);
                                Vec3 vec3 = new Vec3(livingEntity2.m_20208_(1.0), livingEntity2.m_20187_(), livingEntity2.m_20262_(1.0));
                                Vec3 vector3d1 = new Vec3(this.m_20208_(1.0), this.m_20188_(), this.m_20262_(1.0));
                                serverLevel.m_8767_((ParticleOptions)new GatherTrailParticle.Option(colorUtil2, vector3d1), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 0, 0.0, 0.0, 0.0, 0.5);
                                serverLevel.m_8767_((ParticleOptions)new AbsorbTrailParticleOption(vector3d1, 0xAA00AA, 10), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                            }
                            this.m_5634_(lifeSteal);
                            this.m_5496_((SoundEvent)ModSounds.SOUL_EAT.get(), 2.0f, 1.0f);
                        }
                        Vec3 vec3 = vec30.m_82548_();
                        vec3 = vec3.m_82541_();
                        vec3 = vec3.m_82490_(2.0);
                        MobUtil.drag((Entity)livingEntity2, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                    }
                }
                if (this.attackTick == 114) {
                    this.m_5496_((SoundEvent)ModSounds.OBSIDIAN_CLAYMORE_SWING.get(), 2.0f, this.m_6100_());
                }
                if (this.attackTick == 119) {
                    CameraShake.cameraShake(this.f_19853_, this.m_20182_(), 15.0f, 0.1f, 0, 10);
                    this.areaAttack(6.5f, 6.0f, 90.0f, damage, 60, false);
                }
                if (this.attackTick == 120 && (livingEntity2 = this.f_19853_) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)livingEntity2;
                    new SpellExplosion((Level)serverLevel, (Entity)this, this.m_269291_().m_269104_((Entity)this, (Entity)this), this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, damage){

                        @Override
                        public void explodeHurt(Entity target, DamageSource damageSource, double x, double y, double z, double seen, float actualDamage) {
                            LivingEntity livingEntity;
                            super.explodeHurt(target, damageSource, x, y, z, seen, actualDamage);
                            if (EntitySelector.f_20406_.test(target) && target instanceof LivingEntity && !(livingEntity = (LivingEntity)target).m_21023_((MobEffect)GoetyEffects.VOID_TOUCHED.get())) {
                                livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.VOID_TOUCHED.get(), MathHelper.secondsToTicks(3), 2, false, true));
                            }
                        }
                    };
                    colorUtil = new ColorUtil(11600856);
                    serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 4.0f, 1), this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 8.0f, 1), this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.m_8767_((ParticleOptions)new VerticalCircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 4.0f, 1), this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    serverLevel.m_8767_((ParticleOptions)new VerticalCircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, 8.0f, 1), this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    DustCloudParticleOption cloudParticleOptions = new DustCloudParticleOption(new Vector3f((Vector3fc)Vec3.m_82501_((int)0xFF55FF).m_252839_()), 1.0f);
                    for (int i = 0; i < 2; ++i) {
                        ServerParticleUtil.circularParticles(serverLevel, (ParticleOptions)cloudParticleOptions, this.m_20185_(), this.m_20186_() + 0.25, this.m_20189_(), 0.0, 0.14, 0.0, 3.5f);
                    }
                    this.m_5496_((SoundEvent)ModSounds.FUNGUS_EXPLOSION.get(), 3.0f, 0.6f + serverLevel.m_213780_().m_188501_() * 0.4f);
                }
            }
            if (this.isCurrentAnimation(GROUND_POUND) || this.isCurrentAnimation(GROUND_POUND_SPIN)) {
                if (this.hidingTime >= 10) {
                    this.stopHide();
                    this.m_5496_((SoundEvent)ModSounds.OBSIDIAN_CLAYMORE_SMASH.get(), 2.0f, this.m_6100_());
                }
                if (this.attackTick == 5) {
                    Level i = this.f_19853_;
                    if (i instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)i;
                        ColorUtil colorUtil = new ColorUtil(ChatFormatting.DARK_PURPLE);
                        serverLevel.m_8767_((ParticleOptions)new CircleExplodeParticleOption(colorUtil.red, colorUtil.green, colorUtil.blue, this.groundPoundSize, 1), this.m_20185_(), BlockFinder.moveDownToGround((Entity)this), this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    CameraShake.cameraShake(this.f_19853_, this.m_20182_(), 25.0f, 0.2f, 0, 20);
                }
                for (int i = 5; i < 5 + this.groundPoundSize; ++i) {
                    if (this.attackTick != i) continue;
                    this.surroundTremor(i - 5, 3.0, 0.0f, damage);
                }
                if (this.isCurrentAnimation(GROUND_POUND_SPIN)) {
                    if (this.attackTick == 33) {
                        this.pushOn(3.0f, 3.0f);
                    }
                    if (this.attackTick == 38) {
                        this.m_5496_((SoundEvent)ModSounds.SWIRLINGS.get(), 2.0f, this.m_6100_() - 0.25f);
                    }
                    if (this.attackTick >= 38 && this.attackTick < 58) {
                        Level colorUtil = this.f_19853_;
                        if (colorUtil instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)colorUtil;
                            serverLevel.m_8767_((ParticleOptions)new WindParticleOption(new ColorUtil(ChatFormatting.DARK_PURPLE), 4.5f, 1.5f, this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
                            serverLevel.m_8767_((ParticleOptions)new WindParticleOption(new ColorUtil(ChatFormatting.DARK_PURPLE), 6.0f, 1.0f, this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
                            serverLevel.m_8767_((ParticleOptions)new WindParticleOption(new ColorUtil(ChatFormatting.DARK_PURPLE), 4.5f, 0.5f, this.m_19879_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 1, 0.0, 0.0, 0.0, 1.0);
                        }
                        for (LivingEntity entityHit : this.f_19853_.m_45976_(LivingEntity.class, this.m_20191_().m_82377_(6.0, 0.0, 6.0))) {
                            if (MobUtil.areAllies((Entity)this, (Entity)entityHit)) continue;
                            boolean flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage + entityHit.m_21233_() * ((Double)AttributesConfig.EnderKeeperHPPercentDamage.get()).floatValue());
                            if (entityHit.m_21275_(this.m_269291_().m_269333_((LivingEntity)this))) {
                                MobUtil.disableShield(entityHit, 100);
                            }
                            if (!flag) continue;
                            this.applyVoidTouched((Entity)entityHit);
                            double d0 = entityHit.m_20185_() - this.m_20185_();
                            double d1 = entityHit.m_20189_() - this.m_20189_();
                            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                            entityHit.m_5997_(d0 / d2 * 2.5, 0.18, d1 / d2 * 2.2);
                        }
                    }
                }
            }
            if (this.isCurrentAnimation(BACK_AWAY) && this.attackTick == 2) {
                float speed = -2.5f;
                float dodgeYaw = (float)Math.toRadians(this.m_146908_() + 90.0f);
                Vec3 vec3 = this.m_20184_().m_82520_((double)speed * Math.cos(dodgeYaw), 0.0, (double)speed * Math.sin(dodgeYaw));
                this.m_5496_(SoundEvents.f_12313_, 2.0f, 1.0f);
                this.m_20334_(vec3.f_82479_, 0.4f, vec3.f_82481_);
            }
            if (this.isCurrentAnimation(SLICE_START)) {
                int hideTime;
                int n = hideTime = MobUtil.healthIsHalved((LivingEntity)this) ? 20 : 40;
                if (this.m_5448_() == null || this.m_5448_().m_21224_()) {
                    this.stopHide();
                    this.setAnimationState(IDLE);
                } else if (this.hidingTime >= hideTime) {
                    this.stopHide();
                    this.setAnimationState(SLICE_1);
                }
            }
            if (this.isCurrentAnimation(SLICE_1) || this.isCurrentAnimation(SLICE_2)) {
                if (this.attackTick == 1) {
                    this.m_5496_((SoundEvent)ModSounds.OBSIDIAN_CLAYMORE_WINDUP.get(), 2.0f, this.m_6100_());
                }
                if (this.attackTick == 5) {
                    this.m_5496_((SoundEvent)ModSounds.OBSIDIAN_CLAYMORE_SWING.get(), 2.0f, this.m_6100_());
                }
                if (this.attackTick == 10) {
                    float pushPower = MobUtil.healthIsHalved((LivingEntity)this) ? 3.0f : 1.35f;
                    this.pushOn(pushPower, pushPower);
                    this.areaAttack(6.5f, 5.0f, 90.0f, damage, 60, false);
                }
                if (this.attackTick >= 24) {
                    this.startHide();
                    if (this.m_5448_() != null) {
                        this.teleportTowards((Entity)this.m_5448_(), 2.0);
                    }
                }
                if (this.m_5448_() == null || this.m_5448_().m_21224_()) {
                    this.stopHide();
                    this.setAnimationState(IDLE);
                }
            }
        }
        if (this.m_5448_() != null) {
            this.m_5448_().m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.PLUNGE.get(), 5, 0, false, false));
            LivingEntity livingEntity = this.m_5448_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.m_150110_().f_35935_ &= player.m_7500_();
            }
        }
    }

    @Override
    public void m_6710_(@Nullable LivingEntity p_21544_) {
        this.normalSetTarget(p_21544_);
    }

    @Override
    public void servantTick() {
        if (this.isGuardingArea() && this.m_20238_(this.vec3BoundPos()) > (double)Mth.m_14207_((float)64.0f) && this.m_5448_() == null) {
            Vec3 vec3 = this.vec3BoundPos();
            this.teleportOut();
            if (this.ownedTeleport(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_)) {
                this.teleportIn();
            }
        }
    }

    public void areaAttack(float range, float height, float arc, float damage, int shieldBreak, boolean knockback) {
        MobUtil.areaAttack((LivingEntity)this, range, height, arc, damage, ((Double)AttributesConfig.EnderKeeperHPPercentDamage.get()).floatValue(), shieldBreak, this.m_269291_().m_269333_((LivingEntity)this), knockback, this::applyVoidTouched);
    }

    public void applyVoidTouched(Entity entity) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && !(livingEntity = (LivingEntity)entity).m_21023_((MobEffect)GoetyEffects.VOID_TOUCHED.get())) {
            livingEntity.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.VOID_TOUCHED.get(), MathHelper.secondsToTicks(5), 1, false, true));
        }
    }

    public void surroundTremor(int distance, double topY, float side, float damage) {
        int hitY = Mth.m_14107_((double)(this.m_20191_().f_82289_ - 0.5));
        double spread = Math.PI * 2;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        double minY = this.m_20186_() - 1.0;
        double maxY = this.m_20186_() + topY;
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = this.m_20185_() + vx * (double)distance + (double)side * Math.cos((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0);
            double pz = this.m_20189_() + vz * (double)distance + (double)side * Math.sin((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0);
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            BlockPos blockPos = new BlockPos(hitX, hitY, hitZ);
            BlockState blockState = this.f_19853_.m_8055_(blockPos);
            while (blockState.m_60799_() != RenderShape.MODEL) {
                blockPos = blockPos.m_7495_();
                blockState = this.f_19853_.m_8055_(blockPos);
            }
            BlockState blockAbove = this.f_19853_.m_8055_(blockPos.m_7494_());
            if (blockState != Blocks.f_50016_.m_49966_() && !blockState.m_155947_() && !blockAbove.m_280555_()) {
                ModFallingBlock fallingBlock = new ModFallingBlock(this.f_19853_, Vec3.m_82512_((Vec3i)blockPos.m_7494_()), blockState, (float)(0.2 + this.m_217043_().m_188583_() * 0.15));
                this.f_19853_.m_7967_((Entity)fallingBlock);
            }
            AABB selection = new AABB(px - 0.5, minY, pz - 0.5, px + 0.5, maxY, pz + 0.5);
            List entities = this.f_19853_.m_45976_(LivingEntity.class, selection);
            for (LivingEntity target : entities) {
                boolean flag;
                if (MobUtil.areAllies((Entity)target, (Entity)this) || target == this || !(flag = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage + target.m_21233_() * ((Double)AttributesConfig.EnderKeeperHPPercentDamage.get()).floatValue()))) continue;
                this.applyVoidTouched((Entity)target);
                double d0 = target.m_20185_() - this.m_20185_();
                double d1 = target.m_20189_() - this.m_20189_();
                double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                target.m_5997_(d0 / d2 * 2.5, 0.18, d1 / d2 * 2.2);
            }
        }
    }

    private void outwardTremor(int distance, float math, float damage) {
        int hitY = Mth.m_14107_((double)(this.m_20191_().f_82289_ - 0.5));
        double minY = this.m_20186_() - 2.0;
        double maxY = this.m_20186_() + 3.0;
        float angle = (float)Math.PI / 180 * this.f_20883_;
        float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
        double extraX = (float)distance * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = (float)distance * Mth.m_14089_((float)angle);
        double px = this.m_20185_() + extraX + (double)(f * math);
        double pz = this.m_20189_() + extraZ + (double)(f1 * math);
        int hitX = Mth.m_14107_((double)px);
        int hitZ = Mth.m_14107_((double)pz);
        BlockPos pos = new BlockPos(hitX, hitY, hitZ);
        BlockState block = this.m_9236_().m_8055_(pos);
        int maxDepth = 30;
        for (int depthCount = 0; depthCount < maxDepth && block.m_60799_() != RenderShape.MODEL; ++depthCount) {
            pos = pos.m_7495_();
            block = this.m_9236_().m_8055_(pos);
        }
        if (block.m_60799_() != RenderShape.MODEL) {
            block = Blocks.f_50016_.m_49966_();
        }
        if (!this.m_9236_().f_46443_) {
            ModFallingBlock fallingBlockEntity = new ModFallingBlock(this.m_9236_(), (double)hitX + 0.5, (double)hitY + 1.0, (double)hitZ + 0.5, block, 10);
            fallingBlockEntity.m_5997_(0.0, 0.2 + this.m_217043_().m_188583_() * 0.15, 0.0);
            this.m_9236_().m_7967_((Entity)fallingBlockEntity);
            AABB selection = new AABB(px - 0.5, minY, pz - 0.5, px + 0.5, maxY, pz + 0.5);
            List hit = this.m_9236_().m_45976_(LivingEntity.class, selection);
            for (LivingEntity target : hit) {
                boolean flag;
                if (MobUtil.areAllies((Entity)target, (Entity)this) || target == this || !(flag = target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage + target.m_21233_() * ((Double)AttributesConfig.EnderKeeperHPPercentDamage.get()).floatValue()))) continue;
                this.applyVoidTouched((Entity)target);
                double d0 = target.m_20185_() - this.m_20185_();
                double d1 = target.m_20189_() - this.m_20189_();
                double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                target.m_5997_(d0 / d2 * 2.5, 0.18, d1 / d2 * 2.2);
            }
        }
    }

    @Override
    public void hidingTick() {
        if (!this.isHiding()) {
            this.hidingTime = 0;
        } else {
            ++this.hidingTime;
            this.m_21573_().m_26573_();
            this.m_21566_().m_24988_(0.0f, 0.0f);
            if (this.m_5448_() == null || this.m_5448_().m_21224_()) {
                this.stopHide();
            }
        }
    }

    public void pushOn(float powerX, float powerZ) {
        float f1 = (float)Math.cos(Math.toRadians(this.m_146908_() + 90.0f));
        float f2 = (float)Math.sin(Math.toRadians(this.m_146908_() + 90.0f));
        this.m_5997_(f1 * powerX, 0.0, f2 * powerZ);
    }

    public Vec3 getHorizontalLookAngle() {
        return this.m_20171_(0.0f, this.m_146908_());
    }

    public double m_142593_(LivingEntity livingEntity) {
        return Mth.m_144952_((double)6.0);
    }

    public boolean m_217066_(LivingEntity livingentity) {
        double d0 = this.m_20275_(livingentity.m_20185_(), livingentity.m_20186_(), livingentity.m_20189_());
        return d0 <= this.m_142593_(livingentity);
    }

    @Override
    public void stopHide() {
        if (this.isHiding()) {
            this.teleportIn();
        }
        super.stopHide();
        this.m_6210_();
    }

    @Override
    public boolean ownedTeleport(double x, double y, double z) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos(x, y, z);
        while (blockpos$mutableblockpos.m_123342_() > this.m_9236_().m_141937_() && !this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos).m_280555_()) {
            blockpos$mutableblockpos.m_122173_(Direction.DOWN);
        }
        BlockState blockstate = this.m_9236_().m_8055_((BlockPos)blockpos$mutableblockpos);
        boolean flag = blockstate.m_280555_();
        boolean flag1 = blockstate.m_60819_().m_205070_(FluidTags.f_13131_);
        if (flag && !flag1) {
            EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z);
            if (event.isCanceled()) {
                return false;
            }
            Vec3 vec3 = this.m_20182_();
            boolean flag2 = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), false);
            if (flag2) {
                if (!this.f_19853_.f_46443_) {
                    ModNetwork.sendToALL(new SRepositionPacket(this.m_19879_(), this.m_20185_(), this.m_20186_(), this.m_20189_()));
                }
                this.f_19853_.m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)this));
            }
            return flag2;
        }
        return false;
    }

    @Override
    public void teleportTowards(Entity entity, double range) {
        if (!this.f_19853_.m_5776_() && this.m_6084_()) {
            if (entity == null) {
                return;
            }
            try {
                for (int i = 0; i < 128; ++i) {
                    double d3;
                    double d2;
                    int range2 = Mth.m_14107_((double)range);
                    double d1 = entity.m_20185_() + (double)this.f_19853_.m_213780_().m_216332_(-range2, range2);
                    EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)d1, (double)(d2 = entity.m_20186_()), (double)(d3 = entity.m_20189_() + (double)this.f_19853_.m_213780_().m_216332_(-range2, range2)));
                    if (!event.isCanceled()) {
                        Vec3 vec3 = new Vec3(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                        if (this.f_19853_.m_45772_(this.m_20191_().m_82383_(vec3)) && !this.f_19853_.m_46855_(this.m_20191_().m_82383_(vec3))) {
                            this.m_6021_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                            MobUtil.instaLook((Mob)this, entity, true);
                        } else {
                            if (i != 127) continue;
                            MobUtil.instaLook((Mob)this, entity, true);
                        }
                    }
                    break;
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public void teleportIn() {
        super.teleportIn();
        if (!this.f_19853_.f_46443_) {
            ModNetwork.sendToALL(new SRepositionPacket(this.m_19879_(), this.m_20185_(), this.m_20186_(), this.m_20189_()));
        }
    }

    @Override
    public void m_7822_(byte pByte) {
        if (pByte == 6) {
            this.shakeSword = 5;
        } else {
            super.m_7822_(pByte);
        }
    }

    public static class KeeperAttackGoal
    extends Goal {
        protected final EnderKeeper entity;
        protected final int currentAttackType;
        protected final int attackType;
        protected final int attackEndType;
        protected final int attackMaxTick;
        protected final int attackSeeTick;
        protected final float attackOuterRange;
        protected final float attackRange;

        public KeeperAttackGoal(EnderKeeper entity, int currentAttackType, int attackType, int attackEndType, int attackMaxTick, int attackSeeTick, float attackOuterRange, float attackRange) {
            this.entity = entity;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.currentAttackType = currentAttackType;
            this.attackType = attackType;
            this.attackEndType = attackEndType;
            this.attackMaxTick = attackMaxTick;
            this.attackSeeTick = attackSeeTick;
            this.attackOuterRange = attackOuterRange;
            this.attackRange = attackRange;
        }

        public KeeperAttackGoal(EnderKeeper entity, String currentAttackType, String attackType, String attackEndType, int attackMaxTick, int attackSeeTick, float attackOuterRange, float attackRange) {
            this(entity, entity.getAnimationState(currentAttackType), entity.getAnimationState(attackType), entity.getAnimationState(attackEndType), attackMaxTick, attackSeeTick, attackOuterRange, attackRange);
        }

        public KeeperAttackGoal(EnderKeeper entity, String currentAttackType, String attackType, String attackEndType, int attackMaxTick, int attackSeeTick, float attackRange) {
            this(entity, entity.getAnimationState(currentAttackType), entity.getAnimationState(attackType), entity.getAnimationState(attackEndType), attackMaxTick, attackSeeTick, 0.0f, attackRange);
        }

        public boolean m_8036_() {
            LivingEntity target = this.entity.m_5448_();
            return target != null && target.m_6084_() && this.entity.m_20270_((Entity)target) < this.attackRange && this.entity.m_20270_((Entity)target) >= this.attackOuterRange && this.entity.getCurrentAnimation() == this.currentAttackType;
        }

        public void m_8056_() {
            this.entity.setAnimationState(this.attackType);
            this.entity.m_21573_().m_26573_();
        }

        public void m_8041_() {
            this.entity.setAnimationState(this.attackEndType);
            LivingEntity target = this.entity.m_5448_();
            if (!EntitySelector.f_20406_.test(target)) {
                this.entity.m_6710_(null);
            }
            this.entity.m_21573_().m_26573_();
            if (this.entity.m_5448_() == null) {
                this.entity.m_21561_(false);
            }
            this.entity.attackTick = 0;
        }

        public boolean m_8045_() {
            return this.entity.getCurrentAnimation() == this.attackType && this.entity.attackTick <= this.attackMaxTick;
        }

        public void m_8037_() {
            LivingEntity target = this.entity.m_5448_();
            if (this.entity.attackTick < this.attackSeeTick && target != null) {
                MobUtil.instaLook((Mob)this.entity, (Entity)target);
            } else {
                this.entity.m_146922_(this.entity.f_19859_);
            }
            this.entity.m_21573_().m_26573_();
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

