/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.entities.neutral;

import com.Polarice3.Goety.common.effects.brew.BrewEffectInstance;
import com.Polarice3.Goety.common.entities.hostile.cultists.Cultist;
import com.Polarice3.Goety.common.entities.hostile.cultists.SpellCastingCultist;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.BrewUtils;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ApostleShade
extends SpellCastingCultist {
    protected static final EntityDataAccessor<String> SHADE_MOOD = SynchedEntityData.m_135353_(ApostleShade.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static String PLEASED_MOOD = "Pleased";
    public static String IDLE_MOOD = "Idle";
    public static String MIFFED_MOOD = "Miffed";
    public UUID dealingPlayer;
    public int castingTime;
    public int checkTime;
    public int moodTime;

    public ApostleShade(EntityType<? extends SpellCastingCultist> type, Level p_i48551_2_) {
        super(type, p_i48551_2_);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 3.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 3.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHADE_MOOD, (Object)"Idle");
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128362_("DealingPlayer", this.dealingPlayer);
        compound.m_128405_("CheckTime", this.checkTime);
        compound.m_128405_("MoodTime", this.moodTime);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("DealingPlayer")) {
            this.dealingPlayer = compound.m_128342_("DealingPlayer");
        }
        if (compound.m_128441_("CheckTime")) {
            this.setCheckTime(compound.m_128451_("CheckTime"));
        }
        if (compound.m_128441_("MoodTime")) {
            this.setMoodTime(compound.m_128451_("MoodTime"));
        }
    }

    public boolean isPleased() {
        return ((String)this.f_19804_.m_135370_(SHADE_MOOD)).equals(PLEASED_MOOD);
    }

    public boolean isIdle() {
        return ((String)this.f_19804_.m_135370_(SHADE_MOOD)).equals(IDLE_MOOD);
    }

    public boolean isMiffed() {
        return ((String)this.f_19804_.m_135370_(SHADE_MOOD)).equals(MIFFED_MOOD);
    }

    public void setMood(String mood) {
        this.f_19804_.m_135381_(SHADE_MOOD, (Object)mood);
    }

    public boolean m_37882_() {
        return false;
    }

    @Override
    protected SoundEvent getCastingSoundEvent() {
        return (SoundEvent)ModSounds.APOSTLE_CAST_SPELL.get();
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() instanceof Player) {
            return super.m_6469_(source, 1.0f);
        }
        return source.m_269533_(DamageTypeTags.f_268738_);
    }

    public void m_6667_(DamageSource cause) {
        if (!this.f_19853_.f_46443_) {
            for (int i = 0; i < this.f_19853_.f_46441_.m_188503_(35) + 10; ++i) {
                ServerParticleUtil.smokeParticles((ParticleOptions)ParticleTypes.f_123755_, this.m_20185_(), this.m_20188_(), this.m_20189_(), this.f_19853_);
            }
        }
        this.m_146870_();
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource damageSource) {
        return false;
    }

    public boolean m_7301_(MobEffectInstance p_21197_) {
        return false;
    }

    @Override
    public Cultist.CultistArmPose getArmPose() {
        if (this.isSpellcasting()) {
            return Cultist.CultistArmPose.SPELLCASTING;
        }
        if (this.isChecking()) {
            return Cultist.CultistArmPose.ITEM;
        }
        return Cultist.CultistArmPose.CROSSED;
    }

    protected boolean m_7341_(Entity pEntity) {
        return false;
    }

    public Player getDealingPlayer() {
        if (this.dealingPlayer != null) {
            return this.f_19853_.m_46003_(this.dealingPlayer);
        }
        return null;
    }

    public void setDealingPlayer(Player player) {
        this.dealingPlayer = player.m_20148_();
    }

    public boolean isCoolDown() {
        return this.moodTime > 0;
    }

    public int getMoodTime() {
        return this.moodTime;
    }

    public void setMoodTime(int moodTime) {
        this.moodTime = moodTime;
    }

    public boolean isChecking() {
        return this.checkTime > 0;
    }

    public int getCheckTime() {
        return this.checkTime;
    }

    public void setCheckTime(int checkTime) {
        this.checkTime = checkTime;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_20256_(Vec3.f_82478_);
        if (this.castingTime > 0) {
            --this.castingTime;
        }
        if (this.getCheckTime() > 0) {
            --this.checkTime;
        }
        if (this.getMoodTime() > 0) {
            --this.moodTime;
        }
        if (this.f_19853_.f_46443_) {
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        }
        ItemStack itemStack = this.m_21205_();
        if (this.isChecking()) {
            if (BrewUtils.isEmpty(itemStack)) {
                this.setCheckTime(0);
                this.setMood(MIFFED_MOOD);
            }
        } else if (!itemStack.m_41619_()) {
            int i = 0;
            for (BrewEffectInstance instance : BrewUtils.getBrewEffects(itemStack)) {
                ++i;
                if (instance.getAmplifier() > 0) {
                    i += instance.getAmplifier();
                }
                if (instance.getDuration() <= 20) continue;
                i += Mth.m_14143_((float)((float)instance.getDuration() / 20.0f));
            }
            for (BrewEffectInstance instance : PotionUtils.m_43547_((ItemStack)itemStack)) {
                ++i;
                if (instance.m_19564_() > 0) {
                    i += instance.m_19564_();
                }
                if (instance.m_19557_() <= 20) continue;
                i += Mth.m_14143_((float)((float)instance.m_19557_() / 20.0f));
            }
            i += BrewUtils.getAreaOfEffect(itemStack);
            i += (int)BrewUtils.getLingering(itemStack);
            i += BrewUtils.getQuaffLevel(itemStack);
            i += BrewUtils.getVelocityLevel(itemStack);
            if (BrewUtils.getAquatic(itemStack)) {
                i += 2;
            }
            if (BrewUtils.getFireProof(itemStack)) {
                i += 10;
            }
            if (BrewUtils.isLingering(itemStack)) {
                i += 5;
            }
            if (BrewUtils.isGas(itemStack)) {
                i += 10;
            }
            if (i >= this.m_217043_().m_216332_(10, 20)) {
                this.setMood(PLEASED_MOOD);
                this.setMoodTime(MathHelper.minecraftDayToTicks(3));
            } else {
                this.setMood(MIFFED_MOOD);
                this.setMoodTime(MathHelper.minecraftDayToTicks(1));
            }
        }
        if (this.getMoodTime() > 0) {
            --this.moodTime;
        } else if (!this.isIdle()) {
            this.setMood(IDLE_MOOD);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (this.isIdle() && !this.isChecking()) {
            if (BrewUtils.isEmpty(itemstack)) return InteractionResult.FAIL;
            this.m_8061_(EquipmentSlot.MAINHAND, itemstack.m_41620_(1));
            this.setCheckTime(MathHelper.secondsToTicks(5));
            this.setDealingPlayer(pPlayer);
            return super.m_6071_(pPlayer, pHand);
        } else {
            if (!this.isPleased() || this.getDealingPlayer() == pPlayer) return super.m_6071_(pPlayer, pHand);
            return InteractionResult.FAIL;
        }
    }
}

