/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.items.magic;

import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.entities.ModEntityType;
import com.Polarice3.Goety.common.entities.projectiles.HellChant;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.CuriosFinder;
import com.Polarice3.Goety.utils.ItemHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;

public class InfernalTome
extends Item {
    public static String CHANT_TIMES = "Chant Times";

    public InfernalTome() {
        super(new Item.Properties().m_41503_(64).m_41486_().m_41497_(Rarity.UNCOMMON));
    }

    public void m_6883_(ItemStack stack, Level level, Entity entityIn, int p_41407_, boolean p_41408_) {
        if (stack.m_41783_() != null && !stack.m_41783_().m_128441_(CHANT_TIMES)) {
            stack.m_41783_().m_128405_(CHANT_TIMES, 0);
        }
        super.m_6883_(stack, level, entityIn, p_41407_, p_41408_);
    }

    public void m_7836_(ItemStack pStack, Level pLevel, Player pPlayer) {
        CompoundTag compound = pStack.m_41784_();
        compound.m_128405_(CHANT_TIMES, 0);
        super.m_7836_(pStack, pLevel, pPlayer);
    }

    public static int getChantTimes(ItemStack pStack) {
        if (pStack.m_41783_() != null && pStack.m_41783_().m_128441_(CHANT_TIMES)) {
            return pStack.m_41783_().m_128451_(CHANT_TIMES);
        }
        return 0;
    }

    public static void setChantTimes(ItemStack pStack, int time) {
        if (pStack.m_41783_() != null) {
            pStack.m_41783_().m_128405_(CHANT_TIMES, time);
        }
    }

    public static void increaseChantTimes(ItemStack pStack) {
        InfernalTome.setChantTimes(pStack, InfernalTome.getChantTimes(pStack) + 1);
    }

    public static boolean isChanting(ItemStack pStack) {
        if (pStack.m_41783_() != null && pStack.m_41783_().m_128441_(CHANT_TIMES)) {
            return pStack.m_41783_().m_128451_(CHANT_TIMES) > 0;
        }
        return false;
    }

    public void m_5929_(Level worldIn, LivingEntity livingEntityIn, ItemStack stack, int count) {
        super.m_5929_(worldIn, livingEntityIn, stack, count);
        if (stack.m_41720_() instanceof InfernalTome) {
            int CastTime = stack.m_41779_() - count;
            if (CastTime == 1) {
                worldIn.m_6263_(null, livingEntityIn.m_20185_(), livingEntityIn.m_20186_(), livingEntityIn.m_20189_(), (SoundEvent)ModSounds.HERETIC_CHANT.get(), SoundSource.PLAYERS, 2.0f, 0.5f);
            }
            if (!worldIn.f_46443_) {
                HellChant hellChant;
                boolean nether = CuriosFinder.hasNetherRobe(livingEntityIn);
                if (!nether) {
                    livingEntityIn.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 60, 0, false, false));
                }
                if (count % 10 == 0 && (hellChant = (HellChant)((EntityType)ModEntityType.HELL_CHANT.get()).m_20615_(worldIn)) != null) {
                    hellChant.setExtraDamage(stack.getEnchantmentLevel((Enchantment)ModEnchantments.POTENCY.get()));
                    hellChant.setBurning(stack.getEnchantmentLevel((Enchantment)ModEnchantments.BURNING.get()));
                    hellChant.chant(livingEntityIn);
                    worldIn.m_7967_((Entity)hellChant);
                    ItemHelper.hurtAndBreak(stack, 1, livingEntityIn);
                }
            }
        }
    }

    public ItemStack m_5922_(ItemStack pStack, Level level, LivingEntity livingEntity) {
        Player player;
        Player player2 = player = livingEntity instanceof Player ? (Player)livingEntity : null;
        if (player != null) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (pStack.m_41720_() instanceof InfernalTome) {
                player.m_36335_().m_41524_((Item)this, 100);
                if (pStack.m_41783_() != null && pStack.m_41783_().m_128451_(CHANT_TIMES) != 0) {
                    pStack.m_41783_().m_128405_(CHANT_TIMES, 0);
                }
            }
        }
        return pStack;
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int useTimeRemaining) {
        if (stack.m_41720_() instanceof InfernalTome && livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.m_36335_().m_41524_((Item)this, 100);
            if (stack.m_41783_() != null && stack.m_41783_().m_128451_(CHANT_TIMES) != 0) {
                stack.m_41783_().m_128405_(CHANT_TIMES, 0);
            }
        }
    }

    public int m_8105_(ItemStack p_41454_) {
        return 60;
    }

    public UseAnim m_6164_(ItemStack p_41452_) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_40672_, Player p_40673_, InteractionHand p_40674_) {
        ItemStack itemstack = p_40673_.m_21120_(p_40674_);
        p_40673_.m_6672_(p_40674_);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 5;
    }

    public boolean m_8120_(ItemStack pStack) {
        return pStack.m_41613_() == 1;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == ModEnchantments.POTENCY.get() || enchantment == ModEnchantments.BURNING.get() || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && slotChanged;
    }

    public boolean m_6832_(ItemStack pToRepair, ItemStack pRepair) {
        return pRepair.m_41720_() == Items.f_42516_ || super.m_6832_(pToRepair, pRepair);
    }
}

