/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.common.magic.spells.storm;

import com.Polarice3.Goety.api.magic.SpellType;
import com.Polarice3.Goety.client.particles.ModParticleTypes;
import com.Polarice3.Goety.common.effects.GoetyEffects;
import com.Polarice3.Goety.common.enchantments.ModEnchantments;
import com.Polarice3.Goety.common.events.TimedEvents;
import com.Polarice3.Goety.common.magic.Spell;
import com.Polarice3.Goety.common.magic.SpellStat;
import com.Polarice3.Goety.config.SpellConfig;
import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.ColorUtil;
import com.Polarice3.Goety.utils.ConstantPaths;
import com.Polarice3.Goety.utils.EventTask;
import com.Polarice3.Goety.utils.MathHelper;
import com.Polarice3.Goety.utils.MiscCapHelper;
import com.Polarice3.Goety.utils.MobUtil;
import com.Polarice3.Goety.utils.ModDamageSource;
import com.Polarice3.Goety.utils.ServerParticleUtil;
import com.Polarice3.Goety.utils.WandUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BoltingSpell
extends Spell {
    @Override
    public int defaultSoulCost() {
        return (Integer)SpellConfig.BoltingCost.get();
    }

    @Override
    public int defaultCastDuration() {
        return (Integer)SpellConfig.BoltingDuration.get();
    }

    @Override
    @Nullable
    public SoundEvent CastingSound() {
        return (SoundEvent)ModSounds.ZAP.get();
    }

    @Override
    public int defaultSpellCooldown() {
        return (Integer)SpellConfig.BoltingCoolDown.get();
    }

    @Override
    public SpellType getSpellType() {
        return SpellType.STORM;
    }

    @Override
    public List<Enchantment> acceptedEnchantments() {
        ArrayList<Enchantment> list = new ArrayList<Enchantment>();
        list.add((Enchantment)ModEnchantments.POTENCY.get());
        list.add((Enchantment)ModEnchantments.VELOCITY.get());
        return list;
    }

    @Override
    public void SpellResult(ServerLevel worldIn, LivingEntity caster, ItemStack staff, SpellStat spellStat) {
        int potency = spellStat.getPotency();
        double velocity = spellStat.getVelocity();
        if (WandUtil.enchantedFocus(caster)) {
            potency = WandUtil.getLevels((Enchantment)ModEnchantments.POTENCY.get(), caster);
            velocity = WandUtil.getLevels((Enchantment)ModEnchantments.VELOCITY.get(), caster);
        }
        caster.f_19864_ = true;
        caster.m_6853_(false);
        Vec3 vector3d = caster.m_20154_();
        double power = this.rightStaff(staff) ? 3.5 : 2.5;
        double d0 = power + velocity / 4.0;
        vector3d = vector3d.m_82542_(d0, d0, d0);
        caster.m_20334_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
        caster.f_19812_ = true;
        caster.f_19789_ = 0.0f;
        TimedEvents.submitTask("goety:bolting", new BoltingDashTask(caster.m_20148_(), worldIn, this.rightStaff(staff), potency));
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.HEAVY_WOOSH.get(), 3.0f, 1.0f);
        this.playSound(worldIn, (Entity)caster, (SoundEvent)ModSounds.REDSTONE_EXPLODE.get(), 3.0f, 1.0f);
    }

    public static class BoltingDashTask
    implements EventTask {
        public UUID owner;
        public ServerLevel level;
        public boolean staff;
        public float damage;
        public int ticks = 0;

        public BoltingDashTask(UUID owner, ServerLevel level, boolean staff, float damage) {
            this.owner = owner;
            this.level = level;
            this.staff = staff;
            this.damage = damage;
        }

        @Override
        public void startTask() {
            Entity entity = this.level.m_8791_(this.owner);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                MiscCapHelper.setCustomSpinTexture(living, ConstantPaths.boltingDash());
                living.m_21155_(4, true);
                for (int i = 0; i < 4; ++i) {
                    ServerParticleUtil.windParticle(this.level, new ColorUtil(ChatFormatting.YELLOW), 2.0f, (float)((2.0 * Math.random() - 1.0) * 0.5), living.m_19879_(), living.m_20182_());
                }
                ColorUtil colorUtil = new ColorUtil(ChatFormatting.YELLOW);
                this.level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.ELECTRIC_EXPLODE.get()), living.m_20185_(), living.m_20186_() + 0.5, living.m_20189_(), 0, (double)colorUtil.red(), (double)colorUtil.green(), (double)colorUtil.blue(), 1.0);
            }
        }

        @Override
        public void tickTask() {
            ++this.ticks;
            Entity entity = this.level.m_8791_(this.owner);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.f_19789_ = 0.0f;
                living.f_19802_ = 20;
                double radius = 1.0;
                if (this.staff) {
                    radius += 0.25;
                }
                for (int i = 0; i < 2; ++i) {
                    double d0 = (2.0 * Math.random() - 1.0) * 0.2;
                    double d1 = (2.0 * Math.random() - 1.0) * 0.2;
                    double d2 = (2.0 * Math.random() - 1.0) * 0.2;
                    this.level.m_8767_((ParticleOptions)((SimpleParticleType)ModParticleTypes.BIG_ELECTRIC.get()), living.m_20208_(1.0), living.m_20187_(), living.m_20262_(1.0), 0, d0, d1, d2, 0.5);
                }
                ServerParticleUtil.addParticlesAroundMiddleSelf(this.level, (ParticleOptions)ModParticleTypes.ELECTRIC.get(), (Entity)living);
                List list = this.level.m_45933_((Entity)living, living.m_20191_().m_82400_(radius));
                if (!list.isEmpty()) {
                    for (Entity entity2 : list) {
                        if (!(entity2 instanceof LivingEntity)) continue;
                        LivingEntity target = (LivingEntity)entity2;
                        if (MobUtil.areAllies((Entity)living, entity2) || !EntitySelector.f_20406_.test(entity2) || !entity2.m_6097_()) continue;
                        float baseDamage = ((Double)SpellConfig.BoltingDamage.get()).floatValue() * (float)((Integer)SpellConfig.SpellDamageMultiplier.get()).intValue();
                        if (!target.m_6469_(ModDamageSource.directShock(living), baseDamage + this.damage)) continue;
                        float chance = this.staff ? 0.25f : 0.05f;
                        float chainDamage = this.damage / 2.0f;
                        if (this.level.m_46470_() && this.level.m_46758_(target.m_20183_())) {
                            chance += 0.25f;
                            chainDamage = this.damage;
                        }
                        if (this.level.f_46441_.m_188501_() <= chance) {
                            target.m_7292_(new MobEffectInstance((MobEffect)GoetyEffects.SPASMS.get(), MathHelper.secondsToTicks(5)));
                        }
                        if (!this.staff) continue;
                        WandUtil.chainLightning(target, living, 2.0, chainDamage);
                    }
                }
            }
        }

        @Override
        public boolean getAsBoolean() {
            boolean flag = false;
            Entity entity = this.level.m_8791_(this.owner);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (++this.ticks >= 20 || living.m_21224_()) {
                    flag = true;
                }
                if (living.f_19862_) {
                    flag = true;
                }
                if (flag) {
                    living.m_21155_(4, false);
                    MiscCapHelper.setCustomSpinTexture(living, null);
                }
            } else {
                flag = true;
            }
            return flag;
        }

        @Override
        public void endTask() {
            Entity entity = this.level.m_8791_(this.owner);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_21155_(4, false);
                MiscCapHelper.setCustomSpinTexture(living, null);
            }
        }
    }
}

