/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.init.ModSounds;
import com.Polarice3.Goety.utils.NetherBehaviour;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.slf4j.Logger;

public class NetherSpreaderUtil {
    public static final int MAX_GROWTH_RATE_RADIUS = 24;
    public static final int MAX_CHARGE = 1000;
    public static final float MAX_DECAY_FACTOR = 0.5f;
    private static final int MAX_CURSORS = 32;
    public static final int SHRIEKER_PLACEMENT_RATE = 11;
    final boolean isWorldGeneration;
    private final int growthSpawnCost;
    private final int noGrowthRadius;
    private final int chargeDecayRate;
    private final int additionalDecayRate;
    private List<ChargeCursor> cursors = new ArrayList<ChargeCursor>();
    private static final Logger LOGGER = LogUtils.getLogger();

    public NetherSpreaderUtil(boolean p_222248_, int p_222250_, int p_222251_, int p_222252_, int p_222253_) {
        this.isWorldGeneration = p_222248_;
        this.growthSpawnCost = p_222250_;
        this.noGrowthRadius = p_222251_;
        this.chargeDecayRate = p_222252_;
        this.additionalDecayRate = p_222253_;
    }

    public static NetherSpreaderUtil createLevelSpreader() {
        return new NetherSpreaderUtil(false, 10, 1, 16, 5);
    }

    public static NetherSpreaderUtil createWorldGenSpreader() {
        return new NetherSpreaderUtil(true, 50, 1, 5, 10);
    }

    public int growthSpawnCost() {
        return this.growthSpawnCost;
    }

    public int noGrowthRadius() {
        return this.noGrowthRadius;
    }

    public int chargeDecayRate() {
        return this.chargeDecayRate;
    }

    public int additionalDecayRate() {
        return this.additionalDecayRate;
    }

    public boolean isWorldGeneration() {
        return this.isWorldGeneration;
    }

    @VisibleForTesting
    public List<ChargeCursor> getCursors() {
        return this.cursors;
    }

    public void clear() {
        this.cursors.clear();
    }

    public void load(CompoundTag p_222270_) {
        if (p_222270_.m_128425_("cursors", 9)) {
            this.cursors.clear();
            List list = ChargeCursor.CODEC.listOf().parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_222270_.m_128437_("cursors", 10))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseGet(ArrayList::new);
            int i = Math.min(list.size(), 32);
            for (int j = 0; j < i; ++j) {
                this.addCursor((ChargeCursor)list.get(j));
            }
        }
    }

    public void save(CompoundTag p_222276_) {
        ChargeCursor.CODEC.listOf().encodeStart((DynamicOps)NbtOps.f_128958_, this.cursors).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(p_222273_ -> p_222276_.m_128365_("cursors", p_222273_));
    }

    public void addCursors(BlockPos p_222267_, int p_222268_) {
        while (p_222268_ > 0) {
            int i = Math.min(p_222268_, 1000);
            this.addCursor(new ChargeCursor(p_222267_, i));
            p_222268_ -= i;
        }
    }

    private void addCursor(ChargeCursor p_222261_) {
        if (this.cursors.size() < 32) {
            this.cursors.add(p_222261_);
        }
    }

    public void updateCursors(LevelAccessor p_222256_, BlockPos p_222257_, RandomSource p_222258_, boolean p_222259_) {
        if (!this.cursors.isEmpty()) {
            ArrayList<ChargeCursor> list = new ArrayList<ChargeCursor>();
            HashMap<BlockPos, ChargeCursor> map = new HashMap<BlockPos, ChargeCursor>();
            Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
            for (ChargeCursor chargeCursor : this.cursors) {
                chargeCursor.update(p_222256_, p_222257_, p_222258_, this, p_222259_);
                if (chargeCursor.charge <= 0) continue;
                BlockPos blockpos = chargeCursor.getPos();
                object2intmap.computeInt((Object)blockpos, (p_222264_, p_222265_) -> (p_222265_ == null ? 0 : p_222265_) + chargeCursor.charge);
                ChargeCursor chargeCursor1 = (ChargeCursor)map.get(blockpos);
                if (chargeCursor1 == null) {
                    map.put(blockpos, chargeCursor);
                    list.add(chargeCursor);
                    continue;
                }
                if (!this.isWorldGeneration() && chargeCursor.charge + chargeCursor1.charge <= 1000) {
                    chargeCursor1.mergeWith(chargeCursor);
                    continue;
                }
                list.add(chargeCursor);
                if (chargeCursor.charge >= chargeCursor1.charge) continue;
                map.put(blockpos, chargeCursor);
            }
            for (Object2IntMap.Entry entry : object2intmap.object2IntEntrySet()) {
                Set<Direction> collection;
                BlockPos blockpos1 = (BlockPos)entry.getKey();
                int k = entry.getIntValue();
                ChargeCursor chargeCursor = (ChargeCursor)map.get(blockpos1);
                Set<Direction> set = collection = chargeCursor == null ? null : chargeCursor.getFacingData();
                if (k <= 0 || collection == null) continue;
                int i = (int)(Math.log1p(k) / (double)2.3f) + 1;
                int j = (i << 6) + MultifaceBlock.m_221576_(collection);
                p_222256_.m_46796_(2001, blockpos1, Block.m_49956_((BlockState)Blocks.f_50134_.m_49966_()));
            }
            this.cursors = list;
        }
    }

    public static class ChargeCursor {
        private static final ObjectArrayList<Vec3i> NON_CORNER_NEIGHBOURS = (ObjectArrayList)Util.m_137469_((Object)new ObjectArrayList(18), p_222338_ -> BlockPos.m_121990_((BlockPos)new BlockPos(-1, -1, -1), (BlockPos)new BlockPos(1, 1, 1)).filter(p_222336_ -> (p_222336_.m_123341_() == 0 || p_222336_.m_123342_() == 0 || p_222336_.m_123343_() == 0) && !p_222336_.equals((Object)BlockPos.f_121853_)).map(BlockPos::m_7949_).forEach(arg_0 -> ((ObjectArrayList)p_222338_).add(arg_0)));
        public static final int MAX_CURSOR_DECAY_DELAY = 1;
        private BlockPos pos;
        int charge;
        private int updateDelay;
        private int decayDelay;
        @Nullable
        private Set<Direction> facings;
        private static final Codec<Set<Direction>> DIRECTION_SET = Direction.f_175356_.listOf().xmap(p_222340_ -> Sets.newEnumSet((Iterable)p_222340_, Direction.class), Lists::newArrayList);
        public static final Codec<ChargeCursor> CODEC = RecordCodecBuilder.create(p_222330_ -> p_222330_.group((App)BlockPos.f_121852_.fieldOf("pos").forGetter(ChargeCursor::getPos), (App)Codec.intRange((int)0, (int)1000).fieldOf("charge").orElse((Object)0).forGetter(ChargeCursor::getCharge), (App)Codec.intRange((int)0, (int)1).fieldOf("decay_delay").orElse((Object)1).forGetter(ChargeCursor::getDecayDelay), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("update_delay").orElse((Object)0).forGetter(p_222346_ -> p_222346_.updateDelay), (App)DIRECTION_SET.optionalFieldOf("facings").forGetter(p_222343_ -> Optional.ofNullable(p_222343_.getFacingData()))).apply((Applicative)p_222330_, ChargeCursor::new));

        private ChargeCursor(BlockPos p_222299_, int p_222300_, int p_222301_, int p_222302_, Optional<Set<Direction>> p_222303_) {
            this.pos = p_222299_;
            this.charge = p_222300_;
            this.decayDelay = p_222301_;
            this.updateDelay = p_222302_;
            this.facings = p_222303_.orElse(null);
        }

        public ChargeCursor(BlockPos p_222296_, int p_222297_) {
            this(p_222296_, p_222297_, 1, 0, Optional.empty());
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public int getCharge() {
            return this.charge;
        }

        public int getDecayDelay() {
            return this.decayDelay;
        }

        @Nullable
        public Set<Direction> getFacingData() {
            return this.facings;
        }

        private boolean shouldUpdate(LevelAccessor p_222326_, BlockPos p_222327_, boolean p_222328_) {
            if (this.charge <= 0) {
                return false;
            }
            if (p_222328_) {
                return true;
            }
            if (p_222326_ instanceof ServerLevel) {
                ServerLevel serverlevel = (ServerLevel)p_222326_;
                return serverlevel.m_220393_(p_222327_);
            }
            return false;
        }

        public void update(LevelAccessor p_222312_, BlockPos p_222313_, RandomSource p_222314_, NetherSpreaderUtil p_222315_, boolean p_222316_) {
            if (this.shouldUpdate(p_222312_, p_222313_, p_222315_.isWorldGeneration)) {
                if (this.updateDelay > 0) {
                    --this.updateDelay;
                } else {
                    BlockState blockstate = p_222312_.m_8055_(this.pos);
                    NetherBehaviour netherbehaviour = ChargeCursor.getBlockBehaviour(blockstate);
                    if (p_222316_ && netherbehaviour.attemptSpreadVein(p_222312_, this.pos, blockstate, this.facings, p_222315_.isWorldGeneration())) {
                        if (netherbehaviour.canChangeBlockStateOnSpread()) {
                            blockstate = p_222312_.m_8055_(this.pos);
                            netherbehaviour = ChargeCursor.getBlockBehaviour(blockstate);
                        }
                        p_222312_.m_5594_(null, this.pos, (SoundEvent)ModSounds.NETHER_SPREAD.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    this.charge = netherbehaviour.attemptUseCharge(this, p_222312_, p_222313_, p_222314_, p_222315_, p_222316_);
                    if (this.charge <= 0) {
                        netherbehaviour.onDischarged(p_222312_, blockstate, this.pos, p_222314_);
                    } else {
                        BlockPos blockpos = ChargeCursor.getValidMovementPos(p_222312_, this.pos, p_222314_);
                        if (blockpos != null) {
                            netherbehaviour.onDischarged(p_222312_, blockstate, this.pos, p_222314_);
                            this.pos = blockpos.m_7949_();
                            if (p_222315_.isWorldGeneration() && !this.pos.m_123314_(new Vec3i(p_222313_.m_123341_(), this.pos.m_123342_(), p_222313_.m_123343_()), 15.0)) {
                                this.charge = 0;
                                return;
                            }
                            blockstate = p_222312_.m_8055_(blockpos);
                        } else {
                            --this.charge;
                        }
                        this.decayDelay = netherbehaviour.updateDecayDelay(this.decayDelay);
                        this.updateDelay = netherbehaviour.getNetherSpreadDelay();
                    }
                }
            }
        }

        void mergeWith(ChargeCursor p_222332_) {
            this.charge += p_222332_.charge;
            p_222332_.charge = 0;
            this.updateDelay = Math.min(this.updateDelay, p_222332_.updateDelay);
        }

        private static NetherBehaviour getBlockBehaviour(BlockState p_222334_) {
            NetherBehaviour netherbehaviour;
            Block block = p_222334_.m_60734_();
            NetherBehaviour netherbehaviour1 = block instanceof NetherBehaviour ? (netherbehaviour = (NetherBehaviour)block) : NetherBehaviour.DEFAULT;
            return netherbehaviour1;
        }

        private static List<Vec3i> getRandomizedNonCornerNeighbourOffsets(RandomSource p_222306_) {
            return Util.m_214611_(NON_CORNER_NEIGHBOURS, (RandomSource)p_222306_);
        }

        @Nullable
        private static BlockPos getValidMovementPos(LevelAccessor p_222308_, BlockPos p_222309_, RandomSource p_222310_) {
            BlockPos.MutableBlockPos blockpos$mutableblockpos = p_222309_.m_122032_();
            BlockPos.MutableBlockPos blockpos$mutableblockpos1 = p_222309_.m_122032_();
            for (Vec3i vec3i : ChargeCursor.getRandomizedNonCornerNeighbourOffsets(p_222310_)) {
                blockpos$mutableblockpos1.m_175306_((Vec3i)p_222309_, vec3i);
                BlockState blockstate = p_222308_.m_8055_((BlockPos)blockpos$mutableblockpos1);
                if (blockstate.m_60795_() || !ChargeCursor.isMovementUnobstructed(p_222308_, p_222309_, (BlockPos)blockpos$mutableblockpos1)) continue;
                blockpos$mutableblockpos.m_122190_((Vec3i)blockpos$mutableblockpos1);
            }
            return blockpos$mutableblockpos.equals((Object)p_222309_) ? null : blockpos$mutableblockpos;
        }

        private static boolean isMovementUnobstructed(LevelAccessor p_222318_, BlockPos p_222319_, BlockPos p_222320_) {
            if (p_222319_.m_123333_((Vec3i)p_222320_) == 1) {
                return true;
            }
            BlockPos blockpos = p_222320_.m_121996_((Vec3i)p_222319_);
            Direction direction = Direction.m_122387_((Direction.Axis)Direction.Axis.X, (Direction.AxisDirection)(blockpos.m_123341_() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
            Direction direction1 = Direction.m_122387_((Direction.Axis)Direction.Axis.Y, (Direction.AxisDirection)(blockpos.m_123342_() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
            Direction direction2 = Direction.m_122387_((Direction.Axis)Direction.Axis.Z, (Direction.AxisDirection)(blockpos.m_123343_() < 0 ? Direction.AxisDirection.NEGATIVE : Direction.AxisDirection.POSITIVE));
            if (blockpos.m_123341_() == 0) {
                return ChargeCursor.isUnobstructed(p_222318_, p_222319_, direction1) || ChargeCursor.isUnobstructed(p_222318_, p_222319_, direction2);
            }
            if (blockpos.m_123342_() == 0) {
                return ChargeCursor.isUnobstructed(p_222318_, p_222319_, direction) || ChargeCursor.isUnobstructed(p_222318_, p_222319_, direction2);
            }
            return ChargeCursor.isUnobstructed(p_222318_, p_222319_, direction) || ChargeCursor.isUnobstructed(p_222318_, p_222319_, direction1);
        }

        private static boolean isUnobstructed(LevelAccessor p_222322_, BlockPos p_222323_, Direction p_222324_) {
            BlockPos blockpos = p_222323_.m_121945_(p_222324_);
            return !p_222322_.m_8055_(blockpos).m_60795_();
        }
    }
}

