/*
 * Decompiled with CFR 0.152.
 */
package com.Polarice3.Goety.utils;

import com.Polarice3.Goety.common.entities.projectiles.AbstractCyclone;
import com.Polarice3.Goety.utils.MobUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.ProtectionEnchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpellExplosion {
    public SpellExplosion(Level level, Entity source, DamageSource damageSource, double x, double y, double z, float radius) {
        this(level, source, damageSource, x, y, z, radius, 0.0f);
    }

    public SpellExplosion(Level level, Entity source, DamageSource damageSource, BlockPos blockPos, float radius, float damage) {
        this(level, source, damageSource, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), radius, damage);
    }

    public SpellExplosion(Level level, Entity source, DamageSource damageSource, double x, double y, double z, float radius, float damage) {
        float f2 = radius * 2.0f;
        Vec3 vec3 = new Vec3(x, y, z);
        for (Entity entity : SpellExplosion.explosionRangeEntities(level, source, x, y, z, radius)) {
            double d9;
            double d7;
            double d5;
            double d13;
            double d12 = Math.sqrt(entity.m_20238_(vec3)) / (double)f2;
            if (!(d12 <= 1.0) || (d13 = Math.sqrt((d5 = entity.m_20185_() - x) * d5 + (d7 = entity.m_20188_() - y) * d7 + (d9 = entity.m_20189_() - z) * d9)) == 0.0) continue;
            d5 /= d13;
            d7 /= d13;
            d9 /= d13;
            double d14 = SpellExplosion.getSeenPercent(vec3, entity);
            double d10 = (1.0 - d12) * d14;
            float actualDamage = damage == 0.0f ? (float)((int)((d10 * d10 + d10) / 2.0 * 7.0 * (double)f2 + 1.0)) : damage;
            boolean hurt = true;
            if (damageSource.m_269533_(DamageTypeTags.f_268415_) && entity.m_6128_()) {
                hurt = false;
            } else if (damageSource.m_7639_() != null) {
                if (MobUtil.areAllies(damageSource.m_7639_(), entity) || entity == damageSource.m_7639_()) {
                    hurt = false;
                }
            } else if (source != null && (MobUtil.areAllies(source, entity) || entity == source)) {
                hurt = false;
            }
            if (!hurt) continue;
            this.explodeHurt(entity, damageSource, d5, d7, d9, d10, actualDamage);
        }
    }

    public void explodeHurt(Entity target, DamageSource damageSource, double x, double y, double z, double seen, float actualDamage) {
        target.m_6469_(damageSource, actualDamage);
        double d11 = seen;
        if (target instanceof LivingEntity) {
            d11 = ProtectionEnchantment.m_45135_((LivingEntity)((LivingEntity)target), (double)seen);
        }
        if (damageSource.m_276093_(DamageTypes.f_268515_) && target instanceof AbstractCyclone) {
            AbstractCyclone cyclone = (AbstractCyclone)target;
            cyclone.trueRemove();
        }
        if (target instanceof LivingEntity) {
            MobUtil.push(target, x * d11, y * d11, z * d11);
        }
    }

    public static List<Entity> explosionRangeEntities(Level level, Entity source, BlockPos blockPos, float range) {
        return SpellExplosion.explosionRangeEntities(level, source, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), range);
    }

    public static List<Entity> explosionRangeEntities(Level level, Entity source, double x, double y, double z, float radius) {
        float f2 = radius * 2.0f;
        int k1 = Mth.m_14107_((double)(x - (double)f2 - 1.0));
        int l1 = Mth.m_14107_((double)(x + (double)f2 + 1.0));
        int i2 = Mth.m_14107_((double)(y - (double)f2 - 1.0));
        int i1 = Mth.m_14107_((double)(y + (double)f2 + 1.0));
        int j2 = Mth.m_14107_((double)(z - (double)f2 - 1.0));
        int j1 = Mth.m_14107_((double)(z + (double)f2 + 1.0));
        return level.m_45933_(source, new AABB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
    }

    public static float getSeenPercent(Vec3 vector, Entity target) {
        AABB aabb = target.m_20191_();
        double d0 = 1.0 / ((aabb.f_82291_ - aabb.f_82288_) * 2.0 + 1.0);
        double d1 = 1.0 / ((aabb.f_82292_ - aabb.f_82289_) * 2.0 + 1.0);
        double d2 = 1.0 / ((aabb.f_82293_ - aabb.f_82290_) * 2.0 + 1.0);
        double d3 = (1.0 - Math.floor(1.0 / d0) * d0) / 2.0;
        double d4 = (1.0 - Math.floor(1.0 / d2) * d2) / 2.0;
        if (!(d0 < 0.0 || d1 < 0.0 || d2 < 0.0)) {
            int i = 0;
            int j = 0;
            for (double d5 = 0.0; d5 <= 1.0; d5 += d0) {
                for (double d6 = 0.0; d6 <= 1.0; d6 += d1) {
                    for (double d7 = 0.0; d7 <= 1.0; d7 += d2) {
                        double d10;
                        double d9;
                        double d8 = Mth.m_14139_((double)d5, (double)aabb.f_82288_, (double)aabb.f_82291_);
                        Vec3 vec3 = new Vec3(d8 + d3, d9 = Mth.m_14139_((double)d6, (double)aabb.f_82289_, (double)aabb.f_82292_), (d10 = Mth.m_14139_((double)d7, (double)aabb.f_82290_, (double)aabb.f_82293_)) + d4);
                        if (target.f_19853_.m_45547_(new ClipContext(vec3, vector, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, target)).m_6662_() == HitResult.Type.MISS) {
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            return (float)i / (float)j;
        }
        return 0.0f;
    }
}

