/*
 * Decompiled with CFR 0.152.
 */
package org.primal.client.renderer.replaced;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.primal.client.model.replaced.FoxModel;
import org.primal.entity.replaced.FoxReplaced;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.GeoReplacedEntityRenderer;
import software.bernie.geckolib.renderer.layer.BlockAndItemGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;

public class FoxRenderer
extends GeoReplacedEntityRenderer<Fox, FoxReplaced> {
    private static final String ITEM = "mouth";
    protected ItemStack mainHandItem;

    public FoxRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new FoxModel(), (GeoAnimatable)new FoxReplaced());
        this.addRenderLayer((GeoRenderLayer)new BlockAndItemGeoLayer<FoxReplaced>((GeoRenderer)this){

            @Nullable
            protected ItemStack getStackForBone(GeoBone bone, FoxReplaced animatable) {
                if (bone.getName().equals(FoxRenderer.ITEM)) {
                    return FoxRenderer.this.mainHandItem;
                }
                return null;
            }

            protected ItemDisplayContext getTransformTypeForStack(GeoBone bone, ItemStack stack, FoxReplaced animatable) {
                if (bone.getName().equals(FoxRenderer.ITEM)) {
                    return ItemDisplayContext.GROUND;
                }
                return ItemDisplayContext.NONE;
            }

            protected void renderStackForBone(PoseStack poseStack, GeoBone bone, ItemStack stack, FoxReplaced dwarf, MultiBufferSource bufferSource, float partialTick, int packedLight, int packedOverlay) {
                if (stack == FoxRenderer.this.mainHandItem) {
                    poseStack.m_252781_(Axis.f_252495_.m_252977_(-90.0f));
                    poseStack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
                    float f = 0.75f;
                    poseStack.m_85841_(f, f, f);
                }
                super.renderStackForBone(poseStack, bone, stack, (GeoAnimatable)dwarf, bufferSource, partialTick, packedLight, packedOverlay);
            }
        });
        this.f_114477_ = 0.4f;
    }

    public ResourceLocation getTextureLocation(FoxReplaced animatable) {
        Fox fox = (Fox)this.currentEntity;
        return ResourceLocation.fromNamespaceAndPath((String)"primal", (String)("textures/entity/fox/" + fox.m_28554_().m_7912_() + (fox.m_5803_() ? "_sleep" : "") + ".png"));
    }

    public void preRender(PoseStack poseStack, FoxReplaced animatable, BakedGeoModel model, @Nullable MultiBufferSource bufferSource, @Nullable VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        super.preRender(poseStack, (GeoAnimatable)animatable, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, blue, green, alpha);
        this.mainHandItem = ((Fox)this.currentEntity).m_21205_();
    }

    protected void applyRotations(FoxReplaced animatable, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
        super.applyRotations((GeoAnimatable)animatable, poseStack, ageInTicks, rotationYaw, partialTick);
        if (((Fox)this.currentEntity).m_28557_() && !((Fox)this.currentEntity).m_20096_()) {
            float f = -Mth.m_14179_((float)partialTick, (float)((Fox)this.currentEntity).f_19860_, (float)((Fox)this.currentEntity).m_146909_());
            poseStack.m_252781_(Axis.f_252529_.m_252977_(f));
        }
    }

    public void scaleModelForRender(float widthScale, float heightScale, PoseStack poseStack, FoxReplaced animatable, BakedGeoModel model, boolean isReRender, float partialTick, int packedLight, int packedOverlay) {
        GeoBone bone = (GeoBone)model.getBone("head").get();
        float headScale = ((Fox)this.currentEntity).m_6162_() ? 2.0f : 1.0f;
        bone.updateScale(headScale, headScale, headScale);
        if (((Fox)this.currentEntity).m_6162_()) {
            heightScale = 0.5f;
            widthScale = 0.5f;
        }
        super.scaleModelForRender(widthScale, heightScale, poseStack, (GeoAnimatable)animatable, model, isReRender, partialTick, packedLight, packedOverlay);
    }

    public float getMotionAnimThreshold(FoxReplaced animatable) {
        return ((Fox)this.currentEntity).m_20069_() ? 0.0015f : 0.0015f;
    }
}

