/*
 * Decompiled with CFR 0.152.
 */
package org.primal.entity.animal;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.UUID;
import java.util.function.IntFunction;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.primal.client.animation.entity.SharkAnimations;
import org.primal.entity.ai.SharkAi;
import org.primal.entity.ai.controls.BreachingWaterBoundPathNavigation;
import org.primal.registry.Primal_Advancements;
import org.primal.registry.Primal_Items;
import org.primal.registry.Primal_MemoryModuleTypes;
import org.primal.registry.Primal_Sounds;
import org.primal.registry.Primal_Tags;
import org.primal.util.MiscUtil;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SharkEntity
extends WaterAnimal
implements VariantHolder<Variant>,
GeoEntity,
NeutralMob {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> DATA_VARIANT_ID = SynchedEntityData.m_135353_(SharkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_JOCKEY = SynchedEntityData.m_135353_(SharkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static int AirSupplyWhenBeached = 1200;

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 1.0).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22278_, (double)0.4f);
    }

    public SharkEntity(EntityType<? extends WaterAnimal> entityType, Level level) {
        super(entityType, level);
        this.m_21153_(this.m_21233_());
        this.f_21342_ = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.02f, 0.1f, true);
        this.f_21365_ = new SmoothSwimmingLookControl((Mob)this, 10);
    }

    @NotNull
    public SpawnGroupData m_6518_(ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, CompoundTag tag) {
        Holder holder = level.m_204166_(this.m_20183_());
        if (holder.m_203656_(Primal_Tags.SPAWNS_TIGER_SHARK)) {
            this.setVariant(Variant.TIGER);
        } else if (holder.m_203656_(Primal_Tags.SPAWNS_HAMMERHEAD)) {
            this.setVariant(Variant.HAMMERHEAD);
        } else {
            this.setVariant(Variant.GREAT_WHITE);
        }
        return super.m_6518_(level, difficulty, spawnType, spawnGroupData, tag);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{SharkAnimations.mainController(this).receiveTriggeredAnimations()});
    }

    public int m_8085_() {
        return 1;
    }

    public int m_8132_() {
        return 1;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21525_()) {
            this.m_20301_(this.m_6062_());
        }
        if (this.m_20096_() && !this.m_20069_() && !this.m_21224_() && !this.shouldBeBeached()) {
            this.m_20256_(this.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - 1.0f) * 0.2f), 0.5, (double)((this.f_19796_.m_188501_() - 1.0f) * 0.2f)));
            this.m_146922_(this.f_19796_.m_188501_() * 360.0f);
            this.m_6853_(false);
            this.f_19812_ = true;
            this.m_5496_(this.getFlopSound(), this.m_6121_(), this.m_6100_());
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT_ID, (Object)Variant.GREAT_WHITE.id);
        this.f_19804_.m_135372_(IS_JOCKEY, (Object)false);
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Variant", this.getVariant().id);
        compound.m_128379_("SharkJockey", this.isSharkJockey());
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(Variant.byId(compound.m_128451_("Variant")));
        this.setSharkJockey(compound.m_128471_("SharkJockey"));
    }

    public void setVariant(@NotNull Variant variant) {
        this.f_19804_.m_135381_(DATA_VARIANT_ID, (Object)variant.id);
    }

    public @NotNull Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT_ID));
    }

    public boolean isSharkJockey() {
        return (Boolean)this.f_19804_.m_135370_(IS_JOCKEY);
    }

    public void setSharkJockey(boolean isJockey) {
        this.f_19804_.m_135381_(IS_JOCKEY, (Object)isJockey);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level level) {
        return new BreachingWaterBoundPathNavigation((Mob)this, level);
    }

    protected void m_8024_() {
        super.m_8024_();
        Brain<SharkEntity> brain = this.m_6274_();
        brain.m_21865_((ServerLevel)this.m_9236_(), (LivingEntity)this);
        this.m_6858_(brain.m_21952_(MemoryModuleType.f_26372_).isPresent());
        SharkAi.updateActivity(this);
        if (this.isSharkJockey() && this.shouldBeBeached()) {
            this.m_20153_();
        }
        if (this.isSharkJockey() && !this.m_20160_()) {
            this.setSharkJockey(false);
        }
    }

    public void m_7023_(@NotNull Vec3 travelVector) {
        if (this.m_21515_() && this.m_20069_()) {
            this.m_19920_(this.m_6113_(), travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(travelVector);
        }
    }

    public float m_6113_() {
        return this.m_20142_() ? super.m_6113_() * 1.3f : super.m_6113_();
    }

    protected void m_8099_() {
    }

    @NotNull
    protected Brain.Provider<SharkEntity> m_5490_() {
        return SharkAi.brainProvider();
    }

    @NotNull
    protected Brain<?> m_8075_(@NotNull Dynamic<?> dynamic) {
        return SharkAi.makeBrain((Brain<SharkEntity>)this.m_5490_().m_22073_(dynamic));
    }

    @NotNull
    public Brain<SharkEntity> m_6274_() {
        return super.m_6274_();
    }

    @Nullable
    public LivingEntity m_5448_() {
        return this.getTargetFromBrain();
    }

    protected final LivingEntity getTargetFromBrain() {
        return this.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
    }

    public boolean m_6779_(@NotNull LivingEntity target) {
        return super.m_6779_(target) && this.m_20069_() && (target.m_21223_() < target.m_21233_() && !(target instanceof SharkEntity) || !this.m_6274_().m_21874_(MemoryModuleType.f_148201_) && target.m_6095_().m_204039_(Primal_Tags.SHARK_HUNTABLE) || this.m_21188_() == target || this.m_6274_().m_21874_((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_CONDUIT_PLAYER.get()) && (((LivingEntity)this.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_CONDUIT_PLAYER.get()).get()).m_21214_() == target || ((LivingEntity)this.m_6274_().m_21952_((MemoryModuleType)Primal_MemoryModuleTypes.NEAREST_CONDUIT_PLAYER.get()).get()).m_21188_() == target)) && !target.m_21023_(MobEffects.f_19592_) && MiscUtil.isNotNeverAttack(target);
    }

    public boolean m_214076_(@NotNull ServerLevel level, @NotNull LivingEntity killed) {
        List playersList;
        if (killed.m_6095_().m_204039_(Primal_Tags.SHARK_HUNTABLE)) {
            this.m_6274_().m_21882_(MemoryModuleType.f_148201_, (Object)true, 600L);
        }
        if (Primal_Advancements.ANIMALS_SHARK_NEEDS_TO_KILL.contains(killed.m_6095_()) && !(playersList = this.m_9236_().m_45976_(ServerPlayer.class, this.m_20191_().m_82400_(24.0))).isEmpty()) {
            playersList.forEach(player -> Primal_Advancements.FEED_SHARK.trigger((ServerPlayer)player, killed));
        }
        return super.m_214076_(level, killed);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        Entity entity;
        boolean hurt = super.m_6469_(source, amount);
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (hurt && (entity = source.m_7639_()) instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            SharkAi.wasHurtBy(this, target);
        }
        return hurt;
    }

    public boolean m_7327_(@NotNull Entity entity) {
        boolean hurt = super.m_7327_(entity);
        if (this.m_217043_().m_216332_(0, 100) < 5) {
            ItemStack toothStack = new ItemStack((ItemLike)Primal_Items.SHARK_TOOTH.get(), this.m_217043_().m_188499_() ? 2 : 1);
            this.m_19983_(toothStack);
        }
        if (entity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)entity;
            this.m_6274_().m_21882_(MemoryModuleType.f_26383_, (Object)target, (long)this.m_217043_().m_216332_(20, 100));
        }
        return hurt;
    }

    protected void m_19956_(@NotNull Entity passenger, @NotNull Entity.MoveFunction callback) {
        if (this.m_20363_(passenger)) {
            double y = this.m_20186_() + 0.2;
            float bodyYawRad = this.f_20883_ * ((float)Math.PI / 180);
            double forwardOffset = -0.8;
            double sideOffset = -0.0;
            double x = this.m_20185_() + (double)Mth.m_14031_((float)bodyYawRad) * forwardOffset + (double)Mth.m_14089_((float)bodyYawRad) * sideOffset;
            double z = this.m_20189_() - (double)Mth.m_14089_((float)bodyYawRad) * forwardOffset + (double)Mth.m_14031_((float)bodyYawRad) * sideOffset;
            callback.m_20372_(passenger, x, y, z);
        }
    }

    protected SoundEvent getFlopSound() {
        return (SoundEvent)Primal_Sounds.SHARK_FLOP.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)Primal_Sounds.SHARK_IDLE.get();
    }

    public int m_8100_() {
        return 200;
    }

    public void m_21011_(@NotNull InteractionHand hand, boolean p_21013_) {
        super.m_21011_(hand, p_21013_);
        this.m_5496_((SoundEvent)Primal_Sounds.SHARK_ATTACK.get(), 1.0f, 1.0f);
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource damageSource) {
        return (SoundEvent)Primal_Sounds.SHARK_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)Primal_Sounds.SHARK_DEATH.get();
    }

    public boolean shouldBeBeached() {
        return this.m_20146_() <= AirSupplyWhenBeached;
    }

    public int m_6062_() {
        return 2400;
    }

    protected void m_6229_(int airSupply) {
        if (this.m_6084_() && !this.m_20072_()) {
            this.m_20301_(airSupply - 1);
            if (this.m_20146_() == -20) {
                this.m_20301_(0);
                this.m_6469_(this.m_269291_().m_269063_(), 2.0f);
            }
        } else {
            this.m_20301_(this.m_6062_());
        }
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return this.isSharkJockey();
    }

    protected float m_6431_(@NotNull Pose pose, @NotNull EntityDimensions entityDimensions) {
        return 0.75f;
    }

    public int m_6784_() {
        return 0;
    }

    public void m_7870_(int remainingPersistentAngerTime) {
    }

    @Nullable
    public UUID m_6120_() {
        return null;
    }

    public void m_6925_(@Nullable UUID persistentAngerTarget) {
    }

    public void m_6825_() {
    }

    public static enum Variant implements StringRepresentable
    {
        GREAT_WHITE(0, "great_white"),
        HAMMERHEAD(1, "hammerhead"),
        TIGER(2, "tiger");

        public static final Codec<Variant> CODEC;
        private static final IntFunction<Variant> BY_ID;
        final int id;
        private final String name;

        public static Variant byId(int id) {
            return BY_ID.apply(id);
        }

        private Variant(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getId() {
            return this.id;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Variant::values);
            BY_ID = ByIdMap.m_262839_(Variant::getId, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.CLAMP);
        }
    }
}

