/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.client.model.entity;

import com.klikli_dev.occultism.client.model.entity.DragonFamiliarModel;
import com.klikli_dev.occultism.common.entity.familiar.CthulhuFamiliarEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;

public class CthulhuFamiliarModel
extends EntityModel<CthulhuFamiliarEntity> {
    private static final float PI = (float)Math.PI;
    public ModelPart body;
    public ModelPart head;
    public ModelPart leftLeg;
    public ModelPart leftArm;
    public ModelPart tail;
    public ModelPart leftWing;
    public ModelPart rightLeg;
    public ModelPart rightArm;
    public ModelPart rightWing;
    public ModelPart hair;
    public ModelPart leftEye;
    public ModelPart rightEye;
    public ModelPart leftEar;
    public ModelPart tentacle1;
    public ModelPart tentacle2;
    public ModelPart tentacle3;
    public ModelPart rightEar;
    public ModelPart hat1;
    public ModelPart trunk1;
    public ModelPart hat2;
    public ModelPart trunk2;
    public ModelPart trunk3;
    public ModelPart lantern1;
    public ModelPart lantern2;
    public ModelPart lantern3;
    public DragonFamiliarModel.ColorModelPartProxy lantern4;

    public CthulhuFamiliarModel(ModelPart part) {
        this.body = part.getChild("body");
        this.head = this.body.getChild("head");
        this.leftLeg = this.body.getChild("leftLeg");
        this.leftArm = this.body.getChild("leftArm");
        this.tail = this.body.getChild("tail");
        this.leftWing = this.body.getChild("leftWing");
        this.rightLeg = this.body.getChild("rightLeg");
        this.rightArm = this.body.getChild("rightArm");
        this.rightWing = this.body.getChild("rightWing");
        this.hair = this.head.getChild("hair");
        this.leftEye = this.head.getChild("leftEye");
        this.rightEye = this.head.getChild("rightEye");
        this.leftEar = this.head.getChild("leftEar");
        this.tentacle1 = this.head.getChild("tentacle1");
        this.tentacle2 = this.head.getChild("tentacle2");
        this.tentacle3 = this.head.getChild("tentacle3");
        this.rightEar = this.head.getChild("rightEar");
        this.hat1 = this.head.getChild("hat1");
        this.trunk1 = this.head.getChild("trunk1");
        this.hat2 = this.hat1.getChild("hat2");
        this.trunk2 = this.trunk1.getChild("trunk2");
        this.trunk3 = this.trunk2.getChild("trunk3");
        this.lantern1 = this.leftArm.getChild("lantern1");
        this.lantern2 = this.lantern1.getChild("lantern2");
        this.lantern3 = this.lantern2.getChild("lantern3");
        this.lantern4 = new DragonFamiliarModel.ColorModelPartProxy(this.lantern3.getChild("lantern4"));
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition parts = mesh.getRoot();
        PartDefinition body = parts.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-3.5f, -6.0f, -1.5f, 7.0f, 7.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)17.0f, (float)0.0f, (float)0.43912482f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.addOrReplaceChild("head", CubeListBuilder.create().texOffs(20, 0).addBox(-3.0f, -5.0f, -3.2f, 6.0f, 5.0f, 6.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-5.8f, (float)-0.3f, (float)-0.2628466f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = body.addOrReplaceChild("leftLeg", CubeListBuilder.create().texOffs(44, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, false), PartPose.offsetAndRotation((float)2.0f, (float)0.5f, (float)0.0f, (float)-0.39426988f, (float)0.0f, (float)0.0f));
        PartDefinition leftArm = body.addOrReplaceChild("leftArm", CubeListBuilder.create().texOffs(52, 0).addBox(0.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, false), PartPose.offsetAndRotation((float)3.2f, (float)-4.5f, (float)0.0f, (float)-1.6891296f, (float)0.0f, (float)0.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(0, 22).addBox(0.0f, -1.0f, 0.0f, 0.0f, 5.0f, 5.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)1.0f, (float)0.628493f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = body.addOrReplaceChild("leftWing", CubeListBuilder.create().texOffs(20, 21).addBox(0.0f, -8.0f, 0.0f, 8.0f, 8.0f, 0.0f, false), PartPose.offsetAndRotation((float)2.4f, (float)-5.0f, (float)1.4f, (float)-0.1314233f, (float)-0.42917648f, (float)0.5256932f));
        PartDefinition rightLeg = body.addOrReplaceChild("rightLeg", CubeListBuilder.create().texOffs(44, 0).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 5.0f, 2.0f, true), PartPose.offsetAndRotation((float)-2.0f, (float)0.5f, (float)0.0f, (float)-0.39426988f, (float)0.0f, (float)0.0f));
        PartDefinition rightArm = body.addOrReplaceChild("rightArm", CubeListBuilder.create().texOffs(52, 0).addBox(-2.0f, -1.0f, -1.0f, 2.0f, 5.0f, 2.0f, true), PartPose.offsetAndRotation((float)-3.2f, (float)-4.5f, (float)0.0f, (float)-0.43807766f, (float)0.0f, (float)0.0f));
        PartDefinition rightWing = body.addOrReplaceChild("rightWing", CubeListBuilder.create().texOffs(20, 21).addBox(-8.0f, -8.0f, 0.0f, 8.0f, 8.0f, 0.0f, true), PartPose.offsetAndRotation((float)-2.4f, (float)-5.0f, (float)1.4f, (float)-0.1314233f, (float)0.42917648f, (float)-0.5256932f));
        PartDefinition hair = head.addOrReplaceChild("hair", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, -7.0f, -3.2f, 0.0f, 7.0f, 10.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEye = head.addOrReplaceChild("leftEye", CubeListBuilder.create().texOffs(26, 12).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)1.3f, (float)-3.0f, (float)-3.7f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition rightEye = head.addOrReplaceChild("rightEye", CubeListBuilder.create().texOffs(26, 12).addBox(-1.0f, -1.0f, 0.0f, 2.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)-1.3f, (float)-3.0f, (float)-3.7f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition leftEar = head.addOrReplaceChild("leftEar", CubeListBuilder.create().texOffs(0, 21).addBox(0.0f, 0.0f, 0.0f, 3.0f, 4.0f, 0.0f, false), PartPose.offsetAndRotation((float)3.0f, (float)-4.5f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition tentacle1 = head.addOrReplaceChild("tentacle1", CubeListBuilder.create().texOffs(0, 17).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, false), PartPose.offsetAndRotation((float)-0.1f, (float)-1.1f, (float)-2.8f, (float)-0.19338249f, (float)0.0f, (float)0.57595867f));
        PartDefinition tentacle2 = head.addOrReplaceChild("tentacle2", CubeListBuilder.create().texOffs(0, 17).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.4f, (float)-2.8f, (float)-0.19338249f, (float)0.0f, (float)0.0f));
        PartDefinition tentacle3 = head.addOrReplaceChild("tentacle3", CubeListBuilder.create().texOffs(0, 17).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 3.0f, 1.0f, false), PartPose.offsetAndRotation((float)0.1f, (float)-1.1f, (float)-2.8f, (float)-0.19338249f, (float)0.0f, (float)-0.57595867f));
        PartDefinition rightEar = head.addOrReplaceChild("rightEar", CubeListBuilder.create().texOffs(0, 21).addBox(-3.0f, 0.0f, 0.0f, 3.0f, 4.0f, 0.0f, true), PartPose.offsetAndRotation((float)-3.0f, (float)-4.5f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition hat1 = head.addOrReplaceChild("hat1", CubeListBuilder.create().texOffs(20, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 1.0f, 4.0f, false), PartPose.offsetAndRotation((float)2.5f, (float)-5.5f, (float)-3.0f, (float)0.27366763f, (float)-0.039095376f, (float)0.23457225f));
        PartDefinition trunk1 = head.addOrReplaceChild("trunk1", CubeListBuilder.create().texOffs(44, 7).addBox(-1.5f, 0.0f, -1.0f, 3.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-1.1f, (float)-2.2f, (float)-0.86009824f, (float)0.0f, (float)0.0f));
        PartDefinition hat2 = hat1.addOrReplaceChild("hat2", CubeListBuilder.create().texOffs(36, 16).addBox(-2.0f, 0.0f, -2.0f, 3.0f, 2.0f, 3.0f, false), PartPose.offsetAndRotation((float)0.5f, (float)-2.0f, (float)0.5f, (float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition trunk2 = trunk1.addOrReplaceChild("trunk2", CubeListBuilder.create().texOffs(44, 11).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)0.0f, (float)-0.4691445f, (float)0.0f, (float)0.0f));
        PartDefinition trunk3 = trunk2.addOrReplaceChild("trunk3", CubeListBuilder.create().texOffs(54, 7).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 2.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)1.5f, (float)0.0f, (float)0.39095375f, (float)0.0f, (float)0.0f));
        PartDefinition lantern1 = leftArm.addOrReplaceChild("lantern1", CubeListBuilder.create().texOffs(58, 29).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 3.0f, 0.0f, false), PartPose.offsetAndRotation((float)1.0f, (float)3.5f, (float)-0.5f, (float)1.2901473f, (float)0.0f, (float)0.0f));
        PartDefinition lantern2 = lantern1.addOrReplaceChild("lantern2", CubeListBuilder.create().texOffs(42, 23).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 5.0f, 4.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)2.5f, (float)0.0f, (float)0.0f, (float)0.7853982f, (float)0.0f));
        PartDefinition lantern3 = lantern2.addOrReplaceChild("lantern3", CubeListBuilder.create().texOffs(34, 27).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)4.99f, (float)0.0f, (float)0.0f, (float)-0.7853982f, (float)0.0f));
        PartDefinition lantern4 = lantern3.addOrReplaceChild("lantern4", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, false), PartPose.offsetAndRotation((float)0.0f, (float)-3.3f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.7853982f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32);
    }

    public void renderToBuffer(PoseStack pPoseStack, VertexConsumer pBuffer, int pPackedLight, int pPackedOverlay, int pColor) {
        this.body.render(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
        this.lantern4.proxyRender(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pColor);
    }

    public void setupAnim(CthulhuFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float partialTicks = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        entityIn.riderLimbSwing = limbSwing;
        entityIn.riderLimbSwingAmount = limbSwingAmount;
        this.showModels(entityIn);
        this.lantern4.setColor(1.0f, 1.0f, 1.0f, (Mth.cos((float)(ageInTicks * 0.2f)) + 1.0f) * 0.5f);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180) * 0.7f;
        this.head.xRot = headPitch * ((float)Math.PI / 180) * 0.7f - 0.26f;
        if (entityIn.isPartying()) {
            this.body.xRot = -this.toRads(90.0f);
            this.rightLeg.xRot = this.toRads(15.0f);
            this.leftLeg.xRot = this.toRads(15.0f);
            this.head.yRot = 0.0f;
            this.head.xRot = 0.0f;
        } else if (entityIn.isSitting()) {
            this.rightArm.xRot = 0.0f;
            this.leftArm.xRot = 0.0f;
            this.rightLeg.xRot = -1.5707964f;
            this.leftLeg.xRot = -1.5707964f;
            this.body.xRot = 0.0f;
        } else {
            this.rightArm.xRot = Mth.cos((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.2f - 0.44f;
            this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.5f + (float)Math.PI)) * limbSwingAmount * 0.2f - 0.44f;
            this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.5f)) * 1.4f * limbSwingAmount * 0.2f - 0.39f;
            this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.5f)) * 1.4f * limbSwingAmount * 0.2f - 0.39f;
            float f = this.body.xRot = entityIn.isInWater() ? 1.0f : 0.44f;
        }
        if (entityIn.isAngry()) {
            this.leftEye.zRot = -this.toRads(45.0f);
            this.rightEye.zRot = -this.toRads(45.0f);
            this.leftEar.zRot = this.toRads(20.0f);
            this.rightEar.zRot = -this.toRads(20.0f);
        } else {
            this.leftEye.zRot = 0.0f;
            this.rightEye.zRot = 0.0f;
            this.leftEar.zRot = 0.0f;
            this.rightEar.zRot = 0.0f;
        }
        if (entityIn.isGiving()) {
            this.leftArm.yRot = this.toRads(40.0f);
            this.rightArm.yRot = -this.toRads(40.0f);
            this.leftArm.xRot -= this.toRads(40.0f);
            this.rightArm.xRot -= this.toRads(40.0f);
        } else {
            this.leftArm.yRot = 0.0f;
            this.rightArm.yRot = 0.0f;
        }
        this.trunk1.xRot = -0.86f + Mth.cos((float)(ageInTicks / 10.0f)) * 0.15f;
        this.trunk2.xRot = -0.47f + Mth.cos((float)(ageInTicks / 10.0f)) * 0.15f;
        this.trunk3.xRot = 0.39f + Mth.cos((float)(ageInTicks / 10.0f)) * 0.15f;
        this.tentacle1.zRot = 0.58f + Mth.cos((float)(ageInTicks / 10.0f)) * 0.07f;
        this.tentacle3.zRot = -0.58f - Mth.cos((float)(ageInTicks / 10.0f)) * 0.07f;
        if (entityIn.hasBlacksmithUpgrade()) {
            if (entityIn.isSitting()) {
                this.lantern1.xRot = this.toRads(0.0f);
                this.lantern1.y = -1.6f;
                this.lantern1.x = 3.0f;
                this.lantern1.z = -5.0f;
            } else {
                this.leftArm.xRot = Mth.cos((float)(limbSwing * 0.4f + (float)Math.PI)) * limbSwingAmount * 0.2f + this.toRads(-100.0f);
                this.lantern1.yRot = Mth.cos((float)(ageInTicks * 0.2f)) * this.toRads(5.0f);
                this.lantern1.zRot = -Mth.cos((float)(ageInTicks * 0.2f)) * this.toRads(5.0f);
                this.lantern1.xRot = this.toRads(74.0f);
                this.lantern1.y = 3.5f;
                this.lantern1.x = 1.0f;
                this.lantern1.z = -0.5f;
            }
        }
        if (entityIn.isVehicle()) {
            float animHeight = entityIn.getAnimationHeight(partialTicks);
            this.rightArm.xRot = this.toRads(40.0f - animHeight * 15.0f);
        }
    }

    public void prepareMobModel(CthulhuFamiliarEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        if (entityIn.isSitting() && !entityIn.isPartying()) {
            this.leftWing.yRot = -0.43f;
            this.rightWing.yRot = 0.43f;
        } else {
            float animationHeight = entityIn.getAnimationHeight(partialTick);
            this.leftWing.yRot = animationHeight * this.toRads(20.0f) - 0.43f;
            this.rightWing.yRot = -animationHeight * this.toRads(20.0f) + 0.43f;
        }
    }

    private float toRads(float deg) {
        return (float)Math.PI / 180 * deg;
    }

    private void showModels(CthulhuFamiliarEntity entity) {
        boolean hasTrunk = entity.hasTrunk();
        this.hat1.visible = entity.hasHat();
        this.lantern1.visible = entity.hasBlacksmithUpgrade();
        this.trunk1.visible = hasTrunk;
        this.tentacle1.visible = !hasTrunk;
        this.tentacle2.visible = !hasTrunk;
        this.tentacle3.visible = !hasTrunk;
    }
}

