/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.container.spirit;

import com.klikli_dev.occultism.common.container.spirit.SpiritContainer;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.registry.OccultismContainers;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class SpiritTransporterContainer
extends SpiritContainer {
    protected final Player player;

    public SpiritTransporterContainer(int id, Inventory playerInventory, SpiritEntity spirit) {
        super(OccultismContainers.SPIRIT_TRANSPORTER.get(), id, playerInventory, spirit);
        this.player = playerInventory.player;
        this.setupFilterSlots();
    }

    @Override
    protected void setupPlayerInventorySlots(Player player) {
        int playerInventoryTop = 138;
        int playerInventoryLeft = 8;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)player.getInventory(), j + i * 9 + 9, playerInventoryLeft + j * 18, playerInventoryTop + i * 18));
            }
        }
    }

    @Override
    protected void setupPlayerHotbar(Player player) {
        int hotbarTop = 196;
        int hotbarLeft = 8;
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)player.getInventory(), i, hotbarLeft + i * 18, hotbarTop));
        }
    }

    public void clicked(int id, int dragType, ClickType clickType, Player player) {
        Slot slot = id >= 0 ? this.getSlot(id) : null;
        ItemStack holding = player.containerMenu.getCarried();
        if (slot instanceof FilterSlot) {
            if (holding.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else if (slot.mayPlace(holding)) {
                slot.set(holding.copy());
            }
            return;
        }
        super.clicked(id, dragType, clickType, player);
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        if (slot instanceof FilterSlot) {
            return false;
        }
        return super.canTakeItemForPickAll(stack, slot);
    }

    protected void setupFilterSlots() {
        int x = 8;
        int y = 84;
        ItemStackHandler filterItems = this.spirit.filterItemStackHandler;
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < filterItems.getSlots() / 2; ++j) {
                this.addSlot((Slot)new FilterSlot(this, (IItemHandler)filterItems, j + i * 7, x + j * 18, y + i * 18));
            }
        }
    }

    @Override
    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        int filterSize = 14;
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index >= this.slots.size() - this.inventory.getSlots() - 14 ? !this.moveItemStackTo(itemstack1, 0, this.slots.size() - this.inventory.getSlots() - 14, true) : !this.moveItemStackTo(itemstack1, this.slots.size() - this.inventory.getSlots() - 14, this.slots.size() - 14, true)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return itemstack;
    }

    public class FilterSlot
    extends SlotItemHandler {
        public FilterSlot(SpiritTransporterContainer this$0, IItemHandler handler, int inventoryIndex, int x, int y) {
            super(handler, inventoryIndex, x, y);
        }

        public void set(@Nonnull ItemStack stack) {
            if (!stack.isEmpty()) {
                stack.setCount(1);
            }
            super.set(stack);
        }
    }
}

