/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.familiar;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.klikli_dev.occultism.common.advancement.FamiliarTrigger;
import com.klikli_dev.occultism.common.entity.familiar.DevilFamiliarEntity;
import com.klikli_dev.occultism.common.entity.familiar.FamiliarEntity;
import com.klikli_dev.occultism.network.Networking;
import com.klikli_dev.occultism.network.messages.MessageHeadlessDie;
import com.klikli_dev.occultism.registry.OccultismAdvancements;
import com.klikli_dev.occultism.registry.OccultismEntities;
import com.klikli_dev.occultism.registry.OccultismItems;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.joml.Vector3f;

public class HeadlessFamiliarEntity
extends FamiliarEntity {
    private static final int HEAD_TIME = 1200;
    private static final byte NO_HEAD = 0;
    private static final EntityDataAccessor<Byte> HEAD = SynchedEntityData.defineId(HeadlessFamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> WEAPON = SynchedEntityData.defineId(HeadlessFamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static final EntityDataAccessor<Byte> REBUILT = SynchedEntityData.defineId(HeadlessFamiliarEntity.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    private static ImmutableBiMap<Byte, EntityType<? extends LivingEntity>> typesLookup;
    private int headTimer;
    private int headlessDieTimer;

    public HeadlessFamiliarEntity(EntityType<? extends HeadlessFamiliarEntity> type, Level level) {
        super(type, level);
    }

    private static ImmutableBiMap<Byte, EntityType<? extends LivingEntity>> getTypesLookup() {
        if (typesLookup == null) {
            ImmutableBiMap.Builder builder = new ImmutableBiMap.Builder();
            builder.put((Object)1, (Object)EntityType.PLAYER);
            builder.put((Object)2, (Object)EntityType.ZOMBIE);
            builder.put((Object)3, (Object)EntityType.HUSK);
            builder.put((Object)4, (Object)EntityType.DROWNED);
            builder.put((Object)5, (Object)EntityType.SKELETON);
            builder.put((Object)6, (Object)EntityType.WITHER_SKELETON);
            builder.put((Object)7, (Object)EntityType.STRAY);
            builder.put((Object)8, (Object)EntityType.BOGGED);
            builder.put((Object)9, (Object)EntityType.CREEPER);
            builder.put((Object)10, (Object)EntityType.SPIDER);
            builder.put((Object)11, (Object)EntityType.CAVE_SPIDER);
            builder.put((Object)12, (Object)EntityType.PIGLIN);
            builder.put((Object)13, (Object)EntityType.PIGLIN_BRUTE);
            builder.put((Object)14, (Object)EntityType.ZOMBIFIED_PIGLIN);
            builder.put((Object)15, (Object)EntityType.BLAZE);
            builder.put((Object)16, (Object)EntityType.BREEZE);
            builder.put((Object)17, (Object)EntityType.ENDERMAN);
            builder.put((Object)18, (Object)EntityType.ENDER_DRAGON);
            builder.put((Object)19, OccultismEntities.CTHULHU_FAMILIAR.get());
            builder.put((Object)20, (Object)EntityType.VILLAGER);
            builder.put((Object)21, (Object)EntityType.WANDERING_TRADER);
            builder.put((Object)22, (Object)EntityType.ZOMBIE_VILLAGER);
            builder.put((Object)23, (Object)EntityType.WITCH);
            builder.put((Object)24, (Object)EntityType.PILLAGER);
            builder.put((Object)25, (Object)EntityType.VINDICATOR);
            builder.put((Object)26, (Object)EntityType.EVOKER);
            typesLookup = builder.build();
        }
        return typesLookup;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return FamiliarEntity.createAttributes().add(Attributes.MAX_HEALTH, 40.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FamiliarEntity.FamiliarPanicGoal(this, 1.25));
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new FamiliarEntity.SitGoal(this, this));
        this.goalSelector.addGoal(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new FamiliarEntity.FollowOwnerGoal(this, 1.0, 3.0f, 1.0f));
        this.goalSelector.addGoal(6, (Goal)new DevilFamiliarEntity.AttackGoal(this, 5.0f){

            @Override
            public boolean canUse() {
                return super.canUse() && !HeadlessFamiliarEntity.this.isHeadlessDead();
            }
        });
        this.goalSelector.addGoal(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(8, (Goal)new FollowMobGoal((Mob)this, 1.0, 3.0f, 7.0f));
    }

    public void tick() {
        block7: {
            block6: {
                super.tick();
                if (this.level().isClientSide) break block6;
                if (this.headTimer-- == 0) {
                    this.setHead((byte)0);
                }
                if (!this.hasBlacksmithUpgrade() || this.isHeadlessDead() || this.tickCount % 10 != 0 || this.getHeadType() == null) break block7;
                for (LivingEntity e2 : this.level().getEntities(this.getHeadType(), this.getBoundingBox().inflate(5.0), e -> e != this.getFamiliarOwner())) {
                    e2.addEffect(new MobEffectInstance(MobEffects.WEAKNESS, 60));
                }
                break block7;
            }
            if (this.hasBlacksmithUpgrade() && !this.isHeadlessDead() && this.tickCount % 10 == 0) {
                Vec3 forward = Vec3.directionFromRotation((float)0.0f, (float)this.getYRot());
                Vec3 pos = this.position().add(forward.reverse().scale(0.15)).add(this.randPos(0.08), this.randPos(0.08), this.randPos(0.08));
                this.level().addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, pos.x, pos.y + 1.1, pos.z, 0.0, 0.0, 0.0);
            }
            if (this.headlessDieTimer == 1) {
                this.level().addParticle((ParticleOptions)ParticleTypes.SOUL, this.getX(), this.getY() + 1.0, this.getZ(), 0.0, 0.0, 0.0);
            }
            if (this.headlessDieTimer-- > 7) {
                for (int i = 0; i < 2; ++i) {
                    this.level().addParticle((ParticleOptions)new DustParticleOptions(new Vector3f(0.5f, 0.0f, 0.0f), 1.0f), this.getX() + this.randPos(0.3), this.getY() + 1.0 + this.randPos(0.3), this.getZ() + this.randPos(0.3), 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        this.setWeapon((byte)this.getRandom().nextInt(3));
        this.setHairy(this.getRandom().nextBoolean());
        this.setGlasses(this.getRandom().nextDouble() < 0.1);
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    @Override
    public Iterable<MobEffectInstance> getFamiliarEffects() {
        return ImmutableList.of();
    }

    @Override
    public boolean canBlacksmithUpgrade() {
        return !this.hasBlacksmithUpgrade();
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HEAD, (Object)0);
        builder.define(WEAPON, (Object)0);
        builder.define(REBUILT, (Object)0);
    }

    @Override
    protected InteractionResult mobInteract(Player playerIn, InteractionHand hand) {
        if (this.isHeadlessDead()) {
            ItemStack stack = playerIn.getItemInHand(hand);
            Item item = stack.getItem();
            boolean success = false;
            if (stack.is(Tags.Items.CROPS_WHEAT) && !this.isRebuilt(Rebuilt.LeftLeg)) {
                this.setRebuilt(Rebuilt.LeftLeg);
                success = true;
            } else if (stack.is(Tags.Items.CROPS_WHEAT) && !this.isRebuilt(Rebuilt.RightLeg)) {
                this.setRebuilt(Rebuilt.RightLeg);
                success = true;
            } else if (item == Items.HAY_BLOCK && !this.isRebuilt(Rebuilt.Body)) {
                this.setRebuilt(Rebuilt.Body);
                success = true;
            } else if (stack.is(Tags.Items.RODS_WOODEN) && this.isRebuilt(Rebuilt.Body) && !this.isRebuilt(Rebuilt.LeftArm)) {
                this.setRebuilt(Rebuilt.LeftArm);
                success = true;
            } else if (stack.is(Tags.Items.RODS_WOODEN) && this.isRebuilt(Rebuilt.Body) && !this.isRebuilt(Rebuilt.RightArm)) {
                this.setRebuilt(Rebuilt.RightArm);
                success = true;
            } else if (item == Items.CARVED_PUMPKIN && this.isRebuilt(Rebuilt.Body) && !this.isRebuilt(Rebuilt.Head)) {
                this.setRebuilt(Rebuilt.Head);
                success = true;
            }
            if (success) {
                stack.shrink(1);
                if (this.isFullyRebuilt()) {
                    ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger((LivingEntity)playerIn, FamiliarTrigger.Type.HEADLESS_REBUILT);
                }
                return InteractionResult.sidedSuccess((!this.level().isClientSide ? 1 : 0) != 0);
            }
        }
        return super.mobInteract(playerIn, hand);
    }

    @Override
    public void setFamiliarOwner(LivingEntity owner) {
        if (this.hasGlasses()) {
            ((FamiliarTrigger)((Object)OccultismAdvancements.FAMILIAR.get())).trigger(owner, FamiliarTrigger.Type.RARE_VARIANT);
        }
        super.setFamiliarOwner(owner);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.setHead(compound.getByte("head"));
        this.headTimer = compound.getInt("headTimer");
        if (!compound.contains("variants")) {
            this.setHairy(compound.getBoolean("isHairy"));
            this.setGlasses(compound.getBoolean("hasGlasses"));
            this.setHeadlessDead(compound.getBoolean("isHeadlessDead"));
        }
        this.setWeapon(compound.getByte("getWeapon"));
        this.setRebuilt(compound.getByte("getRebuilt"));
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putByte("head", this.getHead());
        compound.putInt("headTimer", this.headTimer);
        compound.putByte("getWeapon", this.getWeapon());
        compound.putByte("getRebuilt", this.getRebuilt());
    }

    protected void actuallyHurt(DamageSource pDamageSrc, float pDamageAmount) {
        super.actuallyHurt(pDamageSrc, pDamageAmount);
        if ((double)(this.getHealth() / this.getMaxHealth()) < 0.5 && !this.isHeadlessDead()) {
            this.setHeadlessDead(true);
            Networking.sendToTracking((Entity)this, new MessageHeadlessDie(this.getId()));
        }
    }

    private double randPos(double scale) {
        return ((double)this.getRandom().nextFloat() - 0.5) * scale;
    }

    public boolean isHairy() {
        return this.hasVariant(0);
    }

    private void setHairy(boolean b) {
        this.setVariant(0, b);
    }

    private void setGlasses(boolean b) {
        this.setVariant(1, b);
    }

    public boolean hasGlasses() {
        return this.hasVariant(1);
    }

    private byte getWeapon() {
        return (Byte)this.entityData.get(WEAPON);
    }

    private void setWeapon(byte b) {
        this.entityData.set(WEAPON, (Object)b);
    }

    public ItemStack getWeaponItem() {
        Item weapon = Items.IRON_SWORD;
        switch (this.getWeapon()) {
            case 1: {
                weapon = Items.IRON_AXE;
                break;
            }
            case 2: {
                weapon = Items.IRON_HOE;
            }
        }
        return new ItemStack((ItemLike)weapon);
    }

    private byte getHead() {
        return (Byte)this.entityData.get(HEAD);
    }

    private void setHead(byte head) {
        this.entityData.set(HEAD, (Object)head);
        if (head != 0) {
            this.headTimer = 1200;
        }
    }

    public boolean hasHead() {
        return this.getHead() != 0;
    }

    public EntityType<? extends LivingEntity> getHeadType() {
        return (EntityType)HeadlessFamiliarEntity.getTypesLookup().getOrDefault((Object)this.getHead(), null);
    }

    public void setHeadType(EntityType<?> type) {
        if (type == null || !HeadlessFamiliarEntity.getTypesLookup().inverse().containsKey(type)) {
            return;
        }
        this.setHead((Byte)HeadlessFamiliarEntity.getTypesLookup().inverse().get(type));
    }

    public boolean isHeadlessDead() {
        return this.hasVariant(2);
    }

    private void setHeadlessDead(boolean b) {
        this.setVariant(2, b);
    }

    private byte getRebuilt() {
        return (Byte)this.entityData.get(REBUILT);
    }

    private void setRebuilt(byte b) {
        this.entityData.set(REBUILT, (Object)b);
    }

    private void setRebuilt(Rebuilt r) {
        this.setRebuilt((byte)(this.getRebuilt() | 1 << r.getValue()));
    }

    public boolean isRebuilt(Rebuilt r) {
        return (this.getRebuilt() >> r.getValue() & 1) == 1;
    }

    private boolean isFullyRebuilt() {
        return this.getRebuilt() == 63;
    }

    public void killHeadless() {
        this.headlessDieTimer = 20;
    }

    @Override
    protected void dropFromLootTable(DamageSource pDamageSource, boolean pAttackedRecently) {
        super.dropFromLootTable(pDamageSource, pAttackedRecently);
        LivingEntity owner = this.getFamiliarOwner();
        ItemStack shard = new ItemStack((ItemLike)OccultismItems.SOUL_SHARD_ITEM.get());
        float health = this.getHealth();
        this.setHealth(this.getMaxHealth());
        this.resetFallDistance();
        this.removeAllEffects();
        this.setHeadlessDead(false);
        this.entityData.set(REBUILT, (Object)0);
        CompoundTag entityData = new CompoundTag();
        String id = this.getEncodeId();
        if (id != null) {
            entityData.putString("id", id);
        }
        entityData = this.saveWithoutId(entityData);
        shard.set(DataComponents.ENTITY_DATA, (Object)CustomData.of((CompoundTag)entityData));
        this.setHealth(health);
        if (owner instanceof Player) {
            Player player = (Player)owner;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)shard);
        } else {
            ItemEntity entityitem = new ItemEntity(this.level(), this.getX(), this.getY() + 0.5, this.getZ(), shard);
            entityitem.setPickUpDelay(5);
            entityitem.setDeltaMovement(entityitem.getDeltaMovement().multiply(0.0, 1.0, 0.0));
            this.level().addFreshEntity((Entity)entityitem);
        }
    }

    public static enum Rebuilt {
        LeftLeg(0),
        RightLeg(1),
        Body(2),
        LeftArm(3),
        RightArm(4),
        Head(5);

        private final int value;

        private Rebuilt(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

